/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.mail.internal.factory;

import java.util.Hashtable;
import java.util.Properties;
import java.util.StringTokenizer;
import javax.mail.Address;
import javax.mail.Message;
import javax.mail.Session;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimePartDataSource;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.RefAddr;
import javax.naming.Reference;
import javax.naming.spi.ObjectFactory;
import org.objectweb.util.monolog.api.BasicLevel;
import org.objectweb.util.monolog.api.Logger;
import org.ow2.jonas.lib.util.JNDIUtils;
import org.ow2.jonas.lib.util.Log;
import org.ow2.jonas.lib.util.PropDump;
import org.ow2.jonas.mail.internal.factory.lib.JAuthenticator;

public class JavaMailMimePartDSFactory
implements ObjectFactory {
    protected static final String FACTORY_TYPE = "javax.mail.internet.MimePartDataSource";
    private static Logger logger = null;

    public Object getObjectInstance(Object obj, Name name, Context nameCtx, Hashtable environment) throws Exception {
        if (logger == null) {
            logger = Log.getLogger("org.ow2.jonas.mail");
        }
        Reference ref = (Reference)obj;
        String clname = ref.getClassName();
        if (!ref.getClassName().equals(FACTORY_TYPE)) {
            logger.log(BasicLevel.ERROR, (Object)("Cannot create object : required type is 'javax.mail.internet.MimePartDataSource', but found type is '" + clname + "'."));
            return null;
        }
        Properties sessionProps = new Properties();
        Properties mimeMessageProps = new Properties();
        Properties authenticationProps = new Properties();
        RefAddr refAddr = null;
        refAddr = ref.get("javaxmailSession.properties");
        if (refAddr != null) {
            sessionProps = (Properties)JNDIUtils.getObjectFromBytes((byte[])refAddr.getContent());
            if (logger.isLoggable(BasicLevel.DEBUG)) {
                PropDump.print("These are the properties used to obtain a new Session object", sessionProps, logger, BasicLevel.DEBUG);
            }
        }
        if ((refAddr = ref.get("javaxInternetMimeMessage.properties")) != null) {
            mimeMessageProps = (Properties)JNDIUtils.getObjectFromBytes((byte[])refAddr.getContent());
            if (logger.isLoggable(BasicLevel.DEBUG)) {
                PropDump.print("These are the properties specific to Internet mail", mimeMessageProps, logger, BasicLevel.DEBUG);
            }
        }
        if ((refAddr = ref.get("authentication.properties")) != null) {
            authenticationProps = (Properties)JNDIUtils.getObjectFromBytes((byte[])refAddr.getContent());
            if (logger.isLoggable(BasicLevel.DEBUG)) {
                PropDump.print("These are the authentication properties", authenticationProps, logger, BasicLevel.DEBUG);
            }
        }
        String mailAuthenticationUsername = authenticationProps.getProperty("mail.authentication.username");
        String mailAuthenticationPassword = authenticationProps.getProperty("mail.authentication.password");
        String mailTo = mimeMessageProps.getProperty("mail.to");
        Address[] toRecipients = null;
        if (mailTo != null) {
            toRecipients = JavaMailMimePartDSFactory.getInternetAddressFromString(mailTo);
        }
        String mailCc = mimeMessageProps.getProperty("mail.cc");
        Address[] ccRecipients = null;
        if (mailCc != null) {
            ccRecipients = JavaMailMimePartDSFactory.getInternetAddressFromString(mailCc);
        }
        String mailBcc = mimeMessageProps.getProperty("mail.bcc");
        Address[] bccRecipients = null;
        if (mailBcc != null) {
            bccRecipients = JavaMailMimePartDSFactory.getInternetAddressFromString(mailBcc);
        }
        String mailSubject = mimeMessageProps.getProperty("mail.subject");
        JAuthenticator jAuthenticator = null;
        if (mailAuthenticationUsername != null && mailAuthenticationPassword != null) {
            jAuthenticator = new JAuthenticator(mailAuthenticationUsername, mailAuthenticationPassword);
        }
        MimeMessage mimeMessage = new MimeMessage(Session.getInstance(sessionProps, jAuthenticator));
        if (toRecipients != null) {
            mimeMessage.setRecipients(Message.RecipientType.TO, toRecipients);
        }
        if (ccRecipients != null) {
            mimeMessage.setRecipients(Message.RecipientType.CC, ccRecipients);
        }
        if (bccRecipients != null) {
            mimeMessage.setRecipients(Message.RecipientType.BCC, bccRecipients);
        }
        if (mailSubject != null) {
            mimeMessage.setSubject(mailSubject);
        }
        MimePartDataSource mimePartDS = new MimePartDataSource(mimeMessage);
        return mimePartDS;
    }

    private static InternetAddress[] getInternetAddressFromString(String txt) {
        if (txt == null) {
            return null;
        }
        StringTokenizer st = new StringTokenizer(txt, ",");
        InternetAddress[] addresses = new InternetAddress[st.countTokens()];
        int i = 0;
        try {
            while (st.hasMoreTokens()) {
                addresses[i] = new InternetAddress(st.nextToken());
                ++i;
            }
        }
        catch (Exception e) {
            return null;
        }
        return addresses;
    }
}

