/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.registry.carol;

import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.rmi.PortableRemoteObject;
import org.objectweb.util.monolog.api.BasicLevel;
import org.objectweb.util.monolog.api.Logger;
import org.ow2.carol.jndi.ns.NameServiceManager;
import org.ow2.carol.jndi.spi.VirtualJNDIContextFactory;
import org.ow2.carol.jndi.spi.VirtualJNDILookup;
import org.ow2.carol.util.configuration.ConfigurationException;
import org.ow2.carol.util.configuration.ConfigurationRepository;
import org.ow2.carol.util.configuration.ProtocolConfiguration;
import org.ow2.jonas.configuration.DeploymentPlanDeployer;
import org.ow2.jonas.lib.execution.ExecutionResult;
import org.ow2.jonas.lib.execution.IExecution;
import org.ow2.jonas.lib.execution.RunnableHelper;
import org.ow2.jonas.lib.loader.OSGiClassLoader;
import org.ow2.jonas.lib.service.AbsServiceImpl;
import org.ow2.jonas.lib.util.Log;
import org.ow2.jonas.naming.JComponentContextFactory;
import org.ow2.jonas.naming.JComponentContextFactoryDelegate;
import org.ow2.jonas.registry.RegistryService;
import org.ow2.jonas.registry.carol.delegate.ORBCCFDelegate;
import org.ow2.jonas.service.ServiceException;
import org.ow2.jonas.versioning.VersioningService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CarolRegistryService
extends AbsServiceImpl
implements RegistryService {
    private static Logger logger = Log.getLogger("org.ow2.jonas.registry");
    public static final String DEFAULT_MODE = "automatic";
    public static final String COLLOCATED = "collocated";
    public static final String REMOTE = "remote";
    private boolean bStartRegistry = true;
    private boolean bIgnoreError = true;
    private JComponentContextFactoryDelegate delegate = null;
    private JComponentContextFactory factory = null;
    private URL configurationURL;
    private MBeanServer mbeanServer = null;
    private DeploymentPlanDeployer deploymentPlanDeployer = null;
    private InitialContext ictx = null;
    private static final String SECURITY_PROPAGATION = "jonas.security.propagation";
    private static final String CSIV2_PROPAGATION = "jonas.csiv2.propagation";
    private static final String SEC_CHECK = "jonas.security.context.check";
    private static final String TRANSACTION_PROPAGATION = "jonas.transaction.propagation";

    public void setMode(String mode) {
        if (DEFAULT_MODE.equalsIgnoreCase(mode)) {
            this.setStartRegistry(true);
            this.setIgnoreError(true);
        } else if (COLLOCATED.equalsIgnoreCase(mode)) {
            this.setStartRegistry(true);
            this.setIgnoreError(false);
        } else if (REMOTE.equalsIgnoreCase(mode)) {
            this.setStartRegistry(false);
            this.setIgnoreError(false);
        }
    }

    @Override
    public void doStart() throws ServiceException {
        logger.log(BasicLevel.DEBUG, (Object)"Starting Carol Registry Service");
        IExecution<Void> exec = new IExecution<Void>(){

            @Override
            public Void execute() throws Exception {
                System.setProperty("carol.server.mode", "true");
                if (CarolRegistryService.this.configurationURL != null) {
                    try {
                        ConfigurationRepository.init(CarolRegistryService.this.configurationURL, CarolRegistryService.this.getDomainName(), CarolRegistryService.this.getJonasServerName(), CarolRegistryService.this.getMBeanServerId());
                    }
                    catch (ConfigurationException e) {
                        throw new ServiceException("Cannot init Carol", e);
                    }
                } else {
                    ConfigurationRepository.init(CarolRegistryService.this.getDomainName(), CarolRegistryService.this.getJonasServerName(), CarolRegistryService.this.getMBeanServerId());
                }
                try {
                    PortableRemoteObject.narrow(null, null);
                }
                catch (Exception e) {
                    logger.log(BasicLevel.DEBUG, (Object)"PortableRemoteObject initialized");
                }
                return null;
            }
        };
        ExecutionResult<Void> result = RunnableHelper.execute(this.getClass().getClassLoader(), exec);
        if (result.hasException()) {
            throw new ServiceException(result.getException().getMessage(), result.getException());
        }
        try {
            this.initInterceptors();
        }
        catch (ConfigurationException e) {
            throw new ServiceException("Cannot init Carol interceptors", e);
        }
        exec = new IExecution<Void>(){

            @Override
            public Void execute() throws Exception {
                if (CarolRegistryService.this.bStartRegistry) {
                    NameServiceManager nameServiceManager = NameServiceManager.getNameServiceManager();
                    try {
                        if (CarolRegistryService.this.bIgnoreError) {
                            nameServiceManager.startNonStartedNS();
                        } else {
                            nameServiceManager.startNS();
                        }
                    }
                    catch (Exception e) {
                        throw new ServiceException("Cannot start the registry", e);
                    }
                }
                return null;
            }
        };
        result = RunnableHelper.execute(new OSGiClassLoader(), exec);
        if (result.hasException()) {
            throw new ServiceException(result.getException().getMessage(), result.getException());
        }
        try {
            this.setDelegate(new ORBCCFDelegate());
            this.factory.addDelegate(this.delegate);
        }
        catch (NamingException e) {
            throw new ServiceException("Cannot add the delegate", e);
        }
        VirtualJNDIContextFactory.parent = System.getProperty("java.naming.factory.initial");
        System.setProperty("java.naming.factory.initial", VirtualJNDIContextFactory.class.getName());
        logger.log(BasicLevel.INFO, (Object)"Carol Registry Service started");
    }

    private void initInterceptors() throws ConfigurationException {
        boolean security = Boolean.parseBoolean(this.getServerProperties().getValue(SECURITY_PROPAGATION));
        boolean transaction = Boolean.parseBoolean(this.getServerProperties().getValue(TRANSACTION_PROPAGATION));
        boolean csiv2 = Boolean.parseBoolean(this.getServerProperties().getValue(CSIV2_PROPAGATION));
        boolean iiopEnabled = ConfigurationRepository.getConfiguration("iiop") != null;
        boolean deploySecurityInterceptors = false;
        if (security && iiopEnabled) {
            deploySecurityInterceptors = true;
            ConfigurationRepository.addInterceptors("iiop", "org.ow2.jonas.security.interceptors.iiop.SecurityInitializer");
        }
        if (iiopEnabled && csiv2) {
            deploySecurityInterceptors = true;
            ConfigurationRepository.addInterceptors("iiop", "org.ow2.jonas.security.iiop.Csiv2Initializer");
        }
        if (deploySecurityInterceptors) {
            try {
                this.deploymentPlanDeployer.deploy("sec-interceptors-iiop");
            }
            catch (Exception e) {
                throw new ConfigurationException(e);
            }
        }
        if (transaction && iiopEnabled) {
            try {
                this.deploymentPlanDeployer.deploy("trans-interceptors-iiop");
            }
            catch (Exception e) {
                throw new ConfigurationException(e);
            }
            ConfigurationRepository.addInterceptors("iiop", "org.ow2.jonas.tm.jotm.ots.OTSORBInitializer");
        }
    }

    @Override
    public void doStop() throws ServiceException {
        logger.log(BasicLevel.DEBUG, (Object)"Stopping Carol Registry Service");
        try {
            NameServiceManager.getNameServiceManager().stopNS();
        }
        catch (Exception e) {
            throw new ServiceException("Problem when stopping registry service", e);
        }
        logger.log(BasicLevel.INFO, (Object)"Carol Registry Service stopped");
    }

    @Override
    public List<String> getActiveProtocolNames() {
        ArrayList<String> protocols = new ArrayList<String>();
        ProtocolConfiguration[] configs = ConfigurationRepository.getConfigurations();
        for (int i = 0; i < configs.length; ++i) {
            protocols.add(configs[i].getName());
        }
        return protocols;
    }

    @Override
    public String getDefaultProtocolName() {
        return ConfigurationRepository.getDefaultConfiguration().getName();
    }

    @Override
    public int getExportedObjectPort(String protocolName) {
        ProtocolConfiguration config = this.getProtocolConfiguration(protocolName);
        String key = "carol." + protocolName + ".server.port";
        String port = config.getProperties().getProperty(key, "0");
        return Integer.valueOf(port);
    }

    @Override
    public String getInitialContextFactoryName(String protocolName) {
        ProtocolConfiguration config = this.getProtocolConfiguration(protocolName);
        return config.getProtocol().getInitialContextFactoryClassName();
    }

    @Override
    public URI getProviderURL(String protocolName) {
        ProtocolConfiguration config = this.getProtocolConfiguration(protocolName);
        return URI.create(config.getProviderURL());
    }

    @Override
    public void setDefaultProtocol(String protocolName) {
        ProtocolConfiguration config = this.getProtocolConfiguration(protocolName);
        ConfigurationRepository.setCurrentConfiguration(config);
    }

    private ProtocolConfiguration getProtocolConfiguration(String protocolName) {
        return ConfigurationRepository.getConfiguration(protocolName);
    }

    public void setComponentContextFactory(JComponentContextFactory factory) {
        this.factory = factory;
    }

    public void setDelegate(JComponentContextFactoryDelegate delegate) {
        this.delegate = delegate;
    }

    public void setStartRegistry(boolean startRegistry) {
        this.bStartRegistry = startRegistry;
    }

    public void setIgnoreError(boolean ignoreError) {
        this.bIgnoreError = ignoreError;
    }

    public void setConfigurationURL(URL configurationURL) {
        this.configurationURL = configurationURL;
    }

    public void setConfiguration(String configurationURL) throws MalformedURLException {
        this.setConfigurationURL(new URL(configurationURL));
    }

    @Override
    public InitialContext getRegistryContext() {
        if (this.ictx == null) {
            IExecution<InitialContext> ie = new IExecution<InitialContext>(){

                @Override
                public InitialContext execute() throws Exception {
                    return new InitialContext();
                }
            };
            ExecutionResult<InitialContext> result = null;
            result = RunnableHelper.execute(this.getClass().getClassLoader(), ie);
            if (result.hasException()) {
                logger.log(BasicLevel.ERROR, (Object)result.getException());
            }
            this.ictx = result.getResult();
        }
        return this.ictx;
    }

    private String getMBeanServerId() throws ServiceException {
        try {
            ObjectName on = ObjectName.getInstance("JMImplementation:type=MBeanServerDelegate");
            return (String)this.mbeanServer.getAttribute(on, "MBeanServerId");
        }
        catch (Exception e) {
            throw new ServiceException("MBeanServerId cannot be retrieved", e);
        }
    }

    public void setMbeanServer(MBeanServer mbeanServer) {
        this.mbeanServer = mbeanServer;
    }

    public void setDeploymentPlanDeployer(DeploymentPlanDeployer deploymentPlanDeployer) {
        this.deploymentPlanDeployer = deploymentPlanDeployer;
    }

    public void setVersioningService(VersioningService versioningService) {
        VirtualJNDILookup.setVersioningService(versioningService);
    }

    public void unsetVersioningService() {
        VirtualJNDILookup.unsetVersioningService();
    }

    public VersioningService getVersioningService() {
        return VirtualJNDILookup.getVersioningService();
    }
}

