/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.resource.internal;

import java.io.File;
import java.net.URL;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.Properties;
import java.util.Vector;
import java.util.jar.JarEntry;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.naming.Context;
import javax.naming.NamingException;
import javax.resource.Referenceable;
import javax.resource.spi.ActivationSpec;
import javax.resource.spi.ConnectionManager;
import javax.resource.spi.ManagedConnectionFactory;
import javax.resource.spi.ResourceAllocationException;
import org.objectweb.util.monolog.api.BasicLevel;
import org.objectweb.util.monolog.api.Logger;
import org.ow2.jonas.deployment.ejb.ActivationConfigPropertyDesc;
import org.ow2.jonas.deployment.rar.AdminobjectDesc;
import org.ow2.jonas.deployment.rar.AuthenticationMechanismDesc;
import org.ow2.jonas.deployment.rar.ConfigPropertyDesc;
import org.ow2.jonas.deployment.rar.ConnectionDefinitionDesc;
import org.ow2.jonas.deployment.rar.ConnectorDesc;
import org.ow2.jonas.deployment.rar.InboundResourceadapterDesc;
import org.ow2.jonas.deployment.rar.JonasActivationspecDesc;
import org.ow2.jonas.deployment.rar.JonasAdminobjectDesc;
import org.ow2.jonas.deployment.rar.JonasConnectionDefinitionDesc;
import org.ow2.jonas.deployment.rar.JonasConnectorDesc;
import org.ow2.jonas.deployment.rar.MessageadapterDesc;
import org.ow2.jonas.deployment.rar.MessagelistenerDesc;
import org.ow2.jonas.deployment.rar.OutboundResourceadapterDesc;
import org.ow2.jonas.deployment.rar.RarDeploymentDesc;
import org.ow2.jonas.deployment.rar.RequiredConfigPropertyDesc;
import org.ow2.jonas.deployment.rar.ResourceadapterDesc;
import org.ow2.jonas.deployment.rar.TmConfigPropertyDesc;
import org.ow2.jonas.deployment.rar.lib.RarDeploymentDescManager;
import org.ow2.jonas.jmx.JmxService;
import org.ow2.jonas.lib.bootstrap.JProp;
import org.ow2.jonas.lib.bootstrap.loader.JClassLoader;
import org.ow2.jonas.lib.management.javaee.J2eeObjectName;
import org.ow2.jonas.lib.util.JJarFile;
import org.ow2.jonas.lib.util.Log;
import org.ow2.jonas.lib.util.ModuleNamingUtils;
import org.ow2.jonas.resource.ResourceServiceException;
import org.ow2.jonas.resource.internal.JOnASResourceService;
import org.ow2.jonas.resource.internal.ResourceBootstrapContext;
import org.ow2.jonas.resource.internal.ResourceUtility;
import org.ow2.jonas.resource.internal.cm.ConnectionManagerImpl;
import org.ow2.jonas.resource.internal.cm.ConnectionManagerPoolParams;
import org.ow2.jonas.resource.internal.mbean.JCAActivationSpec;
import org.ow2.jonas.resource.internal.mbean.JCAAdminObject;
import org.ow2.jonas.resource.internal.mbean.JCAResource;
import org.ow2.jonas.resource.internal.mbean.ResourceAdapter;
import org.ow2.jonas.resource.internal.mbean.ResourceAdapterModule;
import org.ow2.jonas.service.ServiceException;
import org.ow2.jonas.tm.TransactionManager;

public class Rar
implements org.ow2.jonas.resource.Rar {
    private static Logger logger = Log.getLogger("org.ow2.jonas.jca.process");
    private static Logger poolLogger = Log.getLogger("org.ow2.jonas.jca.pool");
    private static Logger setterLogger = Log.getLogger("org.ow2.jonas.jca.setters");
    private static Logger manageLogger = Log.getLogger("org.ow2.jonas.jca.management");
    String rarFileName = null;
    ClassLoader curLoader = null;
    boolean isInEar;
    URL earUrl = null;
    Context rCtx = null;
    String jDomain = null;
    String jServer = null;
    Vector jndinames = new Vector();
    String lnkJndiName = "";
    String lnkRarFilename = "";
    JCAResource jcaResourceMBean = null;
    String JCAResourceName = null;
    private ResourceBootstrapContext bootCtx = null;
    public static final String CLASS = "jonas.service.resource.class";
    public static final String JNDI_NAME = "jndiname";
    public static final String RAR_FILENAME = "rarfilename";
    public static final String LNK_JNDI_NAME = "lnkjndiname";
    public static final String LNK_RAR_FILENAME = "lnkrarfilename";
    public static final String OBJ_TYPE = "objtype";
    public static final String RESOURCE_LIST = "jonas.service.resource.resources";
    public static final int DEF_WRK_THREADS = 5;
    public static final int DEF_EXEC_TIME = 0;
    public static final String JCD = "JCD";
    public static final String JAS = "JAS";
    public static final String JAO = "JAO";
    public String objectName = null;
    public String pathName = null;
    public javax.resource.spi.ResourceAdapter resAdp = null;
    public ConnectorDesc raConn = null;
    public JonasConnectorDesc lnkJonasConn = null;
    public JonasConnectorDesc jonasConn = null;
    public String xmlContent = null;
    public String jonasXmlContent = null;
    private static Vector defaultAS = new Vector();
    private Hashtable cfgObjs = new Hashtable();
    private TransactionManager tm = null;
    private JmxService jmx = null;
    private Context ictx = null;
    private ResourceUtility ru = null;

    public Rar() {
        this.curLoader = Thread.currentThread().getContextClassLoader();
        this.ru = new ResourceUtility(null, logger, setterLogger, manageLogger);
    }

    public Rar(Context ctx, String jDom, String jServ, ResourceBootstrapContext btCtx, TransactionManager txManager, JmxService jmxService) {
        try {
            this.rarFileName = (String)ctx.lookup("rarFileName");
            this.isInEar = (Boolean)ctx.lookup("isInEar");
            if (this.isInEar) {
                this.earUrl = (URL)ctx.lookup("earUrl");
            }
            this.curLoader = (ClassLoader)ctx.lookup("classloader");
        }
        catch (NamingException e) {
            String err = "Error while getting parameter from context param.";
            logger.log(BasicLevel.ERROR, (Object)(err + e.getMessage()));
            throw new ResourceServiceException(err, e);
        }
        catch (Exception ex) {
            String err = "Error while getting parameter from context param.";
            logger.log(BasicLevel.ERROR, (Object)(err + ex.getMessage()));
            throw new ResourceServiceException(err, ex);
        }
        this.bootCtx = btCtx;
        this.rCtx = ctx;
        this.jDomain = jDom;
        this.jServer = jServ;
        this.tm = txManager;
        this.jmx = jmxService;
        this.ru = new ResourceUtility(this.jmx, logger, setterLogger, manageLogger);
    }

    public void setTransactionManager(TransactionManager tm) {
        this.tm = tm;
    }

    public void setJMXService(JmxService jmx) {
        this.jmx = jmx;
    }

    public void setInitialContext(Context context) {
        this.ictx = context;
    }

    public Context processRar(String domainName, JOnASResourceService rserv) throws Exception {
        String specVersion;
        List tmParams;
        String onRar = null;
        RarDeploymentDesc radesc = RarDeploymentDescManager.getInstance(this.rCtx);
        ConnectorDesc conn = radesc.getConnectorDesc();
        JonasConnectorDesc jConn = radesc.getJonasConnectorDesc();
        this.xmlContent = radesc.getXmlContent();
        this.jonasXmlContent = radesc.getJOnASXmlContent();
        ConnectionManager cm = null;
        ManagedConnectionFactory mcf = null;
        if (conn == null && jConn == null) {
            logger.log(BasicLevel.ERROR, (Object)("Rar.processRar: Resource (" + this.rarFileName + ") must be a valid RAR file."));
            throw new Exception("resource input file incorrect");
        }
        logger.log(BasicLevel.DEBUG, (Object)("Process Resource " + this.rarFileName));
        String rarVal = jConn.getRarlink();
        if (rarVal != null && rarVal.length() > 0) {
            this.lnkJndiName = rarVal;
            conn = rserv.getConnectorDesc(this.lnkJndiName);
            if (conn == null) {
                return this.rCtx;
            }
            ConfigObj co = (ConfigObj)rserv.getConfigObject(this.lnkJndiName);
            if (co == null) {
                logger.log(BasicLevel.ERROR, (Object)("ConfigObject " + this.lnkJndiName + "  not found."));
                throw new Exception("ConfigObject not found");
            }
            this.lnkRarFilename = co.rarFilename;
            this.xmlContent = rserv.getXmlContent(this.lnkJndiName);
            this.lnkJonasConn = rserv.getJonasConnectorDesc(this.lnkJndiName);
        } else if (conn == null) {
            logger.log(BasicLevel.ERROR, (Object)("Rar.processRar: Resource (" + this.rarFileName + ") is not valid."));
            throw new Exception("resource input file incorrect: no ra.xml file");
        }
        this.bldSecurityTable(this.lnkJonasConn, jConn);
        this.raConn = conn;
        this.jonasConn = jConn;
        ConnectionManagerPoolParams pParams = this.ru.configurePoolParams(jConn.getPoolParamsDesc(), jConn.getJdbcConnParamsDesc(), null);
        this.extractJars(this.rarFileName, jConn);
        ResourceadapterDesc ra = conn.getResourceadapterDesc();
        boolean basicPass = true;
        List authList = ra.getAuthenticationMechanismList();
        if (authList != null && authList.size() > 0) {
            basicPass = false;
            for (AuthenticationMechanismDesc am : authList) {
                if (!am.getAuthenticationMechanismType().equalsIgnoreCase("BasicPassword")) continue;
                basicPass = true;
                break;
            }
            if (!basicPass) {
                logger.log(BasicLevel.ERROR, (Object)("Rar.processRar: Resource (" + this.rarFileName + ") doesn't contain an AuthenticationMechanismType that is supported by JOnAS(BasicPassword)."));
                throw new Exception("No AuthenticationMechanismType that is supported by JOnAS(BasicPassword).");
            }
        }
        ConfigPropertyDesc[] cfgRaJonas = null;
        String logEnabled = null;
        if (jConn.getLogEnabled() != null) {
            logEnabled = jConn.getLogEnabled().trim();
        }
        String logTopic = null;
        if (jConn.getLogTopic() != null) {
            logTopic = jConn.getLogTopic().trim();
        }
        Referenceable cf = null;
        String jndiName = null;
        String mcfc = null;
        ConfigObj cObj = null;
        cfgRaJonas = this.lnkJonasConn != null ? this.ru.buildConfigProperty(ra.getConfigPropertyList(), jConn.getJonasConfigPropertyList(), this.lnkJonasConn.getJonasConfigPropertyList()) : this.ru.buildConfigProperty(ra.getConfigPropertyList(), jConn.getJonasConfigPropertyList(), null);
        Properties tmProp = new Properties();
        if (jConn.getTmParamsDesc() != null && (tmParams = jConn.getTmParamsDesc().getTmConfigPropertyList()) != null) {
            for (TmConfigPropertyDesc tpd : tmParams) {
                String tpdVal = tpd.getTmConfigPropertyValue();
                if (tpdVal == null) {
                    tpdVal = "";
                }
                tmProp.setProperty(tpd.getTmConfigPropertyName(), tpdVal);
            }
            if (logger.isLoggable(BasicLevel.DEBUG)) {
                logger.log(BasicLevel.DEBUG, (Object)("TM Properties: " + tmProp));
            }
        }
        if ((specVersion = conn.getSpecVersion()).equals("1.0")) {
            if (!jConn.isSetup()) {
                logger.log(BasicLevel.ERROR, (Object)("Rar.processRar: Resource (" + this.rarFileName + ") must be a valid RAR file, there must be jonas-ra.xml file."));
                throw new Exception("resource input file incorrect: no jonas-ra.xml file");
            }
            jndiName = jConn.getJndiName().trim();
            ConnectionManagerPoolParams cmpp = this.ru.configurePoolParams(jConn.getPoolParamsDesc(), jConn.getJdbcConnParamsDesc(), null);
            onRar = this.registerRarMBean(cfgRaJonas, specVersion, jndiName, domainName, null);
            cm = this.ru.createConnectionManager(ra.getTransactionSupport(), this.tm, logger, poolLogger);
            mcfc = ra.getManagedconnectionfactoryClass();
            mcf = (ManagedConnectionFactory)this.ru.processMCF(conn, jConn, this.curLoader, this.rarFileName, mcfc, jndiName, logEnabled, logTopic, cfgRaJonas, this.resAdp, 0);
            ((ConnectionManagerImpl)cm).setResourceAdapter(mcf, cmpp);
            cf = (Referenceable)mcf.createConnectionFactory(cm);
            cObj = new ConfigObj(JCD, 0, jndiName, this.rarFileName, null, mcfc, cf);
            cObj.cm = cm;
            cObj.basicPass = basicPass;
            this.cfgObjs.put(jndiName, cObj);
            this.jndinames.add(jndiName);
            this.ru.registerMBean(cf, jndiName, onRar, this.rarFileName, conn, this.jonasConn, JCD, 0, this.jcaResourceMBean, this.JCAResourceName, this.jDomain, this.jServer, this.ictx, this.buildProp(cfgRaJonas), "", (ConnectionManagerImpl)cm);
            ((ConnectionManagerImpl)cm).setXAName(this.ru.getJcaMcfName(jndiName));
            ((ConnectionManagerImpl)cm).registerXAResource(tmProp);
        } else if (conn.getSpecVersion().equals("1.5")) {
            String raStr = conn.getResourceadapterDesc().getResourceadapterClass().trim();
            boolean isResAdapt = false;
            logger.log(BasicLevel.INFO, (Object)("Starting deployment of " + this.rarFileName));
            if (raStr != null && raStr.length() > 0) {
                isResAdapt = true;
                Class<?> raClass = this.curLoader.loadClass(raStr);
                this.resAdp = (javax.resource.spi.ResourceAdapter)raClass.newInstance();
                this.ru.processSetters(raClass, this.resAdp, this.rarFileName, cfgRaJonas);
                try {
                    this.resAdp.start(this.bootCtx);
                }
                catch (Exception ex) {
                    logger.log(BasicLevel.ERROR, (Object)("Rar: Error from resource (" + this.rarFileName + ") start method."));
                    throw new Exception("Error from start method. ", ex);
                }
                catch (Throwable th) {
                    logger.log(BasicLevel.ERROR, (Object)("Rar: Error from resource (" + this.rarFileName + ") start method."));
                    throw new Exception("Error from start method. ", th);
                }
            }
            onRar = this.registerRarMBean(cfgRaJonas, specVersion, null, domainName, conn.getResourceadapter().getResourceadapterClass());
            OutboundResourceadapterDesc outRa = ra.getOutboundResourceadapterDesc();
            List cdList = null;
            if (outRa != null) {
                cdList = outRa.getConnectionDefinitionList();
            }
            ConnectionDefinitionDesc conDef = null;
            JonasConnectionDefinitionDesc jConDef = null;
            String id = null;
            int idOffset = -1;
            if (cdList != null) {
                if (cdList.size() > 0 && !jConn.isSetup()) {
                    logger.log(BasicLevel.ERROR, (Object)("Rar.processRar: Resource (" + this.rarFileName + ") must be a valid RAR file, there must be jonas-ra.xml file."));
                    throw new Exception("resource input file incorrect: no jonas-ra.xml file");
                }
                for (int cd = 0; cd < cdList.size(); ++cd) {
                    conDef = (ConnectionDefinitionDesc)cdList.get(cd);
                    id = conDef.getId();
                    jConDef = (JonasConnectionDefinitionDesc)this.ru.getJonasXML(jConn, id, ++idOffset, JCD);
                    if (jConDef.getLogEnabled() != null) {
                        logEnabled = jConDef.getLogEnabled().trim();
                    }
                    if (jConDef.getLogTopic() != null) {
                        logTopic = jConDef.getLogTopic().trim();
                    }
                    ConfigPropertyDesc[] cfgCdDesc = this.ru.buildConfigProperty(conDef.getConfigPropertyList(), jConDef.getJonasConfigPropertyList(), null);
                    ConnectionManagerPoolParams pool = this.ru.configurePoolParams(jConDef.getPoolParamsDesc(), jConDef.getJdbcConnParamsDesc(), pParams);
                    cm = this.ru.createConnectionManager(outRa.getTransactionSupport(), this.tm, logger, poolLogger);
                    jndiName = jConDef.getJndiName().trim();
                    mcfc = conDef.getManagedconnectionfactoryClass();
                    mcf = (ManagedConnectionFactory)this.ru.processMCF(conn, jConn, this.curLoader, this.rarFileName, mcfc, jndiName, logEnabled, logTopic, cfgCdDesc, this.resAdp, idOffset);
                    ((ConnectionManagerImpl)cm).setResourceAdapter(mcf, pool);
                    cf = (Referenceable)mcf.createConnectionFactory(cm);
                    cObj = new ConfigObj(JCD, idOffset, jndiName, this.rarFileName, null, mcfc, cf);
                    cObj.cm = cm;
                    cObj.basicPass = basicPass;
                    this.cfgObjs.put(jndiName, cObj);
                    this.jndinames.add(jndiName);
                    String desc = "";
                    List descList = jConDef.getDescriptionList();
                    if (descList != null) {
                        for (int i = 0; i < descList.size(); ++i) {
                            String tmp = (String)descList.get(i);
                            desc = desc + tmp;
                        }
                    }
                    this.ru.registerMBean(cf, jndiName, onRar, this.rarFileName, conn, this.jonasConn, JCD, idOffset, this.jcaResourceMBean, this.JCAResourceName, this.jDomain, this.jServer, this.ictx, this.buildProp(cfgCdDesc), desc, (ConnectionManagerImpl)cm);
                    ((ConnectionManagerImpl)cm).setXAName(this.ru.getJcaMcfName(jndiName));
                    ((ConnectionManagerImpl)cm).registerXAResource(tmProp);
                }
            }
            if (isResAdapt) {
                InboundResourceadapterDesc inAdapt = ra.getInboundResourceadapterDesc();
                MessageadapterDesc msgAdapt = null;
                List mlList = null;
                if (inAdapt != null) {
                    msgAdapt = inAdapt.getMessageadapterDesc();
                    mlList = null;
                    if (msgAdapt != null) {
                        mlList = msgAdapt.getMessagelistenerList();
                    }
                }
                MessagelistenerDesc msgList = null;
                JonasActivationspecDesc jAct = null;
                id = null;
                idOffset = -1;
                if (mlList != null) {
                    if (mlList.size() > 0 && !jConn.isSetup()) {
                        logger.log(BasicLevel.ERROR, (Object)("Rar.processRar: Resource (" + this.rarFileName + ") must be a valid RAR file, there must be jonas-ra.xml file."));
                        throw new Exception("resource input file incorrect: no jonas-ra.xml file");
                    }
                    for (int ml = 0; ml < mlList.size(); ++ml) {
                        msgList = (MessagelistenerDesc)mlList.get(ml);
                        id = msgList.getId();
                        jAct = (JonasActivationspecDesc)this.ru.getJonasXML(jConn, id, ++idOffset, JAS);
                        this.processJAS(this.rarFileName, msgList, jAct, idOffset);
                    }
                }
                List aoList = ra.getAdminobjectList();
                AdminobjectDesc admObj = null;
                JonasAdminobjectDesc jAObj = null;
                id = null;
                idOffset = -1;
                if (aoList != null) {
                    if (aoList.size() > 0 && !jConn.isSetup()) {
                        logger.log(BasicLevel.ERROR, (Object)("aoList = " + aoList));
                        logger.log(BasicLevel.ERROR, (Object)("Rar.processRar: Resource (" + this.rarFileName + ") must be a valid RAR file, there must be jonas-ra.xml file."));
                        throw new Exception("resource input file incorrect: no jonas-ra.xml file");
                    }
                    for (int ao = 0; ao < aoList.size(); ++ao) {
                        admObj = (AdminobjectDesc)aoList.get(ao);
                        id = admObj.getId();
                        jAObj = (JonasAdminobjectDesc)this.ru.getJonasXML(jConn, id, ++idOffset, JAO);
                        ConfigPropertyDesc[] cfgCdDesc = this.ru.buildConfigProperty(admObj.getConfigPropertyList(), jAObj.getJonasConfigPropertyList(), null);
                        this.processJAO(this.rarFileName, admObj, jAObj, cfgCdDesc, idOffset);
                    }
                }
            }
        } else {
            logger.log(BasicLevel.ERROR, (Object)("ResourceService.createRA: Resource (" + this.rarFileName + ") must be specify a valid specification of 1.0 or 1.5."));
            throw new Exception("resource input file incorrect: invalid specification support(only 1.0 & 1.5 are valid)");
        }
        logger.log(BasicLevel.INFO, (Object)(this.rarFileName + " available"));
        try {
            this.rCtx.rebind("onRar", (Object)onRar);
            this.rCtx.rebind("deployed", (Object)new Boolean(true));
        }
        catch (Exception ex) {
            String err = "Error while getting parameter from context param.";
            logger.log(BasicLevel.ERROR, (Object)(err + ex.getMessage()));
            throw new ResourceServiceException(err, ex);
        }
        return this.rCtx;
    }

    private String registerRarMBean(ConfigPropertyDesc[] cfgRaJonas, String specVersion, String jndiName, String domainName, String resourceAdapterClassname) throws Exception {
        String serverName = this.jServer;
        String raName = null;
        Properties props = this.buildProp(cfgRaJonas);
        URL rarURL = new File(this.rarFileName).toURL();
        String jmxRaName = rarURL.getFile().replace(':', '|');
        String appName = null;
        if (this.isInEar) {
            appName = ModuleNamingUtils.fromURL(this.earUrl);
        }
        String resourceAdapterModuleName = Rar.buildModuleName(jmxRaName, appName);
        ObjectName onResourceAdapterModule = J2eeObjectName.getResourceAdapterModule(this.jDomain, this.jServer, appName, resourceAdapterModuleName);
        if (manageLogger.isLoggable(BasicLevel.DEBUG)) {
            manageLogger.log(BasicLevel.DEBUG, (Object)("ObjectName created for ResourceAdapterModule: " + onResourceAdapterModule.toString()));
        }
        ResourceAdapterModule raModuleMBean = new ResourceAdapterModule(onResourceAdapterModule, this.isInEar, this.earUrl);
        raModuleMBean.setFileName(jmxRaName);
        raModuleMBean.setRarURL(rarURL);
        raModuleMBean.setDeploymentDescriptor(this.xmlContent);
        raModuleMBean.setJonasDeploymentDescriptor(this.jonasXmlContent);
        raModuleMBean.setServer(J2eeObjectName.J2EEServerName(domainName, serverName));
        this.jmx.registerModelMBean((Object)raModuleMBean, onResourceAdapterModule);
        if (manageLogger.isLoggable(BasicLevel.DEBUG)) {
            manageLogger.log(BasicLevel.DEBUG, (Object)"ResourceAdapterModule MBean created");
        }
        raName = resourceAdapterModuleName;
        ObjectName onResourceAdapter = J2eeObjectName.getResourceAdapter(this.jDomain, resourceAdapterModuleName, appName, this.jServer, raName);
        ResourceAdapter raMBean = new ResourceAdapter(onResourceAdapter.toString(), props, jndiName, jmxRaName, this.isInEar, this.earUrl, specVersion);
        raMBean.setResourceAdapterClassname(resourceAdapterClassname);
        this.jmx.registerModelMBean((Object)raMBean, onResourceAdapter);
        if (manageLogger.isLoggable(BasicLevel.DEBUG)) {
            manageLogger.log(BasicLevel.DEBUG, (Object)"ResourceAdapter ManagedBean created");
        }
        raModuleMBean.setResourceAdapter(onResourceAdapter.toString());
        if (manageLogger.isLoggable(BasicLevel.DEBUG)) {
            manageLogger.log(BasicLevel.DEBUG, (Object)"ResourceAdapterModule ManagedBean updated");
        }
        this.JCAResourceName = raName;
        ObjectName onJCAResource = J2eeObjectName.getJCAResource(this.jDomain, this.jServer, raName, this.JCAResourceName);
        this.jcaResourceMBean = new JCAResource(onJCAResource.toString());
        this.jmx.registerModelMBean((Object)this.jcaResourceMBean, onJCAResource);
        if (manageLogger.isLoggable(BasicLevel.DEBUG)) {
            manageLogger.log(BasicLevel.DEBUG, (Object)"JCAResource J2EEResource created");
        }
        raMBean.setJcaResource(onJCAResource.toString());
        if (manageLogger.isLoggable(BasicLevel.DEBUG)) {
            manageLogger.log(BasicLevel.DEBUG, (Object)"JCAResource J2EEResource updated");
        }
        return onResourceAdapterModule.toString();
    }

    public void unRegister(String domainName) throws Exception {
        for (int i = 0; i < this.jndinames.size(); ++i) {
            String jName = (String)this.jndinames.get(i);
            ConfigObj co = (ConfigObj)this.cfgObjs.get(jName);
            try {
                this.ictx.unbind(jName);
            }
            catch (NamingException ex) {
                if (logger.isLoggable(BasicLevel.DEBUG)) {
                    logger.log(BasicLevel.DEBUG, (Object)("ResourceService: cannot unbind jndiname of " + jName + " for ResourceAdapter " + this.rarFileName), (Throwable)ex);
                }
                throw new ServiceException("Cannot unregister", ex);
            }
            if (co.defaultAS) {
                Rar.removeDefaultAS(jName);
            }
            if (co == null || co.cm == null) continue;
            ((ConnectionManagerImpl)co.cm).cleanResourceAdapter();
        }
        this.cfgObjs.clear();
        this.jndinames.clear();
        String jmxRaName = new File(this.rarFileName).toURL().getFile().replace(':', '|');
        String appName = null;
        if (this.isInEar) {
            appName = ModuleNamingUtils.fromURL(this.earUrl);
        }
        String resourceAdapaterModuleName = Rar.buildModuleName(jmxRaName, appName);
        ObjectName onResourceAdapterModule = J2eeObjectName.getResourceAdapterModule(this.jDomain, this.jServer, appName, resourceAdapaterModuleName);
        MBeanServer mbeanServer = this.jmx.getJmxServer();
        try {
            String[] resourceAdapterNames = (String[])mbeanServer.getAttribute(onResourceAdapterModule, "resourceAdapters");
            this.jmx.unregisterModelMBean(onResourceAdapterModule);
            for (int i = 0; i < resourceAdapterNames.length; ++i) {
                String resourceAdapterName = resourceAdapterNames[i];
                ObjectName onResourceAdapater = new ObjectName(resourceAdapterName);
                String jcaResourceName = (String)mbeanServer.getAttribute(onResourceAdapater, "jcaResource");
                this.jmx.unregisterModelMBean(onResourceAdapater);
                ObjectName onJCAResource = new ObjectName(jcaResourceName);
                String[] connectionFactoriesNames = (String[])mbeanServer.getAttribute(onJCAResource, "connectionFactories");
                for (int j = 0; j < connectionFactoriesNames.length; ++j) {
                    String connectionFactoryName = connectionFactoriesNames[j];
                    ObjectName onJCAConnectionFactory = new ObjectName(connectionFactoryName);
                    String managedConnectionFactoryName = (String)mbeanServer.getAttribute(onJCAConnectionFactory, "managedConnectionFactory");
                    this.jmx.unregisterModelMBean(onJCAConnectionFactory);
                    this.jmx.unregisterModelMBean(new ObjectName(managedConnectionFactoryName));
                }
                String[] adminObjectNames = (String[])mbeanServer.getAttribute(onJCAResource, "adminObjects");
                for (int j = 0; j < adminObjectNames.length; ++j) {
                    String adminObjectName = adminObjectNames[j];
                    ObjectName onJCAAdminObject = new ObjectName(adminObjectName);
                    this.jmx.unregisterModelMBean(onJCAAdminObject);
                }
                String[] activationSpecNames = (String[])mbeanServer.getAttribute(onJCAResource, "activationSpecs");
                for (int j = 0; j < activationSpecNames.length; ++j) {
                    String activationSpecName = activationSpecNames[j];
                    ObjectName onJCAActivationSpec = new ObjectName(activationSpecName);
                    this.jmx.unregisterModelMBean(onJCAActivationSpec);
                }
                this.jmx.unregisterModelMBean(onJCAResource);
            }
        }
        catch (MalformedObjectNameException ma) {
            logger.log(BasicLevel.ERROR, (Object)"Cannot cleanly unregister RAR: ", (Throwable)ma);
        }
        catch (MBeanRegistrationException mr) {
            logger.log(BasicLevel.ERROR, (Object)"Cannot cleanly unregister RAR: ", (Throwable)mr);
        }
        catch (InstanceNotFoundException infe) {
            logger.log(BasicLevel.ERROR, (Object)"Cannot cleanly unregister RAR: ", (Throwable)infe);
        }
        catch (Exception e) {
            logger.log(BasicLevel.ERROR, (Object)"Cannot cleanly unregister RAR: ", (Throwable)e);
        }
        if (this.resAdp != null) {
            this.resAdp.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getConfigObj(String jndiName) {
        Hashtable hashtable = this.cfgObjs;
        synchronized (hashtable) {
            ConfigObj co = (ConfigObj)this.cfgObjs.get(jndiName);
            return co;
        }
    }

    public ConnectorDesc getConnectorDesc() {
        return this.raConn;
    }

    public void setConnectorDesc(ConnectorDesc cd) {
        this.raConn = cd;
    }

    public String getXmlContent() {
        return this.xmlContent;
    }

    public JonasConnectorDesc getJonasConnectorDesc() {
        return this.jonasConn;
    }

    public void setJonasConnectorDesc(JonasConnectorDesc jcd) {
        this.jonasConn = jcd;
    }

    public Object getFactory(String jndiname) {
        ConfigObj co = (ConfigObj)this.cfgObjs.get(jndiname);
        return co == null ? null : co.factory;
    }

    public String getInterface(String jndiname) {
        ConfigObj co = (ConfigObj)this.cfgObjs.get(jndiname);
        return co == null ? null : co.interfaceStr;
    }

    public Vector getJndinames() {
        return this.jndinames;
    }

    public javax.resource.spi.ResourceAdapter getResourceAdapter() {
        return this.resAdp;
    }

    public void configureAS(ActivationSpec as, List acp, List jacp, String jndiname, String ejbName) throws Exception {
        ConfigPropertyDesc[] asCp = this.ru.buildConfigProperty(null, acp, jacp);
        if (as.getResourceAdapter() == null) {
            as.setResourceAdapter(this.resAdp);
        }
        this.ru.processSetters(as.getClass(), as, ejbName, asCp);
        this.validateAS(as, jndiname, acp, jacp);
    }

    private void validateAS(ActivationSpec as, String jndiname, List acp, List jacp) throws Exception {
        boolean found = false;
        String reqName = null;
        RequiredConfigPropertyDesc rcProp2 = null;
        ActivationConfigPropertyDesc acProp2 = null;
        ConfigObj co = (ConfigObj)this.cfgObjs.get(jndiname);
        for (RequiredConfigPropertyDesc rcProp2 : co.reqConfigProps) {
            found = false;
            reqName = rcProp2.getConfigPropertyName();
            if (acp != null) {
                for (ActivationConfigPropertyDesc acProp2 : acp) {
                    if (!reqName.equals(acProp2.getActivationConfigPropertyName())) continue;
                    found = true;
                    break;
                }
            }
            if (!found && jacp != null) {
                for (ActivationConfigPropertyDesc acProp2 : jacp) {
                    if (!reqName.equals(acProp2.getActivationConfigPropertyName())) continue;
                    found = true;
                    break;
                }
            }
            if (found) continue;
            logger.log(BasicLevel.ERROR, (Object)("Required property " + reqName + " not specified "));
            throw new ResourceAllocationException("Required property " + reqName + " not specified ");
        }
        try {
            as.validate();
        }
        catch (UnsupportedOperationException uoe) {
        }
        catch (Exception ex) {
            logger.log(BasicLevel.ERROR, (Object)("Error from ActivationSpec.validate(). " + ex));
            throw new ResourceAllocationException("Error from ActivationSpec.validate(). ", ex);
        }
    }

    private void bldSecurityTable(JonasConnectorDesc lnkJCon, JonasConnectorDesc jCon) {
    }

    public static String buildModuleName(String rarFileName, String appName) {
        String sName = null;
        try {
            sName = new File(rarFileName).getName();
            int iPos = sName.lastIndexOf(46);
            if (iPos > -1) {
                sName = sName.substring(0, iPos);
            }
        }
        catch (NullPointerException e) {
            // empty catch block
        }
        if (appName != null) {
            StringBuffer sbName = new StringBuffer(appName);
            sbName.append(".");
            sbName.append(sName);
            sName = sbName.toString();
        }
        return sName;
    }

    public Object createFactory(String jndiName, String rarObjectName, int factoryOffset, String factoryType, ConnectorDesc conn, JonasConnectorDesc jConn) throws Exception {
        List tmParams;
        ResourceUtility ru = new ResourceUtility(null, logger, setterLogger, manageLogger);
        Object factory = null;
        ManagedConnectionFactory mcf = null;
        ResourceadapterDesc ra = conn.getResourceadapterDesc();
        javax.resource.spi.ResourceAdapter resAdp = null;
        String logEnabled = null;
        if (jConn.getLogEnabled() != null) {
            logEnabled = jConn.getLogEnabled().trim();
        }
        String logTopic = null;
        if (jConn.getLogTopic() != null) {
            logTopic = jConn.getLogTopic().trim();
        }
        String specVersion = conn.getSpecVersion();
        ConnectionManager cm = null;
        String jBase = null;
        try {
            jBase = System.getProperty("jonas.base");
            if (this.tm != null) {
                cm = ru.createConnectionManager(ra.getTransactionSupport(), this.tm, logger, poolLogger);
            }
        }
        catch (Exception ex) {
            logger.log(BasicLevel.ERROR, (Object)("Use default ConnectionManager: " + rarObjectName));
        }
        ConfigPropertyDesc[] cfgRaJonas = ru.buildConfigProperty(ra.getConfigPropertyList(), jConn.getJonasConfigPropertyList(), null);
        ConnectionManagerPoolParams cmpp = ru.configurePoolParams(jConn.getPoolParamsDesc(), jConn.getJdbcConnParamsDesc(), null);
        Properties tmProp = new Properties();
        if (jConn.getTmParamsDesc() != null && (tmParams = jConn.getTmParamsDesc().getTmConfigPropertyList()) != null) {
            for (TmConfigPropertyDesc tpd : tmParams) {
                String tpdVal = tpd.getTmConfigPropertyValue();
                if (tpdVal == null) {
                    tpdVal = "";
                }
                tmProp.setProperty(tpd.getTmConfigPropertyName(), tpdVal);
            }
            if (logger.isLoggable(BasicLevel.DEBUG)) {
                logger.log(BasicLevel.DEBUG, (Object)("TM Properties: " + tmProp));
            }
        }
        if (specVersion.equals("1.0")) {
            mcf = (ManagedConnectionFactory)ru.processMCF(conn, jConn, this.curLoader, rarObjectName, ra.getManagedconnectionfactoryClass(), jndiName, logEnabled, logTopic, cfgRaJonas, resAdp, 0);
            if (cm != null) {
                ((ConnectionManagerImpl)cm).setResourceAdapter(mcf, cmpp);
                factory = mcf.createConnectionFactory(cm);
            } else {
                factory = mcf.createConnectionFactory();
            }
        } else if (specVersion.equals("1.5")) {
            boolean callStart = false;
            String raStr = conn.getResourceadapterDesc().getResourceadapterClass().trim();
            if (raStr != null && raStr.length() > 0) {
                Class<?> raClass = this.curLoader.loadClass(raStr);
                resAdp = (javax.resource.spi.ResourceAdapter)raClass.newInstance();
                ru.processSetters(raClass, resAdp, rarObjectName, cfgRaJonas);
                try {
                    if (callStart) {
                        resAdp.start(this.bootCtx);
                    }
                }
                catch (Exception ex) {
                    logger.log(BasicLevel.ERROR, (Object)("Rar: Error from resource (" + rarObjectName + ") start method."));
                    throw new Exception("Error from start method. " + ex);
                }
                catch (Throwable th) {
                    logger.log(BasicLevel.ERROR, (Object)("Rar: Error from resource (" + rarObjectName + ") start method."));
                    throw new Exception("Error from start method. ", th);
                }
            }
            if (factoryType.equals(JCD)) {
                OutboundResourceadapterDesc outRa = ra.getOutboundResourceadapterDesc();
                List cdList = null;
                if (outRa != null) {
                    cdList = outRa.getConnectionDefinitionList();
                }
                ConnectionDefinitionDesc conDef = null;
                JonasConnectionDefinitionDesc jConDef = null;
                String id = null;
                if (cdList != null) {
                    conDef = (ConnectionDefinitionDesc)cdList.get(factoryOffset);
                    id = conDef.getId();
                    jConDef = (JonasConnectionDefinitionDesc)ru.getJonasXML(jConn, id, factoryOffset, JCD);
                    if (jConDef.getLogEnabled() != null) {
                        logEnabled = jConDef.getLogEnabled().trim();
                    }
                    if (jConDef.getLogTopic() != null) {
                        logTopic = jConDef.getLogTopic().trim();
                    }
                    ConfigPropertyDesc[] cfgCdDesc = ru.buildConfigProperty(conDef.getConfigPropertyList(), jConDef.getJonasConfigPropertyList(), null);
                    mcf = (ManagedConnectionFactory)ru.processMCF(conn, jConn, this.curLoader, rarObjectName, conDef.getManagedconnectionfactoryClass(), jndiName, logEnabled, logTopic, cfgCdDesc, resAdp, factoryOffset);
                    if (cm != null) {
                        ConnectionManagerPoolParams pool = ru.configurePoolParams(jConDef.getPoolParamsDesc(), jConDef.getJdbcConnParamsDesc(), cmpp);
                        ((ConnectionManagerImpl)cm).setResourceAdapter(mcf, pool);
                        factory = mcf.createConnectionFactory(cm);
                    } else {
                        factory = mcf.createConnectionFactory();
                    }
                }
            } else {
                if (factoryType.equals(JAO)) {
                    if (logger.isLoggable(BasicLevel.DEBUG)) {
                        logger.log(BasicLevel.DEBUG, (Object)("Cannot lookup remote admin object of " + jndiName));
                    }
                    return null;
                }
                if (factoryType.equals(JAS)) {
                    if (logger.isLoggable(BasicLevel.DEBUG)) {
                        logger.log(BasicLevel.DEBUG, (Object)("Cannot lookup remote activationspec of " + jndiName));
                    }
                    return null;
                }
            }
        }
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)("cf = " + factory));
        }
        if (factoryType.equals(JCD) && cm != null) {
            ((ConnectionManagerImpl)cm).setXAName(ru.getJcaMcfName(jndiName));
            ((ConnectionManagerImpl)cm).registerXAResource(tmProp);
        }
        return factory;
    }

    public static void addDefaultAS(String jndiName) {
        defaultAS.add(jndiName);
    }

    public static String getDefaultAS() {
        String ret;
        block2: {
            ret = null;
            try {
                ret = (String)defaultAS.firstElement();
            }
            catch (Exception ex) {
                if (!logger.isLoggable(BasicLevel.DEBUG)) break block2;
                logger.log(BasicLevel.DEBUG, (Object)"No default activationspec");
            }
        }
        return ret;
    }

    public static void removeDefaultAS(String jndiName) {
        block2: {
            try {
                defaultAS.remove(jndiName);
            }
            catch (Exception ex) {
                if (!logger.isLoggable(BasicLevel.DEBUG)) break block2;
                logger.log(BasicLevel.DEBUG, (Object)"Unable to remove default activationspec");
            }
        }
    }

    private Properties buildProp(ConfigPropertyDesc[] cfgRaJonas) {
        Properties ret = new Properties();
        if (cfgRaJonas != null) {
            for (int i = 0; i < cfgRaJonas.length; ++i) {
                String val = cfgRaJonas[i].getConfigPropertyValue() != null ? cfgRaJonas[i].getConfigPropertyValue() : "";
                ret.setProperty(cfgRaJonas[i].getConfigPropertyName(), val);
            }
        }
        return ret;
    }

    private void extractJars(String resFileName, JonasConnectorDesc jonasConn) throws ResourceServiceException {
        String rarName;
        String jarPath = JOnASResourceService.WORK_RARS_DIR + File.separator + "jonas" + File.separator;
        String binPath = null;
        if (jonasConn.getNativeLib() != null && jonasConn.getNativeLib().trim().length() > 0 && !(binPath = jonasConn.getNativeLib().trim() + File.separator).startsWith("/") && !binPath.startsWith("\\") && binPath.charAt(1) != ':') {
            binPath = JProp.getJonasBase() + File.separator + binPath;
        }
        if ((rarName = resFileName).endsWith(".rar")) {
            rarName = resFileName.substring(0, resFileName.lastIndexOf(46));
        }
        int off = rarName.lastIndexOf(File.separator);
        rarName = rarName.substring(++off);
        if (File.separatorChar == '\\') {
            off = rarName.lastIndexOf("/");
            rarName = rarName.substring(++off);
        }
        JJarFile jjar = null;
        try {
            jjar = new JJarFile(resFileName);
            Enumeration<JarEntry> ent = jjar.entries();
            while (ent.hasMoreElements()) {
                String fileName;
                JarEntry je = ent.nextElement();
                if (!je.isDirectory() && je.getName().endsWith(".jar")) {
                    fileName = this.constructFilename(jarPath, rarName, je);
                    jjar.extract(je, fileName);
                    ((JClassLoader)this.curLoader).addURL(new File(fileName).toURL());
                    continue;
                }
                if (je.isDirectory() || je.getName().startsWith("META-INF") || binPath == null) continue;
                fileName = this.constructFilename(binPath, null, je);
                jjar.extract(je, fileName);
            }
        }
        catch (Exception ex) {
            String err = "Error while extracting the files from " + resFileName;
            logger.log(BasicLevel.ERROR, (Object)(err + ex.getMessage()));
            throw new ResourceServiceException(err, ex);
        }
    }

    private String constructFilename(String path, String rarName, JarEntry je) throws Exception {
        int offset;
        String fileName = new File(path + je.getName()).toURL().getPath();
        File newd = new File(fileName.substring(0, offset = fileName.lastIndexOf("/")));
        if (!newd.exists()) {
            newd.mkdirs();
        }
        if (rarName != null) {
            String temp = newd.getPath() + File.separator;
            fileName = temp = temp + "_" + rarName + "_" + fileName.substring(offset + 1);
        }
        return fileName;
    }

    private void processJAO(String rarFilename, AdminobjectDesc aObj, JonasAdminobjectDesc jao, ConfigPropertyDesc[] cfgRaJonas, int idOff) throws Exception {
        ConfigObj cObj = null;
        String jndiName = jao.getJndiName();
        String aoDesc = "";
        for (String desc : jao.getDescriptionList()) {
            aoDesc = aoDesc + desc + " ";
        }
        if (jndiName == null || jndiName.length() == 0) {
            logger.log(BasicLevel.ERROR, (Object)("Rar: jndi-name not set in jonas-ra.xml for Adminobject: " + idOff));
            throw new Exception("configuration file incorrect");
        }
        String admObj = aObj.getAdminobjectClass();
        Class<?> aoClass = this.curLoader.loadClass(admObj);
        Object ao = aoClass.newInstance();
        this.ru.processSetters(aoClass, ao, this.rarFileName, cfgRaJonas);
        this.jndinames.add(jndiName);
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)("jndiName=" + jndiName));
        }
        cObj = new ConfigObj(JAO, idOff, jndiName, this.rarFileName, aObj.getAdminobjectInterface(), admObj, ao);
        this.cfgObjs.put(jndiName, cObj);
        try {
            this.ictx.rebind(jndiName, ao);
        }
        catch (Exception e) {
            logger.log(BasicLevel.ERROR, (Object)("Rar: Cannot register ResourceAdapter with the name " + jndiName));
            logger.log(BasicLevel.ERROR, (Object)("Rar: Exception caught : " + e));
            throw new Exception("Error binding jndiName: " + jndiName, e.getCause());
        }
        String jcaAdminobjectName = jndiName;
        Properties p = this.buildProp(cfgRaJonas);
        ObjectName onJCAAdminobject = J2eeObjectName.getJCAAdminObject(this.jDomain, this.JCAResourceName, this.jServer, jcaAdminobjectName);
        JCAAdminObject jcaAdminobjectMBean = new JCAAdminObject(onJCAAdminobject.toString(), jndiName, aoDesc, p);
        if (manageLogger.isLoggable(BasicLevel.DEBUG)) {
            manageLogger.log(BasicLevel.DEBUG, (Object)"JCAAdminObject created");
        }
        this.jmx.registerModelMBean((Object)jcaAdminobjectMBean, onJCAAdminobject);
        this.jcaResourceMBean.setAdminObjects(onJCAAdminobject.toString());
    }

    private void processJAS(String rarFilename, MessagelistenerDesc mlst, JonasActivationspecDesc jas, int idOff) throws Exception {
        ConfigObj cObj = null;
        String jndiName = jas.getJndiName();
        String asDesc = "";
        for (String desc : jas.getDescriptionList()) {
            asDesc = asDesc + desc + " ";
        }
        if (jndiName == null || jndiName.length() == 0) {
            logger.log(BasicLevel.ERROR, (Object)("Rar: jndi-name not set in jonas-ra.xml for Activationspec: " + idOff));
            throw new Exception("configuration file incorrect");
        }
        String mlIntf = mlst.getMessagelistenerType();
        String actSpec = mlst.getActivationspecDesc().getActivationspecClass();
        Class<?> asClass = this.curLoader.loadClass(actSpec);
        ActivationSpec as = (ActivationSpec)asClass.newInstance();
        this.jndinames.add(jndiName);
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)("jndiName=" + jndiName));
        }
        cObj = new ConfigObj(JAS, idOff, jndiName, rarFilename, mlIntf, actSpec, as);
        cObj.reqConfigProps = mlst.getActivationspecDesc().getRequiredConfigPropertyList();
        if (jas.getDefaultAS() != null && jas.getDefaultAS().equals("true")) {
            cObj.defaultAS = true;
            Rar.addDefaultAS(jndiName);
        }
        this.cfgObjs.put(jndiName, cObj);
        try {
            this.ictx.rebind(jndiName, (Object)as);
        }
        catch (Exception e) {
            logger.log(BasicLevel.ERROR, (Object)("Rar.processJAS: Cannot register ResourceAdapter with the name " + jndiName));
            logger.log(BasicLevel.ERROR, (Object)("Rar.processJAS: Exception caught : " + e));
            throw new Exception("Error binding jndiName: " + jndiName, e.getCause());
        }
        String jcaActivationSpecName = jndiName;
        ObjectName onJCAActivationSpec = J2eeObjectName.getJCAActivationSpec(this.jDomain, this.JCAResourceName, this.jServer, jcaActivationSpecName);
        JCAActivationSpec jcaActivationSpecMBean = new JCAActivationSpec(onJCAActivationSpec.toString(), jndiName, asDesc, cObj.reqConfigProps);
        if (manageLogger.isLoggable(BasicLevel.DEBUG)) {
            manageLogger.log(BasicLevel.DEBUG, (Object)"JCAActivationSpec created");
        }
        this.jmx.registerModelMBean((Object)jcaActivationSpecMBean, onJCAActivationSpec);
        this.jcaResourceMBean.setActivationSpecs(onJCAActivationSpec.toString());
    }

    private class ConfigObj {
        public String type;
        public int offset;
        public String jndiName;
        public String rarFilename;
        public String lnkJndiName;
        public String lnkRarFilename;
        public String interfaceStr;
        public String classStr;
        public Object factory;
        public ConnectionManager cm;
        public boolean basicPass;
        public boolean defaultAS;
        public List reqConfigProps;

        public ConfigObj(String fType, int off, String jndi, String fName, String intStr, String clsStr, Object fact) {
            this.type = fType;
            this.offset = off;
            this.jndiName = jndi;
            this.rarFilename = fName;
            this.interfaceStr = intStr;
            this.classStr = clsStr;
            this.factory = fact;
            this.cm = null;
            this.reqConfigProps = null;
            this.lnkJndiName = "";
            this.lnkRarFilename = "";
            this.defaultAS = false;
        }
    }
}

