/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.resourcemonitor.internal;

import java.util.Iterator;
import java.util.List;
import javax.management.ObjectName;
import org.ow2.jonas.jmx.JmxService;
import org.ow2.jonas.lib.service.AbsServiceImpl;
import org.ow2.jonas.lib.util.JonasObjectName;
import org.ow2.jonas.resourcemonitor.ResourceMonitorService;
import org.ow2.jonas.resourcemonitor.internal.JOnASResourceMonitorServiceMBean;
import org.ow2.jonas.service.ServiceException;
import org.ow2.util.ee.deploy.api.deployer.DeployerException;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;
import org.ow2.util.plan.deploy.deployable.api.DeploymentPlanDeployable;
import org.ow2.util.plan.deployer.api.FragmentDeploymentException;
import org.ow2.util.plan.deployer.api.FragmentUndeploymentException;
import org.ow2.util.plan.deployer.api.IDeploymentPlanDeployer;
import org.ow2.util.plan.fetcher.api.IResourceFetcher;
import org.ow2.util.plan.monitor.api.IResourceMonitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JOnASResourceMonitorService
extends AbsServiceImpl
implements ResourceMonitorService,
JOnASResourceMonitorServiceMBean {
    private static final long DEFAULT_MONITOR_TIME_INTERVAL = 60000L;
    private Log logger = LogFactory.getLog(JOnASResourceMonitorService.class);
    private IResourceMonitor resourceMonitor = null;
    private Long monitorInterval = null;
    private JmxService jmxService = null;
    private IDeploymentPlanDeployer deploymentPlanDeployer = null;
    private MonitoringThread monitoringThread = new MonitoringThread();

    @Override
    protected void doStart() throws ServiceException {
        if (this.jmxService != null) {
            try {
                ObjectName objectName = JonasObjectName.resourceMonitor(this.getDomainName());
                this.jmxService.registerMBean((Object)this, objectName);
            }
            catch (Exception e) {
                this.logger.error("JMX registration error, {0}", e);
                throw new ServiceException("JMX registration error", e);
            }
        }
        if (this.monitorInterval == null) {
            this.monitorInterval = 60000L;
        }
        this.monitoringThread.start();
        this.logger.info("Resource Monitor Service Started", new Object[0]);
    }

    @Override
    protected void doStop() throws ServiceException {
        this.monitoringThread.isStopping = true;
        if (this.jmxService != null) {
            try {
                ObjectName objectName = JonasObjectName.resourceMonitor(this.getDomainName());
                this.jmxService.unregisterMBean(objectName);
            }
            catch (Exception e) {
                this.logger.error("JMX registration error, {0}", e);
                throw new ServiceException("JMX registration error", e);
            }
        }
        this.logger.info("Resource Monitor Service Stopped", new Object[0]);
    }

    @Override
    public Integer getMonitoredResourcesCount() {
        return this.resourceMonitor.getMonitoredResourcesCount();
    }

    @Override
    public List<String> getMonitoredResourcesDescriptions() {
        return this.resourceMonitor.getMonitoredResourcesDescriptions();
    }

    @Override
    public Long getMonitoringInterval() {
        return this.monitorInterval;
    }

    @Override
    public void setMonitoringInterval(Long interval) {
        this.logger.info("Monitoring interval set to {0}", interval);
        this.monitorInterval = interval;
    }

    public void setResourceMonitor(IResourceMonitor resourceMonitor) {
        this.resourceMonitor = resourceMonitor;
    }

    public IResourceMonitor getResourceMonitor() {
        return this.resourceMonitor;
    }

    public JmxService getJmxService() {
        return this.jmxService;
    }

    public void setJmxService(JmxService jmxService) {
        this.jmxService = jmxService;
    }

    public void setDeploymentPlanDeployer(IDeploymentPlanDeployer deploymentPlanDeployer) {
        this.deploymentPlanDeployer = deploymentPlanDeployer;
    }

    public IDeploymentPlanDeployer getDeploymentPlanDeployer() {
        return this.deploymentPlanDeployer;
    }

    private class MonitoringThread
    extends Thread {
        boolean isStopping = false;

        private MonitoringThread() {
        }

        public void run() {
            block2: while (true) {
                try {
                    Thread.sleep(JOnASResourceMonitorService.this.monitorInterval);
                }
                catch (InterruptedException e) {
                    JOnASResourceMonitorService.this.logger.warn("Sleep interrupted", new Object[0]);
                }
                if (this.isStopping) {
                    return;
                }
                Iterator<IResourceFetcher> i$ = JOnASResourceMonitorService.this.resourceMonitor.getChangedResources().iterator();
                do {
                    if (!i$.hasNext()) continue block2;
                    IResourceFetcher resourceFetcher = i$.next();
                    this.processResource(resourceFetcher);
                } while (!this.isStopping);
                break;
            }
        }

        private void processResource(IResourceFetcher resourceFetcher) {
            JOnASResourceMonitorService.this.resourceMonitor.removeMonitoredResource(resourceFetcher);
            try {
                JOnASResourceMonitorService.this.deploymentPlanDeployer.undeployDeployment(resourceFetcher.getDeployment());
            }
            catch (FragmentUndeploymentException e) {
                JOnASResourceMonitorService.this.logger.error("Exception while trying to redeploy deployment {0} (during undeployment) - trying to go on.", resourceFetcher.getDeployment());
            }
            try {
                JOnASResourceMonitorService.this.deploymentPlanDeployer.deployDeployment(resourceFetcher.getDeployment());
                JOnASResourceMonitorService.this.logger.info("Resource {0} changed and was redeployed", resourceFetcher.getDeployment());
            }
            catch (FragmentDeploymentException e) {
                JOnASResourceMonitorService.this.logger.error("Exception while trying to redeploy deployment {0} (during deployment) - aborting", resourceFetcher.getDeployment());
                DeploymentPlanDeployable deploymentPlanDeployable = JOnASResourceMonitorService.this.deploymentPlanDeployer.getOwnerDeploymentPlanDeployable(resourceFetcher.getDeployment());
                if (deploymentPlanDeployable == null) {
                    JOnASResourceMonitorService.this.logger.error("Could not find which deployment plan owns the deployment {0} - stopping undeployment", resourceFetcher.getDeployment());
                }
                try {
                    JOnASResourceMonitorService.this.deploymentPlanDeployer.undeploy(deploymentPlanDeployable);
                }
                catch (DeployerException deployerException) {
                    JOnASResourceMonitorService.this.logger.error("Could not undeploy deployment plan {0}", deploymentPlanDeployable);
                }
            }
        }
    }
}

