/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.security.auth.spi;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.security.InvalidKeyException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.Principal;
import java.security.PrivateKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.UnrecoverableKeyException;
import java.security.acl.Group;
import java.security.cert.CertificateException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.login.LoginException;
import javax.security.auth.spi.LoginModule;
import org.ow2.jonas.lib.security.auth.JSigned;

public class SignLoginModule
implements LoginModule {
    private Subject subject = null;
    private Map options = null;
    private static PrivateKey privateKey = null;

    public void initialize(Subject subject, CallbackHandler callbackHandler, Map sharedState, Map options) {
        this.subject = subject;
        this.options = options;
    }

    public boolean login() throws LoginException {
        if (privateKey == null) {
            String keystoreFile = (String)this.options.get("keystoreFile");
            if (keystoreFile == null) {
                throw new LoginException("The 'keystoreFile' attribute was not found but this attribute is mandatory");
            }
            String keystorePass = (String)this.options.get("keystorePass");
            if (keystorePass == null) {
                throw new LoginException("The 'keystorePass' attribute was not found but this attribute is mandatory");
            }
            String keyPass = (String)this.options.get("keyPass");
            if (keyPass == null) {
                throw new LoginException("The 'keyPass' attribute was not found but this attribute is mandatory");
            }
            String alias = (String)this.options.get("alias");
            if (alias == null) {
                throw new LoginException("The 'alias' attribute was not found but this attribute is mandatory");
            }
            File f = new File(keystoreFile);
            if (!f.exists()) {
                throw new LoginException("The keystore file named '" + f + "' was not found.");
            }
            KeyStore keyStore = null;
            try {
                keyStore = KeyStore.getInstance(KeyStore.getDefaultType());
            }
            catch (KeyStoreException e) {
                throw new LoginException("Error while getting a keystore '" + e.getMessage());
            }
            try {
                keyStore.load(new BufferedInputStream(new FileInputStream(f)), keystorePass.toCharArray());
            }
            catch (NoSuchAlgorithmException e) {
                throw new LoginException("Error while loading the keystore file '" + f + "'." + e.getMessage());
            }
            catch (CertificateException e) {
                throw new LoginException("Error while loading the keystore file '" + f + "'." + e.getMessage());
            }
            catch (FileNotFoundException e) {
                throw new LoginException("Error while loading the keystore file '" + f + "'." + e.getMessage());
            }
            catch (IOException e) {
                throw new LoginException("Error while loading the keystore file '" + f + "'." + e.getMessage());
            }
            try {
                privateKey = (PrivateKey)keyStore.getKey(alias, keyPass.toCharArray());
            }
            catch (KeyStoreException e) {
                throw new LoginException("Error while getting alias named '" + alias + "' in the keystore file '" + f + "'." + e.getMessage());
            }
            catch (NoSuchAlgorithmException e) {
                throw new LoginException("Error while getting alias named '" + alias + "' in the keystore file '" + f + "'." + e.getMessage());
            }
            catch (UnrecoverableKeyException e) {
                throw new LoginException("Error while getting alias named '" + alias + "' in the keystore file '" + f + "'." + e.getMessage());
            }
        }
        return true;
    }

    public boolean commit() throws LoginException {
        Signature signature;
        String principalName = null;
        Set<Principal> principals = this.subject.getPrincipals(Principal.class);
        for (Principal principal : principals) {
            if (principal instanceof Group) continue;
            principalName = principal.getName();
        }
        if (principalName == null) {
            throw new LoginException("There was no previous login module. This login module can only be used in addition to another module which perform the authentication.");
        }
        ArrayList<String> principalRoles = new ArrayList<String>();
        principals = this.subject.getPrincipals(Group.class);
        for (Group group : principals) {
            Enumeration e = group.members();
            while (e.hasMoreElements()) {
                Principal p = (Principal)e.nextElement();
                principalRoles.add(p.getName());
            }
        }
        Object var5_6 = null;
        try {
            signature = Signature.getInstance("SHA1withDSA");
        }
        catch (NoSuchAlgorithmException e) {
            throw new LoginException("The algorithm 'SHA1withDSA' was not found:" + e.getMessage());
        }
        try {
            signature.initSign(privateKey);
        }
        catch (InvalidKeyException e) {
            throw new LoginException("Invalid private key when initializing signature:" + e.getMessage());
        }
        try {
            signature.update(principalName.getBytes());
        }
        catch (SignatureException e) {
            throw new LoginException("Cannot add the bytes of the principal name:" + e.getMessage());
        }
        Iterator itRole = principalRoles.iterator();
        while (itRole.hasNext()) {
            try {
                signature.update(((String)itRole.next()).getBytes());
            }
            catch (SignatureException e) {
                throw new LoginException("Cannot add the bytes of one role:" + e.getMessage());
            }
        }
        byte[] signedData = null;
        try {
            signedData = signature.sign();
        }
        catch (SignatureException e) {
            throw new LoginException("Cannot sign the data:" + e.getMessage());
        }
        JSigned signed = new JSigned(signedData);
        this.subject.getPrincipals().add((Principal)((Object)signed));
        return true;
    }

    public boolean abort() throws LoginException {
        return true;
    }

    public boolean logout() throws LoginException {
        return true;
    }
}

