/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.services.bootstrap.repository;

import java.io.File;
import java.util.ArrayList;
import java.util.Dictionary;
import java.util.Hashtable;
import java.util.List;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.osgi.service.cm.Configuration;
import org.osgi.service.cm.ConfigurationAdmin;
import org.ow2.jonas.lib.bootstrap.JProp;
import org.ow2.jonas.lib.util.JonasObjectName;
import org.ow2.jonas.properties.ServerProperties;
import org.ow2.jonas.services.bootstrap.repository.JOnASRepositoriesMBean;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;
import org.ow2.util.plan.bindings.exceptions.InvalidRepositoryException;
import org.ow2.util.plan.bindings.repository.ExtendedRepository;
import org.ow2.util.plan.bindings.repository.Repositories;
import org.ow2.util.plan.bindings.repository.Repository;
import org.ow2.util.plan.bindings.repository.RepositoryKind;
import org.ow2.util.plan.deployer.api.IRepositoryDeployer;
import org.ow2.util.plan.reader.repository.IRepositoryDataReader;
import org.ow2.util.plan.repository.api.IRepositoryManager;
import org.ow2.util.plan.repository.api.RepositoryIdCollisionException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JOnASRepositories
implements JOnASRepositoriesMBean {
    private Log logger = LogFactory.getLog(JOnASRepositories.class);
    private ServerProperties serverProperties = null;
    private IRepositoryManager repositoryManager = null;
    private ConfigurationAdmin configurationAdmin = null;
    private MBeanServer mbeanServer = null;
    private IRepositoryDeployer repositoryDeployer;
    private IRepositoryDataReader repositoryReader = null;
    private static final String PROP_M2_LOCAL_REPOSITORY = "m2.repository";
    private static final String PATH_DEFAULT_REPOSITORY = ".m2/repository";
    private static final String CONFIG_FILE = "initial-repositories.xml";

    public void start() throws Exception {
        Configuration configuration = this.configurationAdmin.getConfiguration("org.ow2.util.plan.fetcher", null);
        if (configuration != null) {
            Hashtable<String, String> props = new Hashtable<String, String>();
            ((Dictionary)props).put("local.repositories.base.dir", JProp.getJonasRoot() + "/repositories");
            configuration.update(props);
        }
        this.addLocalRepository();
        Repositories initialRepositories = null;
        File configFile = new File(JProp.getConfDir(), CONFIG_FILE);
        if (configFile.exists()) {
            try {
                initialRepositories = this.repositoryReader.readRepositories(configFile);
            }
            catch (Exception e) {
                this.logger.error("Exception while parsing the initial repositories file : {0}", e);
            }
        }
        if (initialRepositories != null) {
            int repositoryCount = 0;
            for (Repository repository : initialRepositories.getRepositories()) {
                try {
                    this.repositoryManager.addRepository(repository);
                    ++repositoryCount;
                }
                catch (RepositoryIdCollisionException e) {
                    this.logger.warn("Multiple repository with same id; id={0}", repository.getId());
                }
                catch (InvalidRepositoryException e) {
                    this.logger.warn("Invalid repository with id {0}", repository.getId());
                }
            }
            this.logger.debug("JOnAS started with {0} repositories.", repositoryCount);
        } else {
            this.logger.debug("JOnAS started with no repositories", new Object[0]);
        }
        try {
            ObjectName objectName = JonasObjectName.repository(this.serverProperties.getDomainName());
            this.mbeanServer.registerMBean(this, objectName);
        }
        catch (Exception e) {
            this.logger.error("MBean registration error, {0}", e);
        }
    }

    public void stop() throws Exception {
        if (this.mbeanServer != null) {
            try {
                ObjectName objectName = JonasObjectName.repository(this.serverProperties.getDomainName());
                this.mbeanServer.unregisterMBean(objectName);
            }
            catch (Exception e) {
                this.logger.error("MBean unregistration error, {0}", e);
            }
        }
    }

    @Override
    public Integer getRepositoryDeployablesCount() {
        return this.repositoryDeployer.getDeployablesCount();
    }

    @Override
    public List<String> getRepositoriesDescriptions() {
        ArrayList<String> repositoriesDescriptions = new ArrayList<String>();
        for (Repository repository : this.repositoryManager) {
            repositoriesDescriptions.add(repository.toString());
        }
        return repositoriesDescriptions;
    }

    @Override
    public Integer getRepositoriesNumber() {
        return this.repositoryManager.getRepositoryCount();
    }

    public void setServerProperties(ServerProperties serverProperties) {
        this.serverProperties = serverProperties;
    }

    public void setRepositoryManager(IRepositoryManager repositoryManager) {
        this.repositoryManager = repositoryManager;
    }

    public void setRepositoryDeployer(IRepositoryDeployer repositoryDeployer) {
        this.repositoryDeployer = repositoryDeployer;
    }

    public void setMBeanServer(MBeanServer mbeanServer) {
        this.mbeanServer = mbeanServer;
    }

    public void setRepositoryReader(IRepositoryDataReader repositoryReader) {
        this.repositoryReader = repositoryReader;
    }

    public void setConfigurationAdmin(ConfigurationAdmin configurationAdmin) {
        this.configurationAdmin = configurationAdmin;
    }

    private void addLocalRepository() {
        boolean developer = Boolean.getBoolean("jonas.developer");
        ExtendedRepository repository = new ExtendedRepository();
        repository.setType(RepositoryKind.MAVEN_2);
        String location = null;
        if (developer) {
            repository.setId("Maven2 local repository");
            location = this.getMaven2RepositoryLocation();
        } else {
            repository.setId("JOnAS bundles repository");
            location = this.getRepositoriesBundlesLocation();
        }
        if (location.startsWith("/")) {
            repository.setUrl("file:" + location);
        } else {
            repository.setUrl("file:/" + location);
        }
        try {
            this.repositoryManager.addRepository(repository);
        }
        catch (RepositoryIdCollisionException e) {
            this.logger.error("Cannot add repository {0}, it already exists", repository);
        }
        catch (InvalidRepositoryException e) {
            this.logger.error("Invalid repository {0}", repository);
        }
    }

    private String getRepositoriesBundlesLocation() {
        return JProp.getJonasRoot() + File.separator + "repositories" + File.separator + "bundles";
    }

    private String getMaven2RepositoryLocation() {
        String m2Repository = System.getProperty(PROP_M2_LOCAL_REPOSITORY);
        if (m2Repository == null) {
            String userHome = System.getProperty("user.home");
            m2Repository = userHome + File.separator + PATH_DEFAULT_REPOSITORY;
        }
        return m2Repository;
    }
}

