/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.web.tomcat6.versioning;

import org.apache.catalina.connector.CoyoteAdapter;
import org.objectweb.util.monolog.api.BasicLevel;
import org.objectweb.util.monolog.api.Logger;
import org.ow2.jonas.asm.MethodAdapter;
import org.ow2.jonas.asm.MethodVisitor;
import org.ow2.jonas.lib.util.Log;
import org.ow2.jonas.web.tomcat6.versioning.CoyoteAdapterWithDelegatedContextSearch;

public class ReplaceNewCoyoteAdapter
extends MethodAdapter {
    private static Logger logger = Log.getLogger(ReplaceNewCoyoteAdapter.class.getName());
    private String coyoteAdapterName = CoyoteAdapter.class.getName().replace('.', '/');
    private String modifiedCoyoteAdapterName = CoyoteAdapterWithDelegatedContextSearch.class.getName().replace('.', '/');

    public ReplaceNewCoyoteAdapter(MethodVisitor mv) {
        super(mv);
    }

    public void visitTypeInsn(int opcode, String owner) {
        logger.log(BasicLevel.DEBUG, (Object)("Inside visitTypeInsn with owner : " + owner));
        if (this.coyoteAdapterName.equals(owner)) {
            logger.log(BasicLevel.DEBUG, (Object)("    Changing TypeInsn for owner: " + owner));
            owner = this.modifiedCoyoteAdapterName;
        }
        this.mv.visitTypeInsn(opcode, owner);
    }

    public void visitMethodInsn(int opcode, String owner, String name, String desc) {
        logger.log(BasicLevel.DEBUG, (Object)("Inside visitMethodInsn with owner : " + owner));
        if (this.coyoteAdapterName.equals(owner)) {
            logger.log(BasicLevel.DEBUG, (Object)("    Changing MethodInsn for method: " + name + ", owner " + owner));
            owner = this.modifiedCoyoteAdapterName;
        }
        this.mv.visitMethodInsn(opcode, owner, name, desc);
    }
}

