/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.ws.base.mbean;

import java.util.List;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.objectweb.util.monolog.api.BasicLevel;
import org.objectweb.util.monolog.api.Logger;
import org.ow2.jonas.jmx.JmxService;
import org.ow2.jonas.lib.management.javaee.J2EEManagedObject;
import org.ow2.jonas.lib.util.Log;

public abstract class AbstractWebServiceMBean
extends J2EEManagedObject {
    private static Logger log = Log.getLogger("org.ow2.jonas.ws");
    private ObjectName realObjectName = null;

    public AbstractWebServiceMBean(String objectName) {
        super(objectName);
        try {
            this.realObjectName = ObjectName.getInstance(objectName);
        }
        catch (MalformedObjectNameException e) {
            this.realObjectName = null;
        }
    }

    public void register(JmxService jmx) {
        try {
            jmx.registerModelMBean((Object)this, this.realObjectName);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        List childs = this.getChildsMBeans();
        if (childs != null) {
            for (AbstractWebServiceMBean child : childs) {
                child.register(jmx);
            }
        }
    }

    protected abstract String getMBeanType();

    public void unregister(JmxService jmx) {
        try {
            jmx.unregisterModelMBean(ObjectName.getInstance(this.getObjectName()));
        }
        catch (Exception e) {
            log.log(BasicLevel.DEBUG, (Object)"Should never goes here", (Throwable)e);
        }
        List childs = this.getChildsMBeans();
        if (childs != null) {
            for (AbstractWebServiceMBean child : childs) {
                child.unregister(jmx);
            }
        }
    }

    protected abstract List getChildsMBeans();

    public ObjectName getRealObjectName() {
        return this.realObjectName;
    }
}

