/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.util.ee.metadata.common.impl.enc;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.ow2.util.asm.Type;
import org.ow2.util.ee.metadata.common.api.ICommonClassMetadata;
import org.ow2.util.ee.metadata.common.api.ICommonFieldMetadata;
import org.ow2.util.ee.metadata.common.api.ICommonMethodMetadata;
import org.ow2.util.ee.metadata.common.api.interfaces.ISharedMetadata;
import org.ow2.util.ee.metadata.common.api.struct.IJAnnotationResource;
import org.ow2.util.ee.metadata.common.api.struct.IJEjbEJB;
import org.ow2.util.ee.metadata.common.api.struct.IJavaxPersistenceContext;
import org.ow2.util.ee.metadata.common.api.struct.IJavaxPersistenceUnit;
import org.ow2.util.ee.metadata.common.api.struct.IJaxwsWebServiceRef;
import org.ow2.util.ee.metadata.common.impl.CommonFieldMetadata;
import org.ow2.util.ee.metadata.common.impl.CommonMethodMetadata;
import org.ow2.util.ee.metadata.common.impl.enc.ENCBinding;
import org.ow2.util.ee.metadata.common.impl.enc.ENCBindingException;
import org.ow2.util.ee.metadata.common.impl.enc.ENCBindingHolder;
import org.ow2.util.scan.api.metadata.structures.JMethod;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbsENCBindingBuilder {
    private ENCBindingHolder bindingHolder = new ENCBindingHolder();
    private static final int GETTER_LENGTH = 3;

    protected abstract Collection<? extends ICommonClassMetadata<?, ?, ?>> getClassMetadataCollection();

    protected AbsENCBindingBuilder() {
    }

    protected void analyze() throws ENCBindingException {
        for (ICommonClassMetadata<?, ?, ?> classMetadata : this.getClassMetadataCollection()) {
            this.analyzeClassMetadata(classMetadata);
        }
    }

    protected void analyzeClassMetadata(ICommonClassMetadata<?, ?, ?> classMetadata) throws ENCBindingException {
        List<IJaxwsWebServiceRef> refs;
        List<IJEjbEJB> jEjbEJBs;
        List<IJAnnotationResource> jAnnotationResources;
        List<IJavaxPersistenceUnit> javaxPersistenceUnits;
        List<IJavaxPersistenceContext> javaxPersistenceContexts = classMetadata.getJavaxPersistencePersistenceContexts();
        if (javaxPersistenceContexts != null) {
            for (IJavaxPersistenceContext javaxPersistenceContext : javaxPersistenceContexts) {
                this.addPersistenceContext(javaxPersistenceContext);
            }
        }
        if ((javaxPersistenceUnits = classMetadata.getJavaxPersistencePersistenceUnits()) != null) {
            for (IJavaxPersistenceUnit javaxPersistenceUnit : javaxPersistenceUnits) {
                this.addPersistenceUnit(javaxPersistenceUnit);
            }
        }
        if ((jAnnotationResources = classMetadata.getJAnnotationResources()) != null) {
            for (IJAnnotationResource jAnnotationResource : jAnnotationResources) {
                this.addResource(jAnnotationResource);
            }
        }
        if ((jEjbEJBs = classMetadata.getJEjbEJBs()) != null) {
            for (IJEjbEJB jEjbEJB : jEjbEJBs) {
                this.addEJB(jEjbEJB);
            }
        }
        if ((refs = classMetadata.getJaxwsWebServiceRefs()) != null) {
            for (IJaxwsWebServiceRef ref : refs) {
                if (this.isNullOrEmpty(ref.getName())) {
                    throw new ENCBindingException("@WebServiceRef.name (or service-ref/service-ref-name) required in the annotation/XML defined for the class '" + classMetadata.getJClass() + "'.");
                }
                if (this.isNullOrEmpty(ref.getType())) {
                    throw new ENCBindingException("@WebServiceRef.type (or service-ref/service-ref-type) required in the annotation/XML defined for the class '" + classMetadata.getJClass() + "'.");
                }
                if (this.isNullOrEmpty(ref.getValue())) {
                    ref.setValue(ref.getType());
                }
                this.addWebServiceRef(ref);
            }
        }
        this.analyzeCommonMetadata(classMetadata);
        for (ICommonFieldMetadata fieldAnnotationMetadata : classMetadata.getStandardFieldMetadataCollection()) {
            this.analyzeFieldMetadata(fieldAnnotationMetadata);
        }
        for (ICommonMethodMetadata methodAnnotationMetadata : classMetadata.getStandardMethodMetadataCollection()) {
            this.analyzeMethodMetadata(methodAnnotationMetadata);
        }
    }

    protected void analyzeFieldMetadata(ICommonFieldMetadata<?, ?, ?> fieldMetadata) throws ENCBindingException {
        this.analyzeCommonMetadata(fieldMetadata);
    }

    protected void analyzeMethodMetadata(ICommonMethodMetadata<?, ?, ?> methodMetadata) throws ENCBindingException {
        this.analyzeCommonMetadata(methodMetadata);
    }

    protected void analyzeCommonMetadata(ISharedMetadata commonMetadata) throws ENCBindingException {
        IJaxwsWebServiceRef ref;
        IJEjbEJB jEjbEJB;
        IJAnnotationResource jAnnotationResource;
        IJavaxPersistenceUnit javaxPersistenceUnit;
        IJavaxPersistenceContext javaxPersistenceContext = commonMetadata.getJavaxPersistenceContext();
        if (javaxPersistenceContext != null) {
            if (this.isNullOrEmpty(javaxPersistenceContext.getName())) {
                javaxPersistenceContext.setName(this.getName(commonMetadata, javaxPersistenceContext));
            }
            this.addPersistenceContext(javaxPersistenceContext);
        }
        if ((javaxPersistenceUnit = commonMetadata.getJavaxPersistenceUnit()) != null) {
            if (this.isNullOrEmpty(javaxPersistenceUnit.getName())) {
                javaxPersistenceUnit.setName(this.getName(commonMetadata, javaxPersistenceUnit));
            }
            this.addPersistenceUnit(javaxPersistenceUnit);
        }
        if ((jAnnotationResource = commonMetadata.getJAnnotationResource()) != null) {
            if (this.isNullOrEmpty(jAnnotationResource.getName())) {
                jAnnotationResource.setName(this.getName(commonMetadata, jAnnotationResource));
            }
            jAnnotationResource.setType(this.getType(commonMetadata, jAnnotationResource.getType()));
            this.addResource(jAnnotationResource);
        }
        if ((jEjbEJB = commonMetadata.getJEjbEJB()) != null) {
            if (this.isNullOrEmpty(jEjbEJB.getName())) {
                jEjbEJB.setName(this.getName(commonMetadata, jEjbEJB));
            }
            jEjbEJB.setBeanInterface(this.getType(commonMetadata, jEjbEJB.getBeanInterface()));
            this.addEJB(jEjbEJB);
        }
        if ((ref = commonMetadata.getJaxwsWebServiceRef()) != null) {
            if (this.isNullOrEmpty(ref.getName())) {
                ref.setName(this.getName(commonMetadata, ref));
            }
            if (this.isNullOrEmpty(ref.getValue())) {
                ref.setValue(this.getType(commonMetadata, null));
            }
            ref.setType(this.getType(commonMetadata, ref.getType()));
            this.addWebServiceRef(ref);
        }
    }

    private boolean isNullOrEmpty(String name) {
        return name == null || "".equals(name);
    }

    private String getName(ISharedMetadata commonMetadata, Object o) throws ENCBindingException {
        if (commonMetadata instanceof CommonFieldMetadata) {
            CommonFieldMetadata fieldAnnotationMetadata = (CommonFieldMetadata)commonMetadata;
            return ((ICommonClassMetadata)fieldAnnotationMetadata.getClassMetadata()).getJClass().getName().replace("/", ".") + "/" + fieldAnnotationMetadata.getJField().getName();
        }
        if (commonMetadata instanceof CommonMethodMetadata) {
            CommonMethodMetadata methodAnnotationMetadata = (CommonMethodMetadata)commonMetadata;
            StringBuilder propertyBuilder = new StringBuilder(methodAnnotationMetadata.getJMethod().getName());
            propertyBuilder.delete(0, 3);
            propertyBuilder.setCharAt(0, Character.toLowerCase(propertyBuilder.charAt(0)));
            propertyBuilder.insert(0, ((ICommonClassMetadata)methodAnnotationMetadata.getClassMetadata()).getJClass().getName().replace("/", ".") + "/");
            return propertyBuilder.toString();
        }
        throw new ENCBindingException("There is no defined name in the object '" + o + "' that is defined on the class '" + commonMetadata + "'.");
    }

    private String getType(ISharedMetadata commonMetadata, String currentType) throws ENCBindingException {
        if (commonMetadata instanceof CommonFieldMetadata) {
            CommonFieldMetadata fieldAnnotationMetadata = (CommonFieldMetadata)commonMetadata;
            Type typeInterface = Type.getType(fieldAnnotationMetadata.getJField().getDescriptor());
            return typeInterface.getClassName();
        }
        if (commonMetadata instanceof CommonMethodMetadata) {
            CommonMethodMetadata methodAnnotationMetadata = (CommonMethodMetadata)commonMetadata;
            JMethod jMethod = methodAnnotationMetadata.getJMethod();
            Type[] args = Type.getArgumentTypes(jMethod.getDescriptor());
            if (args.length != 1) {
                throw new ENCBindingException("Method args '" + Arrays.asList(args) + "' for method '" + jMethod + "' are invalid. Length should be of 1.");
            }
            Type typeInterface = args[0];
            return typeInterface.getClassName();
        }
        return currentType;
    }

    protected void addPersistenceContext(IJavaxPersistenceContext javaxPersistenceContext) {
        this.bindingHolder.addPersistenceContextBinding(new ENCBinding<IJavaxPersistenceContext>(javaxPersistenceContext.getName(), javaxPersistenceContext));
    }

    protected void addPersistenceUnit(IJavaxPersistenceUnit javaxPersistenceUnit) {
        this.bindingHolder.addPersistenceUnitBinding(new ENCBinding<IJavaxPersistenceUnit>(javaxPersistenceUnit.getName(), javaxPersistenceUnit));
    }

    protected void addResource(IJAnnotationResource jAnnotationResource) {
        this.bindingHolder.addResourceBinding(new ENCBinding<IJAnnotationResource>(jAnnotationResource.getName(), jAnnotationResource));
    }

    protected void addEJB(IJEjbEJB jEjbEJB) {
        this.bindingHolder.addEJBBinding(new ENCBinding<IJEjbEJB>(jEjbEJB.getName(), jEjbEJB));
    }

    protected void addWebServiceRef(IJaxwsWebServiceRef ref) {
        this.bindingHolder.addWebServicesBinding(new ENCBinding<IJaxwsWebServiceRef>(ref.getName(), ref));
    }

    protected ENCBindingHolder getHolder() {
        return this.bindingHolder;
    }
}

