/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.util.plan.deployer.impl;

import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.ow2.util.archive.api.ArchiveException;
import org.ow2.util.archive.api.IArchive;
import org.ow2.util.archive.impl.ArchiveManager;
import org.ow2.util.ee.deploy.api.deployable.IDeployable;
import org.ow2.util.ee.deploy.api.deployable.OSGiDeployable;
import org.ow2.util.ee.deploy.api.deployer.DeployerException;
import org.ow2.util.ee.deploy.api.deployer.IDeployerManager;
import org.ow2.util.ee.deploy.api.deployer.UnsupportedDeployerException;
import org.ow2.util.ee.deploy.impl.helper.DeployableHelper;
import org.ow2.util.ee.deploy.impl.helper.DeployableHelperException;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;
import org.ow2.util.plan.bindings.deploymentplan.Deployment;
import org.ow2.util.plan.bindings.deploymentplan.DeploymentHelper;
import org.ow2.util.plan.bindings.deploymentplan.DeploymentPlan;
import org.ow2.util.plan.bindings.deploymentplan.DeploymentPlanFragment;
import org.ow2.util.plan.bindings.exceptions.InvalidDeploymentException;
import org.ow2.util.plan.deploy.deployable.api.DeploymentPlanDeployable;
import org.ow2.util.plan.deploy.deployable.impl.DeploymentPlanDeployableImpl;
import org.ow2.util.plan.deployer.api.DeploymentPlanDeploymentException;
import org.ow2.util.plan.deployer.api.DeploymentPlanUndeploymentException;
import org.ow2.util.plan.deployer.api.FragmentDeploymentException;
import org.ow2.util.plan.deployer.api.FragmentUndeploymentException;
import org.ow2.util.plan.deployer.api.IDeploymentPlanDeployer;
import org.ow2.util.plan.fetcher.api.IResourceFetcher;
import org.ow2.util.plan.fetcher.api.IResourceFetcherFactoryManager;
import org.ow2.util.plan.monitor.api.IResourceMonitor;
import org.ow2.util.plan.reader.plan.IPlanReader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DeploymentPlanDeployer
implements IDeploymentPlanDeployer {
    private IDeployerManager deployerManager = null;
    private Map<Deployment, IDeployable> deploymentToDeployableMap = new HashMap<Deployment, IDeployable>();
    private IResourceMonitor resourceMonitor = null;
    private static Log logger = LogFactory.getLog(DeploymentPlanDeployer.class);
    private Collection<DeploymentPlanDeployable> deploymentPlans = new ArrayList<DeploymentPlanDeployable>();
    private IPlanReader planReader;
    private IResourceFetcherFactoryManager fetcherFactoryManager = null;

    @Override
    public void deploy(IDeployable<?> deployable) throws DeployerException {
        if (deployable == null) {
            logger.error("Null deployable", new Object[0]);
            throw new DeployerException("Null deployable");
        }
        if (!(deployable instanceof DeploymentPlanDeployable)) {
            logger.error("Bad deployable type {0}", deployable.getClass());
            throw new DeployerException("Bad deployable type");
        }
        DeploymentPlanDeployable deploymentPlanDeployable = (DeploymentPlanDeployable)deployable;
        DeploymentPlan deploymentPlan = null;
        if (this.planReader == null) {
            logger.error("Deployment aborted - the PlanReader is null", new Object[0]);
            throw new DeployerException("the PlanReader is null");
        }
        URL archiveUrl = null;
        try {
            archiveUrl = deploymentPlanDeployable.getArchive().getURL();
        }
        catch (ArchiveException e) {
            logger.error("Error while getting URL for archive {0} - Deployment aborted", deploymentPlanDeployable.getArchive());
            throw new DeployerException(e);
        }
        try {
            deploymentPlan = this.planReader.readPlan(new File(archiveUrl.getPath()));
        }
        catch (Exception e) {
            logger.error("Error while parsing archive {0} - Deployment aborted", archiveUrl);
            throw new DeployerException(e);
        }
        if (deploymentPlan == null) {
            logger.error("The deployable {0} resolved in null deployment plan - Deployment aborted", deployable);
            throw new DeployerException("null deployment plan structure");
        }
        deploymentPlanDeployable.setAttachedData(deploymentPlan);
        try {
            this.deployDeploymentPlans(deploymentPlan);
        }
        catch (DeploymentPlanDeploymentException e) {
            logger.error("Deployment plan deployment failed; exception: {0}", e);
            throw new DeployerException(e);
        }
        logger.debug("deployable {0} deployed", deployable);
        this.deploymentPlans.add(deploymentPlanDeployable);
    }

    @Override
    public boolean isDeployed(IDeployable<?> deployable) throws DeployerException {
        return this.deploymentPlans.contains(deployable);
    }

    @Override
    public boolean supports(IDeployable<?> deployable) {
        return deployable instanceof DeploymentPlanDeployableImpl;
    }

    @Override
    public void undeploy(IDeployable<?> deployable) throws DeployerException {
        if (deployable == null) {
            logger.error("Null deployable", new Object[0]);
            throw new DeployerException("Null deployable");
        }
        if (!(deployable instanceof DeploymentPlanDeployable)) {
            logger.error("Bad deployable type {0}", deployable.getClass());
            throw new DeployerException("Bad deployable type");
        }
        if (this.isDeployed(deployable)) {
            this.deploymentPlans.remove(deployable);
            DeploymentPlanDeployable deploymentPlanDeployable = (DeploymentPlanDeployable)deployable;
            DeploymentPlan deploymentPlan = deploymentPlanDeployable.getAttachedData();
            try {
                this.undeployDeploymentPlans(deploymentPlan);
            }
            catch (DeploymentPlanUndeploymentException e) {
                logger.error("Deployment plan undeployment failed; exception: {0}", e);
                throw new DeployerException(e);
            }
        } else {
            logger.error("Cannot undeploy deployable {0} - it is not deployed", deployable);
            throw new DeployerException("Cannot undeploy deployable that is not deployed");
        }
        logger.debug("deployable {0} undeployed", deployable);
    }

    @Override
    public void setPlanReader(IPlanReader planReader) {
        this.planReader = planReader;
    }

    @Override
    public IPlanReader getPlanReader() {
        return this.planReader;
    }

    private void deployDeploymentPlans(DeploymentPlan deploymentPlan) throws DeploymentPlanDeploymentException {
        for (DeploymentPlan plans : deploymentPlan.getDeploymentPlans()) {
            this.deployDeploymentPlans(plans);
        }
        this.deployDeploymentPlan(deploymentPlan);
    }

    private void deployDeploymentPlan(DeploymentPlan deploymentPlan) throws DeploymentPlanDeploymentException {
        for (Deployment deployment : deploymentPlan.getDeployments()) {
            DeploymentPlanFragment fragment = (DeploymentPlanFragment)deployment;
            try {
                this.deployDeployment(fragment);
                fragment.setDeployed(true);
            }
            catch (FragmentDeploymentException deployException) {
                logger.error("Error while deploying part {0} of deployment plan {1} : {2}", fragment, deploymentPlan, deployException);
                if (deploymentPlan.isAtomic()) {
                    logger.error("The deployment plan {0} failed and is atomic; it must be undeployed", deploymentPlan);
                    try {
                        this.undeployDeploymentPlans(deploymentPlan);
                    }
                    catch (DeploymentPlanUndeploymentException undeployException) {
                        logger.error("The deployment plan was not correctly undeployed.", new Object[0]);
                    }
                }
                throw new DeploymentPlanDeploymentException(deployException);
            }
        }
    }

    private void undeployDeploymentPlans(DeploymentPlan deploymentPlan) throws DeploymentPlanUndeploymentException {
        for (DeploymentPlan plans : deploymentPlan.getDeploymentPlans()) {
            this.undeployDeploymentPlans(plans);
        }
        this.undeployDeploymentPlan(deploymentPlan);
    }

    private void undeployDeploymentPlan(DeploymentPlan deploymentPlan) throws DeploymentPlanUndeploymentException {
        for (Deployment deployment : deploymentPlan.getDeployments()) {
            DeploymentPlanFragment fragment = (DeploymentPlanFragment)deployment;
            boolean partialFail = false;
            if (fragment.isDeployed()) {
                try {
                    this.undeployDeployment(fragment);
                    fragment.setDeployed(false);
                }
                catch (FragmentUndeploymentException e) {
                    logger.error("error undeploying deployment {0} of deployment plan {1}", fragment, deploymentPlan);
                    partialFail = true;
                }
            }
            if (!partialFail) continue;
            throw new DeploymentPlanUndeploymentException();
        }
    }

    @Override
    public void deployDeployment(Deployment deployment) throws FragmentDeploymentException {
        if (deployment == null) {
            throw new FragmentDeploymentException("Null deployment fragment.");
        }
        if (!(deployment instanceof DeploymentPlanFragment)) {
            throw new FragmentDeploymentException("Bad deployment instance : " + deployment);
        }
        DeploymentPlanFragment fragment = (DeploymentPlanFragment)deployment;
        Boolean reloadable = null;
        try {
            reloadable = DeploymentHelper.isReloadable(fragment);
        }
        catch (InvalidDeploymentException e) {
            logger.error("Invalid deployment found : {0} with id {1}", fragment);
            throw new FragmentDeploymentException(e);
        }
        File file = null;
        IResourceFetcher fetcher = null;
        try {
            fetcher = this.fetcherFactoryManager.getResourceFetcher(fragment);
            fetcher.resolve();
            file = fetcher.getResource();
        }
        catch (Exception e) {
            throw new FragmentDeploymentException(e);
        }
        if (file == null) {
            throw new FragmentDeploymentException("Null file");
        }
        IArchive archive = ArchiveManager.getInstance().getArchive(file);
        if (archive == null) {
            throw new FragmentDeploymentException("Null archive for file " + file);
        }
        IDeployable<?> deployable = null;
        try {
            deployable = DeployableHelper.getDeployable(archive);
        }
        catch (DeployableHelperException e) {
            throw new FragmentDeploymentException(e);
        }
        if (deployable == null) {
            throw new FragmentDeploymentException("Null deployable for archive" + archive);
        }
        if (deployable instanceof OSGiDeployable) {
            try {
                Boolean start = DeploymentHelper.isStart(fragment);
                ((OSGiDeployable)deployable).setStart(start);
            }
            catch (InvalidDeploymentException e) {
                logger.error("Invalid deployment found : {0} with id {1}", fragment);
                throw new FragmentDeploymentException(e);
            }
        }
        try {
            this.deployerManager.deploy(deployable);
        }
        catch (DeployerException e) {
            logger.error("Exception while deploying deployable {0}: {1}", deployable, e.getMessage());
            throw new FragmentDeploymentException(e);
        }
        catch (UnsupportedDeployerException e) {
            logger.error("No deployer found for deployable {0}", deployable);
            throw new FragmentDeploymentException(e);
        }
        this.deploymentToDeployableMap.put(fragment, deployable);
        if (reloadable.booleanValue()) {
            this.resourceMonitor.addMonitoredResource(fetcher);
        }
    }

    @Override
    public void undeployDeployment(Deployment deployment) throws FragmentUndeploymentException {
        if (deployment == null) {
            throw new FragmentUndeploymentException("Null deployment fragment.");
        }
        IDeployable deployable = this.deploymentToDeployableMap.get(deployment);
        if (deployable == null) {
            throw new FragmentUndeploymentException("Cannot undeploy Deployment " + deployment.toString());
        }
        this.deploymentToDeployableMap.remove(deployment);
        try {
            this.deployerManager.undeploy(deployable);
        }
        catch (Exception e) {
            logger.error("Could not undeploy resource {0} - trying to finish undeployment", deployable.getArchive());
            throw new FragmentUndeploymentException(e);
        }
    }

    @Override
    public void setFetcherFactoryManager(IResourceFetcherFactoryManager factoryManager) {
        this.fetcherFactoryManager = factoryManager;
    }

    @Override
    public IResourceFetcherFactoryManager getFetcherFactoryManager() {
        return this.fetcherFactoryManager;
    }

    @Override
    public void setDeployerManager(IDeployerManager deployerManager) {
        this.deployerManager = deployerManager;
    }

    @Override
    public IDeployerManager getDeployerManager() {
        return this.deployerManager;
    }

    @Override
    public Integer getDeploymentPlansCount() {
        return this.deploymentPlans.size();
    }

    @Override
    public List<String> getDeploymentPlansIds() {
        ArrayList<String> result = new ArrayList<String>();
        for (DeploymentPlanDeployable deploymentPlanDeployable : this.deploymentPlans) {
            DeploymentPlan deploymentPlan = deploymentPlanDeployable.getAttachedData();
            if (deploymentPlan.getId() == null) {
                result.add("<unnamed deployment>");
                continue;
            }
            result.add(deploymentPlan.getId());
        }
        return result;
    }

    @Override
    public IResourceMonitor getResourceMonitor() {
        return this.resourceMonitor;
    }

    @Override
    public void setResourceMonitor(IResourceMonitor resourceMonitor) {
        this.resourceMonitor = resourceMonitor;
    }

    @Override
    public DeploymentPlanDeployable getOwnerDeploymentPlanDeployable(Deployment deployment) {
        for (DeploymentPlanDeployable deploymentPlanDeployable : this.deploymentPlans) {
            DeploymentPlan deploymentPlan = deploymentPlanDeployable.getAttachedData();
            if (!deploymentPlan.getDeployments().contains(deployment)) continue;
            return deploymentPlanDeployable;
        }
        return null;
    }
}

