/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.util.plan.fetcher.impl.maven2;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import org.ow2.util.file.FileUtils;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;
import org.ow2.util.plan.bindings.deploymentplan.DeploymentHelper;
import org.ow2.util.plan.bindings.deploymentplan.maven2.Maven2Deployment;
import org.ow2.util.plan.bindings.exceptions.InvalidDeploymentException;
import org.ow2.util.plan.bindings.repository.Repository;
import org.ow2.util.plan.bindings.repository.RepositoryKind;
import org.ow2.util.plan.fetcher.api.IResourceFetcher;
import org.ow2.util.plan.fetcher.api.exceptions.FetcherException;
import org.ow2.util.plan.fetcher.api.exceptions.ResourceFetcherNotResolvedException;
import org.ow2.util.plan.fetcher.api.exceptions.ResourceNotFoundException;
import org.ow2.util.plan.fetcher.impl.AbsResourceFetcherImpl;
import org.ow2.util.plan.fetcher.impl.maven2.Maven2Utils;

public class Maven2ResourceFetcher
extends AbsResourceFetcherImpl
implements IResourceFetcher {
    private static final Log logger = LogFactory.getLog(Maven2ResourceFetcher.class);
    private File localFile = null;
    private URL foundURL = null;

    public RepositoryKind getSupportedRepositoryType() {
        return RepositoryKind.MAVEN_2;
    }

    public File getResource() throws ResourceFetcherNotResolvedException {
        if (this.localFile == null) {
            throw new ResourceFetcherNotResolvedException();
        }
        return this.localFile;
    }

    public boolean hasChanged() throws FetcherException {
        try {
            URLConnection connection = this.foundURL.openConnection();
            if (connection.getLastModified() > this.localFile.lastModified()) {
                return true;
            }
        }
        catch (IOException e) {
            logger.debug("Cannot retrieve the last modification date for the URL {0} : {1}", this.foundURL, e.getMessage());
        }
        return false;
    }

    public void resolve() throws FetcherException {
        if (this.deployment == null) {
            throw new FetcherException(new InvalidDeploymentException("Null deployment"));
        }
        if (!(this.deployment instanceof Maven2Deployment)) {
            throw new FetcherException(new InvalidDeploymentException("Bad deployment type: " + this.deployment.getClass().getName()));
        }
        Maven2Deployment maven2Deployment = (Maven2Deployment)this.deployment;
        logger.debug("Trying to resolve resource {0}", maven2Deployment.toString());
        String groupId = maven2Deployment.getGroupId();
        String artifactId = maven2Deployment.getArtifactId();
        String version2 = maven2Deployment.getVersion();
        String type = maven2Deployment.getType();
        String classifier = maven2Deployment.getClassifier();
        if (groupId == null || artifactId == null || version2 == null) {
            throw new FetcherException(new InvalidDeploymentException("Incomplete maven description: " + maven2Deployment));
        }
        String repositoryRef = null;
        try {
            repositoryRef = DeploymentHelper.getRepositoryRef(maven2Deployment);
        }
        catch (InvalidDeploymentException e) {
            logger.error(e.getMessage(), new Object[0]);
        }
        if (type == null) {
            type = "jar";
        }
        this.localFile = null;
        if (repositoryRef != null) {
            this.resolveArtifact(this.getRepositoryManager().getRepositoryById(repositoryRef), groupId, artifactId, version2, classifier, type);
        } else {
            for (Repository repository : this.getRepositoryManager()) {
                if (repository.getType() != RepositoryKind.MAVEN_2) continue;
                this.resolveArtifact(repository, groupId, artifactId, version2, classifier, type);
                if (this.localFile == null || !this.localFile.exists()) continue;
                break;
            }
        }
        if (this.localFile == null || !this.localFile.exists()) {
            throw new FetcherException(new ResourceNotFoundException(maven2Deployment.toString()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resolveArtifact(Repository repository, String groupId, String artifactId, String version2, String classifier, String type) throws FetcherException {
        URL repositoryURL = null;
        try {
            repositoryURL = new URL(repository.getUrl());
        }
        catch (MalformedURLException e) {
            logger.debug("Invalid repository URL {0}", repository);
        }
        if (repositoryURL != null && "file".equals(repositoryURL.getProtocol())) {
            this.localFile = Maven2Utils.getMaven2File(repositoryURL.getFile(), groupId, artifactId, version2, classifier, type);
        } else {
            try {
                this.foundURL = Maven2Utils.getMaven2URL(repositoryURL.toExternalForm(), groupId, artifactId, version2, classifier, type);
            }
            catch (MalformedURLException e) {
                logger.debug("Invalid resource URL:" + e.getMessage(), new Object[0]);
            }
            this.localFile = Maven2Utils.getMaven2File(this.localRepositoriesBaseDir + File.separator + repository.getId(), groupId, artifactId, version2, classifier, type);
            if (!this.localFile.exists() || this.hasChanged()) {
                if (!this.localFile.getParentFile().exists()) {
                    this.localFile.getParentFile().mkdirs();
                }
                InputStream is = null;
                try {
                    URLConnection connection = this.foundURL.openConnection();
                    is = connection.getInputStream();
                    FileUtils.dump(is, this.localFile);
                    this.localFile.setLastModified(connection.getLastModified());
                }
                catch (Exception e) {
                    logger.debug("Exception while copying data from resource {0} : {1}", this.foundURL, e.getMessage());
                }
                finally {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (IOException e) {}
                    }
                }
            }
        }
    }

    public void update() throws FetcherException {
        this.resolve();
    }
}

