/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.util.plan.fetcher.impl.maven2;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;

public final class Maven2Utils {
    private Maven2Utils() {
    }

    public static String getMaven2Location(String repository, String groupId, String artifactId, String version2, String classifier, String type) {
        String appendedClassifier = "";
        if (classifier != null) {
            appendedClassifier = appendedClassifier.concat("-").concat(classifier);
        }
        String path = Maven2Utils.constructDirectoryPath(groupId, artifactId, version2);
        String location = repository.concat("/").concat(path.concat("/").concat(artifactId).concat("-").concat(version2).concat(appendedClassifier).concat(".").concat(type));
        return location;
    }

    public static File getMaven2File(String repository, String groupId, String artifactId, String version2, String classifier, String type) {
        return new File(Maven2Utils.getMaven2Location(repository, groupId, artifactId, version2, classifier, type));
    }

    public static URL getMaven2URL(String repository, String groupId, String artifactId, String version2, String classifier, String type) throws MalformedURLException {
        return new URL(Maven2Utils.getMaven2Location(repository, groupId, artifactId, version2, classifier, type));
    }

    private static String constructDirectoryPath(String groupId, String artifactId, String version2) {
        String transformed = groupId.replace('.', '/');
        return transformed.concat("/").concat(artifactId).concat("/").concat(version2);
    }
}

