/*
 * Decompiled with CFR 0.152.
 */
package wssec;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.PrintWriter;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.UnsupportedCallbackException;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.apache.axis.Message;
import org.apache.axis.MessageContext;
import org.apache.axis.client.AxisClient;
import org.apache.axis.configuration.NullProvider;
import org.apache.axis.message.SOAPEnvelope;
import org.apache.axis.utils.XMLUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ws.security.WSConstants;
import org.apache.ws.security.WSPasswordCallback;
import org.apache.ws.security.WSSConfig;
import org.apache.ws.security.WSSecurityEngine;
import org.apache.ws.security.components.crypto.Crypto;
import org.apache.ws.security.components.crypto.CryptoFactory;
import org.apache.ws.security.message.WSEncryptBody;
import org.apache.ws.security.message.WSSAddUsernameToken;
import org.apache.ws.security.message.token.Reference;
import org.apache.ws.security.message.token.SecurityTokenReference;
import org.apache.ws.security.util.WSSecurityUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import wssec.SOAPUtil;

public class TestWSSecurity10
extends TestCase
implements CallbackHandler {
    private static Log log = LogFactory.getLog(class$wssec$TestWSSecurity10 == null ? (class$wssec$TestWSSecurity10 = TestWSSecurity10.class$("wssec.TestWSSecurity10")) : class$wssec$TestWSSecurity10);
    static final String soapMsg = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><soapenv:Envelope xmlns:soapenv=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\">   <soapenv:Body>      <ns1:testMethod xmlns:ns1=\"http://axis/service/security/test10/LogTestService10\"></ns1:testMethod>   </soapenv:Body></soapenv:Envelope>";
    static final WSSecurityEngine secEngine = new WSSecurityEngine();
    static final Crypto crypto = CryptoFactory.getInstance();
    MessageContext msgContext;
    Message message;
    private byte[] sharedSecret = "SriLankaSriLankaSriLanka".getBytes();
    static /* synthetic */ Class class$wssec$TestWSSecurity10;

    public TestWSSecurity10(String name) {
        super(name);
    }

    public static Test suite() {
        return new TestSuite(class$wssec$TestWSSecurity10 == null ? (class$wssec$TestWSSecurity10 = TestWSSecurity10.class$("wssec.TestWSSecurity10")) : class$wssec$TestWSSecurity10);
    }

    protected void setUp() throws Exception {
        AxisClient tmpEngine = new AxisClient(new NullProvider());
        this.msgContext = new MessageContext(tmpEngine);
        this.message = this.getSOAPMessage();
    }

    protected Message getSOAPMessage() throws Exception {
        ByteArrayInputStream in = new ByteArrayInputStream(soapMsg.getBytes());
        Message msg = new Message(in);
        msg.setMessageContext(this.msgContext);
        return msg;
    }

    public void testEMBED_SECURITY_TOKEN_REF() throws Exception {
        SOAPEnvelope unsignedEnvelope = this.message.getSOAPEnvelope();
        Object envelope = null;
        WSEncryptBody wsEncrypt = new WSEncryptBody();
        log.info("Before Encryption....");
        Document doc = unsignedEnvelope.getAsDocument();
        String username = "Dimthu";
        String password = "Sri Lanka Sri Lanka UOM ";
        byte[] key = password.getBytes();
        WSSAddUsernameToken builder = new WSSAddUsernameToken("", false);
        builder.setPasswordType("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-username-token-profile-1.0#PasswordText");
        builder.build(doc, username, password);
        Element usrEle = (Element)doc.getElementsByTagNameNS(WSConstants.WSSE_NS, "UsernameToken").item(0);
        String idValue = "1234";
        usrEle.setAttribute("Id", idValue);
        Reference ref = new Reference(WSSConfig.getDefaultWSConfig(), doc);
        ref.setURI("#" + idValue);
        ref.setValueType("UsernameToken");
        SecurityTokenReference secRef = new SecurityTokenReference(WSSConfig.getDefaultWSConfig(), doc);
        secRef.setReference(ref);
        WSSecurityUtil.setNamespace(secRef.getElement(), WSConstants.WSSE_NS, "wsse");
        wsEncrypt.setKeyIdentifierType(6);
        wsEncrypt.setSecurityTokenReference(secRef);
        wsEncrypt.setKey(key);
        Document encDoc = wsEncrypt.build(doc, crypto);
        Message signedMsg = (Message)SOAPUtil.toSOAPMessage(encDoc);
        XMLUtils.PrettyElementToWriter(signedMsg.getSOAPEnvelope().getAsDOM(), new PrintWriter(System.out));
        log.info("Encryption Done\n");
    }

    private void verifyEMBED_SECURITY_TOKEN_REF(Document doc) throws Exception {
        secEngine.processSecurityHeader(doc, "", this, null);
        log.info("Success ......");
    }

    public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
        for (int i = 0; i < callbacks.length; ++i) {
            if (callbacks[i] instanceof WSPasswordCallback) {
                WSPasswordCallback pc = (WSPasswordCallback)callbacks[i];
                if (pc.getUsage() == 2) {
                    pc.setPassword("Sri Lanka Sri Lanka UOM ");
                    continue;
                }
                if (pc.getUsage() != 1) continue;
                pc.setKey("Sri Lanka Sri Lanka UOM ".getBytes());
                continue;
            }
            throw new UnsupportedCallbackException(callbacks[i], "Unrecognized Callback");
        }
    }

    public static void main(String[] args) throws Exception {
        TestWSSecurity10 tst10 = new TestWSSecurity10("TestWSSecurity10");
        tst10.setUp();
        tst10.testEMBED_SECURITY_TOKEN_REF();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

