/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ws.commons.schema.resolver;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import org.apache.ws.commons.schema.resolver.URIResolver;
import org.xml.sax.InputSource;

public class DefaultURIResolver
implements URIResolver {
    public InputSource resolveEntity(String namespace, String schemaLocation, String baseUri) {
        if (baseUri != null) {
            try {
                File baseFile = new File(baseUri);
                if (baseFile.exists()) {
                    baseUri = baseFile.toURI().toString();
                }
                String ref = new URI(baseUri).resolve(new URI(schemaLocation)).toString();
                return new InputSource(ref);
            }
            catch (URISyntaxException e1) {
                throw new RuntimeException(e1);
            }
        }
        return new InputSource(schemaLocation);
    }

    protected boolean isAbsolute(String uri) {
        return uri.startsWith("http://");
    }

    protected URL getURL(URL contextURL, String spec) throws IOException {
        URL url;
        String path = spec.replace('\\', '/');
        try {
            url = new URL(contextURL, path);
            if (contextURL != null && url.getProtocol().equals("file") && contextURL.getProtocol().equals("file")) {
                url = this.getFileURL(contextURL, path);
            }
        }
        catch (MalformedURLException me) {
            url = this.getFileURL(contextURL, path);
        }
        return url;
    }

    protected URL getFileURL(URL contextURL, String path) throws IOException {
        if (contextURL != null) {
            String contextFileName = contextURL.getFile();
            URL parent = null;
            File contextFile = new File(contextFileName);
            File parentFile = contextFile.isDirectory() ? contextFile : contextFile.getParentFile();
            if (parentFile != null) {
                parent = parentFile.toURL();
            }
            if (parent != null) {
                return new URL(parent, path);
            }
        }
        return new URL("file", "", path);
    }
}

