/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.joram.client.connector;

import java.io.Serializable;
import javax.jms.IllegalStateException;
import javax.jms.JMSException;
import javax.jms.JMSSecurityException;
import javax.jms.QueueConnectionFactory;
import javax.jms.TopicConnectionFactory;
import javax.resource.ResourceException;
import javax.resource.spi.CommException;
import javax.resource.spi.ConnectionManager;
import javax.resource.spi.ConnectionRequestInfo;
import javax.resource.spi.ManagedConnectionFactory;
import javax.resource.spi.SecurityException;
import org.objectweb.joram.client.connector.AdapterTracing;
import org.objectweb.joram.client.connector.ConnectionRequest;
import org.objectweb.joram.client.connector.ManagedConnectionFactoryImpl;
import org.objectweb.joram.client.connector.QueueConnectionRequest;
import org.objectweb.joram.client.connector.TopicConnectionRequest;
import org.objectweb.joram.client.jms.ConnectionFactory;
import org.objectweb.joram.client.jms.tcp.QueueTcpConnectionFactory;
import org.objectweb.joram.client.jms.tcp.TcpConnectionFactory;
import org.objectweb.joram.client.jms.tcp.TopicTcpConnectionFactory;
import org.objectweb.util.monolog.api.BasicLevel;

public class DefaultConnectionManager
implements ConnectionManager,
Serializable {
    private static final long serialVersionUID = 1L;
    private static DefaultConnectionManager ref = null;

    public Object allocateConnection(ManagedConnectionFactory mcf, ConnectionRequestInfo cxRequest) throws ResourceException {
        String password;
        String userName;
        if (AdapterTracing.dbgAdapter.isLoggable(BasicLevel.DEBUG)) {
            AdapterTracing.dbgAdapter.log(BasicLevel.DEBUG, (Object)(this + " allocateConnection(" + mcf + "," + cxRequest + ")"));
        }
        if (cxRequest == null) {
            userName = ((ManagedConnectionFactoryImpl)mcf).getUserName();
            password = ((ManagedConnectionFactoryImpl)mcf).getPassword();
        } else {
            userName = ((ConnectionRequest)cxRequest).getUserName();
            password = ((ConnectionRequest)cxRequest).getPassword();
        }
        String hostName = ((ManagedConnectionFactoryImpl)mcf).getHostName();
        int serverPort = ((ManagedConnectionFactoryImpl)mcf).getServerPort();
        try {
            if (cxRequest instanceof QueueConnectionRequest) {
                QueueConnectionFactory factory = QueueTcpConnectionFactory.create(hostName, serverPort);
                this.setFactoryParameters((ConnectionFactory)factory, (ManagedConnectionFactoryImpl)mcf);
                return factory.createQueueConnection(userName, password);
            }
            if (cxRequest instanceof TopicConnectionRequest) {
                TopicConnectionFactory factory = TopicTcpConnectionFactory.create(hostName, serverPort);
                this.setFactoryParameters((ConnectionFactory)factory, (ManagedConnectionFactoryImpl)mcf);
                return factory.createTopicConnection(userName, password);
            }
            javax.jms.ConnectionFactory factory = TcpConnectionFactory.create(hostName, serverPort);
            this.setFactoryParameters((ConnectionFactory)factory, (ManagedConnectionFactoryImpl)mcf);
            return factory.createConnection(userName, password);
        }
        catch (IllegalStateException exc) {
            throw new CommException("Could not access the JORAM server: " + (Object)((Object)exc));
        }
        catch (JMSSecurityException exc) {
            throw new SecurityException("Invalid user identification: " + (Object)((Object)exc));
        }
        catch (JMSException exc) {
            throw new ResourceException("Failed connecting process: " + (Object)((Object)exc));
        }
    }

    private void setFactoryParameters(ConnectionFactory factory, ManagedConnectionFactoryImpl mcf) {
        if (AdapterTracing.dbgAdapter.isLoggable(BasicLevel.DEBUG)) {
            AdapterTracing.dbgAdapter.log(BasicLevel.DEBUG, (Object)(this + " setFactoryParameters(" + factory + "," + mcf + ")"));
        }
        factory.getParameters().connectingTimer = mcf.getConnectingTimer();
        factory.getParameters().cnxPendingTimer = mcf.getCnxPendingTimer();
        factory.getParameters().txPendingTimer = mcf.getTxPendingTimer();
        factory.getParameters().asyncSend = mcf.isAsyncSend();
        factory.getParameters().multiThreadSync = mcf.isMultiThreadSync();
        factory.getParameters().multiThreadSyncDelay = mcf.getMultiThreadSyncDelay();
        factory.getParameters().outLocalAddress = mcf.getOutLocalAddress();
        factory.getParameters().outLocalPort = mcf.getOutLocalPort();
    }

    static DefaultConnectionManager getRef() {
        if (ref == null) {
            ref = new DefaultConnectionManager();
        }
        return ref;
    }
}

