/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.joram.mom.proxies.tcp;

import fr.dyade.aaa.agent.AgentId;
import org.objectweb.joram.mom.proxies.AckedQueue;
import org.objectweb.joram.mom.proxies.tcp.IOControl;
import org.objectweb.joram.mom.proxies.tcp.TcpProxyService;
import org.objectweb.joram.mom.proxies.tcp.TcpReader;
import org.objectweb.joram.mom.proxies.tcp.TcpWriter;
import org.objectweb.joram.shared.JoramTracing;
import org.objectweb.util.monolog.api.BasicLevel;

public class TcpConnection {
    private IOControl ioctrl;
    private AgentId proxyId;
    private int key;
    private AckedQueue replyQueue;
    private TcpReader tcpReader;
    private TcpWriter tcpWriter;
    private TcpProxyService proxyService;
    private boolean closeConnection;

    public TcpConnection(IOControl ioctrl, AgentId proxyId, AckedQueue replyQueue, int key, TcpProxyService proxyService, boolean closeConnection) {
        this.ioctrl = ioctrl;
        this.proxyId = proxyId;
        this.replyQueue = replyQueue;
        this.key = key;
        this.proxyService = proxyService;
        this.closeConnection = closeConnection;
    }

    public final AgentId getProxyId() {
        return this.proxyId;
    }

    public final int getKey() {
        return this.key;
    }

    void start() throws Exception {
        if (JoramTracing.dbgProxy.isLoggable(BasicLevel.DEBUG)) {
            JoramTracing.dbgProxy.log(BasicLevel.DEBUG, (Object)"TcpConnection.start()");
        }
        try {
            this.tcpWriter = new TcpWriter(this.ioctrl, this.replyQueue, this);
            this.tcpReader = new TcpReader(this.ioctrl, this.proxyId, this, this.closeConnection);
            this.proxyService.registerConnection(this);
            this.tcpWriter.start();
            this.tcpReader.start();
        }
        catch (Exception exc) {
            this.close();
            throw exc;
        }
    }

    void close() {
        if (this.tcpWriter != null) {
            this.tcpWriter.stop();
        }
        if (this.tcpReader != null) {
            this.tcpReader.stop();
        }
        if (this.ioctrl != null) {
            this.ioctrl.close();
        }
        this.ioctrl = null;
        this.proxyService.unregisterConnection(this);
    }
}

