/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.util.ee.metadata.common.impl.xml.parsing;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import javax.xml.namespace.QName;
import org.ow2.util.ee.metadata.common.api.xml.struct.IEJBLocalRef;
import org.ow2.util.ee.metadata.common.api.xml.struct.IEJBRef;
import org.ow2.util.ee.metadata.common.api.xml.struct.IEnvEntry;
import org.ow2.util.ee.metadata.common.api.xml.struct.IEnvironment;
import org.ow2.util.ee.metadata.common.api.xml.struct.IInjectionTarget;
import org.ow2.util.ee.metadata.common.api.xml.struct.ILifeCycleCallback;
import org.ow2.util.ee.metadata.common.api.xml.struct.IMessageDestinationRef;
import org.ow2.util.ee.metadata.common.api.xml.struct.IPersistenceContextRef;
import org.ow2.util.ee.metadata.common.api.xml.struct.IPersistenceUnitRef;
import org.ow2.util.ee.metadata.common.api.xml.struct.IPortComponentRef;
import org.ow2.util.ee.metadata.common.api.xml.struct.IResourceEnvRef;
import org.ow2.util.ee.metadata.common.api.xml.struct.IResourceGroup;
import org.ow2.util.ee.metadata.common.api.xml.struct.IResourceRef;
import org.ow2.util.ee.metadata.common.api.xml.struct.ISecurityRoleRef;
import org.ow2.util.ee.metadata.common.api.xml.struct.IServiceRef;
import org.ow2.util.ee.metadata.common.impl.xml.parsing.AbsDeploymentDescLoader;
import org.ow2.util.ee.metadata.common.impl.xml.struct.AbsEJBRef;
import org.ow2.util.ee.metadata.common.impl.xml.struct.EJBLocalRef;
import org.ow2.util.ee.metadata.common.impl.xml.struct.EJBRef;
import org.ow2.util.ee.metadata.common.impl.xml.struct.EnvEntry;
import org.ow2.util.ee.metadata.common.impl.xml.struct.InjectionTarget;
import org.ow2.util.ee.metadata.common.impl.xml.struct.LifeCycleCallback;
import org.ow2.util.ee.metadata.common.impl.xml.struct.MessageDestinationRef;
import org.ow2.util.ee.metadata.common.impl.xml.struct.PersistenceContextRef;
import org.ow2.util.ee.metadata.common.impl.xml.struct.PersistenceUnitRef;
import org.ow2.util.ee.metadata.common.impl.xml.struct.PortComponentRef;
import org.ow2.util.ee.metadata.common.impl.xml.struct.ResourceEnvRef;
import org.ow2.util.ee.metadata.common.impl.xml.struct.ResourceRef;
import org.ow2.util.ee.metadata.common.impl.xml.struct.SecurityRoleRef;
import org.ow2.util.ee.metadata.common.impl.xml.struct.ServiceRef;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;
import org.ow2.util.xml.XMLSerializer;
import org.ow2.util.xml.XMLUtils;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public abstract class CommonDeploymentDescLoader
extends AbsDeploymentDescLoader {
    private static final Log logger = LogFactory.getLog(CommonDeploymentDescLoader.class);

    protected CommonDeploymentDescLoader(URL url) {
        super(url);
    }

    protected void analyzeEnvironment(Element envElement, IEnvironment env) {
        this.analyzeLifeCycle(envElement, env, "post-construct");
        this.analyzeLifeCycle(envElement, env, "pre-destroy");
        this.analyzeEnvEnvtry(envElement, env);
        this.analyzeEJBRef(envElement, env);
        this.analyzeEJBLocalRef(envElement, env);
        this.analyzeResourceRef(envElement, env);
        this.analyzeResourceEnvRef(envElement, env);
        this.analyzeMessageDestinationRef(envElement, env);
        this.analyzePersistenceContextRef(envElement, env);
        this.analyzePersistenceUnitRef(envElement, env);
        this.analyzeServiceRef(envElement, env);
        this.analyzeSecurityRoleRef(envElement, env);
    }

    private void analyzeCommonEJBRef(Element refElement, AbsEJBRef ref) {
        String ejbRefName = XMLUtils.getStringValueElement((String)this.getXMLNS(), (Element)refElement, (String)"ejb-ref-name");
        ref.setEjbRefName(ejbRefName);
        String ejbRefType = XMLUtils.getStringValueElement((String)this.getXMLNS(), (Element)refElement, (String)"ejb-ref-type");
        ref.setEjbRefType(ejbRefType);
        String mappedName = XMLUtils.getStringValueElement((String)this.getXMLNS(), (Element)refElement, (String)"mapped-name");
        ref.setMappedName(mappedName);
        String ejbLink = XMLUtils.getStringValueElement((String)this.getXMLNS(), (Element)refElement, (String)"ejb-link");
        ref.setEjbLink(ejbLink);
        this.analyzeInjectionTarget(refElement, ref);
    }

    private void analyzeInjectionTarget(Element refElement, IResourceGroup resourceGroup) {
        NodeList injectionTargetList = refElement.getElementsByTagNameNS(this.getXMLNS(), "injection-target");
        for (int j = 0; j < injectionTargetList.getLength(); ++j) {
            Element injectionTargetElement = (Element)injectionTargetList.item(j);
            InjectionTarget injectionTarget = new InjectionTarget();
            String className = XMLUtils.getStringValueElement((String)this.getXMLNS(), (Element)injectionTargetElement, (String)"injection-target-class");
            injectionTarget.setClassname(className);
            String targetName = XMLUtils.getStringValueElement((String)this.getXMLNS(), (Element)injectionTargetElement, (String)"injection-target-name");
            injectionTarget.setTargetName(targetName);
            resourceGroup.addInjectionTarget((IInjectionTarget)injectionTarget);
        }
    }

    private void analyzeEJBRef(Element envElement, IEnvironment env) {
        NodeList ejbRefList = envElement.getElementsByTagNameNS(this.getXMLNS(), "ejb-ref");
        for (int i = 0; i < ejbRefList.getLength(); ++i) {
            Element ejbRefElement = (Element)ejbRefList.item(i);
            EJBRef ejbRef = new EJBRef();
            this.analyzeCommonEJBRef(ejbRefElement, ejbRef);
            String remote = XMLUtils.getStringValueElement((String)this.getXMLNS(), (Element)ejbRefElement, (String)"remote");
            ejbRef.setRemote(remote);
            String home = XMLUtils.getStringValueElement((String)this.getXMLNS(), (Element)ejbRefElement, (String)"home");
            ejbRef.setHome(home);
            env.addEJBRef((IEJBRef)ejbRef);
        }
    }

    private void analyzeResourceRef(Element envElement, IEnvironment env) {
        NodeList resourceRefList = envElement.getElementsByTagNameNS(this.getXMLNS(), "resource-ref");
        for (int i = 0; i < resourceRefList.getLength(); ++i) {
            Element resourceRefElement = (Element)resourceRefList.item(i);
            ResourceRef resourceRef = new ResourceRef();
            String resRefName = XMLUtils.getStringValueElement((String)this.getXMLNS(), (Element)resourceRefElement, (String)"res-ref-name");
            resourceRef.setResRefName(resRefName);
            String resRefType = XMLUtils.getStringValueElement((String)this.getXMLNS(), (Element)resourceRefElement, (String)"res-type");
            resourceRef.setResRefType(resRefType);
            String mappedName = XMLUtils.getStringValueElement((String)this.getXMLNS(), (Element)resourceRefElement, (String)"mapped-name");
            resourceRef.setMappedName(mappedName);
            this.analyzeInjectionTarget(resourceRefElement, resourceRef);
            env.addResourceRef((IResourceRef)resourceRef);
        }
    }

    private void analyzeSecurityRoleRef(Element envElement, IEnvironment env) {
        NodeList securityRoleRefList = envElement.getElementsByTagNameNS(this.getXMLNS(), "security-role-ref");
        for (int i = 0; i < securityRoleRefList.getLength(); ++i) {
            Element securityRoleRefElement = (Element)securityRoleRefList.item(i);
            SecurityRoleRef securityRoleRef = new SecurityRoleRef();
            String roleName = XMLUtils.getStringValueElement((String)this.getXMLNS(), (Element)securityRoleRefElement, (String)"role-name");
            securityRoleRef.setRoleName(roleName);
            String roleLink = XMLUtils.getStringValueElement((String)this.getXMLNS(), (Element)securityRoleRefElement, (String)"role-link");
            securityRoleRef.setRoleLink(roleLink);
            env.addSecurityRoleRef((ISecurityRoleRef)securityRoleRef);
        }
    }

    private void analyzeMessageDestinationRef(Element envElement, IEnvironment env) {
        NodeList messageDestinationRefList = envElement.getElementsByTagNameNS(this.getXMLNS(), "message-destination-ref");
        for (int i = 0; i < messageDestinationRefList.getLength(); ++i) {
            Element messageDestinationRefElement = (Element)messageDestinationRefList.item(i);
            MessageDestinationRef messageDestinationRef = new MessageDestinationRef();
            String name = XMLUtils.getStringValueElement((String)this.getXMLNS(), (Element)messageDestinationRefElement, (String)"message-destination-ref-name");
            messageDestinationRef.setName(name);
            String type = XMLUtils.getStringValueElement((String)this.getXMLNS(), (Element)messageDestinationRefElement, (String)"message-destination-type");
            messageDestinationRef.setType(type);
            String usage = XMLUtils.getStringValueElement((String)this.getXMLNS(), (Element)messageDestinationRefElement, (String)"message-destination-usage");
            messageDestinationRef.setUsage(usage);
            String link = XMLUtils.getStringValueElement((String)this.getXMLNS(), (Element)messageDestinationRefElement, (String)"message-destination-link");
            messageDestinationRef.setLink(link);
            String mappedName = XMLUtils.getStringValueElement((String)this.getXMLNS(), (Element)messageDestinationRefElement, (String)"mapped-name");
            messageDestinationRef.setMappedName(mappedName);
            this.analyzeInjectionTarget(messageDestinationRefElement, messageDestinationRef);
            env.addMessageDestinationRef((IMessageDestinationRef)messageDestinationRef);
        }
    }

    private void analyzePersistenceUnitRef(Element envElement, IEnvironment env) {
        logger.debug((Object)"Analyze environment, looking for persistence-unit-ref", new Object[0]);
        NodeList persistenceUnitRefList = envElement.getElementsByTagNameNS(this.getXMLNS(), "persistence-unit-ref");
        for (int i = 0; i < persistenceUnitRefList.getLength(); ++i) {
            Element persistenceUnitRefElement = (Element)persistenceUnitRefList.item(i);
            PersistenceUnitRef persistenceUnitRef = new PersistenceUnitRef();
            String unitRefName = XMLUtils.getStringValueElement((String)this.getXMLNS(), (Element)persistenceUnitRefElement, (String)"persistence-unit-ref-name");
            if (unitRefName != null) {
                persistenceUnitRef.setPersistenceUnitRefName(unitRefName);
            }
            logger.debug((Object)("Analyze environment, found persistence-unit-ref-name " + unitRefName), new Object[0]);
            String unitName = XMLUtils.getStringValueElement((String)this.getXMLNS(), (Element)persistenceUnitRefElement, (String)"persistence-unit-name");
            if (unitName != null) {
                persistenceUnitRef.setPersistenceUnitName(unitName);
            }
            env.addPersistenceUnitRef((IPersistenceUnitRef)persistenceUnitRef);
        }
    }

    private void analyzePersistenceContextRef(Element envElement, IEnvironment env) {
        logger.debug((Object)"Analyze environment, looking for persistence-context-ref", new Object[0]);
        NodeList persistenceContextRefList = envElement.getElementsByTagNameNS(this.getXMLNS(), "persistence-context-ref");
        for (int i = 0; i < persistenceContextRefList.getLength(); ++i) {
            String contextType;
            Element persistenceContextRefElement = (Element)persistenceContextRefList.item(i);
            PersistenceContextRef persistenceContextRef = new PersistenceContextRef();
            String contextRefName = XMLUtils.getStringValueElement((String)this.getXMLNS(), (Element)persistenceContextRefElement, (String)"persistence-context-ref-name");
            if (contextRefName != null) {
                persistenceContextRef.setPersistenceContextRefName(contextRefName);
            }
            logger.debug((Object)("Analyze environment, found persistence-context-ref-name " + contextRefName), new Object[0]);
            String unitName = XMLUtils.getStringValueElement((String)this.getXMLNS(), (Element)persistenceContextRefElement, (String)"persistence-unit-name");
            if (unitName != null) {
                persistenceContextRef.setPersistenceUnitName(unitName);
            }
            if ((contextType = XMLUtils.getStringValueElement((String)this.getXMLNS(), (Element)persistenceContextRefElement, (String)"persistence-context-type")) != null) {
                persistenceContextRef.setPersistenceContextType(contextType);
            }
            env.addPersistenceContextRef((IPersistenceContextRef)persistenceContextRef);
        }
    }

    private void analyzeServiceRef(Element envElement, IEnvironment env) {
        NodeList serviceRefList = envElement.getElementsByTagNameNS(this.getXMLNS(), "service-ref");
        for (int i = 0; i < serviceRefList.getLength(); ++i) {
            NodeList serviceQNameList;
            Element serviceRefElement = (Element)serviceRefList.item(i);
            ServiceRef serviceRef = new ServiceRef();
            String name = XMLUtils.getStringValueElement((String)this.getXMLNS(), (Element)serviceRefElement, (String)"service-ref-name");
            serviceRef.setName(name);
            String type = XMLUtils.getStringValueElement((String)this.getXMLNS(), (Element)serviceRefElement, (String)"service-interface");
            serviceRef.setServiceInterface(type);
            String usage = XMLUtils.getStringValueElement((String)this.getXMLNS(), (Element)serviceRefElement, (String)"service-ref-type");
            serviceRef.setServiceRefType(usage);
            String link = XMLUtils.getStringValueElement((String)this.getXMLNS(), (Element)serviceRefElement, (String)"wsdl-file");
            if (link != null) {
                URI location = null;
                try {
                    location = new URI(link);
                }
                catch (URISyntaxException e) {
                    throw new IllegalStateException("Element 'wsdl-file' is not a valid URI", e);
                }
                serviceRef.setWsdlFile(location);
            }
            if ((serviceQNameList = envElement.getElementsByTagNameNS(this.getXMLNS(), "service-qname")).getLength() == 1) {
                QName serviceQName = XMLUtils.getValueAsQName((Element)((Element)serviceQNameList.item(0)));
                serviceRef.setServiceQName(serviceQName);
            }
            this.analyzePortComponentRef(serviceRefElement, serviceRef);
            this.analyzeHandlerChains(serviceRefElement, serviceRef);
            this.analyzeInjectionTarget(serviceRefElement, serviceRef);
            env.addServiceRef((IServiceRef)serviceRef);
        }
    }

    private void analyzeHandlerChains(Element serviceRefElement, IServiceRef serviceRef) {
        NodeList handlerChainsList = serviceRefElement.getElementsByTagNameNS(this.getXMLNS(), "handler-chains");
        if (handlerChainsList.getLength() == 1) {
            Element handlerChainsElement = (Element)handlerChainsList.item(0);
            this.moveNamespacesDeclaration(handlerChainsElement, "soap-header");
            this.moveNamespacesDeclaration(handlerChainsElement, "service-name-pattern");
            this.moveNamespacesDeclaration(handlerChainsElement, "port-name-pattern");
            StringWriter writer = new StringWriter();
            XMLSerializer serializer = new XMLSerializer((Node)handlerChainsElement);
            try {
                serializer.serialize((Writer)writer);
                StringBuffer sb = writer.getBuffer();
                serviceRef.setHandlerChains(sb.toString());
            }
            catch (IOException e) {
                throw new IllegalArgumentException("Unable to serialize handlers description for service-ref '" + serviceRef.getName() + "'.", e);
            }
        }
    }

    private void moveNamespacesDeclaration(Element handlerChainsElement, String localName) {
        Element serviceRefElement = (Element)handlerChainsElement.getParentNode();
        NodeList elementList = handlerChainsElement.getElementsByTagNameNS(this.getXMLNS(), localName);
        for (int i = 0; i < elementList.getLength(); ++i) {
            Element element = (Element)elementList.item(i);
            QName name = XMLUtils.getValueAsQName((Element)element);
            Element declaringParent = null;
            Element traversed = serviceRefElement;
            Element root = serviceRefElement.getOwnerDocument().getDocumentElement();
            while (declaringParent == null && !root.isEqualNode(traversed)) {
                Attr declaration = traversed.getAttributeNodeNS("http://www.w3.org/2000/xmlns/", name.getPrefix());
                if (declaration != null) {
                    declaringParent = traversed;
                    continue;
                }
                traversed = (Element)element.getParentNode();
            }
            if (declaringParent == null) continue;
            handlerChainsElement.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:" + name.getPrefix(), name.getNamespaceURI());
        }
    }

    private void analyzePortComponentRef(Element serviceRefElement, IServiceRef serviceRef) {
        NodeList portComponentRefList = serviceRefElement.getElementsByTagNameNS(this.getXMLNS(), "port-component-ref");
        for (int i = 0; i < portComponentRefList.getLength(); ++i) {
            Element portComponentRefElement = (Element)portComponentRefList.item(i);
            PortComponentRef portComponentRef = new PortComponentRef();
            String sei = XMLUtils.getStringValueElement((String)this.getXMLNS(), (Element)portComponentRefElement, (String)"service-endpoint-interface");
            portComponentRef.setServiceEndpointInterface(sei);
            String enableMTOM = XMLUtils.getStringValueElement((String)this.getXMLNS(), (Element)portComponentRefElement, (String)"enable-mtom");
            if (enableMTOM != null) {
                portComponentRef.setEnableMTOM(Boolean.parseBoolean(enableMTOM));
            }
            String link = XMLUtils.getStringValueElement((String)this.getXMLNS(), (Element)portComponentRefElement, (String)"port-component-link");
            portComponentRef.setPortComponentLink(link);
            serviceRef.addPortComponentRef((IPortComponentRef)portComponentRef);
        }
    }

    private void analyzeResourceEnvRef(Element envElement, IEnvironment env) {
        NodeList resourceEnvRefList = envElement.getElementsByTagNameNS(this.getXMLNS(), "resource-env-ref");
        for (int i = 0; i < resourceEnvRefList.getLength(); ++i) {
            Element resourceEnvRefElement = (Element)resourceEnvRefList.item(i);
            ResourceEnvRef resourceEnvRef = new ResourceEnvRef();
            String resourceEnvRefName = XMLUtils.getStringValueElement((String)this.getXMLNS(), (Element)resourceEnvRefElement, (String)"resource-env-ref-name");
            resourceEnvRef.setResourceEnvRefName(resourceEnvRefName);
            String resourceEnvRefType = XMLUtils.getStringValueElement((String)this.getXMLNS(), (Element)resourceEnvRefElement, (String)"resource-env-ref-type");
            resourceEnvRef.setResourceEnvRefType(resourceEnvRefType);
            String mappedName = XMLUtils.getStringValueElement((String)this.getXMLNS(), (Element)resourceEnvRefElement, (String)"mapped-name");
            resourceEnvRef.setMappedName(mappedName);
            this.analyzeInjectionTarget(resourceEnvRefElement, resourceEnvRef);
            env.addResourceEnvRef((IResourceEnvRef)resourceEnvRef);
        }
    }

    private void analyzeEJBLocalRef(Element envElement, IEnvironment env) {
        NodeList ejbLocalRefList = envElement.getElementsByTagNameNS(this.getXMLNS(), "ejb-local-ref");
        for (int i = 0; i < ejbLocalRefList.getLength(); ++i) {
            Element ejbRefElement = (Element)ejbLocalRefList.item(i);
            EJBLocalRef ejbLocalRef = new EJBLocalRef();
            this.analyzeCommonEJBRef(ejbRefElement, ejbLocalRef);
            String local = XMLUtils.getStringValueElement((String)this.getXMLNS(), (Element)ejbRefElement, (String)"local");
            ejbLocalRef.setLocal(local);
            String localHome = XMLUtils.getStringValueElement((String)this.getXMLNS(), (Element)ejbRefElement, (String)"local-home");
            ejbLocalRef.setLocalHome(localHome);
            env.addEJBLocalRef((IEJBLocalRef)ejbLocalRef);
        }
    }

    private void analyzeEnvEnvtry(Element envElement, IEnvironment bean) {
        NodeList envEntryList = envElement.getElementsByTagNameNS(this.getXMLNS(), "env-entry");
        for (int i = 0; i < envEntryList.getLength(); ++i) {
            Element envEntryElement = (Element)envEntryList.item(i);
            EnvEntry envEntry = new EnvEntry();
            bean.addEnvEntry((IEnvEntry)envEntry);
            String envEntryName = XMLUtils.getStringValueElement((String)this.getXMLNS(), (Element)envEntryElement, (String)"env-entry-name");
            envEntry.setEnvEntryName(envEntryName);
            String envEntryType = XMLUtils.getStringValueElement((String)this.getXMLNS(), (Element)envEntryElement, (String)"env-entry-type");
            envEntry.setEnvEntryType(envEntryType);
            String envEntryValue = XMLUtils.getStringValueElement((String)this.getXMLNS(), (Element)envEntryElement, (String)"env-entry-value");
            envEntry.setEnvEntryValue(envEntryValue);
            this.analyzeInjectionTarget(envEntryElement, envEntry);
        }
    }

    protected void analyzeLifeCycle(Element envElement, IEnvironment env, String lifecycleName) {
        NodeList lifecycleList = envElement.getElementsByTagNameNS(this.getXMLNS(), lifecycleName);
        for (int i = 0; i < lifecycleList.getLength(); ++i) {
            Element lifeCycleElement = (Element)lifecycleList.item(i);
            LifeCycleCallback lifecycleCallback = new LifeCycleCallback();
            if ("post-construct".equals(lifecycleName)) {
                env.addPostConstructCallback((ILifeCycleCallback)lifecycleCallback);
            } else if ("pre-destroy".equals(lifecycleName)) {
                env.addPreDestroyCallback((ILifeCycleCallback)lifecycleCallback);
            } else if ("pre-passivate".equals(lifecycleName)) {
                env.addPrePassivateCallback((ILifeCycleCallback)lifecycleCallback);
            } else if ("post-activate".equals(lifecycleName)) {
                env.addPostActivateCallback((ILifeCycleCallback)lifecycleCallback);
            } else {
                throw new IllegalArgumentException("Unknown lifecycle named '" + lifecycleName + "'.");
            }
            String className = XMLUtils.getStringValueElement((String)this.getXMLNS(), (Element)lifeCycleElement, (String)"lifecycle-callback-class");
            lifecycleCallback.setLifecycleCallbackClass(className);
            String method = XMLUtils.getStringValueElement((String)this.getXMLNS(), (Element)lifeCycleElement, (String)"lifecycle-callback-method");
            lifecycleCallback.setMethodName(method);
        }
    }
}

