/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.lib.bootstrap.loader;

import java.io.File;
import java.net.URL;
import java.net.URLClassLoader;

public class JClassLoader
extends URLClassLoader {
    private String name = null;
    private boolean recomputeToString = true;
    private boolean recomputeClassPath = true;
    private String toStringValue = null;
    private String classpath = null;

    public JClassLoader(String name, URL[] urls, ClassLoader parent) {
        super(urls, parent);
        this.name = name;
        this.recomputeToString = true;
        this.recomputeClassPath = true;
    }

    public JClassLoader(String name, URL[] urls) {
        super(urls, Thread.currentThread().getContextClassLoader());
        this.name = name;
        this.recomputeToString = true;
        this.recomputeClassPath = true;
    }

    public void addURL(URL url) {
        if (url != null) {
            super.addURL(url);
        }
        this.recomputeToString = true;
        this.recomputeClassPath = true;
    }

    public void addURLs(URL[] urls) {
        if (urls != null) {
            for (int i = 0; i < urls.length; ++i) {
                if (urls[i] == null) continue;
                super.addURL(urls[i]);
            }
        }
        this.recomputeToString = true;
        this.recomputeClassPath = true;
    }

    public void printURLs() {
        System.out.println(this.name + " ClassLoader :");
        URL[] urls = super.getURLs();
        for (int i = 0; i < urls.length; ++i) {
            System.out.println("url=" + new File(urls[i].getFile()).getAbsolutePath());
        }
        if (this.getParent() != null && this.getParent() instanceof JClassLoader) {
            System.out.println("parent :");
            ((JClassLoader)this.getParent()).printURLs();
        }
    }

    public String getClassPath() {
        if (this.recomputeClassPath) {
            this.computeClassPath();
        }
        return this.classpath;
    }

    public String toString() {
        if (this.recomputeToString) {
            this.computeToString();
        }
        return this.toStringValue;
    }

    private void computeToString() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.getClass().getName());
        sb.append("[");
        sb.append(this.name);
        sb.append(", urls=");
        URL[] urls = this.getURLs();
        for (int u = 0; u < urls.length; ++u) {
            sb.append(urls[u]);
            if (u == urls.length - 1) continue;
            sb.append(";");
        }
        sb.append("]");
        this.toStringValue = sb.toString();
        this.recomputeToString = false;
    }

    private void computeClassPath() {
        String cp = "";
        if (this.getParent() != null && this.getParent() instanceof JClassLoader) {
            cp = cp + ((JClassLoader)this.getParent()).getClassPath();
        }
        URL[] urls = super.getURLs();
        for (int i = 0; i < urls.length; ++i) {
            cp = cp + File.pathSeparator + new File(urls[i].getFile()).getAbsolutePath();
        }
        this.classpath = cp;
        this.recomputeClassPath = false;
    }
}

