/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.ejb2.internal;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.Vector;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.zip.ZipFile;
import javax.ejb.NoSuchObjectLocalException;
import javax.ejb.Timer;
import javax.management.Attribute;
import javax.management.AttributeNotFoundException;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.resource.spi.work.WorkManager;
import org.apache.felix.ipojo.ComponentInstance;
import org.apache.felix.ipojo.InstanceManager;
import org.apache.felix.ipojo.Pojo;
import org.objectweb.util.monolog.api.BasicLevel;
import org.objectweb.util.monolog.api.Logger;
import org.objectweb.util.monolog.api.LoggerFactory;
import org.ow2.jonas.Version;
import org.ow2.jonas.cmi.CmiService;
import org.ow2.jonas.deployment.common.DeploymentDescException;
import org.ow2.jonas.deployment.ejb.BeanDesc;
import org.ow2.jonas.deployment.ejb.DeploymentDesc;
import org.ow2.jonas.deployment.ejb.EntityBmpDesc;
import org.ow2.jonas.deployment.ejb.EntityCmpDesc;
import org.ow2.jonas.deployment.ejb.MessageDrivenDesc;
import org.ow2.jonas.deployment.ejb.SessionDesc;
import org.ow2.jonas.deployment.ejb.SessionStatefulDesc;
import org.ow2.jonas.deployment.ejb.SessionStatelessDesc;
import org.ow2.jonas.deployment.ejb.lib.EjbDeploymentDescManager;
import org.ow2.jonas.ejb2.EJBService;
import org.ow2.jonas.ejb2.JTimerHandleInfo;
import org.ow2.jonas.ejb2.internal.EJB21Deployer;
import org.ow2.jonas.ejb2.internal.JOnASEJBServiceMBean;
import org.ow2.jonas.ejb2.internal.JarCleanTask;
import org.ow2.jonas.ejb2.internal.PrincipalFactoryImpl;
import org.ow2.jonas.ejb2.internal.mbean.EJBModule;
import org.ow2.jonas.ejb2.internal.mbean.EntityBean;
import org.ow2.jonas.ejb2.internal.mbean.MessageDrivenBean;
import org.ow2.jonas.ejb2.internal.mbean.StatefulSessionBean;
import org.ow2.jonas.ejb2.internal.mbean.StatelessSessionBean;
import org.ow2.jonas.generators.genic.wrapper.GenicServiceWrapper;
import org.ow2.jonas.generators.wsgen.wrapper.WsGenWrapper;
import org.ow2.jonas.ha.HaService;
import org.ow2.jonas.jmx.JmxService;
import org.ow2.jonas.lib.bootstrap.JProp;
import org.ow2.jonas.lib.bootstrap.LoaderManager;
import org.ow2.jonas.lib.ejb21.BeanFactory;
import org.ow2.jonas.lib.ejb21.Container;
import org.ow2.jonas.lib.ejb21.JContainer;
import org.ow2.jonas.lib.ejb21.JEntityFactory;
import org.ow2.jonas.lib.ejb21.JEntitySwitch;
import org.ow2.jonas.lib.ejb21.JFactory;
import org.ow2.jonas.lib.ejb21.JSessionFactory;
import org.ow2.jonas.lib.ejb21.JStatelessFactory;
import org.ow2.jonas.lib.ejb21.JTimerService;
import org.ow2.jonas.lib.ejb21.PermissionManager;
import org.ow2.jonas.lib.ejb21.PrincipalFactory;
import org.ow2.jonas.lib.ejb21.Protocols;
import org.ow2.jonas.lib.ejb21.TraceEjb;
import org.ow2.jonas.lib.loader.EjbJarClassLoader;
import org.ow2.jonas.lib.management.javaee.J2eeObjectName;
import org.ow2.jonas.lib.naming.ComponentContext;
import org.ow2.jonas.lib.service.AbsServiceImpl;
import org.ow2.jonas.lib.timer.TraceTimer;
import org.ow2.jonas.lib.util.JonasObjectName;
import org.ow2.jonas.lib.util.Log;
import org.ow2.jonas.lib.util.ModuleNamingUtils;
import org.ow2.jonas.lib.work.DeployerLog;
import org.ow2.jonas.lib.work.DeployerLogException;
import org.ow2.jonas.naming.JComponentContextFactory;
import org.ow2.jonas.naming.JNamingManager;
import org.ow2.jonas.registry.RegistryService;
import org.ow2.jonas.resource.ResourceService;
import org.ow2.jonas.security.SecurityService;
import org.ow2.jonas.service.ServiceException;
import org.ow2.jonas.tm.TransactionManager;
import org.ow2.jonas.tm.TransactionService;
import org.ow2.jonas.versioning.VersioningService;
import org.ow2.jonas.workcleaner.CleanTask;
import org.ow2.jonas.workcleaner.WorkCleanerService;
import org.ow2.jonas.workmanager.WorkManagerService;
import org.ow2.jonas.ws.WebServicesService;
import org.ow2.util.archive.api.IArchive;
import org.ow2.util.archive.impl.ArchiveManager;
import org.ow2.util.ee.deploy.api.deployable.IDeployable;
import org.ow2.util.ee.deploy.api.deployer.DeployerException;
import org.ow2.util.ee.deploy.api.deployer.IDeployer;
import org.ow2.util.ee.deploy.api.deployer.IDeployerManager;
import org.ow2.util.ee.deploy.impl.helper.DeployableHelper;
import org.ow2.util.event.api.IEventDispatcher;
import org.ow2.util.event.api.IEventListener;
import org.ow2.util.event.api.IEventService;
import org.ow2.util.event.impl.EventDispatcher;
import org.ow2.util.file.FileUtils;
import org.ow2.util.file.FileUtilsException;
import org.ow2.util.url.URLUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JOnASEJBService
extends AbsServiceImpl
implements EJBService,
JOnASEJBServiceMBean,
Pojo {
    private InstanceManager __IM;
    private static Logger logger = Log.getLogger((String)"org.ow2.jonas.ejb");
    private static Logger loaderlog = Log.getLogger((String)"org.ow2.jonas.loader");
    protected static final String WORK_DIR = JProp.getWorkDir();
    protected static final String WORK_EJBJARS_DIR = WORK_DIR + File.separator + "ejbjars";
    private static final int DEFAULT_WSGEN_SLEEP_TIME = 100;
    private static final int MINIMUM_TIMER_DURATION = 100;
    private boolean __Ftm;
    private TransactionManager tm;
    private boolean __FjmxService;
    private JmxService jmxService;
    private boolean __FsecurityService;
    private SecurityService securityService;
    private boolean __FwsService;
    private WebServicesService wsService;
    private boolean __FregistryService;
    private RegistryService registryService;
    private boolean __FejbNames;
    private List<String> ejbNames;
    private boolean __Fcontainers;
    private Vector<JContainer> containers;
    private boolean __FworkManager;
    private WorkManager workManager;
    private boolean __FmonitoringEnabled;
    private boolean monitoringEnabled;
    private boolean __FwarningThreshold;
    private int warningThreshold;
    public static final String BMP = "Bean-Managed";
    public static final String CMP = "Container-Managed";
    private boolean __FextClassLoader;
    private ClassLoader extClassLoader;
    private boolean __FdeployerLog;
    private DeployerLog deployerLog;
    private boolean __FautoGenIC;
    private boolean autoGenIC;
    private boolean __FautoGenICArgsList;
    private List<String> autoGenICArgsList;
    private boolean __FcomponentContextFactory;
    private JComponentContextFactory componentContextFactory;
    private boolean __FtransactionService;
    private TransactionService transactionService;
    private boolean __FworkManagerService;
    private WorkManagerService workManagerService;
    private boolean __Fnaming;
    private JNamingManager naming;
    private boolean __Fejb21Deployer;
    private EJB21Deployer ejb21Deployer;
    private boolean __FcmiService;
    private CmiService cmiService;
    private boolean __FhaService;
    private HaService haService;
    private boolean __FresService;
    private ResourceService resService;
    private boolean __FdeployerManager;
    private IDeployerManager deployerManager;
    private boolean __FworkEjbjarsFile;
    private File workEjbjarsFile;
    private boolean __FversioningService;
    private VersioningService versioningService;
    private boolean __FeventService;
    private IEventService eventService;
    private static final String MONITORING_DISPATCHER_NAME = "/jonas/service/ejb2/monitoring";
    private static final String CONTAINER_LIFECYCLE_DISPATCHER_NAME = "/beans/lifecycle/events";
    private boolean __FmonitoringDispatcher;
    private IEventDispatcher monitoringDispatcher;
    private boolean __FcontainerLifecycleDispatcher;
    private IEventDispatcher containerLifecycleDispatcher;
    private boolean __FbeanMonitoringStatistics;
    private Map<String, BeanMonitoringStatistics> beanMonitoringStatistics;
    static final int DATASOURCE = 1;
    static final int JMS_DESTINATION = 2;
    static final int JMS_FACTORY = 3;
    static final int MAIL_FACTORY = 4;
    private boolean __MsetAutoGenic$boolean;
    private boolean __MsetParsingwithvalidation$boolean;
    private boolean __MsetAutoGenicArgs$java_lang_String;
    private boolean __MdoStart;
    private boolean __MdoStop;
    private boolean __MinitWorkingDirectory;
    private boolean __MsetWorkCleanerService$org_ow2_jonas_workcleaner_WorkCleanerService;
    private boolean __McreateContainer$javax_naming_Context;
    private boolean __MapplyWSGenIfNeeded$java_lang_String;
    private boolean __MgetContainer$java_lang_String;
    private boolean __MremoveContainer$org_ow2_jonas_lib_ejb21_Container;
    private boolean __MlistContainers;
    private boolean __MsyncAllEntities$boolean;
    private boolean __MgetCurrentNumberOfContainer;
    private boolean __MgetTotalCurrentNumberOfBeanType;
    private boolean __MgetTotalCurrentNumberOfBMPType;
    private boolean __MgetTotalCurrentNumberOfCMPType;
    private boolean __MgetTotalCurrentNumberOfSBFType;
    private boolean __MgetTotalCurrentNumberOfSBLType;
    private boolean __MgetTotalCurrentNumberOfMDBType;
    private boolean __MgetDeployedJars;
    private boolean __MremoveContainer$java_lang_String;
    private boolean __McreateContainer$java_lang_String;
    private boolean __MisJarDeployed$java_lang_String;
    private boolean __MisJarDeployedByWorkName$java_lang_String;
    private boolean __MgetDependence$java_lang_String$int;
    private boolean __MconvertToObjectNames$java_util_Set;
    private boolean __MgetDataSourceDependence$java_lang_String;
    private boolean __MgetJmsDestinationDependence$java_lang_String;
    private boolean __MgetJmsConnectionFactoryDependence$java_lang_String;
    private boolean __MgetMailFactoryDependence$java_lang_String;
    private boolean __MdeployJars$javax_naming_Context;
    private boolean __MunDeployJars$java_net_URL__;
    private boolean __MremoveContainer$org_ow2_jonas_lib_ejb21_Container$boolean;
    private boolean __MremoveCache$java_lang_ClassLoader;
    private boolean __MisJarLoaded$java_lang_String;
    private boolean __McheckGenIC$java_lang_String$java_net_URL__;
    private boolean __MgetContainerContextID$java_lang_String;
    private boolean __MgetTimer$org_ow2_jonas_ejb2_JTimerHandleInfo;
    private boolean __MrestartTimer$org_ow2_jonas_ejb2_JTimerHandleInfo;
    private boolean __MgetJTimerService$org_ow2_jonas_ejb2_JTimerHandleInfo;
    private boolean __MregisterEjbServiceMBean$java_lang_Object$java_lang_String;
    private boolean __MunregisterEjbServiceMBean$java_lang_String;
    private boolean __MregisterEJBModuleMBean$java_lang_String$java_lang_String$java_lang_String$java_lang_String$org_ow2_jonas_lib_ejb21_JContainer$java_lang_String$java_net_URL;
    private boolean __MregisterEntityBeanMBean$java_lang_String$java_lang_String$java_lang_String$java_lang_String$java_lang_String$org_ow2_jonas_lib_ejb21_JEntityFactory$java_lang_String;
    private boolean __MregisterStatefulSessionBeanMBean$java_lang_String$java_lang_String$java_lang_String$java_lang_String$java_lang_String$org_ow2_jonas_lib_ejb21_JSessionFactory;
    private boolean __MregisterStatelessSessionBeanMBean$java_lang_String$java_lang_String$java_lang_String$java_lang_String$java_lang_String$org_ow2_jonas_lib_ejb21_JStatelessFactory;
    private boolean __MregisterMdbBeanMBean$java_lang_String$java_lang_String$java_lang_String$java_lang_String$java_lang_String$org_ow2_jonas_lib_ejb21_JFactory;
    private boolean __MregisterCompMBeans$java_lang_String$java_lang_String$java_lang_String$java_lang_String$org_ow2_jonas_lib_ejb21_JContainer$java_lang_String$java_net_URL$org_ow2_jonas_deployment_ejb_DeploymentDesc$java_util_Map$java_util_Map;
    private boolean __MunregisterCompMBeans$java_lang_String$java_lang_String$java_lang_String$java_lang_String;
    private boolean __McallGenic$java_lang_String$java_lang_String__;
    private boolean __MsetJmxService$org_ow2_jonas_jmx_JmxService;
    private boolean __MsetSecurityService$org_ow2_jonas_security_SecurityService;
    private boolean __MsetTransactionService$org_ow2_jonas_tm_TransactionService;
    private boolean __MsetWorkManagerService$org_ow2_jonas_workmanager_WorkManagerService;
    private boolean __MsetWebServicesService$org_ow2_jonas_ws_WebServicesService;
    private boolean __MsetNaming$org_ow2_jonas_naming_JNamingManager;
    private boolean __MsetComponentContextFactory$org_ow2_jonas_naming_JComponentContextFactory;
    private boolean __MsetRegistry$org_ow2_jonas_registry_RegistryService;
    private boolean __MsetHaService$org_ow2_jonas_ha_HaService;
    private boolean __MsetResourceService$org_ow2_jonas_resource_ResourceService;
    private boolean __MgetCmiService;
    private boolean __MsetCmiService$org_ow2_jonas_cmi_CmiService;
    private boolean __MsetDeployerManager$org_ow2_util_ee_deploy_api_deployer_IDeployerManager;
    private boolean __MsetVersioningService$org_ow2_jonas_versioning_VersioningService;
    private boolean __MunsetVersioningService;
    private boolean __MgetVersioningService;
    private boolean __MisVersioningEnabled;
    private boolean __MgetMonitoringEnabled;
    private boolean __MsetMonitoringEnabled$boolean;
    private boolean __MgetWarningThreshold;
    private boolean __MsetWarningThreshold$int;
    private boolean __MgetNumberOfCalls;
    private boolean __MgetTotalProcessingTime;
    private boolean __MgetTotalBusinessProcessingTime;
    private boolean __MgetAverageProcessingTime;
    private boolean __MgetAverageBusinessProcessingTime;
    private boolean __MapplyMonitorSettings$java_lang_String;
    private boolean __MsetEventService$org_ow2_util_event_api_IEventService;
    private boolean __MgetEventService;

    TransactionManager __gettm() {
        if (!this.__Ftm) {
            return this.tm;
        }
        return (TransactionManager)this.__IM.onGet((Object)this, "tm");
    }

    void __settm(TransactionManager transactionManager) {
        if (!this.__Ftm) {
            this.tm = transactionManager;
            return;
        }
        this.__IM.onSet((Object)this, "tm", (Object)transactionManager);
    }

    JmxService __getjmxService() {
        if (!this.__FjmxService) {
            return this.jmxService;
        }
        return (JmxService)this.__IM.onGet((Object)this, "jmxService");
    }

    void __setjmxService(JmxService jmxService) {
        if (!this.__FjmxService) {
            this.jmxService = jmxService;
            return;
        }
        this.__IM.onSet((Object)this, "jmxService", (Object)jmxService);
    }

    SecurityService __getsecurityService() {
        if (!this.__FsecurityService) {
            return this.securityService;
        }
        return (SecurityService)this.__IM.onGet((Object)this, "securityService");
    }

    void __setsecurityService(SecurityService securityService) {
        if (!this.__FsecurityService) {
            this.securityService = securityService;
            return;
        }
        this.__IM.onSet((Object)this, "securityService", (Object)securityService);
    }

    WebServicesService __getwsService() {
        if (!this.__FwsService) {
            return this.wsService;
        }
        return (WebServicesService)this.__IM.onGet((Object)this, "wsService");
    }

    void __setwsService(WebServicesService webServicesService) {
        if (!this.__FwsService) {
            this.wsService = webServicesService;
            return;
        }
        this.__IM.onSet((Object)this, "wsService", (Object)webServicesService);
    }

    RegistryService __getregistryService() {
        if (!this.__FregistryService) {
            return this.registryService;
        }
        return (RegistryService)this.__IM.onGet((Object)this, "registryService");
    }

    void __setregistryService(RegistryService registryService) {
        if (!this.__FregistryService) {
            this.registryService = registryService;
            return;
        }
        this.__IM.onSet((Object)this, "registryService", (Object)registryService);
    }

    List __getejbNames() {
        if (!this.__FejbNames) {
            return this.ejbNames;
        }
        return (List)this.__IM.onGet((Object)this, "ejbNames");
    }

    void __setejbNames(List list) {
        if (!this.__FejbNames) {
            this.ejbNames = list;
            return;
        }
        this.__IM.onSet((Object)this, "ejbNames", (Object)list);
    }

    Vector __getcontainers() {
        if (!this.__Fcontainers) {
            return this.containers;
        }
        return (Vector)this.__IM.onGet((Object)this, "containers");
    }

    void __setcontainers(Vector vector) {
        if (!this.__Fcontainers) {
            this.containers = vector;
            return;
        }
        this.__IM.onSet((Object)this, "containers", (Object)vector);
    }

    WorkManager __getworkManager() {
        if (!this.__FworkManager) {
            return this.workManager;
        }
        return (WorkManager)this.__IM.onGet((Object)this, "workManager");
    }

    void __setworkManager(WorkManager workManager) {
        if (!this.__FworkManager) {
            this.workManager = workManager;
            return;
        }
        this.__IM.onSet((Object)this, "workManager", (Object)workManager);
    }

    boolean __getmonitoringEnabled() {
        if (!this.__FmonitoringEnabled) {
            return this.monitoringEnabled;
        }
        Object object = this.__IM.onGet((Object)this, "monitoringEnabled");
        Boolean bl = (Boolean)object;
        return bl;
    }

    void __setmonitoringEnabled(boolean bl) {
        if (!this.__FmonitoringEnabled) {
            this.monitoringEnabled = bl;
            return;
        }
        Boolean bl2 = new Boolean(bl);
        this.__IM.onSet((Object)this, "monitoringEnabled", (Object)bl2);
    }

    int __getwarningThreshold() {
        if (!this.__FwarningThreshold) {
            return this.warningThreshold;
        }
        Object object = this.__IM.onGet((Object)this, "warningThreshold");
        Integer n = (Integer)object;
        return n;
    }

    void __setwarningThreshold(int n) {
        if (!this.__FwarningThreshold) {
            this.warningThreshold = n;
            return;
        }
        Integer n2 = new Integer(n);
        this.__IM.onSet((Object)this, "warningThreshold", (Object)n2);
    }

    ClassLoader __getextClassLoader() {
        if (!this.__FextClassLoader) {
            return this.extClassLoader;
        }
        return (ClassLoader)this.__IM.onGet((Object)this, "extClassLoader");
    }

    void __setextClassLoader(ClassLoader classLoader) {
        if (!this.__FextClassLoader) {
            this.extClassLoader = classLoader;
            return;
        }
        this.__IM.onSet((Object)this, "extClassLoader", (Object)classLoader);
    }

    DeployerLog __getdeployerLog() {
        if (!this.__FdeployerLog) {
            return this.deployerLog;
        }
        return (DeployerLog)this.__IM.onGet((Object)this, "deployerLog");
    }

    void __setdeployerLog(DeployerLog deployerLog) {
        if (!this.__FdeployerLog) {
            this.deployerLog = deployerLog;
            return;
        }
        this.__IM.onSet((Object)this, "deployerLog", (Object)deployerLog);
    }

    boolean __getautoGenIC() {
        if (!this.__FautoGenIC) {
            return this.autoGenIC;
        }
        Object object = this.__IM.onGet((Object)this, "autoGenIC");
        Boolean bl = (Boolean)object;
        return bl;
    }

    void __setautoGenIC(boolean bl) {
        if (!this.__FautoGenIC) {
            this.autoGenIC = bl;
            return;
        }
        Boolean bl2 = new Boolean(bl);
        this.__IM.onSet((Object)this, "autoGenIC", (Object)bl2);
    }

    List __getautoGenICArgsList() {
        if (!this.__FautoGenICArgsList) {
            return this.autoGenICArgsList;
        }
        return (List)this.__IM.onGet((Object)this, "autoGenICArgsList");
    }

    void __setautoGenICArgsList(List list) {
        if (!this.__FautoGenICArgsList) {
            this.autoGenICArgsList = list;
            return;
        }
        this.__IM.onSet((Object)this, "autoGenICArgsList", (Object)list);
    }

    JComponentContextFactory __getcomponentContextFactory() {
        if (!this.__FcomponentContextFactory) {
            return this.componentContextFactory;
        }
        return (JComponentContextFactory)this.__IM.onGet((Object)this, "componentContextFactory");
    }

    void __setcomponentContextFactory(JComponentContextFactory jComponentContextFactory) {
        if (!this.__FcomponentContextFactory) {
            this.componentContextFactory = jComponentContextFactory;
            return;
        }
        this.__IM.onSet((Object)this, "componentContextFactory", (Object)jComponentContextFactory);
    }

    TransactionService __gettransactionService() {
        if (!this.__FtransactionService) {
            return this.transactionService;
        }
        return (TransactionService)this.__IM.onGet((Object)this, "transactionService");
    }

    void __settransactionService(TransactionService transactionService) {
        if (!this.__FtransactionService) {
            this.transactionService = transactionService;
            return;
        }
        this.__IM.onSet((Object)this, "transactionService", (Object)transactionService);
    }

    WorkManagerService __getworkManagerService() {
        if (!this.__FworkManagerService) {
            return this.workManagerService;
        }
        return (WorkManagerService)this.__IM.onGet((Object)this, "workManagerService");
    }

    void __setworkManagerService(WorkManagerService workManagerService) {
        if (!this.__FworkManagerService) {
            this.workManagerService = workManagerService;
            return;
        }
        this.__IM.onSet((Object)this, "workManagerService", (Object)workManagerService);
    }

    JNamingManager __getnaming() {
        if (!this.__Fnaming) {
            return this.naming;
        }
        return (JNamingManager)this.__IM.onGet((Object)this, "naming");
    }

    void __setnaming(JNamingManager jNamingManager) {
        if (!this.__Fnaming) {
            this.naming = jNamingManager;
            return;
        }
        this.__IM.onSet((Object)this, "naming", (Object)jNamingManager);
    }

    EJB21Deployer __getejb21Deployer() {
        if (!this.__Fejb21Deployer) {
            return this.ejb21Deployer;
        }
        return (EJB21Deployer)this.__IM.onGet((Object)this, "ejb21Deployer");
    }

    void __setejb21Deployer(EJB21Deployer eJB21Deployer) {
        if (!this.__Fejb21Deployer) {
            this.ejb21Deployer = eJB21Deployer;
            return;
        }
        this.__IM.onSet((Object)this, "ejb21Deployer", (Object)eJB21Deployer);
    }

    CmiService __getcmiService() {
        if (!this.__FcmiService) {
            return this.cmiService;
        }
        return (CmiService)this.__IM.onGet((Object)this, "cmiService");
    }

    void __setcmiService(CmiService cmiService) {
        if (!this.__FcmiService) {
            this.cmiService = cmiService;
            return;
        }
        this.__IM.onSet((Object)this, "cmiService", (Object)cmiService);
    }

    HaService __gethaService() {
        if (!this.__FhaService) {
            return this.haService;
        }
        return (HaService)this.__IM.onGet((Object)this, "haService");
    }

    void __sethaService(HaService haService) {
        if (!this.__FhaService) {
            this.haService = haService;
            return;
        }
        this.__IM.onSet((Object)this, "haService", (Object)haService);
    }

    ResourceService __getresService() {
        if (!this.__FresService) {
            return this.resService;
        }
        return (ResourceService)this.__IM.onGet((Object)this, "resService");
    }

    void __setresService(ResourceService resourceService) {
        if (!this.__FresService) {
            this.resService = resourceService;
            return;
        }
        this.__IM.onSet((Object)this, "resService", (Object)resourceService);
    }

    IDeployerManager __getdeployerManager() {
        if (!this.__FdeployerManager) {
            return this.deployerManager;
        }
        return (IDeployerManager)this.__IM.onGet((Object)this, "deployerManager");
    }

    void __setdeployerManager(IDeployerManager iDeployerManager) {
        if (!this.__FdeployerManager) {
            this.deployerManager = iDeployerManager;
            return;
        }
        this.__IM.onSet((Object)this, "deployerManager", (Object)iDeployerManager);
    }

    File __getworkEjbjarsFile() {
        if (!this.__FworkEjbjarsFile) {
            return this.workEjbjarsFile;
        }
        return (File)this.__IM.onGet((Object)this, "workEjbjarsFile");
    }

    void __setworkEjbjarsFile(File file) {
        if (!this.__FworkEjbjarsFile) {
            this.workEjbjarsFile = file;
            return;
        }
        this.__IM.onSet((Object)this, "workEjbjarsFile", (Object)file);
    }

    VersioningService __getversioningService() {
        if (!this.__FversioningService) {
            return this.versioningService;
        }
        return (VersioningService)this.__IM.onGet((Object)this, "versioningService");
    }

    void __setversioningService(VersioningService versioningService) {
        if (!this.__FversioningService) {
            this.versioningService = versioningService;
            return;
        }
        this.__IM.onSet((Object)this, "versioningService", (Object)versioningService);
    }

    IEventService __geteventService() {
        if (!this.__FeventService) {
            return this.eventService;
        }
        return (IEventService)this.__IM.onGet((Object)this, "eventService");
    }

    void __seteventService(IEventService iEventService) {
        if (!this.__FeventService) {
            this.eventService = iEventService;
            return;
        }
        this.__IM.onSet((Object)this, "eventService", (Object)iEventService);
    }

    IEventDispatcher __getmonitoringDispatcher() {
        if (!this.__FmonitoringDispatcher) {
            return this.monitoringDispatcher;
        }
        return (IEventDispatcher)this.__IM.onGet((Object)this, "monitoringDispatcher");
    }

    void __setmonitoringDispatcher(IEventDispatcher iEventDispatcher) {
        if (!this.__FmonitoringDispatcher) {
            this.monitoringDispatcher = iEventDispatcher;
            return;
        }
        this.__IM.onSet((Object)this, "monitoringDispatcher", (Object)iEventDispatcher);
    }

    IEventDispatcher __getcontainerLifecycleDispatcher() {
        if (!this.__FcontainerLifecycleDispatcher) {
            return this.containerLifecycleDispatcher;
        }
        return (IEventDispatcher)this.__IM.onGet((Object)this, "containerLifecycleDispatcher");
    }

    void __setcontainerLifecycleDispatcher(IEventDispatcher iEventDispatcher) {
        if (!this.__FcontainerLifecycleDispatcher) {
            this.containerLifecycleDispatcher = iEventDispatcher;
            return;
        }
        this.__IM.onSet((Object)this, "containerLifecycleDispatcher", (Object)iEventDispatcher);
    }

    Map __getbeanMonitoringStatistics() {
        if (!this.__FbeanMonitoringStatistics) {
            return this.beanMonitoringStatistics;
        }
        return (Map)this.__IM.onGet((Object)this, "beanMonitoringStatistics");
    }

    void __setbeanMonitoringStatistics(Map map) {
        if (!this.__FbeanMonitoringStatistics) {
            this.beanMonitoringStatistics = map;
            return;
        }
        this.__IM.onSet((Object)this, "beanMonitoringStatistics", (Object)map);
    }

    public JOnASEJBService() {
        this(null);
    }

    private JOnASEJBService(InstanceManager _manager) {
        this._setInstanceManager(_manager);
        this.__settm(null);
        this.__setjmxService(null);
        this.__setsecurityService(null);
        this.__setwsService(null);
        this.__setregistryService(null);
        this.__setejbNames(new Vector());
        this.__setcontainers(new Vector());
        this.__setmonitoringEnabled(false);
        this.__setwarningThreshold(0);
        this.__setextClassLoader(null);
        this.__setdeployerLog(null);
        this.__setautoGenIC(true);
        this.__setautoGenICArgsList(new ArrayList());
        this.__setcomponentContextFactory(null);
        this.__setejb21Deployer(null);
        this.__setcmiService(null);
        this.__sethaService(null);
        this.__setresService(null);
        this.__setbeanMonitoringStatistics(new HashMap());
        this.__setejb21Deployer(new EJB21Deployer());
    }

    public void setAutoGenic(boolean bl) {
        if (!this.__MsetAutoGenic$boolean) {
            this.__setAutoGenic(bl);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "setAutoGenic$boolean", new Object[]{new Boolean(bl)});
            this.__setAutoGenic(bl);
            this.__IM.onExit((Object)this, "setAutoGenic$boolean", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "setAutoGenic$boolean", throwable);
            throw throwable;
        }
    }

    private void __setAutoGenic(boolean autoGenIC) {
        this.__setautoGenIC(autoGenIC);
        if (!autoGenIC) {
            logger.log(BasicLevel.INFO, (Object)"Auto GenIC has been disabled");
        }
    }

    public void setParsingwithvalidation(boolean bl) {
        if (!this.__MsetParsingwithvalidation$boolean) {
            this.__setParsingwithvalidation(bl);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "setParsingwithvalidation$boolean", new Object[]{new Boolean(bl)});
            this.__setParsingwithvalidation(bl);
            this.__IM.onExit((Object)this, "setParsingwithvalidation$boolean", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "setParsingwithvalidation$boolean", throwable);
            throw throwable;
        }
    }

    private void __setParsingwithvalidation(boolean validate) {
        EjbDeploymentDescManager.setParsingWithValidation((boolean)validate);
        if (!validate && logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)"XML parsing without validation");
        }
    }

    public void setAutoGenicArgs(String string) {
        if (!this.__MsetAutoGenicArgs$java_lang_String) {
            this.__setAutoGenicArgs(string);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "setAutoGenicArgs$java_lang_String", new Object[]{string});
            this.__setAutoGenicArgs(string);
            this.__IM.onExit((Object)this, "setAutoGenicArgs$java_lang_String", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "setAutoGenicArgs$java_lang_String", throwable);
            throw throwable;
        }
    }

    private void __setAutoGenicArgs(String args) {
        this.__setautoGenICArgsList(JOnASEJBService.convertToList((String)args));
        if (!this.__getautoGenICArgsList().isEmpty()) {
            logger.log(BasicLevel.INFO, (Object)("Auto GenIC args are set to '" + this.__getautoGenICArgsList() + "'."));
        }
    }

    public void doStart() throws ServiceException {
        if (!this.__MdoStart) {
            this.__doStart();
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "doStart", new Object[0]);
            this.__doStart();
            this.__IM.onExit((Object)this, "doStart", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "doStart", throwable);
            throw throwable;
        }
    }

    private void __doStart() throws ServiceException {
        this.initWorkingDirectory();
        this.__settm(this.__gettransactionService().getTransactionManager());
        this.__setworkManager(this.__getworkManagerService().getWorkManager());
        TraceTimer.configure((LoggerFactory)Log.getLoggerFactory());
        TraceEjb.configure((LoggerFactory)Log.getLoggerFactory());
        this.__getejb21Deployer().setEjb21Service(this);
        this.__getdeployerManager().register((IDeployer)this.__getejb21Deployer());
        try {
            this.__setmonitoringDispatcher((IEventDispatcher)new EventDispatcher());
            this.__getmonitoringDispatcher().start();
            this.__geteventService().registerDispatcher(MONITORING_DISPATCHER_NAME, this.__getmonitoringDispatcher());
        }
        catch (Exception e) {
            throw new ServiceException("Cannot create the EJB monitoring dispatcher", (Throwable)e);
        }
        if (this.__getcontainerLifecycleDispatcher() == null) {
            try {
                this.__setcontainerLifecycleDispatcher((IEventDispatcher)new EventDispatcher());
                this.__getcontainerLifecycleDispatcher().start();
                this.__geteventService().registerDispatcher(CONTAINER_LIFECYCLE_DISPATCHER_NAME, this.__getcontainerLifecycleDispatcher());
            }
            catch (Exception e) {
                throw new ServiceException("Cannot create the EJB Container lifecycle dispatcher", (Throwable)e);
            }
        }
        try {
            LoaderManager lm = LoaderManager.getInstance();
            this.__setextClassLoader((ClassLoader)lm.getExternalLoader());
        }
        catch (Throwable e) {
            logger.log(BasicLevel.ERROR, (Object)"Cannot get the Applications ClassLoader from EJB Container Service");
            throw new ServiceException("Cannot get the Applications ClassLoader from EJB Container Service", e);
        }
        if (this.__getjmxService() != null) {
            this.__getjmxService().loadDescriptors(this.getClass().getPackage().getName(), this.getClass().getClassLoader());
        }
        String fileName = null;
        ComponentContext contctx = null;
        for (int i = 0; i < this.__getejbNames().size(); ++i) {
            fileName = (String)this.__getejbNames().get(i);
            try {
                contctx = new ComponentContext(fileName);
                contctx.rebind("filename", (Object)fileName);
            }
            catch (NamingException e) {
                logger.log(BasicLevel.WARN, (Object)("Cannot bind filename '" + fileName + "' in component context"), (Throwable)e);
            }
            try {
                this.createContainer((Context)contctx);
                continue;
            }
            catch (Throwable e) {
                logger.log(BasicLevel.WARN, (Object)("Cannot create container for " + fileName), e);
                try {
                    contctx.close();
                    continue;
                }
                catch (NamingException nne) {
                    if (!logger.isLoggable(BasicLevel.DEBUG)) continue;
                    logger.log(BasicLevel.DEBUG, (Object)("Cannot close deploy context for " + fileName), (Throwable)nne);
                }
            }
        }
        this.registerEjbServiceMBean(this, this.getDomainName());
        logger.log(BasicLevel.INFO, (Object)"EJB 2.1 Service started");
    }

    public void doStop() {
        if (!this.__MdoStop) {
            this.__doStop();
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "doStop", new Object[0]);
            this.__doStop();
            this.__IM.onExit((Object)this, "doStop", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "doStop", throwable);
            throw throwable;
        }
    }

    private void __doStop() {
        if (this.__getdeployerManager() != null) {
            this.__getdeployerManager().unregister((IDeployer)this.__getejb21Deployer());
        }
        ArrayList containers = new ArrayList(this.__getcontainers());
        for (JContainer cont : containers) {
            this.removeContainer((Container)cont);
        }
        containers = null;
        try {
            this.__geteventService().unregisterDispatcher(MONITORING_DISPATCHER_NAME);
            this.__getmonitoringDispatcher().stop();
            this.__setmonitoringDispatcher(null);
        }
        catch (Exception e) {
            throw new ServiceException("Cannot screate the EJB monitoring dispatcher", (Throwable)e);
        }
        if (this.__getcmiService() != null) {
            try {
                this.__geteventService().unregisterDispatcher(CONTAINER_LIFECYCLE_DISPATCHER_NAME);
                this.__getcontainerLifecycleDispatcher().stop();
                this.__setcontainerLifecycleDispatcher(null);
            }
            catch (Exception e) {
                throw new ServiceException("Cannot screate the EJB container lifecycle dispatcher", (Throwable)e);
            }
        }
        this.unregisterEjbServiceMBean(this.getDomainName());
        logger.log(BasicLevel.INFO, (Object)"EJB 2.1 Service stopped");
    }

    protected void initWorkingDirectory() {
        if (!this.__MinitWorkingDirectory) {
            this.__initWorkingDirectory();
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "initWorkingDirectory", new Object[0]);
            this.__initWorkingDirectory();
            this.__IM.onExit((Object)this, "initWorkingDirectory", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "initWorkingDirectory", throwable);
            throw throwable;
        }
    }

    private void __initWorkingDirectory() {
        if (this.__getworkEjbjarsFile() == null) {
            this.__setworkEjbjarsFile(new File(WORK_EJBJARS_DIR + File.separator + this.getServerProperties().getServerName()));
            this.__getworkEjbjarsFile().mkdirs();
        }
    }

    protected void setWorkCleanerService(WorkCleanerService workCleanerService) {
        if (!this.__MsetWorkCleanerService$org_ow2_jonas_workcleaner_WorkCleanerService) {
            this.__setWorkCleanerService(workCleanerService);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "setWorkCleanerService$org_ow2_jonas_workcleaner_WorkCleanerService", new Object[]{workCleanerService});
            this.__setWorkCleanerService(workCleanerService);
            this.__IM.onExit((Object)this, "setWorkCleanerService$org_ow2_jonas_workcleaner_WorkCleanerService", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "setWorkCleanerService$org_ow2_jonas_workcleaner_WorkCleanerService", throwable);
            throw throwable;
        }
    }

    private void __setWorkCleanerService(WorkCleanerService workCleanerService) {
        this.initWorkingDirectory();
        File fileLog = new File(this.__getworkEjbjarsFile().getPath() + File.separator + this.getServerProperties().getServerName() + ".log");
        if (!fileLog.exists()) {
            try {
                fileLog.createNewFile();
            }
            catch (IOException e) {
                logger.log(BasicLevel.ERROR, (Object)("Cannot create the log file " + fileLog), (Throwable)e);
            }
        }
        try {
            this.__setdeployerLog(new DeployerLog(fileLog));
            JarCleanTask cleanTask = new JarCleanTask(this, this.__getdeployerLog());
            workCleanerService.registerTask((CleanTask)cleanTask);
            workCleanerService.executeTasks();
        }
        catch (DeployerLogException e) {
            logger.log(BasicLevel.ERROR, (Object)"Cannot register the clean task", (Throwable)e);
        }
    }

    public String createContainer(Context context) throws Exception {
        String string;
        if (!this.__McreateContainer$javax_naming_Context) {
            return this.__createContainer(context);
        }
        try {
            this.__IM.onEntry((Object)this, "createContainer$javax_naming_Context", new Object[]{context});
            string = this.__createContainer(context);
            this.__IM.onExit((Object)this, "createContainer$javax_naming_Context", (Object)string);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "createContainer$javax_naming_Context", throwable);
            throw throwable;
        }
        return string;
    }

    private String __createContainer(Context ctx) throws Exception {
        IDeployable originalDeployable;
        IArchive archive;
        File earFile;
        String earFileName;
        String earRoot;
        URL earUrl;
        URLClassLoader earClassLoader;
        URLClassLoader ejbClassLoader;
        URL[] url;
        String workFileName;
        boolean isInEar;
        File originalFile;
        String originalFileName;
        block48: {
            originalFileName = (String)ctx.lookup("filename");
            originalFile = new File(originalFileName);
            boolean isEjbJar = originalFileName.toLowerCase().endsWith(".jar");
            boolean isEjbJarXml = originalFileName.toLowerCase().endsWith(".xml") && originalFile.isFile();
            try {
                originalFileName = originalFile.toURL().getPath();
            }
            catch (MalformedURLException e) {
                logger.log(BasicLevel.ERROR, (Object)("Invalid ejb-jar file name '" + originalFileName + "'"), (Throwable)e);
            }
            if (originalFile.isFile() && !isEjbJar && !isEjbJarXml) {
                throw new ServiceException("The ejbjar to deploy is not a jar file nor an xml file");
            }
            if (this.getContainer(originalFileName) != null) {
                logger.log(BasicLevel.ERROR, (Object)("createContainer: " + originalFileName + " already exists"));
                throw new Exception("Container already exists");
            }
            isInEar = true;
            try {
                ctx.lookup("earClassLoader");
            }
            catch (NamingException ne) {
                isInEar = false;
            }
            workFileName = originalFileName;
            if (!isInEar && isEjbJar) {
                workFileName = FileUtils.lastModifiedFileName((File)originalFile);
                workFileName = WORK_EJBJARS_DIR + File.separator + this.getServerProperties().getServerName() + File.separator + workFileName;
                File workDirectory = new File(workFileName);
                workDirectory.mkdirs();
                if (!workDirectory.isDirectory()) {
                    throw new FileNotFoundException("Cannot create work folder : " + workFileName);
                }
                if (!new File(workFileName = workFileName + File.separator + originalFile.getName()).exists()) {
                    FileUtils.copyFile((String)originalFileName, (String)workFileName);
                }
                this.checkGenIC(workFileName, null);
                String resultFilename = this.applyWSGenIfNeeded(workFileName);
                if (resultFilename.endsWith(".ear")) {
                    return J2eeObjectName.getEJBModule((String)this.getDomainName(), (String)this.getJonasServerName(), (String)ModuleNamingUtils.fromFileName((String)resultFilename), (String)ModuleNamingUtils.fromFileName((String)originalFileName)).getCanonicalName();
                }
                try {
                    if (this.__getdeployerLog() != null) {
                        this.__getdeployerLog().addEntry(originalFile, workDirectory);
                    }
                }
                catch (DeployerLogException e) {
                    String err = "Error while adding the " + originalFileName + " entry in the log file";
                    logger.log(BasicLevel.ERROR, (Object)(err + " : " + e.getMessage()));
                    throw new Exception(err, e);
                }
            }
            url = new URL[]{URLUtils.fileToURL((File)new File(workFileName))};
            ejbClassLoader = null;
            earClassLoader = null;
            try {
                earClassLoader = (URLClassLoader)ctx.lookup("earClassLoader");
                ejbClassLoader = (URLClassLoader)ctx.lookup("ejbClassLoader");
                if (loaderlog.isLoggable(BasicLevel.DEBUG)) {
                    loaderlog.log(BasicLevel.DEBUG, (Object)("earClassLoader=" + earClassLoader));
                }
            }
            catch (NamingException ne) {
                ejbClassLoader = isEjbJar ? new EjbJarClassLoader(url, this.__getextClassLoader()) : (URLClassLoader)this.__getextClassLoader();
                if (!loaderlog.isLoggable(BasicLevel.DEBUG)) break block48;
                loaderlog.log(BasicLevel.DEBUG, (Object)("parent Loader=" + this.__getextClassLoader()));
            }
        }
        if (loaderlog.isLoggable(BasicLevel.DEBUG)) {
            loaderlog.log(BasicLevel.DEBUG, (Object)("ejbClassLoader=" + ejbClassLoader));
        }
        DeploymentDesc dd = null;
        try {
            EjbDeploymentDescManager mgr = EjbDeploymentDescManager.getInstance();
            dd = mgr.getDeploymentDesc(url[0], (ClassLoader)ejbClassLoader, (ClassLoader)earClassLoader);
        }
        catch (DeploymentDescException e) {
            String err = "Cannot read the deployment descriptors '" + originalFileName + "'";
            logger.log(BasicLevel.ERROR, (Object)err);
            logger.log(BasicLevel.ERROR, (Object)("DeploymentDescException:" + (Object)((Object)e)));
            throw new ServiceException(err, (Throwable)e);
        }
        String cname = ModuleNamingUtils.fromFileName((String)originalFileName);
        if (cname == null) {
            cname = "EJB container ";
            if (dd.getDisplayName() != null) {
                cname = cname + dd.getDisplayName();
            }
        }
        JContainer cont = new JContainer(cname, originalFileName, workFileName, (ClassLoader)ejbClassLoader, dd, this.__getcmiService(), this.__gethaService(), this.__getwsService(), this.__getjmxService().getJmxServer(), this.__getresService());
        cont.setContainerNaming(this.__getnaming());
        if (this.__getcomponentContextFactory() == null) {
            logger.log(BasicLevel.ERROR, (Object)"componentContextFactory has not been set");
        }
        cont.setComponentContextFactory(this.__getcomponentContextFactory());
        cont.setTransactionManager(this.__gettm());
        cont.setPrincipalFactory((PrincipalFactory)new PrincipalFactoryImpl());
        try {
            earUrl = (URL)ctx.lookup("earURL");
            earRoot = (String)ctx.lookup("earRoot");
            earFileName = URLUtils.urlToFile((URL)earUrl).getPath();
            cont.setEarFileName(earFileName);
            earFile = new File(earRoot);
        }
        catch (NamingException ne) {
            earUrl = null;
            earRoot = null;
            earFile = null;
            earFileName = null;
        }
        if (earFile != null) {
            archive = ArchiveManager.getInstance().getArchive(earFile);
            originalDeployable = DeployableHelper.getDeployable((IArchive)archive);
        } else {
            archive = ArchiveManager.getInstance().getArchive((Object)originalFile);
            originalDeployable = DeployableHelper.getDeployable((IArchive)archive);
        }
        String prefix = null;
        if (this.isVersioningEnabled()) {
            prefix = this.__getversioningService().getPrefix(originalDeployable);
        }
        String javaEEApplicationName = null;
        try {
            javaEEApplicationName = (String)ctx.lookup("j2eeApplicationName");
        }
        catch (NamingException ne) {
            javaEEApplicationName = null;
        }
        cont.setJavaEEApplicationName(javaEEApplicationName);
        if (this.__getsecurityService() == null) {
            if (logger.isLoggable(BasicLevel.DEBUG)) {
                logger.log(BasicLevel.DEBUG, (Object)"EJB Container Service: working without Security Service");
            }
            cont.setSecurity(false);
        } else {
            PermissionManager permissionManager = null;
            try {
                permissionManager = new PermissionManager(dd, cont.getContextId());
                permissionManager.translateEjbDeploymentDescriptor();
                if (!isInEar) {
                    permissionManager.commit();
                }
            }
            catch (Exception e) {
                logger.log(BasicLevel.ERROR, (Object)("Can't build permission manager object for the ejbjar '" + originalFileName + "'"), (Throwable)e);
            }
            cont.setPermissionManager(permissionManager);
        }
        cont.setWorkManager(this.__getworkManager());
        BeanDesc[] beans = dd.getBeanDesc();
        ArrayList<BeanFactory> bflist = new ArrayList<BeanFactory>();
        HashMap<String, BeanFactory> factoryMap = new HashMap<String, BeanFactory>();
        HashMap<String, BeanDesc> beanDescMap = new HashMap<String, BeanDesc>();
        for (BeanDesc beanDesc : beans) {
            String beanName = null;
            try {
                beanName = beanDesc.getEjbName();
                if (prefix != null) {
                    beanName = prefix + beanName;
                    beanDesc.setJndiName(prefix + beanDesc.getJndiName());
                    beanDesc.setJndiLocalName(prefix + beanDesc.getJndiLocalName());
                }
                cont.setLifeCycleDispatcher(this.__getcontainerLifecycleDispatcher());
                BeanFactory bf = cont.addBean(beanDesc);
                if (beanDesc instanceof SessionDesc) {
                    BeanMonitoringStatistics bms;
                    JSessionFactory jsf = (JSessionFactory)bf;
                    jsf.setDispatcher(this.__getmonitoringDispatcher());
                    this.__geteventService().registerListener((IEventListener)jsf, MONITORING_DISPATCHER_NAME);
                    if (!jsf.getMonitoringSettingsDefinedInDD()) {
                        jsf.setMonitoringEnabled(this.__getmonitoringEnabled());
                        jsf.setWarningThreshold(this.__getwarningThreshold());
                    }
                    if ((bms = (BeanMonitoringStatistics)this.__getbeanMonitoringStatistics().get(jsf.getEJBName())) != null) {
                        jsf.setNumberOfCalls(bms.getNumberOfCalls());
                        jsf.setTotalProcessingTime(bms.getTotalProcessingTime());
                        jsf.setTotalBusinessProcessingTime(bms.getTotalBusinessProcessingTime());
                    }
                }
                bflist.add(bf);
                factoryMap.put(beanName, bf);
                beanDescMap.put(beanName, beanDesc);
            }
            catch (Exception e) {
                logger.log(BasicLevel.WARN, (Object)("Can't deploy bean '" + beanName + "'"), (Throwable)e);
            }
        }
        for (BeanFactory bf : bflist) {
            bf.initInstancePool();
        }
        this.__getcontainers().addElement(cont);
        for (BeanFactory bf : bflist) {
            bf.restartTimers();
        }
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)("created container for " + originalFileName));
        }
        String domainName = this.getDomainName();
        String serverName = this.getJonasServerName();
        String ejbModuleON = this.registerCompMBeans(domainName, serverName, javaEEApplicationName, cname, cont, originalFileName, earUrl, dd, factoryMap, beanDescMap);
        if (prefix != null) {
            if (earRoot != null) {
                this.__getversioningService().createJNDIBindingMBeans(originalDeployable);
            } else {
                this.__getversioningService().createJNDIBindingMBeans(originalDeployable);
            }
        }
        return ejbModuleON;
    }

    private String applyWSGenIfNeeded(String string) throws DeployerException {
        String string2;
        if (!this.__MapplyWSGenIfNeeded$java_lang_String) {
            return this.__applyWSGenIfNeeded(string);
        }
        try {
            this.__IM.onEntry((Object)this, "applyWSGenIfNeeded$java_lang_String", new Object[]{string});
            string2 = this.__applyWSGenIfNeeded(string);
            this.__IM.onExit((Object)this, "applyWSGenIfNeeded$java_lang_String", (Object)string2);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "applyWSGenIfNeeded$java_lang_String", throwable);
            throw throwable;
        }
        return string2;
    }

    private String __applyWSGenIfNeeded(String filename) throws DeployerException {
        String nfile;
        block10: {
            if (this.__getwsService() == null) {
                logger.log(BasicLevel.DEBUG, (Object)"The WS service is not present, no need to call WSGen");
                return filename;
            }
            if (!this.__getwsService().isAutoWsGenEngaged()) {
                logger.log(BasicLevel.DEBUG, (Object)"Automatic WsGen is not enabled, no need to call WSGen");
                return filename;
            }
            String jonasVersionWsGen = JOnASEJBService.getAttributeInManifest(filename, "WsGen-JOnAS-Version");
            if (Version.getNumber().equals(jonasVersionWsGen)) {
                logger.log(BasicLevel.DEBUG, (Object)"No change: no need to call WSGen");
                return filename;
            }
            WsGenWrapper wsgen = new WsGenWrapper();
            nfile = null;
            try {
                nfile = wsgen.callWsGenExecute(filename, Boolean.valueOf(false));
                if (!wsgen.callWsGenIsInputModifed()) break block10;
                if (nfile.endsWith(".ear")) {
                    throw new DeployerException("WSGen has changed archive type from EJB-JAR to EAR. WSGen tool needs to be launched on your EJB-JAR '" + filename + "' before deploying it on JOnAS.");
                }
                logger.log(BasicLevel.DEBUG, (Object)("Archive updated, continuing deployment : " + nfile));
                try {
                    System.gc();
                    Thread.sleep(Long.getLong("jonas.wsgen.sleep", 100L));
                    if (!FileUtils.delete((String)filename)) {
                        throw new DeployerException("Cannot delete old application : " + filename);
                    }
                    FileUtils.copyFile((String)nfile, (String)filename);
                    FileUtils.delete((String)nfile);
                }
                catch (FileUtilsException e) {
                    throw new DeployerException("Cannot copy the jar from '" + nfile + "' to '" + filename + "'", (Throwable)e);
                }
                catch (InterruptedException e) {
                    throw new DeployerException("Cannot sleep for the given time period", (Throwable)e);
                }
                return filename;
            }
            catch (Exception e) {
                throw new DeployerException("Cannot execute WSGen on '" + filename + "'", (Throwable)e);
            }
        }
        return nfile;
    }

    public Container getContainer(String string) {
        Container container;
        if (!this.__MgetContainer$java_lang_String) {
            return this.__getContainer(string);
        }
        try {
            this.__IM.onEntry((Object)this, "getContainer$java_lang_String", new Object[]{string});
            container = this.__getContainer(string);
            this.__IM.onExit((Object)this, "getContainer$java_lang_String", (Object)container);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "getContainer$java_lang_String", throwable);
            throw throwable;
        }
        return container;
    }

    private Container __getContainer(String fileName) {
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)fileName);
        }
        File f = null;
        String pathFile = "";
        try {
            f = new File(fileName);
            pathFile = f.toURL().getPath();
        }
        catch (Exception e) {
            String err = "Error while trying to get canonical file '" + fileName + "'";
            logger.log(BasicLevel.ERROR, (Object)err);
            return null;
        }
        for (JContainer cont : this.__getcontainers()) {
            String contName = cont.getExternalFileName();
            if (!contName.equals(pathFile)) continue;
            return cont;
        }
        return null;
    }

    public void removeContainer(Container container) {
        if (!this.__MremoveContainer$org_ow2_jonas_lib_ejb21_Container) {
            this.__removeContainer(container);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "removeContainer$org_ow2_jonas_lib_ejb21_Container", new Object[]{container});
            this.__removeContainer(container);
            this.__IM.onExit((Object)this, "removeContainer$org_ow2_jonas_lib_ejb21_Container", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "removeContainer$org_ow2_jonas_lib_ejb21_Container", throwable);
            throw throwable;
        }
    }

    private void __removeContainer(Container cont) {
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)cont.getName());
        }
        String domainName = this.getDomainName();
        String serverName = this.getJonasServerName();
        String javaEEApplicationName = cont.getJavaEEApplicationName();
        String moduleName = cont.getName();
        String[] beans = cont.listBeanNames();
        for (int i = 0; i < beans.length; ++i) {
            String bean = beans[i];
            BeanFactory bf = cont.getBeanFactory(bean);
            if (!(bf instanceof JSessionFactory)) continue;
            JSessionFactory jsf = (JSessionFactory)bf;
            BeanMonitoringStatistics bms = new BeanMonitoringStatistics(jsf.getNumberOfCalls(), jsf.getTotalProcessingTime(), jsf.getTotalBusinessProcessingTime());
            this.__getbeanMonitoringStatistics().put(jsf.getEJBName(), bms);
            this.__getmonitoringDispatcher().removeListener((IEventListener)jsf);
        }
        this.unregisterCompMBeans(domainName, serverName, javaEEApplicationName, moduleName);
        cont.remove();
        this.__getcontainers().removeElement(cont);
        if (this.__getversioningService() != null && this.__getversioningService().isVersioningEnabled()) {
            this.__getversioningService().garbageCollectJNDIBindingMBeans();
        }
        Runtime.getRuntime().gc();
    }

    public Container[] listContainers() {
        Container[] containerArray;
        if (!this.__MlistContainers) {
            return this.__listContainers();
        }
        try {
            this.__IM.onEntry((Object)this, "listContainers", new Object[0]);
            containerArray = this.__listContainers();
            this.__IM.onExit((Object)this, "listContainers", (Object)containerArray);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "listContainers", throwable);
            throw throwable;
        }
        return containerArray;
    }

    private Container[] __listContainers() {
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)("size= " + this.__getcontainers().size()));
        }
        Object[] ret = new Container[this.__getcontainers().size()];
        this.__getcontainers().copyInto(ret);
        return ret;
    }

    @Override
    public void syncAllEntities(boolean bl) {
        if (!this.__MsyncAllEntities$boolean) {
            this.__syncAllEntities(bl);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "syncAllEntities$boolean", new Object[]{new Boolean(bl)});
            this.__syncAllEntities(bl);
            this.__IM.onExit((Object)this, "syncAllEntities$boolean", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "syncAllEntities$boolean", throwable);
            throw throwable;
        }
    }

    private void __syncAllEntities(boolean passivate) {
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)"");
        }
        for (JContainer cont : this.__getcontainers()) {
            cont.syncAll(true, passivate);
        }
    }

    @Override
    public Integer getCurrentNumberOfContainer() {
        Integer n;
        if (!this.__MgetCurrentNumberOfContainer) {
            return this.__getCurrentNumberOfContainer();
        }
        try {
            this.__IM.onEntry((Object)this, "getCurrentNumberOfContainer", new Object[0]);
            n = this.__getCurrentNumberOfContainer();
            this.__IM.onExit((Object)this, "getCurrentNumberOfContainer", (Object)n);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "getCurrentNumberOfContainer", throwable);
            throw throwable;
        }
        return n;
    }

    private Integer __getCurrentNumberOfContainer() {
        return new Integer(this.__getcontainers().size());
    }

    @Override
    public Integer getTotalCurrentNumberOfBeanType() {
        Integer n;
        if (!this.__MgetTotalCurrentNumberOfBeanType) {
            return this.__getTotalCurrentNumberOfBeanType();
        }
        try {
            this.__IM.onEntry((Object)this, "getTotalCurrentNumberOfBeanType", new Object[0]);
            n = this.__getTotalCurrentNumberOfBeanType();
            this.__IM.onExit((Object)this, "getTotalCurrentNumberOfBeanType", (Object)n);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "getTotalCurrentNumberOfBeanType", throwable);
            throw throwable;
        }
        return n;
    }

    private Integer __getTotalCurrentNumberOfBeanType() {
        int count = 0;
        for (JContainer cont : this.__getcontainers()) {
            count += cont.getBeanNb();
        }
        return new Integer(count);
    }

    @Override
    public Integer getTotalCurrentNumberOfBMPType() {
        Integer n;
        if (!this.__MgetTotalCurrentNumberOfBMPType) {
            return this.__getTotalCurrentNumberOfBMPType();
        }
        try {
            this.__IM.onEntry((Object)this, "getTotalCurrentNumberOfBMPType", new Object[0]);
            n = this.__getTotalCurrentNumberOfBMPType();
            this.__IM.onExit((Object)this, "getTotalCurrentNumberOfBMPType", (Object)n);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "getTotalCurrentNumberOfBMPType", throwable);
            throw throwable;
        }
        return n;
    }

    private Integer __getTotalCurrentNumberOfBMPType() {
        int count = 0;
        for (JContainer cont : this.__getcontainers()) {
            count += cont.getEntityBMPNb();
        }
        return new Integer(count);
    }

    @Override
    public Integer getTotalCurrentNumberOfCMPType() {
        Integer n;
        if (!this.__MgetTotalCurrentNumberOfCMPType) {
            return this.__getTotalCurrentNumberOfCMPType();
        }
        try {
            this.__IM.onEntry((Object)this, "getTotalCurrentNumberOfCMPType", new Object[0]);
            n = this.__getTotalCurrentNumberOfCMPType();
            this.__IM.onExit((Object)this, "getTotalCurrentNumberOfCMPType", (Object)n);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "getTotalCurrentNumberOfCMPType", throwable);
            throw throwable;
        }
        return n;
    }

    private Integer __getTotalCurrentNumberOfCMPType() {
        int count = 0;
        for (JContainer cont : this.__getcontainers()) {
            count += cont.getEntityCMPNb();
        }
        return new Integer(count);
    }

    @Override
    public Integer getTotalCurrentNumberOfSBFType() {
        Integer n;
        if (!this.__MgetTotalCurrentNumberOfSBFType) {
            return this.__getTotalCurrentNumberOfSBFType();
        }
        try {
            this.__IM.onEntry((Object)this, "getTotalCurrentNumberOfSBFType", new Object[0]);
            n = this.__getTotalCurrentNumberOfSBFType();
            this.__IM.onExit((Object)this, "getTotalCurrentNumberOfSBFType", (Object)n);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "getTotalCurrentNumberOfSBFType", throwable);
            throw throwable;
        }
        return n;
    }

    private Integer __getTotalCurrentNumberOfSBFType() {
        int count = 0;
        for (JContainer cont : this.__getcontainers()) {
            count += cont.getStatefulSessionNb();
        }
        return new Integer(count);
    }

    @Override
    public Integer getTotalCurrentNumberOfSBLType() {
        Integer n;
        if (!this.__MgetTotalCurrentNumberOfSBLType) {
            return this.__getTotalCurrentNumberOfSBLType();
        }
        try {
            this.__IM.onEntry((Object)this, "getTotalCurrentNumberOfSBLType", new Object[0]);
            n = this.__getTotalCurrentNumberOfSBLType();
            this.__IM.onExit((Object)this, "getTotalCurrentNumberOfSBLType", (Object)n);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "getTotalCurrentNumberOfSBLType", throwable);
            throw throwable;
        }
        return n;
    }

    private Integer __getTotalCurrentNumberOfSBLType() {
        int count = 0;
        for (JContainer cont : this.__getcontainers()) {
            count += cont.getStatelessSessionNb();
        }
        return new Integer(count);
    }

    @Override
    public Integer getTotalCurrentNumberOfMDBType() {
        Integer n;
        if (!this.__MgetTotalCurrentNumberOfMDBType) {
            return this.__getTotalCurrentNumberOfMDBType();
        }
        try {
            this.__IM.onEntry((Object)this, "getTotalCurrentNumberOfMDBType", new Object[0]);
            n = this.__getTotalCurrentNumberOfMDBType();
            this.__IM.onExit((Object)this, "getTotalCurrentNumberOfMDBType", (Object)n);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "getTotalCurrentNumberOfMDBType", throwable);
            throw throwable;
        }
        return n;
    }

    private Integer __getTotalCurrentNumberOfMDBType() {
        int count = 0;
        for (JContainer cont : this.__getcontainers()) {
            count += cont.getMessageDrivenNb();
        }
        return new Integer(count);
    }

    @Override
    public List<String> getDeployedJars() {
        List<String> list;
        if (!this.__MgetDeployedJars) {
            return this.__getDeployedJars();
        }
        try {
            this.__IM.onEntry((Object)this, "getDeployedJars", new Object[0]);
            list = this.__getDeployedJars();
            this.__IM.onExit((Object)this, "getDeployedJars", list);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "getDeployedJars", throwable);
            throw throwable;
        }
        return list;
    }

    private List<String> __getDeployedJars() {
        ArrayList<String> al = new ArrayList<String>();
        for (JContainer oContainer : this.__getcontainers()) {
            try {
                al.add(new File(oContainer.getExternalFileName()).toURL().getPath());
            }
            catch (Exception e) {}
        }
        return al;
    }

    public void removeContainer(String string) throws Exception {
        if (!this.__MremoveContainer$java_lang_String) {
            this.__removeContainer(string);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "removeContainer$java_lang_String", new Object[]{string});
            this.__removeContainer(string);
            this.__IM.onExit((Object)this, "removeContainer$java_lang_String", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "removeContainer$java_lang_String", throwable);
            throw throwable;
        }
    }

    private void __removeContainer(String fileName) throws Exception {
        Container cont = null;
        try {
            cont = this.getContainer(fileName);
        }
        catch (Exception e) {
            String err = "Error while trying to find file '" + fileName + "'";
            logger.log(BasicLevel.ERROR, (Object)err);
            throw new Exception(err, e);
        }
        if (cont == null) {
            String err = "Cannot remove the non-existant container '" + fileName + "'";
            logger.log(BasicLevel.ERROR, (Object)err);
            throw new Exception(err);
        }
        this.removeContainer(cont, false);
    }

    public String createContainer(String string) throws Exception {
        String string2;
        if (!this.__McreateContainer$java_lang_String) {
            return this.__createContainer(string);
        }
        try {
            this.__IM.onEntry((Object)this, "createContainer$java_lang_String", new Object[]{string});
            string2 = this.__createContainer(string);
            this.__IM.onExit((Object)this, "createContainer$java_lang_String", (Object)string2);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "createContainer$java_lang_String", throwable);
            throw throwable;
        }
        return string2;
    }

    private String __createContainer(String fileName) throws Exception {
        String ejbModuleObjectName = null;
        try {
            ComponentContext contctx = new ComponentContext(fileName);
            contctx.rebind("filename", (Object)fileName);
            ejbModuleObjectName = this.createContainer((Context)contctx);
        }
        catch (Exception e) {
            throw new Exception("Cannot create Container", e);
        }
        return ejbModuleObjectName;
    }

    public Boolean isJarDeployed(String string) {
        Boolean bl;
        if (!this.__MisJarDeployed$java_lang_String) {
            return this.__isJarDeployed(string);
        }
        try {
            this.__IM.onEntry((Object)this, "isJarDeployed$java_lang_String", new Object[]{string});
            bl = this.__isJarDeployed(string);
            this.__IM.onExit((Object)this, "isJarDeployed$java_lang_String", (Object)bl);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "isJarDeployed$java_lang_String", throwable);
            throw throwable;
        }
        return bl;
    }

    private Boolean __isJarDeployed(String fileName) {
        return new Boolean(this.isJarLoaded(fileName));
    }

    public boolean isJarDeployedByWorkName(String string) {
        boolean bl;
        if (!this.__MisJarDeployedByWorkName$java_lang_String) {
            return this.__isJarDeployedByWorkName(string);
        }
        try {
            this.__IM.onEntry((Object)this, "isJarDeployedByWorkName$java_lang_String", new Object[]{string});
            bl = this.__isJarDeployedByWorkName(string);
            this.__IM.onExit((Object)this, "isJarDeployedByWorkName$java_lang_String", (Object)new Boolean(bl));
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "isJarDeployedByWorkName$java_lang_String", throwable);
            throw throwable;
        }
        return bl;
    }

    private boolean __isJarDeployedByWorkName(String workFileName) {
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)workFileName);
        }
        for (JContainer cont : this.__getcontainers()) {
            String contName = new File(cont.getFileName()).getName();
            if (!contName.equals(workFileName)) continue;
            return true;
        }
        return false;
    }

    Set<ObjectName> getDependence(String string, int n) {
        Set<ObjectName> set;
        if (!this.__MgetDependence$java_lang_String$int) {
            return this.__getDependence(string, n);
        }
        try {
            this.__IM.onEntry((Object)this, "getDependence$java_lang_String$int", new Object[]{string, new Integer(n)});
            set = this.__getDependence(string, n);
            this.__IM.onExit((Object)this, "getDependence$java_lang_String$int", set);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "getDependence$java_lang_String$int", throwable);
            throw throwable;
        }
        return set;
    }

    private Set<ObjectName> __getDependence(String name, int type) {
        Set<ObjectName> resultObjectName = new HashSet<ObjectName>();
        HashSet<Properties> resultProperties = new HashSet<Properties>();
        try {
            InitialContext ctx = new InitialContext();
            ctx.lookup(name);
            ctx.close();
            for (JContainer cont : this.__getcontainers()) {
                Set depProps = null;
                switch (type) {
                    case 1: {
                        depProps = cont.getDataSourceDependence(name);
                        break;
                    }
                    case 2: {
                        depProps = cont.getJmsDestinationDependence(name);
                        break;
                    }
                    case 3: {
                        depProps = cont.getJmsConnectionFactoryDependence(name);
                        break;
                    }
                    case 4: {
                        depProps = cont.getMailFactoryDependence(name);
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("Unknown type : " + type);
                    }
                }
                resultProperties.addAll(depProps);
                try {
                    resultObjectName = this.convertToObjectNames(resultProperties);
                }
                catch (Exception e) {
                    logger.log(BasicLevel.ERROR, (Object)"EjbServiceImpl: Object Name Error", (Throwable)e);
                }
            }
        }
        catch (NamingException ne) {
            resultObjectName = new HashSet();
        }
        return resultObjectName;
    }

    private Set<ObjectName> convertToObjectNames(Set<Properties> set) {
        Set<ObjectName> set2;
        if (!this.__MconvertToObjectNames$java_util_Set) {
            return this.__convertToObjectNames(set);
        }
        try {
            this.__IM.onEntry((Object)this, "convertToObjectNames$java_util_Set", new Object[]{set});
            set2 = this.__convertToObjectNames(set);
            this.__IM.onExit((Object)this, "convertToObjectNames$java_util_Set", set2);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "convertToObjectNames$java_util_Set", throwable);
            throw throwable;
        }
        return set2;
    }

    private Set<ObjectName> __convertToObjectNames(Set<Properties> resultProperties) {
        HashSet<ObjectName> resultObjectName = new HashSet<ObjectName>();
        String domainName = this.getDomainName();
        String serverName = this.getJonasServerName();
        String ejbType = null;
        String ejbName = null;
        String earFileName = null;
        String moduleName = null;
        String j2eeAppName = null;
        for (Properties item : resultProperties) {
            ObjectName ejbObjectName = null;
            ejbType = item.getProperty("type");
            ejbName = item.getProperty("name");
            earFileName = item.getProperty("earFileName");
            moduleName = item.getProperty("cname");
            if (earFileName != null) {
                j2eeAppName = ModuleNamingUtils.fromFileName((String)earFileName);
            }
            if (ejbType.equals("ejbbmp") || ejbType.equals("ejbcmp")) {
                ejbObjectName = J2eeObjectName.getEntityBean((String)domainName, (String)moduleName, (String)serverName, (String)j2eeAppName, (String)ejbName);
            } else if (ejbType.equals("ejbsbf")) {
                ejbObjectName = J2eeObjectName.getStatefulSessionBean((String)domainName, (String)moduleName, (String)serverName, (String)j2eeAppName, (String)ejbName);
            } else if (ejbType.equals("ejbsbl")) {
                ejbObjectName = J2eeObjectName.getStatelessSessionBean((String)domainName, (String)moduleName, (String)serverName, (String)j2eeAppName, (String)ejbName);
            } else if (ejbType.equals("ejbmdb")) {
                ejbObjectName = J2eeObjectName.getMessageDrivenBean((String)domainName, (String)moduleName, (String)serverName, (String)j2eeAppName, (String)ejbName);
            }
            if (ejbObjectName == null) continue;
            resultObjectName.add(ejbObjectName);
        }
        return resultObjectName;
    }

    @Override
    public Set<ObjectName> getDataSourceDependence(String string) {
        Set<ObjectName> set;
        if (!this.__MgetDataSourceDependence$java_lang_String) {
            return this.__getDataSourceDependence(string);
        }
        try {
            this.__IM.onEntry((Object)this, "getDataSourceDependence$java_lang_String", new Object[]{string});
            set = this.__getDataSourceDependence(string);
            this.__IM.onExit((Object)this, "getDataSourceDependence$java_lang_String", set);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "getDataSourceDependence$java_lang_String", throwable);
            throw throwable;
        }
        return set;
    }

    private Set<ObjectName> __getDataSourceDependence(String dsName) {
        return this.getDependence(dsName, 1);
    }

    @Override
    public Set<ObjectName> getJmsDestinationDependence(String string) {
        Set<ObjectName> set;
        if (!this.__MgetJmsDestinationDependence$java_lang_String) {
            return this.__getJmsDestinationDependence(string);
        }
        try {
            this.__IM.onEntry((Object)this, "getJmsDestinationDependence$java_lang_String", new Object[]{string});
            set = this.__getJmsDestinationDependence(string);
            this.__IM.onExit((Object)this, "getJmsDestinationDependence$java_lang_String", set);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "getJmsDestinationDependence$java_lang_String", throwable);
            throw throwable;
        }
        return set;
    }

    private Set<ObjectName> __getJmsDestinationDependence(String destName) {
        return this.getDependence(destName, 2);
    }

    @Override
    public Set<ObjectName> getJmsConnectionFactoryDependence(String string) {
        Set<ObjectName> set;
        if (!this.__MgetJmsConnectionFactoryDependence$java_lang_String) {
            return this.__getJmsConnectionFactoryDependence(string);
        }
        try {
            this.__IM.onEntry((Object)this, "getJmsConnectionFactoryDependence$java_lang_String", new Object[]{string});
            set = this.__getJmsConnectionFactoryDependence(string);
            this.__IM.onExit((Object)this, "getJmsConnectionFactoryDependence$java_lang_String", set);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "getJmsConnectionFactoryDependence$java_lang_String", throwable);
            throw throwable;
        }
        return set;
    }

    private Set<ObjectName> __getJmsConnectionFactoryDependence(String cfName) {
        return this.getDependence(cfName, 3);
    }

    @Override
    public Set<ObjectName> getMailFactoryDependence(String string) {
        Set<ObjectName> set;
        if (!this.__MgetMailFactoryDependence$java_lang_String) {
            return this.__getMailFactoryDependence(string);
        }
        try {
            this.__IM.onEntry((Object)this, "getMailFactoryDependence$java_lang_String", new Object[]{string});
            set = this.__getMailFactoryDependence(string);
            this.__IM.onExit((Object)this, "getMailFactoryDependence$java_lang_String", set);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "getMailFactoryDependence$java_lang_String", throwable);
            throw throwable;
        }
        return set;
    }

    private Set<ObjectName> __getMailFactoryDependence(String mfName) {
        return this.getDependence(mfName, 4);
    }

    public void deployJars(Context context) throws ServiceException {
        if (!this.__MdeployJars$javax_naming_Context) {
            this.__deployJars(context);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "deployJars$javax_naming_Context", new Object[]{context});
            this.__deployJars(context);
            this.__IM.onExit((Object)this, "deployJars$javax_naming_Context", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "deployJars$javax_naming_Context", throwable);
            throw throwable;
        }
    }

    private void __deployJars(Context ctx) throws ServiceException {
        URL earRootUrl = null;
        URL earUrl = null;
        ClassLoader earClassLoader = null;
        ClassLoader ejbClassLoader = null;
        URL[] jarURLs = null;
        String[] roleNames = null;
        String j2eeApplicationName = null;
        try {
            earRootUrl = (URL)ctx.lookup("earRootUrl");
            earUrl = (URL)ctx.lookup("earUrl");
            earClassLoader = (ClassLoader)ctx.lookup("earClassLoader");
            ejbClassLoader = (ClassLoader)ctx.lookup("ejbClassLoader");
            jarURLs = (URL[])ctx.lookup("jarURLs");
            j2eeApplicationName = (String)ctx.lookup("j2eeApplicationName");
            roleNames = (String[])ctx.lookup("roleNames");
        }
        catch (NamingException e) {
            String err = "Error while getting parameter from context param :" + e.getMessage();
            logger.log(BasicLevel.ERROR, (Object)err);
            throw new ServiceException(err, (Throwable)e);
        }
        for (int i = 0; i < jarURLs.length; ++i) {
            String fileName = URLUtils.urlToFile((URL)jarURLs[i]).getPath();
            if (logger.isLoggable(BasicLevel.DEBUG)) {
                logger.log(BasicLevel.DEBUG, (Object)("Deploy '" + fileName + "' for the ear service."));
            }
            ComponentContext contctx = null;
            try {
                contctx = new ComponentContext(fileName);
                contctx.rebind("filename", (Object)fileName);
                contctx.rebind("earClassLoader", (Object)earClassLoader);
                contctx.rebind("ejbClassLoader", (Object)ejbClassLoader);
                contctx.rebind("earRoot", (Object)URLUtils.urlToFile((URL)earRootUrl).getPath());
                contctx.rebind("earURL", (Object)earUrl);
                contctx.rebind("j2eeApplicationName", (Object)j2eeApplicationName);
                contctx.rebind("roleNames", (Object)roleNames);
                this.createContainer((Context)contctx);
                continue;
            }
            catch (Exception e) {
                logger.log(BasicLevel.ERROR, (Object)("Error when deploying '" + fileName + "'"), (Throwable)e);
                logger.log(BasicLevel.ERROR, (Object)"Undeploy ejb-jar of the ear application");
                for (int j = 0; j <= i; ++j) {
                    Container cont = this.getContainer(URLUtils.urlToFile((URL)jarURLs[j]).getPath());
                    if (cont != null) {
                        this.removeContainer(cont, true);
                        continue;
                    }
                    logger.log(BasicLevel.ERROR, (Object)("Cannot remove the non-existant container '" + fileName + "'"));
                }
                throw new ServiceException("Error during the deployment", (Throwable)e);
            }
        }
    }

    public void unDeployJars(URL[] uRLArray) {
        if (!this.__MunDeployJars$java_net_URL__) {
            this.__unDeployJars(uRLArray);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "unDeployJars$java_net_URL__", new Object[]{uRLArray});
            this.__unDeployJars(uRLArray);
            this.__IM.onExit((Object)this, "unDeployJars$java_net_URL__", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "unDeployJars$java_net_URL__", throwable);
            throw throwable;
        }
    }

    private void __unDeployJars(URL[] urls) {
        for (int i = 0; i < urls.length; ++i) {
            String fileName = URLUtils.urlToFile((URL)urls[i]).getPath();
            Container cont = this.getContainer(fileName);
            if (cont != null) {
                this.removeContainer(cont, true);
                continue;
            }
            logger.log(BasicLevel.ERROR, (Object)("Cannot remove the non-existant container '" + fileName + "'"));
        }
    }

    public void removeContainer(Container container, boolean bl) {
        if (!this.__MremoveContainer$org_ow2_jonas_lib_ejb21_Container$boolean) {
            this.__removeContainer(container, bl);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "removeContainer$org_ow2_jonas_lib_ejb21_Container$boolean", new Object[]{container, new Boolean(bl)});
            this.__removeContainer(container, bl);
            this.__IM.onExit((Object)this, "removeContainer$org_ow2_jonas_lib_ejb21_Container$boolean", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "removeContainer$org_ow2_jonas_lib_ejb21_Container$boolean", throwable);
            throw throwable;
        }
    }

    private void __removeContainer(Container cont, boolean isEarCase) {
        if (isEarCase == (cont.getEarFileName() != null)) {
            this.removeContainer(cont);
        } else {
            String err = "Cannot remove container '" + cont.getName() + "' it is in an ear application. You must undeploy the ear associated.";
            logger.log(BasicLevel.ERROR, (Object)err);
        }
    }

    public void removeCache(ClassLoader classLoader) {
        if (!this.__MremoveCache$java_lang_ClassLoader) {
            this.__removeCache(classLoader);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "removeCache$java_lang_ClassLoader", new Object[]{classLoader});
            this.__removeCache(classLoader);
            this.__IM.onExit((Object)this, "removeCache$java_lang_ClassLoader", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "removeCache$java_lang_ClassLoader", throwable);
            throw throwable;
        }
    }

    private void __removeCache(ClassLoader earClassLoader) {
        EjbDeploymentDescManager mgr = EjbDeploymentDescManager.getInstance();
        mgr.removeCache(earClassLoader);
    }

    @Override
    public boolean isJarLoaded(String string) {
        boolean bl;
        if (!this.__MisJarLoaded$java_lang_String) {
            return this.__isJarLoaded(string);
        }
        try {
            this.__IM.onEntry((Object)this, "isJarLoaded$java_lang_String", new Object[]{string});
            bl = this.__isJarLoaded(string);
            this.__IM.onExit((Object)this, "isJarLoaded$java_lang_String", (Object)new Boolean(bl));
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "isJarLoaded$java_lang_String", throwable);
            throw throwable;
        }
        return bl;
    }

    private boolean __isJarLoaded(String fileName) {
        return this.getContainer(fileName) != null;
    }

    private static boolean checkCurrentProtocolIncludeIntoGenerated(String listProtocolGenerated, String listCurrentProtocol) {
        Protocols generated = new Protocols(listProtocolGenerated);
        Protocols current = new Protocols(listCurrentProtocol);
        return generated.isSupported(current);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getAttributeInManifest(String jarName, String attributName) {
        ZipFile jar = null;
        try {
            File jarFile = new File(jarName);
            jar = new JarFile(jarFile);
            Manifest man = ((JarFile)jar).getManifest();
            Attributes atts = man.getMainAttributes();
            String string = atts.getValue(attributName);
            return string;
        }
        catch (Exception e) {
            logger.log(BasicLevel.ERROR, (Object)("Cannot read Manifest: " + e));
            String string = null;
            return string;
        }
        finally {
            try {
                if (jar != null) {
                    jar.close();
                }
            }
            catch (IOException e) {
                logger.log(BasicLevel.ERROR, (Object)("Cannot close the Jar File: " + e));
            }
        }
    }

    public void checkGenIC(String string, URL[] uRLArray) {
        if (!this.__McheckGenIC$java_lang_String$java_net_URL__) {
            this.__checkGenIC(string, uRLArray);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "checkGenIC$java_lang_String$java_net_URL__", new Object[]{string, uRLArray});
            this.__checkGenIC(string, uRLArray);
            this.__IM.onExit((Object)this, "checkGenIC$java_lang_String$java_net_URL__", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "checkGenIC$java_lang_String$java_net_URL__", throwable);
            throw throwable;
        }
    }

    private void __checkGenIC(String fileName, URL[] urls) {
        if (!this.__getautoGenIC()) {
            return;
        }
        List protocols = this.__getregistryService().getActiveProtocolNames();
        String[] genicArgsString = null;
        int argIndex = 0;
        if (urls != null && urls.length > 0) {
            genicArgsString = new String[4 + this.__getautoGenICArgsList().size()];
            StringBuffer classpath = new StringBuffer();
            for (int i = 0; i < urls.length; ++i) {
                classpath.append(urls[i].getPath());
                if (i == urls.length - 1) continue;
                classpath.append(File.pathSeparator);
            }
            genicArgsString[argIndex++] = "-classpath";
            genicArgsString[argIndex++] = classpath.toString();
        } else {
            genicArgsString = new String[2 + this.__getautoGenICArgsList().size()];
        }
        genicArgsString[argIndex++] = "-protocols";
        String listProtocols = "";
        Iterator i = protocols.iterator();
        while (i.hasNext()) {
            String protocol = (String)i.next();
            listProtocols = listProtocols + protocol;
            if (!i.hasNext()) continue;
            listProtocols = listProtocols + ",";
        }
        genicArgsString[argIndex++] = listProtocols;
        for (String argument : this.__getautoGenICArgsList()) {
            genicArgsString[argIndex++] = argument;
        }
        String jonasVersionGenic = JOnASEJBService.getAttributeInManifest(fileName, "Genic-Jonas-Version");
        String listProtocolGenerated = JOnASEJBService.getAttributeInManifest(fileName, "Genic-Jonas-protocols");
        boolean isCurrentProtocolIncludeIntoGenerated = JOnASEJBService.checkCurrentProtocolIncludeIntoGenerated(listProtocolGenerated, listProtocols);
        if (jonasVersionGenic == null || !jonasVersionGenic.equals(Version.getNumber()) || !isCurrentProtocolIncludeIntoGenerated) {
            if (jonasVersionGenic == null) {
                logger.log(BasicLevel.INFO, (Object)("JOnAS version was not found in the '" + fileName + "' manifest file. Auto-generating container classes..."));
            } else if (!jonasVersionGenic.equals(Version.getNumber())) {
                logger.log(BasicLevel.INFO, (Object)("JOnAS version found in the '" + fileName + "' manifest file :" + jonasVersionGenic + " is different of the current JOnAS version : " + Version.getNumber() + ". Auto-generating container classes..."));
            } else if (!isCurrentProtocolIncludeIntoGenerated) {
                logger.log(BasicLevel.INFO, (Object)("Current Carol protocol is not included in the protocols found in the '" + fileName + "' manifest file. Auto-generating container classes..."));
            }
            try {
                this.callGenic(fileName, genicArgsString);
            }
            catch (ServiceException e) {
                logger.log(BasicLevel.ERROR, (Object)("Cannot apply GenIC on the file '" + fileName + "' with the args '" + Arrays.asList(genicArgsString) + "'."), (Throwable)e);
            }
        }
    }

    public String getContainerContextID(String string) {
        String string2;
        if (!this.__MgetContainerContextID$java_lang_String) {
            return this.__getContainerContextID(string);
        }
        try {
            this.__IM.onEntry((Object)this, "getContainerContextID$java_lang_String", new Object[]{string});
            string2 = this.__getContainerContextID(string);
            this.__IM.onExit((Object)this, "getContainerContextID$java_lang_String", (Object)string2);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "getContainerContextID$java_lang_String", throwable);
            throw throwable;
        }
        return string2;
    }

    private String __getContainerContextID(String containerFileName) {
        return this.getContainer(containerFileName).getContextId();
    }

    public Timer getTimer(JTimerHandleInfo jTimerHandleInfo) {
        Timer timer;
        if (!this.__MgetTimer$org_ow2_jonas_ejb2_JTimerHandleInfo) {
            return this.__getTimer(jTimerHandleInfo);
        }
        try {
            this.__IM.onEntry((Object)this, "getTimer$org_ow2_jonas_ejb2_JTimerHandleInfo", new Object[]{jTimerHandleInfo});
            timer = this.__getTimer(jTimerHandleInfo);
            this.__IM.onExit((Object)this, "getTimer$org_ow2_jonas_ejb2_JTimerHandleInfo", (Object)timer);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "getTimer$org_ow2_jonas_ejb2_JTimerHandleInfo", throwable);
            throw throwable;
        }
        return timer;
    }

    private Timer __getTimer(JTimerHandleInfo info) {
        JTimerService timerservice = this.getJTimerService(info);
        Timer ret = timerservice.getTimerByTime(info.getDuration(), info.getPeriod(), info.getInfo());
        if (ret == null) {
            throw new NoSuchObjectLocalException("The Timer should have been canceled");
        }
        return ret;
    }

    public Timer restartTimer(JTimerHandleInfo jTimerHandleInfo) {
        Timer timer;
        if (!this.__MrestartTimer$org_ow2_jonas_ejb2_JTimerHandleInfo) {
            return this.__restartTimer(jTimerHandleInfo);
        }
        try {
            this.__IM.onEntry((Object)this, "restartTimer$org_ow2_jonas_ejb2_JTimerHandleInfo", new Object[]{jTimerHandleInfo});
            timer = this.__restartTimer(jTimerHandleInfo);
            this.__IM.onExit((Object)this, "restartTimer$org_ow2_jonas_ejb2_JTimerHandleInfo", (Object)timer);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "restartTimer$org_ow2_jonas_ejb2_JTimerHandleInfo", throwable);
            throw throwable;
        }
        return timer;
    }

    private Timer __restartTimer(JTimerHandleInfo info) {
        JTimerService timerservice = this.getJTimerService(info);
        long newDuration = info.getDuration() + info.getStartTime() - System.currentTimeMillis();
        if (newDuration < 100L) {
            newDuration = 100L;
        }
        info.setDuration(newDuration);
        Timer timer = timerservice.createTimer(info.getDuration(), info.getPeriod(), info.getInfo());
        if (timer.getTimeRemaining() > 0L) {
            TraceTimer.logger.log(BasicLevel.DEBUG, (Object)"timer restarted");
        } else {
            TraceTimer.logger.log(BasicLevel.DEBUG, (Object)"timer terminated");
            timer.cancel();
        }
        return timer;
    }

    private JTimerService getJTimerService(JTimerHandleInfo jTimerHandleInfo) {
        JTimerService jTimerService;
        if (!this.__MgetJTimerService$org_ow2_jonas_ejb2_JTimerHandleInfo) {
            return this.__getJTimerService(jTimerHandleInfo);
        }
        try {
            this.__IM.onEntry((Object)this, "getJTimerService$org_ow2_jonas_ejb2_JTimerHandleInfo", new Object[]{jTimerHandleInfo});
            jTimerService = this.__getJTimerService(jTimerHandleInfo);
            this.__IM.onExit((Object)this, "getJTimerService$org_ow2_jonas_ejb2_JTimerHandleInfo", (Object)jTimerService);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "getJTimerService$org_ow2_jonas_ejb2_JTimerHandleInfo", throwable);
            throw throwable;
        }
        return jTimerService;
    }

    private JTimerService __getJTimerService(JTimerHandleInfo info) {
        JContainer cont = (JContainer)this.getContainer(info.getContainerId());
        if (cont == null) {
            TraceTimer.logger.log(BasicLevel.ERROR, (Object)("Cannot get container =" + info.getContainerId()));
            throw new IllegalStateException("Cannot get container");
        }
        JFactory bf = (JFactory)cont.getBeanFactory(info.getBeanId());
        JTimerService timerservice = null;
        if (bf instanceof JEntityFactory) {
            JEntitySwitch es;
            Serializable pk = info.getPk();
            JEntityFactory ef = (JEntityFactory)bf;
            Serializable pks = ef.decodePK(pk);
            if (TraceTimer.isDebug()) {
                TraceTimer.logger.log(BasicLevel.DEBUG, (Object)("encoded PK=" + pk));
                TraceTimer.logger.log(BasicLevel.DEBUG, (Object)("decoded PK=" + pks));
            }
            if ((es = ef.getEJB((Object)pks)) == null) {
                TraceTimer.logger.log(BasicLevel.DEBUG, (Object)"No entity for this pk");
                throw new NoSuchObjectLocalException("No entity for this pk");
            }
            timerservice = (JTimerService)es.getEntityTimerService();
        } else {
            timerservice = (JTimerService)bf.getTimerService();
        }
        if (timerservice == null) {
            TraceTimer.logger.log(BasicLevel.DEBUG, (Object)"Cannot retrieve TimerService");
            throw new IllegalStateException("Cannot retrieve TimerService");
        }
        return timerservice;
    }

    private void registerEjbServiceMBean(Object object, String string) {
        if (!this.__MregisterEjbServiceMBean$java_lang_Object$java_lang_String) {
            this.__registerEjbServiceMBean(object, string);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "registerEjbServiceMBean$java_lang_Object$java_lang_String", new Object[]{object, string});
            this.__registerEjbServiceMBean(object, string);
            this.__IM.onExit((Object)this, "registerEjbServiceMBean$java_lang_Object$java_lang_String", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "registerEjbServiceMBean$java_lang_Object$java_lang_String", throwable);
            throw throwable;
        }
    }

    private void __registerEjbServiceMBean(Object service, String domainName) {
        ObjectName on = JonasObjectName.ejbService((String)domainName);
        this.__getjmxService().registerMBean(service, on);
    }

    private void unregisterEjbServiceMBean(String string) {
        if (!this.__MunregisterEjbServiceMBean$java_lang_String) {
            this.__unregisterEjbServiceMBean(string);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "unregisterEjbServiceMBean$java_lang_String", new Object[]{string});
            this.__unregisterEjbServiceMBean(string);
            this.__IM.onExit((Object)this, "unregisterEjbServiceMBean$java_lang_String", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "unregisterEjbServiceMBean$java_lang_String", throwable);
            throw throwable;
        }
    }

    private void __unregisterEjbServiceMBean(String domainName) {
        if (this.__getjmxService() != null) {
            ObjectName on = JonasObjectName.ejbService((String)domainName);
            this.__getjmxService().unregisterMBean(on);
        }
    }

    private EJBModule registerEJBModuleMBean(String string, String string2, String string3, String string4, JContainer jContainer, String string5, URL uRL) {
        EJBModule eJBModule;
        if (!this.__MregisterEJBModuleMBean$java_lang_String$java_lang_String$java_lang_String$java_lang_String$org_ow2_jonas_lib_ejb21_JContainer$java_lang_String$java_net_URL) {
            return this.__registerEJBModuleMBean(string, string2, string3, string4, jContainer, string5, uRL);
        }
        try {
            this.__IM.onEntry((Object)this, "registerEJBModuleMBean$java_lang_String$java_lang_String$java_lang_String$java_lang_String$org_ow2_jonas_lib_ejb21_JContainer$java_lang_String$java_net_URL", new Object[]{string, string2, string3, string4, jContainer, string5, uRL});
            eJBModule = this.__registerEJBModuleMBean(string, string2, string3, string4, jContainer, string5, uRL);
            this.__IM.onExit((Object)this, "registerEJBModuleMBean$java_lang_String$java_lang_String$java_lang_String$java_lang_String$org_ow2_jonas_lib_ejb21_JContainer$java_lang_String$java_net_URL", (Object)eJBModule);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "registerEJBModuleMBean$java_lang_String$java_lang_String$java_lang_String$java_lang_String$org_ow2_jonas_lib_ejb21_JContainer$java_lang_String$java_net_URL", throwable);
            throw throwable;
        }
        return eJBModule;
    }

    private EJBModule __registerEJBModuleMBean(String domainName, String serverName, String j2eeappName, String moduleName, JContainer container, String fileName, URL earUrl) {
        ObjectName ejbModuleOn = J2eeObjectName.getEJBModule((String)domainName, (String)serverName, (String)j2eeappName, (String)moduleName);
        EJBModule ejbModuleMBean = new EJBModule(this.__getjmxService().getJmxServer(), ejbModuleOn, container, fileName, moduleName, j2eeappName, earUrl);
        ejbModuleMBean.setServer(J2eeObjectName.J2EEServerName((String)domainName, (String)serverName));
        try {
            this.__getjmxService().registerModelMBean((Object)ejbModuleMBean, ejbModuleOn);
        }
        catch (Exception e) {
            logger.log(BasicLevel.WARN, (Object)"Could not register EJBModule MBean", (Throwable)e);
        }
        return ejbModuleMBean;
    }

    private String registerEntityBeanMBean(String string, String string2, String string3, String string4, String string5, JEntityFactory jEntityFactory, String string6) {
        String string7;
        if (!this.__MregisterEntityBeanMBean$java_lang_String$java_lang_String$java_lang_String$java_lang_String$java_lang_String$org_ow2_jonas_lib_ejb21_JEntityFactory$java_lang_String) {
            return this.__registerEntityBeanMBean(string, string2, string3, string4, string5, jEntityFactory, string6);
        }
        try {
            this.__IM.onEntry((Object)this, "registerEntityBeanMBean$java_lang_String$java_lang_String$java_lang_String$java_lang_String$java_lang_String$org_ow2_jonas_lib_ejb21_JEntityFactory$java_lang_String", new Object[]{string, string2, string3, string4, string5, jEntityFactory, string6});
            string7 = this.__registerEntityBeanMBean(string, string2, string3, string4, string5, jEntityFactory, string6);
            this.__IM.onExit((Object)this, "registerEntityBeanMBean$java_lang_String$java_lang_String$java_lang_String$java_lang_String$java_lang_String$org_ow2_jonas_lib_ejb21_JEntityFactory$java_lang_String", (Object)string7);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "registerEntityBeanMBean$java_lang_String$java_lang_String$java_lang_String$java_lang_String$java_lang_String$org_ow2_jonas_lib_ejb21_JEntityFactory$java_lang_String", throwable);
            throw throwable;
        }
        return string7;
    }

    private String __registerEntityBeanMBean(String domainName, String serverName, String j2eeappName, String moduleName, String beanName, JEntityFactory jef, String persist) {
        String entityBeanON = J2eeObjectName.getEntityBeanName((String)domainName, (String)moduleName, (String)serverName, (String)j2eeappName, (String)beanName);
        EntityBean entityBeanMBean = new EntityBean(entityBeanON, jef, persist, this.__getjmxService());
        try {
            this.__getjmxService().registerModelMBean((Object)entityBeanMBean, entityBeanON);
        }
        catch (Exception e) {
            logger.log(BasicLevel.WARN, (Object)"Could not register EntityBean MBean", (Throwable)e);
            return null;
        }
        return entityBeanON;
    }

    private String registerStatefulSessionBeanMBean(String string, String string2, String string3, String string4, String string5, JSessionFactory jSessionFactory) {
        String string6;
        if (!this.__MregisterStatefulSessionBeanMBean$java_lang_String$java_lang_String$java_lang_String$java_lang_String$java_lang_String$org_ow2_jonas_lib_ejb21_JSessionFactory) {
            return this.__registerStatefulSessionBeanMBean(string, string2, string3, string4, string5, jSessionFactory);
        }
        try {
            this.__IM.onEntry((Object)this, "registerStatefulSessionBeanMBean$java_lang_String$java_lang_String$java_lang_String$java_lang_String$java_lang_String$org_ow2_jonas_lib_ejb21_JSessionFactory", new Object[]{string, string2, string3, string4, string5, jSessionFactory});
            string6 = this.__registerStatefulSessionBeanMBean(string, string2, string3, string4, string5, jSessionFactory);
            this.__IM.onExit((Object)this, "registerStatefulSessionBeanMBean$java_lang_String$java_lang_String$java_lang_String$java_lang_String$java_lang_String$org_ow2_jonas_lib_ejb21_JSessionFactory", (Object)string6);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "registerStatefulSessionBeanMBean$java_lang_String$java_lang_String$java_lang_String$java_lang_String$java_lang_String$org_ow2_jonas_lib_ejb21_JSessionFactory", throwable);
            throw throwable;
        }
        return string6;
    }

    private String __registerStatefulSessionBeanMBean(String domainName, String serverName, String j2eeappName, String moduleName, String beanName, JSessionFactory jsf) {
        String ssBeanON = J2eeObjectName.getStatefulSessionBeanName((String)domainName, (String)moduleName, (String)serverName, (String)j2eeappName, (String)beanName);
        StatefulSessionBean ssBeanMBean = new StatefulSessionBean(ssBeanON, jsf, this.__getjmxService());
        try {
            this.__getjmxService().registerModelMBean((Object)ssBeanMBean, ssBeanON);
        }
        catch (Exception e) {
            logger.log(BasicLevel.WARN, (Object)("Could not register StatefulSessionBean MBean for " + beanName), (Throwable)e);
            return null;
        }
        return ssBeanON;
    }

    private String registerStatelessSessionBeanMBean(String string, String string2, String string3, String string4, String string5, JStatelessFactory jStatelessFactory) {
        String string6;
        if (!this.__MregisterStatelessSessionBeanMBean$java_lang_String$java_lang_String$java_lang_String$java_lang_String$java_lang_String$org_ow2_jonas_lib_ejb21_JStatelessFactory) {
            return this.__registerStatelessSessionBeanMBean(string, string2, string3, string4, string5, jStatelessFactory);
        }
        try {
            this.__IM.onEntry((Object)this, "registerStatelessSessionBeanMBean$java_lang_String$java_lang_String$java_lang_String$java_lang_String$java_lang_String$org_ow2_jonas_lib_ejb21_JStatelessFactory", new Object[]{string, string2, string3, string4, string5, jStatelessFactory});
            string6 = this.__registerStatelessSessionBeanMBean(string, string2, string3, string4, string5, jStatelessFactory);
            this.__IM.onExit((Object)this, "registerStatelessSessionBeanMBean$java_lang_String$java_lang_String$java_lang_String$java_lang_String$java_lang_String$org_ow2_jonas_lib_ejb21_JStatelessFactory", (Object)string6);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "registerStatelessSessionBeanMBean$java_lang_String$java_lang_String$java_lang_String$java_lang_String$java_lang_String$org_ow2_jonas_lib_ejb21_JStatelessFactory", throwable);
            throw throwable;
        }
        return string6;
    }

    private String __registerStatelessSessionBeanMBean(String domainName, String serverName, String j2eeappName, String moduleName, String beanName, JStatelessFactory jsf) {
        String ssBeanON = J2eeObjectName.getStatelessSessionBeanName((String)domainName, (String)moduleName, (String)serverName, (String)j2eeappName, (String)beanName);
        StatelessSessionBean ssBeanMBean = new StatelessSessionBean(ssBeanON, jsf, this.__getjmxService());
        try {
            this.__getjmxService().registerModelMBean((Object)ssBeanMBean, ssBeanON);
        }
        catch (Exception e) {
            logger.log(BasicLevel.WARN, (Object)("Could not register StatelessSessionBean MBean" + beanName), (Throwable)e);
            return null;
        }
        return ssBeanON;
    }

    private String registerMdbBeanMBean(String string, String string2, String string3, String string4, String string5, JFactory jFactory) {
        String string6;
        if (!this.__MregisterMdbBeanMBean$java_lang_String$java_lang_String$java_lang_String$java_lang_String$java_lang_String$org_ow2_jonas_lib_ejb21_JFactory) {
            return this.__registerMdbBeanMBean(string, string2, string3, string4, string5, jFactory);
        }
        try {
            this.__IM.onEntry((Object)this, "registerMdbBeanMBean$java_lang_String$java_lang_String$java_lang_String$java_lang_String$java_lang_String$org_ow2_jonas_lib_ejb21_JFactory", new Object[]{string, string2, string3, string4, string5, jFactory});
            string6 = this.__registerMdbBeanMBean(string, string2, string3, string4, string5, jFactory);
            this.__IM.onExit((Object)this, "registerMdbBeanMBean$java_lang_String$java_lang_String$java_lang_String$java_lang_String$java_lang_String$org_ow2_jonas_lib_ejb21_JFactory", (Object)string6);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "registerMdbBeanMBean$java_lang_String$java_lang_String$java_lang_String$java_lang_String$java_lang_String$org_ow2_jonas_lib_ejb21_JFactory", throwable);
            throw throwable;
        }
        return string6;
    }

    private String __registerMdbBeanMBean(String domainName, String serverName, String j2eeappName, String moduleName, String beanName, JFactory jsf) {
        String mdbBeanON = J2eeObjectName.getMessageDrivenBeanName((String)domainName, (String)moduleName, (String)serverName, (String)j2eeappName, (String)beanName);
        MessageDrivenBean mdbBeanMBean = new MessageDrivenBean(mdbBeanON, jsf, this.__getjmxService());
        try {
            this.__getjmxService().registerModelMBean((Object)mdbBeanMBean, mdbBeanON);
        }
        catch (Exception e) {
            logger.log(BasicLevel.WARN, (Object)("Could not register MessageDrivenBean MBean" + beanName), (Throwable)e);
            return null;
        }
        return mdbBeanON;
    }

    private String registerCompMBeans(String string, String string2, String string3, String string4, JContainer jContainer, String string5, URL uRL, DeploymentDesc deploymentDesc, Map<String, BeanFactory> map, Map<String, BeanDesc> map2) {
        String string6;
        if (!this.__MregisterCompMBeans$java_lang_String$java_lang_String$java_lang_String$java_lang_String$org_ow2_jonas_lib_ejb21_JContainer$java_lang_String$java_net_URL$org_ow2_jonas_deployment_ejb_DeploymentDesc$java_util_Map$java_util_Map) {
            return this.__registerCompMBeans(string, string2, string3, string4, jContainer, string5, uRL, deploymentDesc, map, map2);
        }
        try {
            this.__IM.onEntry((Object)this, "registerCompMBeans$java_lang_String$java_lang_String$java_lang_String$java_lang_String$org_ow2_jonas_lib_ejb21_JContainer$java_lang_String$java_net_URL$org_ow2_jonas_deployment_ejb_DeploymentDesc$java_util_Map$java_util_Map", new Object[]{string, string2, string3, string4, jContainer, string5, uRL, deploymentDesc, map, map2});
            string6 = this.__registerCompMBeans(string, string2, string3, string4, jContainer, string5, uRL, deploymentDesc, map, map2);
            this.__IM.onExit((Object)this, "registerCompMBeans$java_lang_String$java_lang_String$java_lang_String$java_lang_String$org_ow2_jonas_lib_ejb21_JContainer$java_lang_String$java_net_URL$org_ow2_jonas_deployment_ejb_DeploymentDesc$java_util_Map$java_util_Map", (Object)string6);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "registerCompMBeans$java_lang_String$java_lang_String$java_lang_String$java_lang_String$org_ow2_jonas_lib_ejb21_JContainer$java_lang_String$java_net_URL$org_ow2_jonas_deployment_ejb_DeploymentDesc$java_util_Map$java_util_Map", throwable);
            throw throwable;
        }
        return string6;
    }

    private String __registerCompMBeans(String domainName, String serverName, String j2eeappName, String moduleName, JContainer container, String fileName, URL earUrl, DeploymentDesc dd, Map<String, BeanFactory> factoryMap, Map<String, BeanDesc> beanDescMap) {
        EJBModule ejbModuleMBean = this.registerEJBModuleMBean(domainName, serverName, j2eeappName, moduleName, container, fileName, earUrl);
        String ejbModuleON = J2eeObjectName.getEJBModuleName((String)domainName, (String)serverName, (String)j2eeappName, (String)moduleName);
        ejbModuleMBean.setDeploymentDescriptor(dd.getXmlContent());
        ejbModuleMBean.setJonasDeploymentDescriptor(dd.getJOnASXmlContent());
        for (String beanName : factoryMap.keySet()) {
            String beanON = null;
            BeanFactory bf = factoryMap.get(beanName);
            BeanDesc beanDesc = beanDescMap.get(beanName);
            if (beanDesc instanceof EntityBmpDesc) {
                beanON = this.registerEntityBeanMBean(domainName, serverName, j2eeappName, moduleName, beanName, (JEntityFactory)bf, BMP);
            } else if (beanDesc instanceof EntityCmpDesc) {
                beanON = this.registerEntityBeanMBean(domainName, serverName, j2eeappName, moduleName, beanName, (JEntityFactory)bf, CMP);
            } else if (beanDesc instanceof SessionStatefulDesc) {
                beanON = this.registerStatefulSessionBeanMBean(domainName, serverName, j2eeappName, moduleName, beanName, (JSessionFactory)bf);
            } else if (beanDesc instanceof SessionStatelessDesc) {
                beanON = this.registerStatelessSessionBeanMBean(domainName, serverName, j2eeappName, moduleName, beanName, (JStatelessFactory)bf);
            } else if (beanDesc instanceof MessageDrivenDesc) {
                beanON = this.registerMdbBeanMBean(domainName, serverName, j2eeappName, moduleName, beanName, (JFactory)bf);
            }
            ejbModuleMBean.addEjb(beanON);
        }
        return ejbModuleON;
    }

    private void unregisterCompMBeans(String string, String string2, String string3, String string4) {
        if (!this.__MunregisterCompMBeans$java_lang_String$java_lang_String$java_lang_String$java_lang_String) {
            this.__unregisterCompMBeans(string, string2, string3, string4);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "unregisterCompMBeans$java_lang_String$java_lang_String$java_lang_String$java_lang_String", new Object[]{string, string2, string3, string4});
            this.__unregisterCompMBeans(string, string2, string3, string4);
            this.__IM.onExit((Object)this, "unregisterCompMBeans$java_lang_String$java_lang_String$java_lang_String$java_lang_String", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "unregisterCompMBeans$java_lang_String$java_lang_String$java_lang_String$java_lang_String", throwable);
            throw throwable;
        }
    }

    private void __unregisterCompMBeans(String domainName, String serverName, String j2eeappName, String moduleName) {
        if (this.__getjmxService() != null) {
            ObjectName onEjbModule = J2eeObjectName.getEJBModule((String)domainName, (String)serverName, (String)j2eeappName, (String)moduleName);
            MBeanServer mbeanServer = this.__getjmxService().getJmxServer();
            ObjectName onEjb = null;
            try {
                String[] onEjbs = (String[])mbeanServer.getAttribute(onEjbModule, "ejbs");
                for (int i = 0; i < onEjbs.length; ++i) {
                    onEjb = new ObjectName(onEjbs[i]);
                    this.__getjmxService().unregisterModelMBean(onEjb);
                }
            }
            catch (Exception e) {
                logger.log(BasicLevel.ERROR, (Object)("Could not unregister MBean " + onEjb.toString()), (Throwable)e);
            }
            this.__getjmxService().unregisterModelMBean(onEjbModule);
        }
    }

    private void callGenic(String string, String[] stringArray) {
        if (!this.__McallGenic$java_lang_String$java_lang_String__) {
            this.__callGenic(string, stringArray);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "callGenic$java_lang_String$java_lang_String__", new Object[]{string, stringArray});
            this.__callGenic(string, stringArray);
            this.__IM.onExit((Object)this, "callGenic$java_lang_String$java_lang_String__", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "callGenic$java_lang_String$java_lang_String__", throwable);
            throw throwable;
        }
    }

    private void __callGenic(String jarPath, String[] genicArgs) {
        String[] args;
        if (genicArgs != null) {
            args = new String[genicArgs.length + 1];
            for (int i = 0; i < genicArgs.length; ++i) {
                args[i] = genicArgs[i];
            }
            args[genicArgs.length] = jarPath;
        } else {
            args = new String[]{jarPath};
        }
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)("Calling GenIC with arguments :" + Arrays.asList(args)));
        }
        GenicServiceWrapper.callGenic((String[])args);
    }

    public void setJmxService(JmxService jmxService) {
        if (!this.__MsetJmxService$org_ow2_jonas_jmx_JmxService) {
            this.__setJmxService(jmxService);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "setJmxService$org_ow2_jonas_jmx_JmxService", new Object[]{jmxService});
            this.__setJmxService(jmxService);
            this.__IM.onExit((Object)this, "setJmxService$org_ow2_jonas_jmx_JmxService", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "setJmxService$org_ow2_jonas_jmx_JmxService", throwable);
            throw throwable;
        }
    }

    private void __setJmxService(JmxService jmxService) {
        this.__setjmxService(jmxService);
    }

    public void setSecurityService(SecurityService securityService) {
        if (!this.__MsetSecurityService$org_ow2_jonas_security_SecurityService) {
            this.__setSecurityService(securityService);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "setSecurityService$org_ow2_jonas_security_SecurityService", new Object[]{securityService});
            this.__setSecurityService(securityService);
            this.__IM.onExit((Object)this, "setSecurityService$org_ow2_jonas_security_SecurityService", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "setSecurityService$org_ow2_jonas_security_SecurityService", throwable);
            throw throwable;
        }
    }

    private void __setSecurityService(SecurityService securityService) {
        this.__setsecurityService(securityService);
    }

    public void setTransactionService(TransactionService transactionService) {
        if (!this.__MsetTransactionService$org_ow2_jonas_tm_TransactionService) {
            this.__setTransactionService(transactionService);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "setTransactionService$org_ow2_jonas_tm_TransactionService", new Object[]{transactionService});
            this.__setTransactionService(transactionService);
            this.__IM.onExit((Object)this, "setTransactionService$org_ow2_jonas_tm_TransactionService", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "setTransactionService$org_ow2_jonas_tm_TransactionService", throwable);
            throw throwable;
        }
    }

    private void __setTransactionService(TransactionService transactionService) {
        this.__settransactionService(transactionService);
    }

    public void setWorkManagerService(WorkManagerService workManagerService) {
        if (!this.__MsetWorkManagerService$org_ow2_jonas_workmanager_WorkManagerService) {
            this.__setWorkManagerService(workManagerService);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "setWorkManagerService$org_ow2_jonas_workmanager_WorkManagerService", new Object[]{workManagerService});
            this.__setWorkManagerService(workManagerService);
            this.__IM.onExit((Object)this, "setWorkManagerService$org_ow2_jonas_workmanager_WorkManagerService", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "setWorkManagerService$org_ow2_jonas_workmanager_WorkManagerService", throwable);
            throw throwable;
        }
    }

    private void __setWorkManagerService(WorkManagerService workManagerService) {
        this.__setworkManagerService(workManagerService);
    }

    public void setWebServicesService(WebServicesService webServicesService) {
        if (!this.__MsetWebServicesService$org_ow2_jonas_ws_WebServicesService) {
            this.__setWebServicesService(webServicesService);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "setWebServicesService$org_ow2_jonas_ws_WebServicesService", new Object[]{webServicesService});
            this.__setWebServicesService(webServicesService);
            this.__IM.onExit((Object)this, "setWebServicesService$org_ow2_jonas_ws_WebServicesService", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "setWebServicesService$org_ow2_jonas_ws_WebServicesService", throwable);
            throw throwable;
        }
    }

    private void __setWebServicesService(WebServicesService webServicesService) {
        this.__setwsService(webServicesService);
    }

    public void setNaming(JNamingManager jNamingManager) {
        if (!this.__MsetNaming$org_ow2_jonas_naming_JNamingManager) {
            this.__setNaming(jNamingManager);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "setNaming$org_ow2_jonas_naming_JNamingManager", new Object[]{jNamingManager});
            this.__setNaming(jNamingManager);
            this.__IM.onExit((Object)this, "setNaming$org_ow2_jonas_naming_JNamingManager", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "setNaming$org_ow2_jonas_naming_JNamingManager", throwable);
            throw throwable;
        }
    }

    private void __setNaming(JNamingManager naming) {
        this.__setnaming(naming);
    }

    public void setComponentContextFactory(JComponentContextFactory jComponentContextFactory) {
        if (!this.__MsetComponentContextFactory$org_ow2_jonas_naming_JComponentContextFactory) {
            this.__setComponentContextFactory(jComponentContextFactory);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "setComponentContextFactory$org_ow2_jonas_naming_JComponentContextFactory", new Object[]{jComponentContextFactory});
            this.__setComponentContextFactory(jComponentContextFactory);
            this.__IM.onExit((Object)this, "setComponentContextFactory$org_ow2_jonas_naming_JComponentContextFactory", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "setComponentContextFactory$org_ow2_jonas_naming_JComponentContextFactory", throwable);
            throw throwable;
        }
    }

    private void __setComponentContextFactory(JComponentContextFactory componentContextFactory) {
        this.__setcomponentContextFactory(componentContextFactory);
    }

    public void setRegistry(RegistryService registryService) {
        if (!this.__MsetRegistry$org_ow2_jonas_registry_RegistryService) {
            this.__setRegistry(registryService);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "setRegistry$org_ow2_jonas_registry_RegistryService", new Object[]{registryService});
            this.__setRegistry(registryService);
            this.__IM.onExit((Object)this, "setRegistry$org_ow2_jonas_registry_RegistryService", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "setRegistry$org_ow2_jonas_registry_RegistryService", throwable);
            throw throwable;
        }
    }

    private void __setRegistry(RegistryService registry) {
        this.__setregistryService(registry);
    }

    public void setHaService(HaService haService) {
        if (!this.__MsetHaService$org_ow2_jonas_ha_HaService) {
            this.__setHaService(haService);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "setHaService$org_ow2_jonas_ha_HaService", new Object[]{haService});
            this.__setHaService(haService);
            this.__IM.onExit((Object)this, "setHaService$org_ow2_jonas_ha_HaService", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "setHaService$org_ow2_jonas_ha_HaService", throwable);
            throw throwable;
        }
    }

    private void __setHaService(HaService haService) {
        this.__sethaService(haService);
    }

    public void setResourceService(ResourceService resourceService) {
        if (!this.__MsetResourceService$org_ow2_jonas_resource_ResourceService) {
            this.__setResourceService(resourceService);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "setResourceService$org_ow2_jonas_resource_ResourceService", new Object[]{resourceService});
            this.__setResourceService(resourceService);
            this.__IM.onExit((Object)this, "setResourceService$org_ow2_jonas_resource_ResourceService", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "setResourceService$org_ow2_jonas_resource_ResourceService", throwable);
            throw throwable;
        }
    }

    private void __setResourceService(ResourceService resService) {
        this.__setresService(resService);
    }

    public CmiService getCmiService() {
        CmiService cmiService;
        if (!this.__MgetCmiService) {
            return this.__getCmiService();
        }
        try {
            this.__IM.onEntry((Object)this, "getCmiService", new Object[0]);
            cmiService = this.__getCmiService();
            this.__IM.onExit((Object)this, "getCmiService", (Object)cmiService);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "getCmiService", throwable);
            throw throwable;
        }
        return cmiService;
    }

    private CmiService __getCmiService() {
        return this.__getcmiService();
    }

    public void setCmiService(CmiService cmiService) {
        if (!this.__MsetCmiService$org_ow2_jonas_cmi_CmiService) {
            this.__setCmiService(cmiService);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "setCmiService$org_ow2_jonas_cmi_CmiService", new Object[]{cmiService});
            this.__setCmiService(cmiService);
            this.__IM.onExit((Object)this, "setCmiService$org_ow2_jonas_cmi_CmiService", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "setCmiService$org_ow2_jonas_cmi_CmiService", throwable);
            throw throwable;
        }
    }

    private void __setCmiService(CmiService cmiService) {
        this.__setcmiService(cmiService);
    }

    public void setDeployerManager(IDeployerManager iDeployerManager) {
        if (!this.__MsetDeployerManager$org_ow2_util_ee_deploy_api_deployer_IDeployerManager) {
            this.__setDeployerManager(iDeployerManager);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "setDeployerManager$org_ow2_util_ee_deploy_api_deployer_IDeployerManager", new Object[]{iDeployerManager});
            this.__setDeployerManager(iDeployerManager);
            this.__IM.onExit((Object)this, "setDeployerManager$org_ow2_util_ee_deploy_api_deployer_IDeployerManager", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "setDeployerManager$org_ow2_util_ee_deploy_api_deployer_IDeployerManager", throwable);
            throw throwable;
        }
    }

    private void __setDeployerManager(IDeployerManager deployerManager) {
        this.__setdeployerManager(deployerManager);
    }

    public void setVersioningService(VersioningService versioningService) {
        if (!this.__MsetVersioningService$org_ow2_jonas_versioning_VersioningService) {
            this.__setVersioningService(versioningService);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "setVersioningService$org_ow2_jonas_versioning_VersioningService", new Object[]{versioningService});
            this.__setVersioningService(versioningService);
            this.__IM.onExit((Object)this, "setVersioningService$org_ow2_jonas_versioning_VersioningService", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "setVersioningService$org_ow2_jonas_versioning_VersioningService", throwable);
            throw throwable;
        }
    }

    private void __setVersioningService(VersioningService versioningService) {
        this.__setversioningService(versioningService);
    }

    public void unsetVersioningService() {
        if (!this.__MunsetVersioningService) {
            this.__unsetVersioningService();
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "unsetVersioningService", new Object[0]);
            this.__unsetVersioningService();
            this.__IM.onExit((Object)this, "unsetVersioningService", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "unsetVersioningService", throwable);
            throw throwable;
        }
    }

    private void __unsetVersioningService() {
        this.__setversioningService(null);
    }

    public VersioningService getVersioningService() {
        VersioningService versioningService;
        if (!this.__MgetVersioningService) {
            return this.__getVersioningService();
        }
        try {
            this.__IM.onEntry((Object)this, "getVersioningService", new Object[0]);
            versioningService = this.__getVersioningService();
            this.__IM.onExit((Object)this, "getVersioningService", (Object)versioningService);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "getVersioningService", throwable);
            throw throwable;
        }
        return versioningService;
    }

    private VersioningService __getVersioningService() {
        return this.__getversioningService();
    }

    public boolean isVersioningEnabled() {
        boolean bl;
        if (!this.__MisVersioningEnabled) {
            return this.__isVersioningEnabled();
        }
        try {
            this.__IM.onEntry((Object)this, "isVersioningEnabled", new Object[0]);
            bl = this.__isVersioningEnabled();
            this.__IM.onExit((Object)this, "isVersioningEnabled", (Object)new Boolean(bl));
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "isVersioningEnabled", throwable);
            throw throwable;
        }
        return bl;
    }

    private boolean __isVersioningEnabled() {
        return this.__getversioningService() != null && this.__getversioningService().isVersioningEnabled();
    }

    @Override
    public boolean getMonitoringEnabled() {
        boolean bl;
        if (!this.__MgetMonitoringEnabled) {
            return this.__getMonitoringEnabled();
        }
        try {
            this.__IM.onEntry((Object)this, "getMonitoringEnabled", new Object[0]);
            bl = this.__getMonitoringEnabled();
            this.__IM.onExit((Object)this, "getMonitoringEnabled", (Object)new Boolean(bl));
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "getMonitoringEnabled", throwable);
            throw throwable;
        }
        return bl;
    }

    private boolean __getMonitoringEnabled() {
        return this.__getmonitoringEnabled();
    }

    @Override
    public void setMonitoringEnabled(boolean bl) {
        if (!this.__MsetMonitoringEnabled$boolean) {
            this.__setMonitoringEnabled(bl);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "setMonitoringEnabled$boolean", new Object[]{new Boolean(bl)});
            this.__setMonitoringEnabled(bl);
            this.__IM.onExit((Object)this, "setMonitoringEnabled$boolean", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "setMonitoringEnabled$boolean", throwable);
            throw throwable;
        }
    }

    private void __setMonitoringEnabled(boolean monitoringEnabled) {
        this.__setmonitoringEnabled(monitoringEnabled);
    }

    @Override
    public int getWarningThreshold() {
        int n;
        if (!this.__MgetWarningThreshold) {
            return this.__getWarningThreshold();
        }
        try {
            this.__IM.onEntry((Object)this, "getWarningThreshold", new Object[0]);
            n = this.__getWarningThreshold();
            this.__IM.onExit((Object)this, "getWarningThreshold", (Object)new Integer(n));
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "getWarningThreshold", throwable);
            throw throwable;
        }
        return n;
    }

    private int __getWarningThreshold() {
        return this.__getwarningThreshold();
    }

    @Override
    public void setWarningThreshold(int n) {
        if (!this.__MsetWarningThreshold$int) {
            this.__setWarningThreshold(n);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "setWarningThreshold$int", new Object[]{new Integer(n)});
            this.__setWarningThreshold(n);
            this.__IM.onExit((Object)this, "setWarningThreshold$int", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "setWarningThreshold$int", throwable);
            throw throwable;
        }
    }

    private void __setWarningThreshold(int warningThreshold) {
        if (warningThreshold < 0) {
            throw new IllegalArgumentException("warningThreshold must be positive or 0");
        }
        this.__setwarningThreshold(warningThreshold);
    }

    @Override
    public int getNumberOfCalls() {
        int n;
        if (!this.__MgetNumberOfCalls) {
            return this.__getNumberOfCalls();
        }
        try {
            this.__IM.onEntry((Object)this, "getNumberOfCalls", new Object[0]);
            n = this.__getNumberOfCalls();
            this.__IM.onExit((Object)this, "getNumberOfCalls", (Object)new Integer(n));
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "getNumberOfCalls", throwable);
            throw throwable;
        }
        return n;
    }

    private int __getNumberOfCalls() {
        int numberOfCalls = 0;
        try {
            for (ObjectName on : this.__getjmxService().getJmxServer().queryNames(new ObjectName(this.getDomainName() + ":j2eeType=StatefulSessionBean,*"), null)) {
                try {
                    numberOfCalls += ((Integer)this.__getjmxService().getJmxServer().getAttribute(on, "numberOfCalls")).intValue();
                }
                catch (AttributeNotFoundException ignored) {}
            }
            for (ObjectName on : this.__getjmxService().getJmxServer().queryNames(new ObjectName(this.getDomainName() + ":j2eeType=StatelessSessionBean,*"), null)) {
                try {
                    numberOfCalls += ((Integer)this.__getjmxService().getJmxServer().getAttribute(on, "numberOfCalls")).intValue();
                }
                catch (AttributeNotFoundException ignored) {}
            }
        }
        catch (Exception e) {
            logger.log(BasicLevel.INFO, (Object)"Failed getting attribute 'numberOfCalls'", (Throwable)e);
        }
        return numberOfCalls;
    }

    @Override
    public long getTotalProcessingTime() {
        long l;
        if (!this.__MgetTotalProcessingTime) {
            return this.__getTotalProcessingTime();
        }
        try {
            this.__IM.onEntry((Object)this, "getTotalProcessingTime", new Object[0]);
            l = this.__getTotalProcessingTime();
            this.__IM.onExit((Object)this, "getTotalProcessingTime", (Object)new Long(l));
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "getTotalProcessingTime", throwable);
            throw throwable;
        }
        return l;
    }

    private long __getTotalProcessingTime() {
        long totalProcessingTime = 0L;
        try {
            for (ObjectName on : this.__getjmxService().getJmxServer().queryNames(new ObjectName(this.getDomainName() + ":j2eeType=StatefulSessionBean,*"), null)) {
                try {
                    totalProcessingTime += ((Long)this.__getjmxService().getJmxServer().getAttribute(on, "totalProcessingTime")).longValue();
                }
                catch (AttributeNotFoundException ignored) {}
            }
            for (ObjectName on : this.__getjmxService().getJmxServer().queryNames(new ObjectName(this.getDomainName() + ":j2eeType=StatelessSessionBean,*"), null)) {
                try {
                    totalProcessingTime += ((Long)this.__getjmxService().getJmxServer().getAttribute(on, "totalProcessingTime")).longValue();
                }
                catch (AttributeNotFoundException ignored) {}
            }
        }
        catch (Exception e) {
            logger.log(BasicLevel.INFO, (Object)"Failed getting attribute 'totalProcessingTime'", (Throwable)e);
        }
        return totalProcessingTime;
    }

    @Override
    public long getTotalBusinessProcessingTime() {
        long l;
        if (!this.__MgetTotalBusinessProcessingTime) {
            return this.__getTotalBusinessProcessingTime();
        }
        try {
            this.__IM.onEntry((Object)this, "getTotalBusinessProcessingTime", new Object[0]);
            l = this.__getTotalBusinessProcessingTime();
            this.__IM.onExit((Object)this, "getTotalBusinessProcessingTime", (Object)new Long(l));
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "getTotalBusinessProcessingTime", throwable);
            throw throwable;
        }
        return l;
    }

    private long __getTotalBusinessProcessingTime() {
        long totalBusinessProcessingTime = 0L;
        try {
            for (ObjectName on : this.__getjmxService().getJmxServer().queryNames(new ObjectName(this.getDomainName() + ":j2eeType=StatefulSessionBean,*"), null)) {
                try {
                    totalBusinessProcessingTime += ((Long)this.__getjmxService().getJmxServer().getAttribute(on, "totalBusinessProcessingTime")).longValue();
                }
                catch (AttributeNotFoundException ignored) {}
            }
            for (ObjectName on : this.__getjmxService().getJmxServer().queryNames(new ObjectName(this.getDomainName() + ":j2eeType=StatelessSessionBean,*"), null)) {
                try {
                    totalBusinessProcessingTime += ((Long)this.__getjmxService().getJmxServer().getAttribute(on, "totalBusinessProcessingTime")).longValue();
                }
                catch (AttributeNotFoundException ignored) {}
            }
        }
        catch (Exception e) {
            logger.log(BasicLevel.INFO, (Object)"Failed getting attribute 'totalBusinessProcessingTime'", (Throwable)e);
        }
        return totalBusinessProcessingTime;
    }

    @Override
    public long getAverageProcessingTime() {
        long l;
        if (!this.__MgetAverageProcessingTime) {
            return this.__getAverageProcessingTime();
        }
        try {
            this.__IM.onEntry((Object)this, "getAverageProcessingTime", new Object[0]);
            l = this.__getAverageProcessingTime();
            this.__IM.onExit((Object)this, "getAverageProcessingTime", (Object)new Long(l));
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "getAverageProcessingTime", throwable);
            throw throwable;
        }
        return l;
    }

    private long __getAverageProcessingTime() {
        if (this.getNumberOfCalls() > 0) {
            return this.getTotalProcessingTime() / (long)this.getNumberOfCalls();
        }
        return 0L;
    }

    @Override
    public long getAverageBusinessProcessingTime() {
        long l;
        if (!this.__MgetAverageBusinessProcessingTime) {
            return this.__getAverageBusinessProcessingTime();
        }
        try {
            this.__IM.onEntry((Object)this, "getAverageBusinessProcessingTime", new Object[0]);
            l = this.__getAverageBusinessProcessingTime();
            this.__IM.onExit((Object)this, "getAverageBusinessProcessingTime", (Object)new Long(l));
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "getAverageBusinessProcessingTime", throwable);
            throw throwable;
        }
        return l;
    }

    private long __getAverageBusinessProcessingTime() {
        if (this.getNumberOfCalls() > 0) {
            return this.getTotalBusinessProcessingTime() / (long)this.getNumberOfCalls();
        }
        return 0L;
    }

    @Override
    public void applyMonitorSettings(String string) {
        if (!this.__MapplyMonitorSettings$java_lang_String) {
            this.__applyMonitorSettings(string);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "applyMonitorSettings$java_lang_String", new Object[]{string});
            this.__applyMonitorSettings(string);
            this.__IM.onExit((Object)this, "applyMonitorSettings$java_lang_String", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "applyMonitorSettings$java_lang_String", throwable);
            throw throwable;
        }
    }

    private void __applyMonitorSettings(String scope) {
        Attribute monitoringEnabled = new Attribute("monitoringEnabled", new Boolean(this.__getmonitoringEnabled()));
        Attribute warningThreshold = new Attribute("warningThreshold", new Integer(this.__getwarningThreshold()));
        try {
            if ("all".equals(scope)) {
                for (ObjectName on : this.__getjmxService().getJmxServer().queryNames(new ObjectName(this.getDomainName() + ":j2eeType=StatefulSessionBean,*"), null)) {
                    this.__getjmxService().getJmxServer().setAttribute(on, monitoringEnabled);
                    this.__getjmxService().getJmxServer().setAttribute(on, warningThreshold);
                }
                for (ObjectName on : this.__getjmxService().getJmxServer().queryNames(new ObjectName(this.getDomainName() + ":j2eeType=StatelessSessionBean,*"), null)) {
                    this.__getjmxService().getJmxServer().setAttribute(on, monitoringEnabled);
                    this.__getjmxService().getJmxServer().setAttribute(on, warningThreshold);
                }
            } else if ("nonDD".equals(scope)) {
                for (ObjectName on : this.__getjmxService().getJmxServer().queryNames(new ObjectName(this.getDomainName() + ":j2eeType=StatefulSessionBean,*"), null)) {
                    try {
                        if (((Boolean)this.__getjmxService().getJmxServer().getAttribute(on, "monitoringSettingsDefinedInDD")).booleanValue()) continue;
                        this.__getjmxService().getJmxServer().setAttribute(on, monitoringEnabled);
                        this.__getjmxService().getJmxServer().setAttribute(on, warningThreshold);
                    }
                    catch (AttributeNotFoundException ignored) {}
                }
                for (ObjectName on : this.__getjmxService().getJmxServer().queryNames(new ObjectName(this.getDomainName() + ":j2eeType=StatelessSessionBean,*"), null)) {
                    try {
                        if (((Boolean)this.__getjmxService().getJmxServer().getAttribute(on, "monitoringSettingsDefinedInDD")).booleanValue()) continue;
                        this.__getjmxService().getJmxServer().setAttribute(on, monitoringEnabled);
                        this.__getjmxService().getJmxServer().setAttribute(on, warningThreshold);
                    }
                    catch (AttributeNotFoundException ignored) {}
                }
            }
        }
        catch (Exception e) {
            logger.log(BasicLevel.INFO, (Object)("Cannot apply monitor settings: " + e.getMessage()), (Throwable)e);
        }
    }

    public void setEventService(IEventService iEventService) {
        if (!this.__MsetEventService$org_ow2_util_event_api_IEventService) {
            this.__setEventService(iEventService);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "setEventService$org_ow2_util_event_api_IEventService", new Object[]{iEventService});
            this.__setEventService(iEventService);
            this.__IM.onExit((Object)this, "setEventService$org_ow2_util_event_api_IEventService", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "setEventService$org_ow2_util_event_api_IEventService", throwable);
            throw throwable;
        }
    }

    private void __setEventService(IEventService eventService) {
        this.__seteventService(eventService);
    }

    public IEventService getEventService() {
        IEventService iEventService;
        if (!this.__MgetEventService) {
            return this.__getEventService();
        }
        try {
            this.__IM.onEntry((Object)this, "getEventService", new Object[0]);
            iEventService = this.__getEventService();
            this.__IM.onExit((Object)this, "getEventService", (Object)iEventService);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "getEventService", throwable);
            throw throwable;
        }
        return iEventService;
    }

    private IEventService __getEventService() {
        return this.__geteventService();
    }

    private void _setInstanceManager(InstanceManager instanceManager) {
        if (instanceManager == null) {
            return;
        }
        this.__IM = instanceManager;
        Set set = this.__IM.getRegistredFields();
        if (set != null) {
            if (set.contains("transactionService")) {
                this.__FtransactionService = true;
            }
            if (set.contains("tm")) {
                this.__Ftm = true;
            }
            if (set.contains("monitoringEnabled")) {
                this.__FmonitoringEnabled = true;
            }
            if (set.contains("deployerManager")) {
                this.__FdeployerManager = true;
            }
            if (set.contains("ejb21Deployer")) {
                this.__Fejb21Deployer = true;
            }
            if (set.contains("autoGenICArgsList")) {
                this.__FautoGenICArgsList = true;
            }
            if (set.contains("registryService")) {
                this.__FregistryService = true;
            }
            if (set.contains("securityService")) {
                this.__FsecurityService = true;
            }
            if (set.contains("autoGenIC")) {
                this.__FautoGenIC = true;
            }
            if (set.contains("warningThreshold")) {
                this.__FwarningThreshold = true;
            }
            if (set.contains("eventService")) {
                this.__FeventService = true;
            }
            if (set.contains("deployerLog")) {
                this.__FdeployerLog = true;
            }
            if (set.contains("workManager")) {
                this.__FworkManager = true;
            }
            if (set.contains("monitoringDispatcher")) {
                this.__FmonitoringDispatcher = true;
            }
            if (set.contains("resService")) {
                this.__FresService = true;
            }
            if (set.contains("wsService")) {
                this.__FwsService = true;
            }
            if (set.contains("naming")) {
                this.__Fnaming = true;
            }
            if (set.contains("workEjbjarsFile")) {
                this.__FworkEjbjarsFile = true;
            }
            if (set.contains("containerLifecycleDispatcher")) {
                this.__FcontainerLifecycleDispatcher = true;
            }
            if (set.contains("haService")) {
                this.__FhaService = true;
            }
            if (set.contains("versioningService")) {
                this.__FversioningService = true;
            }
            if (set.contains("containers")) {
                this.__Fcontainers = true;
            }
            if (set.contains("extClassLoader")) {
                this.__FextClassLoader = true;
            }
            if (set.contains("componentContextFactory")) {
                this.__FcomponentContextFactory = true;
            }
            if (set.contains("cmiService")) {
                this.__FcmiService = true;
            }
            if (set.contains("beanMonitoringStatistics")) {
                this.__FbeanMonitoringStatistics = true;
            }
            if (set.contains("ejbNames")) {
                this.__FejbNames = true;
            }
            if (set.contains("jmxService")) {
                this.__FjmxService = true;
            }
            if (set.contains("workManagerService")) {
                this.__FworkManagerService = true;
            }
        }
        if ((set = this.__IM.getRegistredMethods()) != null) {
            if (set.contains("setAutoGenic$boolean")) {
                this.__MsetAutoGenic$boolean = true;
            }
            if (set.contains("setParsingwithvalidation$boolean")) {
                this.__MsetParsingwithvalidation$boolean = true;
            }
            if (set.contains("setAutoGenicArgs$java_lang_String")) {
                this.__MsetAutoGenicArgs$java_lang_String = true;
            }
            if (set.contains("doStart")) {
                this.__MdoStart = true;
            }
            if (set.contains("doStop")) {
                this.__MdoStop = true;
            }
            if (set.contains("initWorkingDirectory")) {
                this.__MinitWorkingDirectory = true;
            }
            if (set.contains("setWorkCleanerService$org_ow2_jonas_workcleaner_WorkCleanerService")) {
                this.__MsetWorkCleanerService$org_ow2_jonas_workcleaner_WorkCleanerService = true;
            }
            if (set.contains("createContainer$javax_naming_Context")) {
                this.__McreateContainer$javax_naming_Context = true;
            }
            if (set.contains("applyWSGenIfNeeded$java_lang_String")) {
                this.__MapplyWSGenIfNeeded$java_lang_String = true;
            }
            if (set.contains("getContainer$java_lang_String")) {
                this.__MgetContainer$java_lang_String = true;
            }
            if (set.contains("removeContainer$org_ow2_jonas_lib_ejb21_Container")) {
                this.__MremoveContainer$org_ow2_jonas_lib_ejb21_Container = true;
            }
            if (set.contains("listContainers")) {
                this.__MlistContainers = true;
            }
            if (set.contains("syncAllEntities$boolean")) {
                this.__MsyncAllEntities$boolean = true;
            }
            if (set.contains("getCurrentNumberOfContainer")) {
                this.__MgetCurrentNumberOfContainer = true;
            }
            if (set.contains("getTotalCurrentNumberOfBeanType")) {
                this.__MgetTotalCurrentNumberOfBeanType = true;
            }
            if (set.contains("getTotalCurrentNumberOfBMPType")) {
                this.__MgetTotalCurrentNumberOfBMPType = true;
            }
            if (set.contains("getTotalCurrentNumberOfCMPType")) {
                this.__MgetTotalCurrentNumberOfCMPType = true;
            }
            if (set.contains("getTotalCurrentNumberOfSBFType")) {
                this.__MgetTotalCurrentNumberOfSBFType = true;
            }
            if (set.contains("getTotalCurrentNumberOfSBLType")) {
                this.__MgetTotalCurrentNumberOfSBLType = true;
            }
            if (set.contains("getTotalCurrentNumberOfMDBType")) {
                this.__MgetTotalCurrentNumberOfMDBType = true;
            }
            if (set.contains("getDeployedJars")) {
                this.__MgetDeployedJars = true;
            }
            if (set.contains("removeContainer$java_lang_String")) {
                this.__MremoveContainer$java_lang_String = true;
            }
            if (set.contains("createContainer$java_lang_String")) {
                this.__McreateContainer$java_lang_String = true;
            }
            if (set.contains("isJarDeployed$java_lang_String")) {
                this.__MisJarDeployed$java_lang_String = true;
            }
            if (set.contains("isJarDeployedByWorkName$java_lang_String")) {
                this.__MisJarDeployedByWorkName$java_lang_String = true;
            }
            if (set.contains("getDependence$java_lang_String$int")) {
                this.__MgetDependence$java_lang_String$int = true;
            }
            if (set.contains("convertToObjectNames$java_util_Set")) {
                this.__MconvertToObjectNames$java_util_Set = true;
            }
            if (set.contains("getDataSourceDependence$java_lang_String")) {
                this.__MgetDataSourceDependence$java_lang_String = true;
            }
            if (set.contains("getJmsDestinationDependence$java_lang_String")) {
                this.__MgetJmsDestinationDependence$java_lang_String = true;
            }
            if (set.contains("getJmsConnectionFactoryDependence$java_lang_String")) {
                this.__MgetJmsConnectionFactoryDependence$java_lang_String = true;
            }
            if (set.contains("getMailFactoryDependence$java_lang_String")) {
                this.__MgetMailFactoryDependence$java_lang_String = true;
            }
            if (set.contains("deployJars$javax_naming_Context")) {
                this.__MdeployJars$javax_naming_Context = true;
            }
            if (set.contains("unDeployJars$java_net_URL__")) {
                this.__MunDeployJars$java_net_URL__ = true;
            }
            if (set.contains("removeContainer$org_ow2_jonas_lib_ejb21_Container$boolean")) {
                this.__MremoveContainer$org_ow2_jonas_lib_ejb21_Container$boolean = true;
            }
            if (set.contains("removeCache$java_lang_ClassLoader")) {
                this.__MremoveCache$java_lang_ClassLoader = true;
            }
            if (set.contains("isJarLoaded$java_lang_String")) {
                this.__MisJarLoaded$java_lang_String = true;
            }
            if (set.contains("checkGenIC$java_lang_String$java_net_URL__")) {
                this.__McheckGenIC$java_lang_String$java_net_URL__ = true;
            }
            if (set.contains("getContainerContextID$java_lang_String")) {
                this.__MgetContainerContextID$java_lang_String = true;
            }
            if (set.contains("getTimer$org_ow2_jonas_ejb2_JTimerHandleInfo")) {
                this.__MgetTimer$org_ow2_jonas_ejb2_JTimerHandleInfo = true;
            }
            if (set.contains("restartTimer$org_ow2_jonas_ejb2_JTimerHandleInfo")) {
                this.__MrestartTimer$org_ow2_jonas_ejb2_JTimerHandleInfo = true;
            }
            if (set.contains("getJTimerService$org_ow2_jonas_ejb2_JTimerHandleInfo")) {
                this.__MgetJTimerService$org_ow2_jonas_ejb2_JTimerHandleInfo = true;
            }
            if (set.contains("registerEjbServiceMBean$java_lang_Object$java_lang_String")) {
                this.__MregisterEjbServiceMBean$java_lang_Object$java_lang_String = true;
            }
            if (set.contains("unregisterEjbServiceMBean$java_lang_String")) {
                this.__MunregisterEjbServiceMBean$java_lang_String = true;
            }
            if (set.contains("registerEJBModuleMBean$java_lang_String$java_lang_String$java_lang_String$java_lang_String$org_ow2_jonas_lib_ejb21_JContainer$java_lang_String$java_net_URL")) {
                this.__MregisterEJBModuleMBean$java_lang_String$java_lang_String$java_lang_String$java_lang_String$org_ow2_jonas_lib_ejb21_JContainer$java_lang_String$java_net_URL = true;
            }
            if (set.contains("registerEntityBeanMBean$java_lang_String$java_lang_String$java_lang_String$java_lang_String$java_lang_String$org_ow2_jonas_lib_ejb21_JEntityFactory$java_lang_String")) {
                this.__MregisterEntityBeanMBean$java_lang_String$java_lang_String$java_lang_String$java_lang_String$java_lang_String$org_ow2_jonas_lib_ejb21_JEntityFactory$java_lang_String = true;
            }
            if (set.contains("registerStatefulSessionBeanMBean$java_lang_String$java_lang_String$java_lang_String$java_lang_String$java_lang_String$org_ow2_jonas_lib_ejb21_JSessionFactory")) {
                this.__MregisterStatefulSessionBeanMBean$java_lang_String$java_lang_String$java_lang_String$java_lang_String$java_lang_String$org_ow2_jonas_lib_ejb21_JSessionFactory = true;
            }
            if (set.contains("registerStatelessSessionBeanMBean$java_lang_String$java_lang_String$java_lang_String$java_lang_String$java_lang_String$org_ow2_jonas_lib_ejb21_JStatelessFactory")) {
                this.__MregisterStatelessSessionBeanMBean$java_lang_String$java_lang_String$java_lang_String$java_lang_String$java_lang_String$org_ow2_jonas_lib_ejb21_JStatelessFactory = true;
            }
            if (set.contains("registerMdbBeanMBean$java_lang_String$java_lang_String$java_lang_String$java_lang_String$java_lang_String$org_ow2_jonas_lib_ejb21_JFactory")) {
                this.__MregisterMdbBeanMBean$java_lang_String$java_lang_String$java_lang_String$java_lang_String$java_lang_String$org_ow2_jonas_lib_ejb21_JFactory = true;
            }
            if (set.contains("registerCompMBeans$java_lang_String$java_lang_String$java_lang_String$java_lang_String$org_ow2_jonas_lib_ejb21_JContainer$java_lang_String$java_net_URL$org_ow2_jonas_deployment_ejb_DeploymentDesc$java_util_Map$java_util_Map")) {
                this.__MregisterCompMBeans$java_lang_String$java_lang_String$java_lang_String$java_lang_String$org_ow2_jonas_lib_ejb21_JContainer$java_lang_String$java_net_URL$org_ow2_jonas_deployment_ejb_DeploymentDesc$java_util_Map$java_util_Map = true;
            }
            if (set.contains("unregisterCompMBeans$java_lang_String$java_lang_String$java_lang_String$java_lang_String")) {
                this.__MunregisterCompMBeans$java_lang_String$java_lang_String$java_lang_String$java_lang_String = true;
            }
            if (set.contains("callGenic$java_lang_String$java_lang_String__")) {
                this.__McallGenic$java_lang_String$java_lang_String__ = true;
            }
            if (set.contains("setJmxService$org_ow2_jonas_jmx_JmxService")) {
                this.__MsetJmxService$org_ow2_jonas_jmx_JmxService = true;
            }
            if (set.contains("setSecurityService$org_ow2_jonas_security_SecurityService")) {
                this.__MsetSecurityService$org_ow2_jonas_security_SecurityService = true;
            }
            if (set.contains("setTransactionService$org_ow2_jonas_tm_TransactionService")) {
                this.__MsetTransactionService$org_ow2_jonas_tm_TransactionService = true;
            }
            if (set.contains("setWorkManagerService$org_ow2_jonas_workmanager_WorkManagerService")) {
                this.__MsetWorkManagerService$org_ow2_jonas_workmanager_WorkManagerService = true;
            }
            if (set.contains("setWebServicesService$org_ow2_jonas_ws_WebServicesService")) {
                this.__MsetWebServicesService$org_ow2_jonas_ws_WebServicesService = true;
            }
            if (set.contains("setNaming$org_ow2_jonas_naming_JNamingManager")) {
                this.__MsetNaming$org_ow2_jonas_naming_JNamingManager = true;
            }
            if (set.contains("setComponentContextFactory$org_ow2_jonas_naming_JComponentContextFactory")) {
                this.__MsetComponentContextFactory$org_ow2_jonas_naming_JComponentContextFactory = true;
            }
            if (set.contains("setRegistry$org_ow2_jonas_registry_RegistryService")) {
                this.__MsetRegistry$org_ow2_jonas_registry_RegistryService = true;
            }
            if (set.contains("setHaService$org_ow2_jonas_ha_HaService")) {
                this.__MsetHaService$org_ow2_jonas_ha_HaService = true;
            }
            if (set.contains("setResourceService$org_ow2_jonas_resource_ResourceService")) {
                this.__MsetResourceService$org_ow2_jonas_resource_ResourceService = true;
            }
            if (set.contains("getCmiService")) {
                this.__MgetCmiService = true;
            }
            if (set.contains("setCmiService$org_ow2_jonas_cmi_CmiService")) {
                this.__MsetCmiService$org_ow2_jonas_cmi_CmiService = true;
            }
            if (set.contains("setDeployerManager$org_ow2_util_ee_deploy_api_deployer_IDeployerManager")) {
                this.__MsetDeployerManager$org_ow2_util_ee_deploy_api_deployer_IDeployerManager = true;
            }
            if (set.contains("setVersioningService$org_ow2_jonas_versioning_VersioningService")) {
                this.__MsetVersioningService$org_ow2_jonas_versioning_VersioningService = true;
            }
            if (set.contains("unsetVersioningService")) {
                this.__MunsetVersioningService = true;
            }
            if (set.contains("getVersioningService")) {
                this.__MgetVersioningService = true;
            }
            if (set.contains("isVersioningEnabled")) {
                this.__MisVersioningEnabled = true;
            }
            if (set.contains("getMonitoringEnabled")) {
                this.__MgetMonitoringEnabled = true;
            }
            if (set.contains("setMonitoringEnabled$boolean")) {
                this.__MsetMonitoringEnabled$boolean = true;
            }
            if (set.contains("getWarningThreshold")) {
                this.__MgetWarningThreshold = true;
            }
            if (set.contains("setWarningThreshold$int")) {
                this.__MsetWarningThreshold$int = true;
            }
            if (set.contains("getNumberOfCalls")) {
                this.__MgetNumberOfCalls = true;
            }
            if (set.contains("getTotalProcessingTime")) {
                this.__MgetTotalProcessingTime = true;
            }
            if (set.contains("getTotalBusinessProcessingTime")) {
                this.__MgetTotalBusinessProcessingTime = true;
            }
            if (set.contains("getAverageProcessingTime")) {
                this.__MgetAverageProcessingTime = true;
            }
            if (set.contains("getAverageBusinessProcessingTime")) {
                this.__MgetAverageBusinessProcessingTime = true;
            }
            if (set.contains("applyMonitorSettings$java_lang_String")) {
                this.__MapplyMonitorSettings$java_lang_String = true;
            }
            if (set.contains("setEventService$org_ow2_util_event_api_IEventService")) {
                this.__MsetEventService$org_ow2_util_event_api_IEventService = true;
            }
            if (set.contains("getEventService")) {
                this.__MgetEventService = true;
            }
        }
    }

    public ComponentInstance getComponentInstance() {
        return this.__IM;
    }

    private class BeanMonitoringStatistics {
        private int numberOfCalls;
        private long totalProcessingTime;
        private long totalBusinessProcessingTime;

        public BeanMonitoringStatistics(int numberOfCalls, long totalProcessingTime, long totalBusinessProcessingTime) {
            this.numberOfCalls = numberOfCalls;
            this.totalProcessingTime = totalProcessingTime;
            this.totalBusinessProcessingTime = totalBusinessProcessingTime;
        }

        public int getNumberOfCalls() {
            return this.numberOfCalls;
        }

        public long getTotalProcessingTime() {
            return this.totalProcessingTime;
        }

        public long getTotalBusinessProcessingTime() {
            return this.totalBusinessProcessingTime;
        }
    }
}

