/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ejb.packaging;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.persistence.PersistenceException;
import javax.persistence.spi.PersistenceUnitTransactionType;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.hibernate.cfg.EJB3DTDEntityResolver;
import org.hibernate.ejb.packaging.PersistenceMetadata;
import org.hibernate.ejb.packaging.XmlHelper;
import org.hibernate.ejb.util.ConfigurationHelper;
import org.hibernate.util.StringHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXParseException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class PersistenceXmlLoader {
    private static final Logger log = LoggerFactory.getLogger(PersistenceXmlLoader.class);

    private PersistenceXmlLoader() {
    }

    private static Document loadURL(URL configURL, EntityResolver resolver) throws Exception {
        InputStream is = null;
        if (configURL != null) {
            URLConnection conn = configURL.openConnection();
            conn.setUseCaches(false);
            is = conn.getInputStream();
        }
        if (is == null) {
            throw new IOException("Failed to obtain InputStream from url: " + configURL);
        }
        ArrayList errors = new ArrayList();
        DocumentBuilderFactory docBuilderFactory = null;
        docBuilderFactory = DocumentBuilderFactory.newInstance();
        docBuilderFactory.setValidating(true);
        docBuilderFactory.setNamespaceAware(true);
        try {
            docBuilderFactory.setAttribute("http://apache.org/xml/features/validation/schema", true);
        }
        catch (IllegalArgumentException e) {
            docBuilderFactory.setValidating(false);
            docBuilderFactory.setNamespaceAware(false);
        }
        InputSource source = new InputSource(is);
        DocumentBuilder docBuilder = docBuilderFactory.newDocumentBuilder();
        docBuilder.setEntityResolver(resolver);
        docBuilder.setErrorHandler(new ErrorLogger("XML InputStream", errors, resolver));
        Document doc = docBuilder.parse(source);
        if (errors.size() != 0) {
            throw new PersistenceException("invalid persistence.xml", (Throwable)errors.get(0));
        }
        return doc;
    }

    public static List<PersistenceMetadata> deploy(URL url, Map overrides, EntityResolver resolver) throws Exception {
        return PersistenceXmlLoader.deploy(url, overrides, resolver, PersistenceUnitTransactionType.JTA);
    }

    public static List<PersistenceMetadata> deploy(URL url, Map overrides, EntityResolver resolver, PersistenceUnitTransactionType defaultTransactionType) throws Exception {
        Document doc = PersistenceXmlLoader.loadURL(url, resolver);
        Element top = doc.getDocumentElement();
        NodeList children = top.getChildNodes();
        ArrayList<PersistenceMetadata> units = new ArrayList<PersistenceMetadata>();
        for (int i = 0; i < children.getLength(); ++i) {
            String dataSource;
            String transactionType;
            Element element;
            String tag;
            if (children.item(i).getNodeType() != 1 || !(tag = (element = (Element)children.item(i)).getTagName()).equals("persistence-unit")) continue;
            PersistenceMetadata metadata = PersistenceXmlLoader.parsePersistenceUnit(element);
            if (overrides.containsKey("javax.persistence.provider")) {
                String provider = (String)overrides.get("javax.persistence.provider");
                metadata.setProvider(provider);
            }
            if (overrides.containsKey("javax.persistence.transactionType")) {
                transactionType = (String)overrides.get("javax.persistence.transactionType");
                metadata.setTransactionType(PersistenceXmlLoader.getTransactionType(transactionType));
            }
            if (overrides.containsKey("javax.persistence.jtaDataSource")) {
                dataSource = (String)overrides.get("javax.persistence.jtaDataSource");
                metadata.setJtaDatasource(dataSource);
            }
            if (overrides.containsKey("javax.persistence.nonJtaDataSource")) {
                dataSource = (String)overrides.get("javax.persistence.nonJtaDataSource");
                metadata.setNonJtaDatasource(dataSource);
            }
            transactionType = metadata.getTransactionType();
            Boolean isJTA = null;
            if (StringHelper.isNotEmpty(metadata.getJtaDatasource())) {
                isJTA = Boolean.TRUE;
            } else if (StringHelper.isNotEmpty(metadata.getNonJtaDatasource())) {
                isJTA = Boolean.FALSE;
            }
            if (transactionType == null) {
                transactionType = isJTA == Boolean.TRUE ? PersistenceUnitTransactionType.JTA : (isJTA == Boolean.FALSE ? PersistenceUnitTransactionType.RESOURCE_LOCAL : defaultTransactionType);
            }
            metadata.setTransactionType((PersistenceUnitTransactionType)transactionType);
            Properties properties = metadata.getProps();
            ConfigurationHelper.overrideProperties(properties, overrides);
            units.add(metadata);
        }
        return units;
    }

    private static PersistenceMetadata parsePersistenceUnit(Element top) throws Exception {
        PersistenceMetadata metadata = new PersistenceMetadata();
        String puName = top.getAttribute("name");
        if (StringHelper.isNotEmpty(puName)) {
            log.trace("Persistent Unit name from persistence.xml: {}", (Object)puName);
            metadata.setName(puName);
        }
        NodeList children = top.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            if (children.item(i).getNodeType() != 1) continue;
            Element element = (Element)children.item(i);
            String tag = element.getTagName();
            if (tag.equals("non-jta-data-source")) {
                metadata.setNonJtaDatasource(XmlHelper.getElementContent(element));
                continue;
            }
            if (tag.equals("jta-data-source")) {
                metadata.setJtaDatasource(XmlHelper.getElementContent(element));
                continue;
            }
            if (tag.equals("provider")) {
                metadata.setProvider(XmlHelper.getElementContent(element));
                continue;
            }
            if (tag.equals("class")) {
                metadata.getClasses().add(XmlHelper.getElementContent(element));
                continue;
            }
            if (tag.equals("mapping-file")) {
                metadata.getMappingFiles().add(XmlHelper.getElementContent(element));
                continue;
            }
            if (tag.equals("jar-file")) {
                metadata.getJarFiles().add(XmlHelper.getElementContent(element));
                continue;
            }
            if (tag.equals("exclude-unlisted-classes")) {
                metadata.setExcludeUnlistedClasses(true);
                continue;
            }
            if (!tag.equals("properties")) continue;
            NodeList props = element.getChildNodes();
            for (int j = 0; j < props.getLength(); ++j) {
                Element propElement;
                if (props.item(j).getNodeType() != 1 || !"property".equals((propElement = (Element)props.item(j)).getTagName())) continue;
                String propName = propElement.getAttribute("name").trim();
                String propValue = propElement.getAttribute("value").trim();
                if (StringHelper.isEmpty(propValue)) {
                    propValue = XmlHelper.getElementContent(propElement, "");
                }
                metadata.getProps().put(propName, propValue);
            }
        }
        PersistenceUnitTransactionType transactionType = PersistenceXmlLoader.getTransactionType(top.getAttribute("transaction-type"));
        if (transactionType != null) {
            metadata.setTransactionType(transactionType);
        }
        return metadata;
    }

    public static PersistenceUnitTransactionType getTransactionType(String elementContent) {
        if (StringHelper.isEmpty(elementContent)) {
            return null;
        }
        if (elementContent.equalsIgnoreCase("JTA")) {
            return PersistenceUnitTransactionType.JTA;
        }
        if (elementContent.equalsIgnoreCase("RESOURCE_LOCAL")) {
            return PersistenceUnitTransactionType.RESOURCE_LOCAL;
        }
        throw new PersistenceException("Unknown TransactionType: " + elementContent);
    }

    public static class ErrorLogger
    implements ErrorHandler {
        private String file;
        private List errors;
        private EntityResolver resolver;

        ErrorLogger(String file, List errors, EntityResolver resolver) {
            this.file = file;
            this.errors = errors;
            this.resolver = resolver;
        }

        public void error(SAXParseException error) {
            if (this.resolver instanceof EJB3DTDEntityResolver && !((EJB3DTDEntityResolver)this.resolver).isResolved()) {
                return;
            }
            log.error("Error parsing XML: {}({}) {}", new Object[]{this.file, error.getLineNumber(), error.getMessage()});
            this.errors.add(error);
        }

        public void fatalError(SAXParseException error) {
            log.error("Error parsing XML: {}({}) {}", new Object[]{this.file, error.getLineNumber(), error.getMessage()});
            this.errors.add(error);
        }

        public void warning(SAXParseException warn) {
            log.warn("Warning parsing XML: {}({}) {}", new Object[]{this.file, warn.getLineNumber(), warn.getMessage()});
        }
    }
}

