/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.easybeans.container;

import java.io.IOException;
import java.io.Serializable;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.resource.ResourceException;
import javax.resource.spi.ActivationSpec;
import javax.resource.spi.ResourceAdapter;
import org.ow2.easybeans.api.EZBContainer;
import org.ow2.easybeans.api.EZBContainerCallbackInfo;
import org.ow2.easybeans.api.EZBContainerConfig;
import org.ow2.easybeans.api.EZBContainerException;
import org.ow2.easybeans.api.EZBContainerLifeCycleCallback;
import org.ow2.easybeans.api.EZBJ2EEManagedObject;
import org.ow2.easybeans.api.EZBPermissionManager;
import org.ow2.easybeans.api.EZBServer;
import org.ow2.easybeans.api.Factory;
import org.ow2.easybeans.api.FactoryException;
import org.ow2.easybeans.api.LifeCycleCallbackException;
import org.ow2.easybeans.api.PermissionManagerException;
import org.ow2.easybeans.api.bean.info.EZBBeanNamingInfo;
import org.ow2.easybeans.api.bean.info.IBeanInfo;
import org.ow2.easybeans.api.bean.info.IEJBJarInfo;
import org.ow2.easybeans.api.bean.info.IWebServiceInfo;
import org.ow2.easybeans.api.binding.BindingException;
import org.ow2.easybeans.api.binding.EZBBindingFactory;
import org.ow2.easybeans.api.binding.EZBRef;
import org.ow2.easybeans.api.interceptor.EZBInvocationContextFactory;
import org.ow2.easybeans.component.api.EZBComponent;
import org.ow2.easybeans.component.itf.EZBEventComponent;
import org.ow2.easybeans.component.itf.EZBStatisticComponent;
import org.ow2.easybeans.container.info.EJBJarInfo;
import org.ow2.easybeans.container.info.MessageDrivenInfo;
import org.ow2.easybeans.container.info.SessionBeanInfo;
import org.ow2.easybeans.container.info.security.SecurityInfoHelper;
import org.ow2.easybeans.container.info.ws.WebServiceInfo;
import org.ow2.easybeans.container.mdb.MDBMessageEndPointFactory;
import org.ow2.easybeans.container.mdb.helper.MDBResourceAdapterHelper;
import org.ow2.easybeans.container.session.SessionFactory;
import org.ow2.easybeans.container.session.stateful.StatefulSessionFactory;
import org.ow2.easybeans.container.session.stateless.StatelessSessionFactory;
import org.ow2.easybeans.deployment.Deployment;
import org.ow2.easybeans.deployment.annotations.exceptions.ResolverException;
import org.ow2.easybeans.deployment.helper.JavaContextHelper;
import org.ow2.easybeans.deployment.helper.JavaContextHelperException;
import org.ow2.easybeans.deployment.metadata.ejbjar.EasyBeansEjbJarClassMetadata;
import org.ow2.easybeans.deployment.metadata.ejbjar.EjbJarArchiveMetadata;
import org.ow2.easybeans.deployment.metadata.ejbjar.xml.EasyBeansDD;
import org.ow2.easybeans.deployment.metadata.ejbjar.xml.EasyBeansWebservices;
import org.ow2.easybeans.deployment.metadata.ejbjar.xml.WebserviceEndpoint;
import org.ow2.easybeans.deployment.resolver.JNDIResolverHelper;
import org.ow2.easybeans.enhancer.Enhancer;
import org.ow2.easybeans.enhancer.EnhancerException;
import org.ow2.easybeans.enhancer.interceptors.EasyBeansInvocationContextFactory;
import org.ow2.easybeans.event.lifecycle.EventLifeCycleStarted;
import org.ow2.easybeans.event.lifecycle.EventLifeCycleStarting;
import org.ow2.easybeans.event.lifecycle.EventLifeCycleStopped;
import org.ow2.easybeans.event.lifecycle.EventLifeCycleStopping;
import org.ow2.easybeans.jmx.MBeansException;
import org.ow2.easybeans.jmx.MBeansHelper;
import org.ow2.easybeans.loader.EasyBeansClassLoader;
import org.ow2.easybeans.naming.BeanNamingInfoHelper;
import org.ow2.easybeans.naming.J2EEManagedObjectNamingHelper;
import org.ow2.easybeans.persistence.PersistenceUnitManager;
import org.ow2.easybeans.persistence.api.EZBPersistenceUnitManager;
import org.ow2.easybeans.persistence.xml.PersistenceXmlFileAnalyzer;
import org.ow2.easybeans.persistence.xml.PersistenceXmlFileAnalyzerException;
import org.ow2.easybeans.proxy.binding.BindingManager;
import org.ow2.easybeans.proxy.reference.EJBHomeCallRef;
import org.ow2.easybeans.proxy.reference.EJBLocalHomeCallRef;
import org.ow2.easybeans.proxy.reference.LocalCallRef;
import org.ow2.easybeans.proxy.reference.RemoteCallRef;
import org.ow2.easybeans.resolver.api.EZBContainerJNDIResolver;
import org.ow2.easybeans.security.permissions.PermissionManager;
import org.ow2.easybeans.server.Embedded;
import org.ow2.easybeans.util.ExtensorSupport;
import org.ow2.easybeans.util.marshalling.Serialization;
import org.ow2.util.archive.api.ArchiveException;
import org.ow2.util.archive.api.IArchive;
import org.ow2.util.ee.deploy.api.deployable.metadata.DeployableMetadataException;
import org.ow2.util.ee.deploy.impl.helper.DeployableHelperException;
import org.ow2.util.ee.metadata.ejbjar.api.struct.IJLocal;
import org.ow2.util.ee.metadata.ejbjar.api.struct.IJRemote;
import org.ow2.util.ee.metadata.ws.api.struct.IWebServiceMarker;
import org.ow2.util.ee.metadata.ws.api.xml.struct.IPortComponent;
import org.ow2.util.ee.metadata.ws.api.xml.struct.IWebservices;
import org.ow2.util.event.api.IEvent;
import org.ow2.util.event.api.IEventDispatcher;
import org.ow2.util.event.impl.EventDispatcher;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;
import org.ow2.util.pool.api.IPoolConfiguration;
import org.ow2.util.pool.api.Pool;
import org.ow2.util.scan.api.ScanException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JContainer3
implements EZBContainer {
    private static Log logger = LogFactory.getLog(JContainer3.class);
    private String id = null;
    private ClassLoader classLoader = null;
    private Deployment deployment = null;
    private boolean available = false;
    private boolean resolved = false;
    private Map<String, Factory<?, ?>> factories = null;
    private EZBPersistenceUnitManager persistenceUnitManager = null;
    private EZBContainerConfig configuration = null;
    private EZBPermissionManager permissionManager = null;
    private IEJBJarInfo ejbJarInfo = null;
    private List<EZBRef> bindingReferences = null;
    private String applicationName = null;
    private ExtensorSupport extensor = new ExtensorSupport();
    private Map<String, Object> enhancerMap = null;
    private IEventDispatcher dispatcher = null;
    private String j2eeManagedObjectId = null;

    public JContainer3(EZBContainerConfig config) {
        this.setContainerConfig(config);
        this.bindingReferences = new ArrayList<EZBRef>();
    }

    protected JContainer3() {
    }

    protected void setContainerConfig(EZBContainerConfig config) {
        if (this.available) {
            throw new IllegalStateException("Cannot change the EZBContainer configuration after start().");
        }
        this.configuration = config;
        this.id = String.valueOf(System.identityHashCode(this));
        this.deployment = new Deployment(this.configuration);
        this.factories = new HashMap();
    }

    public String getId() {
        return this.id;
    }

    public void resolve() throws EZBContainerException {
        long tStart = System.currentTimeMillis();
        try {
            this.deployment.analyze(this.classLoader);
        }
        catch (ScanException e) {
            throw new EZBContainerException("Cannot analyze archive '" + this.getArchive().getName() + "'.", (Throwable)e);
        }
        catch (ResolverException e) {
            throw new EZBContainerException("Cannot resolve some annotations in the archive '" + this.getName() + "'.", (Throwable)e);
        }
        catch (DeployableHelperException e) {
            throw new EZBContainerException("Cannot transform in deployable archive '" + this.getName() + "'.", (Throwable)e);
        }
        catch (DeployableMetadataException e) {
            throw new EZBContainerException("Cannot create deployable metadata '" + this.getName() + "'.", (Throwable)e);
        }
        JNDIResolverHelper jndiResolver = new JNDIResolverHelper(this);
        jndiResolver.addDeployment(this.deployment);
        this.enhancerMap = new HashMap<String, Object>();
        this.enhancerMap.put(EZBContainerJNDIResolver.class.getName(), this.getConfiguration().getContainerJNDIResolver());
        this.resolved = true;
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Analyze elapsed during : " + (System.currentTimeMillis() - tStart) + " ms"), new Object[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() throws EZBContainerException {
        URL url;
        EZBStatisticComponent statisticComponent;
        long tStart = System.currentTimeMillis();
        this.dispatcher = new EventDispatcher();
        this.dispatcher.start();
        this.j2eeManagedObjectId = J2EEManagedObjectNamingHelper.getJ2EEManagedObjectId(this);
        EZBEventComponent eventComponent = this.getComponent(EZBEventComponent.class);
        if (eventComponent != null) {
            eventComponent.registerJ2EEManagedObject((EZBJ2EEManagedObject)this, this.dispatcher);
        }
        if ((statisticComponent = this.getComponent(EZBStatisticComponent.class)) != null) {
            statisticComponent.registerJ2EEManagedObject((EZBJ2EEManagedObject)this);
        }
        this.dispatcher.dispatch((IEvent)new EventLifeCycleStarting(this.j2eeManagedObjectId));
        try {
            url = this.getArchive().getURL();
        }
        catch (ArchiveException e) {
            throw new EZBContainerException("Cannot get URL on the archive '" + this.getName() + "'.", (Throwable)e);
        }
        final ClassLoader old = Thread.currentThread().getContextClassLoader();
        if (this.classLoader == null) {
            PrivilegedAction<EasyBeansClassLoader> privilegedAction = new PrivilegedAction<EasyBeansClassLoader>(){

                @Override
                public EasyBeansClassLoader run() {
                    return new EasyBeansClassLoader(new URL[]{url}, old);
                }
            };
            this.classLoader = AccessController.doPrivileged(privilegedAction);
        }
        if (!this.resolved) {
            this.resolve();
        }
        try {
            Thread.currentThread().setContextClassLoader(this.classLoader);
            Enhancer enhancer = new Enhancer(this.classLoader, this.deployment.getEjbJarArchiveMetadata(), this.enhancerMap);
            long tStartEnhancing = System.currentTimeMillis();
            try {
                enhancer.enhance();
            }
            catch (EnhancerException ee) {
                throw new EZBContainerException("Cannot run enhancer on archive '" + this.getName() + "'.", (Throwable)ee);
            }
            catch (RuntimeException e) {
                throw new EZBContainerException("Cannot run enhancer on archive '" + this.getName() + "'.", (Throwable)e);
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Enhancement elapsed during : " + (System.currentTimeMillis() - tStartEnhancing) + " ms"), new Object[0]);
            }
            PersistenceUnitManager analyzedPersistenceUnitManager = null;
            try {
                analyzedPersistenceUnitManager = PersistenceXmlFileAnalyzer.analyzePersistenceXmlFile(this.getArchive(), this.getClassLoader());
            }
            catch (PersistenceXmlFileAnalyzerException e) {
                throw new EZBContainerException("Cannot analyze the persistence.xml file in the archive", (Throwable)e);
            }
            if (this.persistenceUnitManager == null) {
                this.persistenceUnitManager = analyzedPersistenceUnitManager;
            } else if (analyzedPersistenceUnitManager != null) {
                analyzedPersistenceUnitManager.merge(this.persistenceUnitManager);
                this.persistenceUnitManager = analyzedPersistenceUnitManager;
            }
            this.createBeanFactories();
            this.deployment.reset();
            enhancer = null;
        }
        finally {
            Thread.currentThread().setContextClassLoader(old);
        }
        if (this.getCallbacksLifeCycle().size() > 0) {
            EZBContainerCallbackInfo info = this.getContainer3CallbackInfo();
            for (EZBContainerLifeCycleCallback callback : this.getCallbacksLifeCycle()) {
                try {
                    callback.start(info);
                }
                catch (Throwable t) {
                    logger.error((Object)"{0}.start() failed", new Object[]{callback.getClass().getName(), t});
                }
            }
        }
        try {
            MBeansHelper.getInstance().registerMBean(this);
        }
        catch (MBeansException e) {
            logger.error((Object)("Cannot register Container MBeans for " + this.getArchive().getName()), new Object[]{e});
        }
        this.getEmbedded().getJNDIResolver().addContainerResolver(this.configuration.getContainerJNDIResolver());
        if (logger.isInfoEnabled()) {
            int sfsb = 0;
            int slsb = 0;
            int mdb = 0;
            for (Factory<?, ?> factory : this.factories.values()) {
                if (factory instanceof StatelessSessionFactory) {
                    ++slsb;
                    continue;
                }
                if (factory instanceof StatefulSessionFactory) {
                    ++sfsb;
                    continue;
                }
                if (!(factory instanceof MDBMessageEndPointFactory)) continue;
                ++mdb;
            }
            logger.info((Object)"Container ''{0}'' [{1} SLSB, {2} SFSB, {3} MDB] started in {4} ms", new Object[]{this.getArchive().getName(), slsb, sfsb, mdb, System.currentTimeMillis() - tStart});
        }
        this.dispatcher.dispatch((IEvent)new EventLifeCycleStarted(this.j2eeManagedObjectId));
        this.available = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createBeanFactories() throws EZBContainerException {
        block19: {
            EZBEventComponent eventComponent = this.getComponent(EZBEventComponent.class);
            if (eventComponent == null) {
                throw new EZBContainerException("Event component is required !");
            }
            IEventDispatcher eventDispatcher = eventComponent.createEventDispatcher();
            eventDispatcher.start();
            eventComponent.getEventService().registerDispatcher("/easybeans/container/factory/context", eventDispatcher);
            logger.debug((Object)"EventService instance {0}", new Object[]{eventComponent.getEventService()});
            try {
                this.ejbJarInfo = new EJBJarInfo();
                EjbJarArchiveMetadata ejbMetadata = this.deployment.getEjbJarArchiveMetadata();
                if (ejbMetadata == null) break block19;
                List beanNames = this.deployment.getEjbJarArchiveMetadata().getBeanNames();
                for (String beanName : beanNames) {
                    for (EasyBeansEjbJarClassMetadata classAnnotationMetadata : this.deployment.getEjbJarArchiveMetadata().getClassesForBean(beanName)) {
                        Context javaContext;
                        Factory<?, ?> factory = null;
                        if (classAnnotationMetadata.isSession()) {
                            factory = this.createSessionBeanFactory(classAnnotationMetadata);
                        } else if (classAnnotationMetadata.isMdb()) {
                            factory = this.createMessageDrivenBeanFactory(classAnnotationMetadata);
                        }
                        if (factory == null) continue;
                        IBeanInfo beanInfo = factory.getBeanInfo();
                        beanInfo.setName(classAnnotationMetadata.getJCommonBean().getName());
                        beanInfo.setSecurityInfo(SecurityInfoHelper.getSecurityInfo(classAnnotationMetadata));
                        beanInfo.setCluster(classAnnotationMetadata.getCluster());
                        if (Boolean.getBoolean("easybeans.dynamicinterceptors")) {
                            factory.setInvocationContextFactory((EZBInvocationContextFactory)new EasyBeansInvocationContextFactory(classAnnotationMetadata, this.classLoader));
                        }
                        this.ejbJarInfo.addBeanInfo(beanInfo);
                        try {
                            javaContext = JavaContextHelper.build(classAnnotationMetadata, factory, eventDispatcher);
                        }
                        catch (JavaContextHelperException e) {
                            throw new EZBContainerException("Cannot build environment", (Throwable)e);
                        }
                        factory.setJavaContext(javaContext);
                        try {
                            MBeansHelper.getInstance().registerMBean(factory);
                        }
                        catch (MBeansException me) {
                            throw new EZBContainerException("Cannot register the factory MBean", (Throwable)me);
                        }
                        this.poolConfiguration(factory, classAnnotationMetadata);
                        try {
                            factory.init();
                        }
                        catch (FactoryException e) {
                            throw new EZBContainerException("Cannot initialize the factory.", (Throwable)e);
                        }
                        this.factories.put(beanName, factory);
                    }
                }
                this.bindReferences();
                try {
                    this.permissionManager = new PermissionManager(this.getArchive().getURL(), this.ejbJarInfo);
                    this.permissionManager.translateMetadata();
                    this.permissionManager.commit();
                }
                catch (PermissionManagerException e) {
                    throw new EZBContainerException("Cannot create permission manager", (Throwable)e);
                }
                catch (ArchiveException e) {
                    throw new EZBContainerException("Cannot create permission manager", (Throwable)e);
                }
            }
            finally {
                eventDispatcher.stop();
                eventComponent.getEventService().unregisterDispatcher("/easybeans/container/factory/context");
            }
        }
    }

    private void bindReferences() throws EZBContainerException {
        for (EZBRef reference : this.bindingReferences) {
            List<EZBContainerLifeCycleCallback> lifeCycleCallbacks = this.getCallbacksLifeCycle();
            if (!lifeCycleCallbacks.isEmpty()) {
                EZBContainerCallbackInfo info = this.getContainer3CallbackInfo();
                for (EZBContainerLifeCycleCallback lifeCycleCallback : lifeCycleCallbacks) {
                    try {
                        lifeCycleCallback.beforeBind(info, reference);
                    }
                    catch (LifeCycleCallbackException e) {
                        throw new EZBContainerException("Cannot invoke the callback before binding.", (Throwable)e);
                    }
                }
            }
            for (EZBBindingFactory bindingFactory : BindingManager.getInstance().getFactories()) {
                try {
                    bindingFactory.bind(reference);
                }
                catch (BindingException e) {
                    logger.warn((Object)"Cannot bind the reference ''{0}'' on the binding factory ''{1}'' for the container ''{2}''.", new Object[]{reference, bindingFactory, this.getArchive().getName(), e});
                }
            }
        }
    }

    private void poolConfiguration(Factory<?, ?> factory, EasyBeansEjbJarClassMetadata beanMetadata) {
        IPoolConfiguration poolConfiguration = beanMetadata.getPoolConfiguration();
        if (poolConfiguration != null) {
            Pool pool = factory.getPool();
            if (pool != null) {
                pool.setPoolConfiguration(poolConfiguration);
            } else {
                logger.warn((Object)"Cannot configure Pool for factory {0} for bean class {1} as pool is not initialized", new Object[]{factory, beanMetadata});
            }
        }
    }

    private Factory<?, ?> createMessageDrivenBeanFactory(EasyBeansEjbJarClassMetadata messageDrivenBean) throws EZBContainerException {
        String className = messageDrivenBean.getClassName().replace('/', '.');
        ActivationSpec activationSpec = null;
        try {
            activationSpec = (ActivationSpec)new InitialContext().lookup("joramActivationSpec");
        }
        catch (NamingException e1) {
            throw new EZBContainerException("Cannot get the activation spec with the name 'joramActivationSpec'.", (Throwable)e1);
        }
        if (activationSpec instanceof Serializable) {
            byte[] byteArgs;
            try {
                byteArgs = Serialization.storeObject((Serializable)activationSpec);
            }
            catch (IOException e) {
                throw new EZBContainerException("Cannot serialize the activation spec object '" + activationSpec + "'.", (Throwable)e);
            }
            try {
                activationSpec = (ActivationSpec)Serialization.loadObject(byteArgs);
            }
            catch (IOException e) {
                throw new EZBContainerException("Cannot load activation spec from the serialized object.", (Throwable)e);
            }
            catch (ClassNotFoundException e) {
                throw new EZBContainerException("Cannot load activation spec from the serialized object.", (Throwable)e);
            }
        }
        ResourceAdapter resourceAdapter = null;
        try {
            resourceAdapter = MDBResourceAdapterHelper.getResourceAdapter("joramActivationSpec", (Embedded)this.getConfiguration().getEZBServer());
        }
        catch (ResourceException e) {
            throw new EZBContainerException("Cannot get the resource adapter for this MDB factory", (Throwable)e);
        }
        if (activationSpec.getResourceAdapter() == null) {
            try {
                activationSpec.setResourceAdapter(resourceAdapter);
            }
            catch (ResourceException e) {
                throw new EZBContainerException("Cannot associate resource adapter with activation spec object", (Throwable)e);
            }
        }
        MDBMessageEndPointFactory mdbMessageEndPointFactory = null;
        try {
            mdbMessageEndPointFactory = new MDBMessageEndPointFactory(className, this, activationSpec, resourceAdapter);
        }
        catch (FactoryException e) {
            throw new EZBContainerException("Cannot build the MDB MessageEndPoint factory", (Throwable)e);
        }
        MessageDrivenInfo messageDrivenInfo = new MessageDrivenInfo();
        messageDrivenInfo.setApplicationExceptions(((EjbJarArchiveMetadata)messageDrivenBean.getEjbJarDeployableMetadata()).getApplicationExceptions());
        messageDrivenInfo.setTransactionManagementType(messageDrivenBean.getTransactionManagementType());
        messageDrivenInfo.setMessageListenerInterface(messageDrivenBean.getJMessageDriven().getMessageListenerInterface());
        messageDrivenInfo.setMessageDestinationLink(messageDrivenBean.getJMessageDriven().getMessageDestinationLink());
        messageDrivenInfo.setActivationConfigProperties(messageDrivenBean.getJMessageDriven().getActivationConfigProperties());
        mdbMessageEndPointFactory.setMessageDrivenInfo(messageDrivenInfo);
        return mdbMessageEndPointFactory;
    }

    private Factory<?, ?> createSessionBeanFactory(EasyBeansEjbJarClassMetadata sessionBean) throws EZBContainerException {
        String className = sessionBean.getClassName().replace('/', '.');
        String factoryName = sessionBean.getJCommonBean().getName();
        SessionFactory sessionFactory = null;
        if (sessionBean.isStateless()) {
            try {
                sessionFactory = new StatelessSessionFactory(className, this);
            }
            catch (FactoryException fe) {
                throw new EZBContainerException("Cannot build the stateless factory", (Throwable)fe);
            }
        }
        try {
            sessionFactory = new StatefulSessionFactory(className, this);
        }
        catch (FactoryException fe) {
            throw new EZBContainerException("Cannot build the stateful factory", (Throwable)fe);
        }
        SessionBeanInfo sessionBeanInfo = new SessionBeanInfo();
        sessionBeanInfo.setTransactionManagementType(sessionBean.getTransactionManagementType());
        sessionBeanInfo.setApplicationExceptions(((EjbJarArchiveMetadata)sessionBean.getEjbJarDeployableMetadata()).getApplicationExceptions());
        sessionFactory.setSessionBeanInfo(sessionBeanInfo);
        if (sessionBean.getWebServiceMarker() != null) {
            IWebServiceInfo info = this.createWebServiceInfo(sessionBean, factoryName);
            sessionBeanInfo.setWebServiceInfo(info);
        }
        IJLocal localItfs = sessionBean.getLocalInterfaces();
        IJRemote remoteItfs = sessionBean.getRemoteInterfaces();
        if (localItfs != null) {
            sessionBeanInfo.setLocalInterfaces(localItfs.getInterfaces());
            for (String itf : localItfs.getInterfaces()) {
                this.bindingReferences.add(this.createLocalItfRef(itf, this.getEmbedded().getID(), this.getId(), factoryName, sessionBean, sessionFactory));
            }
        }
        if (remoteItfs != null) {
            sessionBeanInfo.setRemoteInterfaces(remoteItfs.getInterfaces());
            for (String itf : remoteItfs.getInterfaces()) {
                this.bindingReferences.add(this.createRemoteItfRef(itf, this.getId(), factoryName, sessionBean, sessionFactory));
            }
        }
        String remoteHome = sessionBean.getRemoteHome();
        String localHome = sessionBean.getLocalHome();
        if (remoteHome != null) {
            this.bindingReferences.add(this.createRemoteHomeRef(remoteHome, this.getId(), factoryName, sessionBean, sessionFactory));
        }
        if (localHome != null) {
            this.bindingReferences.add(this.createLocalHomeRef(localHome, this.getEmbedded().getID(), this.getId(), factoryName, sessionBean, sessionFactory));
        }
        return sessionFactory;
    }

    private IWebServiceInfo createWebServiceInfo(EasyBeansEjbJarClassMetadata sessionBean, String beanName) {
        IWebServiceMarker marker = sessionBean.getWebServiceMarker();
        String name = marker.getName();
        IWebservices webservicesDD = this.deployment.getEjbJarArchiveMetadata().getWebservices12();
        IPortComponent portComponent = null;
        if (webservicesDD != null && (portComponent = webservicesDD.findPortComponent(beanName)) != null && name == null) {
            name = portComponent.getName();
        }
        WebserviceEndpoint endpoint = null;
        EasyBeansDD easybeansDD = this.deployment.getEjbJarArchiveMetadata().getEasyBeansDD();
        if (easybeansDD != null) {
            EasyBeansWebservices webservices = easybeansDD.getWebservices();
            if (webservices != null && webservices.getWebserviceEndpoints() != null) {
                Iterator<WebserviceEndpoint> i = webservices.getWebserviceEndpoints().iterator();
                while (i.hasNext() && endpoint == null) {
                    WebserviceEndpoint browsed = i.next();
                    if (!browsed.getPortComponentName().equals(name)) continue;
                    endpoint = browsed;
                }
            }
            WebServiceInfo info = new WebServiceInfo();
            info.setPortComponentName(name);
            if (portComponent != null) {
                info.setWsdlLocation(portComponent.getParent().getWsdlFile());
                info.setServiceName(portComponent.getWsdlService());
                info.setPortName(portComponent.getWsdlPort());
                info.setProtocolBinding(portComponent.getProtocolBinding());
                info.setMTOMEnabled(portComponent.isMTOMEnabled());
                if (!marker.isWebServiceProvider()) {
                    info.setServiceEndpointInterface(portComponent.getServiceEndpointInterface());
                }
            }
            info.setEndpointAddress(sessionBean.getWebServiceEndpointAddress());
            if (endpoint != null) {
                info.setWsdlPublicationDirectory(endpoint.getWsdlPublicationDirectory());
            }
            return info;
        }
        return null;
    }

    public void stop() {
        EZBEventComponent eventComponent;
        this.available = false;
        this.resolved = false;
        this.dispatcher.dispatch((IEvent)new EventLifeCycleStopping(this.j2eeManagedObjectId));
        this.getEmbedded().getJNDIResolver().removeContainerResolver(this.configuration.getContainerJNDIResolver());
        try {
            MBeansHelper.getInstance().unregisterMBean(this);
        }
        catch (MBeansException e) {
            logger.error((Object)("Cannot unregister Container MBeans for " + this.getArchive().getName()), new Object[]{e});
        }
        for (Factory<?, ?> f : this.factories.values()) {
            f.stop();
            try {
                MBeansHelper.getInstance().unregisterMBean(f);
            }
            catch (MBeansException me) {
                logger.error((Object)"Cannot unregister the factory MBean", new Object[]{me});
            }
        }
        this.classLoader = null;
        if (this.getCallbacksLifeCycle().size() > 0) {
            EZBContainerCallbackInfo info = this.getContainer3CallbackInfo();
            for (EZBContainerLifeCycleCallback callback : this.getCallbacksLifeCycle()) {
                try {
                    callback.stop(info);
                }
                catch (Throwable t) {
                    logger.error((Object)"{0}.stop() failed", new Object[]{callback.getClass().getName(), t});
                }
            }
        }
        for (EZBRef reference : this.bindingReferences) {
            for (EZBBindingFactory bindingFactory : BindingManager.getInstance().getFactories()) {
                try {
                    bindingFactory.unbind(reference);
                }
                catch (BindingException e) {
                    logger.warn((Object)"Cannot unbind the reference ''{0}'' on the binding factory ''{1}'' for the container ''{2}''.", new Object[]{reference, bindingFactory, this.getArchive().getName(), e});
                }
            }
        }
        this.dispatcher.dispatch((IEvent)new EventLifeCycleStopped(this.j2eeManagedObjectId));
        EZBStatisticComponent statisticComponent = this.getComponent(EZBStatisticComponent.class);
        if (statisticComponent != null) {
            statisticComponent.unregisterJ2EEManagedObject((EZBJ2EEManagedObject)this);
        }
        if ((eventComponent = this.getComponent(EZBEventComponent.class)) != null) {
            eventComponent.unregisterJ2EEManagedObject((EZBJ2EEManagedObject)this);
        }
        this.dispatcher.stop();
        this.dispatcher = null;
    }

    private EZBContainerCallbackInfo getContainer3CallbackInfo() {
        EZBContainerCallbackInfo info = new EZBContainerCallbackInfo();
        info.setArchive(this.getArchive());
        info.setFactories(this.factories);
        info.setContainer((EZBContainer)this);
        return info;
    }

    private EJBHomeCallRef createRemoteHomeRef(String remoteHome, String containerID, String factoryName, EasyBeansEjbJarClassMetadata bean, SessionFactory<?> factory) throws EZBContainerException {
        String itfClsName = remoteHome.replace('/', '.');
        try {
            this.classLoader.loadClass(itfClsName);
        }
        catch (ClassNotFoundException e) {
            throw new EZBContainerException("Cannot find the class '" + remoteHome + "' in Classloader '" + this.classLoader + "'.", (Throwable)e);
        }
        String remoteInterface = bean.getRemoteInterface();
        EJBHomeCallRef ejbHomeCallRef = new EJBHomeCallRef(itfClsName, containerID, factoryName, bean.isStateful(), remoteInterface);
        ejbHomeCallRef.setFactory(factory);
        ejbHomeCallRef.setJNDIName(this.configuration.getNamingStrategy().getJNDIName((EZBBeanNamingInfo)BeanNamingInfoHelper.buildInfo(bean, itfClsName, "RemoteHome", this.applicationName)));
        return ejbHomeCallRef;
    }

    private EJBLocalHomeCallRef createLocalHomeRef(String itf, Integer embeddedId, String containerID, String factoryName, EasyBeansEjbJarClassMetadata bean, SessionFactory<?> factory) throws EZBContainerException {
        String itfClsName = itf.replace('/', '.');
        try {
            this.classLoader.loadClass(itfClsName);
        }
        catch (ClassNotFoundException e) {
            throw new EZBContainerException("Cannot find the class '" + itf + "' in Classloader '" + this.classLoader + "'.", (Throwable)e);
        }
        EJBLocalHomeCallRef ejbLocalHomeCallRef = new EJBLocalHomeCallRef(itfClsName, embeddedId, containerID, factoryName, bean.isStateful());
        ejbLocalHomeCallRef.setFactory(factory);
        ejbLocalHomeCallRef.setJNDIName(this.configuration.getNamingStrategy().getJNDIName((EZBBeanNamingInfo)BeanNamingInfoHelper.buildInfo(bean, itfClsName, "LocalHome", this.applicationName)));
        return ejbLocalHomeCallRef;
    }

    private LocalCallRef createLocalItfRef(String itf, Integer embeddedId, String containerID, String factoryName, EasyBeansEjbJarClassMetadata bean, SessionFactory<?> factory) throws EZBContainerException {
        String itfClsName = itf.replace('/', '.');
        try {
            this.classLoader.loadClass(itfClsName);
        }
        catch (ClassNotFoundException e) {
            throw new EZBContainerException("Cannot find the class '" + itf + "' in Classloader '" + this.classLoader + "'.", (Throwable)e);
        }
        LocalCallRef localCallRef = new LocalCallRef(itfClsName, embeddedId, containerID, factoryName, bean.isStateful());
        localCallRef.setFactory(factory);
        localCallRef.setJNDIName(this.configuration.getNamingStrategy().getJNDIName((EZBBeanNamingInfo)BeanNamingInfoHelper.buildInfo(bean, itfClsName, "Local", this.applicationName)));
        return localCallRef;
    }

    private RemoteCallRef createRemoteItfRef(String itf, String containerID, String factoryName, EasyBeansEjbJarClassMetadata bean, SessionFactory<?> factory) throws EZBContainerException {
        String itfClsName = itf.replace('/', '.');
        try {
            this.classLoader.loadClass(itfClsName);
        }
        catch (ClassNotFoundException e) {
            throw new EZBContainerException("Cannot find the class '" + itf + "' in Classloader '" + this.classLoader + "'.", (Throwable)e);
        }
        RemoteCallRef remoteCallRef = new RemoteCallRef(itfClsName, containerID, factoryName, bean.isStateful());
        remoteCallRef.setFactory(factory);
        remoteCallRef.setJNDIName(this.configuration.getNamingStrategy().getJNDIName((EZBBeanNamingInfo)BeanNamingInfoHelper.buildInfo(bean, itfClsName, "Remote", this.applicationName)));
        return remoteCallRef;
    }

    public Factory<?, ?> getFactory(String factoryName) {
        return this.factories.get(factoryName);
    }

    public Collection<Factory<?, ?>> getFactories() {
        return this.factories.values();
    }

    public String getName() {
        return this.getArchive().getName();
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public IArchive getArchive() {
        return this.configuration.getArchive();
    }

    public EZBServer getEmbedded() {
        return this.configuration.getEZBServer();
    }

    private List<EZBContainerLifeCycleCallback> getCallbacksLifeCycle() {
        return this.configuration.getCallbacks();
    }

    public boolean isAvailable() {
        return this.available;
    }

    public EZBPersistenceUnitManager getPersistenceUnitManager() {
        return this.persistenceUnitManager;
    }

    public void setClassLoader(ClassLoader classLoader) {
        if (this.classLoader != null) {
            throw new IllegalArgumentException("Cannot replace an existing classloader");
        }
        this.classLoader = classLoader;
    }

    public void setPersistenceUnitManager(EZBPersistenceUnitManager persistenceUnitManager) {
        if (this.persistenceUnitManager != null) {
            throw new IllegalArgumentException("Cannot replace an existing persistenceUnitManager");
        }
        this.persistenceUnitManager = persistenceUnitManager;
    }

    public EZBContainerConfig getConfiguration() {
        return this.configuration;
    }

    public EZBPermissionManager getPermissionManager() {
        return this.permissionManager;
    }

    public void setPermissionManager(EZBPermissionManager ezbPermissionManager) {
        this.permissionManager = ezbPermissionManager;
    }

    public void setApplicationName(String applicationName) {
        this.applicationName = applicationName;
    }

    public String getApplicationName() {
        return this.applicationName;
    }

    public void setExtraArchives(List<IArchive> extraArchives) {
        this.deployment.setExtraArchives(extraArchives);
    }

    public <T> T addExtension(Class<T> clazz, T extension) {
        return this.extensor.addExtension(clazz, extension);
    }

    public <T> T getExtension(Class<T> clazz) {
        return this.extensor.getExtension(clazz);
    }

    public <T> T removeExtension(Class<T> clazz) {
        return this.extensor.removeExtension(clazz);
    }

    public <T extends EZBComponent> T getComponent(Class<T> itf) {
        return (T)this.getEmbedded().getComponent(itf);
    }

    public String getJ2EEManagedObjectId() {
        return this.j2eeManagedObjectId;
    }

    public IEventDispatcher getEventDispatcher() {
        return this.dispatcher;
    }
}

