/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.servlets;

import java.io.IOException;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.UnavailableException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.catalina.ContainerServlet;
import org.apache.catalina.Context;
import org.apache.catalina.Wrapper;
import org.apache.catalina.servlets.InvokerHttpRequest;
import org.apache.catalina.util.StringManager;

public final class InvokerServlet
extends HttpServlet
implements ContainerServlet {
    private Context context = null;
    private int debug = 0;
    private static StringManager sm = StringManager.getManager("org.apache.catalina.servlets");
    private Wrapper wrapper = null;

    public Wrapper getWrapper() {
        return this.wrapper;
    }

    public void setWrapper(Wrapper wrapper) {
        this.wrapper = wrapper;
        this.context = wrapper == null ? null : (Context)wrapper.getParent();
    }

    public void destroy() {
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        this.serveRequest(request, response);
    }

    public void doHead(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        this.serveRequest(request, response);
    }

    public void doPost(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        this.serveRequest(request, response);
    }

    public void init() throws ServletException {
        if (this.wrapper == null || this.context == null) {
            throw new UnavailableException(sm.getString("invokerServlet.noWrapper"));
        }
        if (this.getServletConfig().getInitParameter("debug") != null) {
            this.debug = Integer.parseInt(this.getServletConfig().getInitParameter("debug"));
        }
        if (this.debug >= 1) {
            this.log("init: Associated with Context '" + this.context.getPath() + "'");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void serveRequest(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        boolean included;
        if (request.getAttribute("org.apache.catalina.NAMED") != null) {
            throw new ServletException(sm.getString("invokerServlet.notNamed"));
        }
        String inRequestURI = null;
        String inServletPath = null;
        String inPathInfo = null;
        boolean bl = included = request.getAttribute("javax.servlet.include.request_uri") != null;
        if (included) {
            inRequestURI = (String)request.getAttribute("javax.servlet.include.request_uri");
            inServletPath = (String)request.getAttribute("javax.servlet.include.servlet_path");
            inPathInfo = (String)request.getAttribute("javax.servlet.include.path_info");
        } else {
            inRequestURI = request.getRequestURI();
            inServletPath = request.getServletPath();
            inPathInfo = request.getPathInfo();
        }
        if (this.debug >= 1) {
            this.log("included='" + included + "', requestURI='" + inRequestURI + "'");
            this.log("  servletPath='" + inServletPath + "', pathInfo='" + inPathInfo + "'");
        }
        if (inPathInfo == null) {
            if (this.debug >= 1) {
                this.log("Invalid pathInfo '" + inPathInfo + "'");
            }
            if (included) {
                throw new ServletException(sm.getString("invokerServlet.invalidPath", inRequestURI));
            }
            response.sendError(404, inRequestURI);
            return;
        }
        String pathInfo = inPathInfo;
        String servletClass = pathInfo.substring(1);
        int slash = servletClass.indexOf(47);
        if (slash >= 0) {
            pathInfo = servletClass.substring(slash);
            servletClass = servletClass.substring(0, slash);
        } else {
            pathInfo = "";
        }
        if (servletClass.startsWith("org.apache.catalina")) {
            response.sendError(404, inRequestURI);
            return;
        }
        if (this.debug >= 1) {
            this.log("Processing servlet '" + servletClass + "' with path info '" + pathInfo + "'");
        }
        String name = "org.apache.catalina.INVOKER." + servletClass;
        String pattern = inServletPath + "/" + servletClass + "/*";
        Wrapper wrapper = null;
        InvokerServlet invokerServlet = this;
        synchronized (invokerServlet) {
            wrapper = (Wrapper)this.context.findChild(servletClass);
            if (wrapper == null) {
                wrapper = (Wrapper)this.context.findChild(name);
            }
            if (wrapper != null) {
                String actualServletClass = wrapper.getServletClass();
                if (actualServletClass != null && actualServletClass.startsWith("org.apache.catalina")) {
                    response.sendError(404, inRequestURI);
                    return;
                }
                if (this.debug >= 1) {
                    this.log("Using wrapper for servlet '" + wrapper.getName() + "' with mapping '" + pattern + "'");
                }
                this.context.addServletMapping(pattern, wrapper.getName());
            } else {
                if (this.debug >= 1) {
                    this.log("Creating wrapper for '" + servletClass + "' with mapping '" + pattern + "'");
                }
                try {
                    wrapper = this.context.createWrapper();
                    wrapper.setName(name);
                    wrapper.setLoadOnStartup(1);
                    wrapper.setServletClass(servletClass);
                    this.context.addChild(wrapper);
                    this.context.addServletMapping(pattern, name);
                }
                catch (Exception e) {
                    this.log(sm.getString("invokerServlet.cannotCreate", inRequestURI), e);
                    this.context.removeServletMapping(pattern);
                    this.context.removeChild(wrapper);
                    if (included) {
                        throw new ServletException(sm.getString("invokerServlet.cannotCreate", inRequestURI), (Throwable)e);
                    }
                    response.sendError(404, inRequestURI);
                    return;
                }
            }
        }
        InvokerHttpRequest wrequest = new InvokerHttpRequest(request);
        wrequest.setRequestURI(inRequestURI);
        StringBuffer sb = new StringBuffer(inServletPath);
        sb.append("/");
        sb.append(servletClass);
        wrequest.setServletPath(sb.toString());
        if (pathInfo == null || pathInfo.length() < 1) {
            wrequest.setPathInfo(null);
            wrequest.setPathTranslated(null);
        } else {
            wrequest.setPathInfo(pathInfo);
            wrequest.setPathTranslated(this.getServletContext().getRealPath(pathInfo));
        }
        Servlet instance = null;
        try {
            instance = wrapper.allocate();
        }
        catch (ServletException e) {
            this.log(sm.getString("invokerServlet.allocate", inRequestURI), e);
            this.context.removeServletMapping(pattern);
            this.context.removeChild(wrapper);
            Throwable rootCause = e.getRootCause();
            if (rootCause == null) {
                rootCause = e;
            }
            if (rootCause instanceof ClassNotFoundException) {
                response.sendError(404, inRequestURI);
                return;
            }
            if (rootCause instanceof IOException) {
                throw (IOException)rootCause;
            }
            if (rootCause instanceof RuntimeException) {
                throw (RuntimeException)rootCause;
            }
            if (rootCause instanceof ServletException) {
                throw (ServletException)rootCause;
            }
            throw new ServletException(sm.getString("invokerServlet.allocate", inRequestURI), rootCause);
        }
        if (included) {
            wrequest.setRequestURI(request.getRequestURI());
            wrequest.setPathInfo(request.getPathInfo());
            wrequest.setServletPath(request.getServletPath());
        }
        try {
            String jspFile = wrapper.getJspFile();
            if (jspFile != null) {
                request.setAttribute("org.apache.catalina.jsp_file", (Object)jspFile);
            } else {
                request.removeAttribute("org.apache.catalina.jsp_file");
            }
            request.setAttribute("org.apache.catalina.INVOKED", (Object)request.getServletPath());
            instance.service((ServletRequest)wrequest, (ServletResponse)response);
        }
        catch (UnavailableException e) {
            this.context.removeServletMapping(pattern);
            throw e;
        }
        finally {
            request.removeAttribute("org.apache.catalina.INVOKED");
            request.removeAttribute("org.apache.catalina.jsp_file");
            try {
                wrapper.deallocate(instance);
            }
            catch (ServletException e) {
                this.log(sm.getString("invokerServlet.deallocate", inRequestURI), e);
                throw e;
            }
        }
    }
}

