/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.startup;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.Socket;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.catalina.Lifecycle;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.Server;
import org.apache.catalina.core.StandardServer;
import org.apache.catalina.startup.ClusterRuleSetFactory;
import org.apache.catalina.startup.ConnectorCreateRule;
import org.apache.catalina.startup.ContextRuleSet;
import org.apache.catalina.startup.Embedded;
import org.apache.catalina.startup.EngineRuleSet;
import org.apache.catalina.startup.HostRuleSet;
import org.apache.catalina.startup.NamingRuleSet;
import org.apache.catalina.startup.SetAllPropertiesRule;
import org.apache.catalina.startup.SetParentClassLoaderRule;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.util.digester.Digester;
import org.xml.sax.InputSource;

public class Catalina
extends Embedded {
    protected String configFile = "conf/server.xml";
    protected ClassLoader parentClassLoader = Catalina.class.getClassLoader();
    protected Server server = null;
    protected boolean starting = false;
    protected boolean stopping = false;
    protected boolean useShutdownHook = true;
    protected Thread shutdownHook = null;
    private static Log log = LogFactory.getLog(Catalina.class);

    public void setConfig(String file) {
        this.configFile = file;
    }

    public void setConfigFile(String file) {
        this.configFile = file;
    }

    public String getConfigFile() {
        return this.configFile;
    }

    public void setUseShutdownHook(boolean useShutdownHook) {
        this.useShutdownHook = useShutdownHook;
    }

    public boolean getUseShutdownHook() {
        return this.useShutdownHook;
    }

    public void setParentClassLoader(ClassLoader parentClassLoader) {
        this.parentClassLoader = parentClassLoader;
    }

    public void setServer(Server server) {
        this.server = server;
    }

    public static void main(String[] args) {
        new Catalina().process(args);
    }

    public void process(String[] args) {
        this.setAwait(true);
        this.setCatalinaHome();
        this.setCatalinaBase();
        try {
            if (this.arguments(args)) {
                if (this.starting) {
                    this.load(args);
                    this.start();
                } else if (this.stopping) {
                    this.stopServer();
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace(System.out);
        }
    }

    protected boolean arguments(String[] args) {
        boolean isConfig = false;
        if (args.length < 1) {
            this.usage();
            return false;
        }
        for (int i = 0; i < args.length; ++i) {
            if (isConfig) {
                this.configFile = args[i];
                isConfig = false;
                continue;
            }
            if (args[i].equals("-config")) {
                isConfig = true;
                continue;
            }
            if (args[i].equals("-nonaming")) {
                this.setUseNaming(false);
                continue;
            }
            if (args[i].equals("-help")) {
                this.usage();
                return false;
            }
            if (args[i].equals("start")) {
                this.starting = true;
                this.stopping = false;
                continue;
            }
            if (args[i].equals("stop")) {
                this.starting = false;
                this.stopping = true;
                continue;
            }
            this.usage();
            return false;
        }
        return true;
    }

    protected File configFile() {
        File file = new File(this.configFile);
        if (!file.isAbsolute()) {
            file = new File(System.getProperty("catalina.base"), this.configFile);
        }
        return file;
    }

    protected Digester createStartDigester() {
        long t1 = System.currentTimeMillis();
        Digester digester = new Digester();
        digester.setValidating(false);
        digester.setRulesValidation(true);
        HashMap<Class, List<String>> fakeAttributes = new HashMap<Class, List<String>>();
        ArrayList<String> attrs = new ArrayList<String>();
        attrs.add("className");
        fakeAttributes.put(Object.class, attrs);
        digester.setFakeAttributes(fakeAttributes);
        digester.setClassLoader(StandardServer.class.getClassLoader());
        digester.addObjectCreate("Server", "org.apache.catalina.core.StandardServer", "className");
        digester.addSetProperties("Server");
        digester.addSetNext("Server", "setServer", "org.apache.catalina.Server");
        digester.addObjectCreate("Server/GlobalNamingResources", "org.apache.catalina.deploy.NamingResources");
        digester.addSetProperties("Server/GlobalNamingResources");
        digester.addSetNext("Server/GlobalNamingResources", "setGlobalNamingResources", "org.apache.catalina.deploy.NamingResources");
        digester.addObjectCreate("Server/Listener", null, "className");
        digester.addSetProperties("Server/Listener");
        digester.addSetNext("Server/Listener", "addLifecycleListener", "org.apache.catalina.LifecycleListener");
        digester.addObjectCreate("Server/Service", "org.apache.catalina.core.StandardService", "className");
        digester.addSetProperties("Server/Service");
        digester.addSetNext("Server/Service", "addService", "org.apache.catalina.Service");
        digester.addObjectCreate("Server/Service/Listener", null, "className");
        digester.addSetProperties("Server/Service/Listener");
        digester.addSetNext("Server/Service/Listener", "addLifecycleListener", "org.apache.catalina.LifecycleListener");
        digester.addObjectCreate("Server/Service/Executor", "org.apache.catalina.core.StandardThreadExecutor", "className");
        digester.addSetProperties("Server/Service/Executor");
        digester.addSetNext("Server/Service/Executor", "addExecutor", "org.apache.catalina.Executor");
        digester.addRule("Server/Service/Connector", new ConnectorCreateRule());
        digester.addRule("Server/Service/Connector", new SetAllPropertiesRule(new String[]{"executor"}));
        digester.addSetNext("Server/Service/Connector", "addConnector", "org.apache.catalina.connector.Connector");
        digester.addObjectCreate("Server/Service/Connector/Listener", null, "className");
        digester.addSetProperties("Server/Service/Connector/Listener");
        digester.addSetNext("Server/Service/Connector/Listener", "addLifecycleListener", "org.apache.catalina.LifecycleListener");
        digester.addRuleSet(new NamingRuleSet("Server/GlobalNamingResources/"));
        digester.addRuleSet(new EngineRuleSet("Server/Service/"));
        digester.addRuleSet(new HostRuleSet("Server/Service/Engine/"));
        digester.addRuleSet(new ContextRuleSet("Server/Service/Engine/Host/"));
        digester.addRuleSet(ClusterRuleSetFactory.getClusterRuleSet("Server/Service/Engine/Host/Cluster/"));
        digester.addRuleSet(new NamingRuleSet("Server/Service/Engine/Host/Context/"));
        digester.addRule("Server/Service/Engine", new SetParentClassLoaderRule(this.parentClassLoader));
        digester.addRuleSet(ClusterRuleSetFactory.getClusterRuleSet("Server/Service/Engine/Cluster/"));
        long t2 = System.currentTimeMillis();
        if (log.isDebugEnabled()) {
            log.debug("Digester for server.xml created " + (t2 - t1));
        }
        return digester;
    }

    protected Digester createStopDigester() {
        Digester digester = new Digester();
        digester.addObjectCreate("Server", "org.apache.catalina.core.StandardServer", "className");
        digester.addSetProperties("Server");
        digester.addSetNext("Server", "setServer", "org.apache.catalina.Server");
        return digester;
    }

    public void stopServer() {
        this.stopServer(null);
    }

    public void stopServer(String[] arguments) {
        if (arguments != null) {
            this.arguments(arguments);
        }
        if (this.server == null) {
            Digester digester = this.createStopDigester();
            digester.setClassLoader(Thread.currentThread().getContextClassLoader());
            File file = this.configFile();
            try {
                InputSource is = new InputSource("file://" + file.getAbsolutePath());
                FileInputStream fis = new FileInputStream(file);
                is.setByteStream(fis);
                digester.push(this);
                digester.parse(is);
                fis.close();
            }
            catch (Exception e) {
                log.error("Catalina.stop: ", e);
                System.exit(1);
            }
        }
        try {
            String hostAddress = InetAddress.getByName("localhost").getHostAddress();
            Socket socket = new Socket(hostAddress, this.server.getPort());
            OutputStream stream = socket.getOutputStream();
            String shutdown = this.server.getShutdown();
            for (int i = 0; i < shutdown.length(); ++i) {
                stream.write(shutdown.charAt(i));
            }
            stream.flush();
            stream.close();
            socket.close();
        }
        catch (IOException e) {
            log.error("Catalina.stop: ", e);
            System.exit(1);
        }
    }

    public void setCatalinaBase() {
        this.initDirs();
    }

    public void setCatalinaHome() {
        this.initDirs();
    }

    public void load() {
        long t1 = System.nanoTime();
        this.initDirs();
        this.initNaming();
        Digester digester = this.createStartDigester();
        InputSource inputSource = null;
        InputStream inputStream = null;
        File file = null;
        try {
            file = this.configFile();
            inputStream = new FileInputStream(file);
            inputSource = new InputSource("file://" + file.getAbsolutePath());
        }
        catch (Exception e) {
            // empty catch block
        }
        if (inputStream == null) {
            try {
                inputStream = this.getClass().getClassLoader().getResourceAsStream(this.getConfigFile());
                inputSource = new InputSource(this.getClass().getClassLoader().getResource(this.getConfigFile()).toString());
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if (inputStream == null) {
            try {
                inputStream = this.getClass().getClassLoader().getResourceAsStream("server-embed.xml");
                inputSource = new InputSource(this.getClass().getClassLoader().getResource("server-embed.xml").toString());
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if (inputStream == null && file != null) {
            log.warn("Can't load server.xml from " + file.getAbsolutePath());
            return;
        }
        try {
            inputSource.setByteStream(inputStream);
            digester.push(this);
            digester.parse(inputSource);
            inputStream.close();
        }
        catch (Exception e) {
            log.warn("Catalina.start using " + this.getConfigFile() + ": ", e);
            return;
        }
        this.initStreams();
        if (this.server instanceof Lifecycle) {
            try {
                this.server.initialize();
            }
            catch (LifecycleException e) {
                log.error("Catalina.start", e);
            }
        }
        long t2 = System.nanoTime();
        if (log.isInfoEnabled()) {
            log.info("Initialization processed in " + (t2 - t1) / 1000000L + " ms");
        }
    }

    public void load(String[] args) {
        try {
            if (this.arguments(args)) {
                this.load();
            }
        }
        catch (Exception e) {
            e.printStackTrace(System.out);
        }
    }

    public void create() {
    }

    public void destroy() {
    }

    public void start() {
        if (this.server == null) {
            this.load();
        }
        long t1 = System.nanoTime();
        if (this.server instanceof Lifecycle) {
            try {
                ((Lifecycle)((Object)this.server)).start();
            }
            catch (LifecycleException e) {
                log.error("Catalina.start: ", e);
            }
        }
        long t2 = System.nanoTime();
        if (log.isInfoEnabled()) {
            log.info("Server startup in " + (t2 - t1) / 1000000L + " ms");
        }
        try {
            if (this.useShutdownHook) {
                if (this.shutdownHook == null) {
                    this.shutdownHook = new CatalinaShutdownHook();
                }
                Runtime.getRuntime().addShutdownHook(this.shutdownHook);
            }
        }
        catch (Throwable t) {
            // empty catch block
        }
        if (this.await) {
            this.await();
            this.stop();
        }
    }

    public void stop() {
        try {
            if (this.useShutdownHook) {
                Runtime.getRuntime().removeShutdownHook(this.shutdownHook);
            }
        }
        catch (Throwable t) {
            // empty catch block
        }
        if (this.server instanceof Lifecycle) {
            try {
                ((Lifecycle)((Object)this.server)).stop();
            }
            catch (LifecycleException e) {
                log.error("Catalina.stop", e);
            }
        }
    }

    public void await() {
        this.server.await();
    }

    protected void usage() {
        System.out.println("usage: java org.apache.catalina.startup.Catalina [ -config {pathname} ] [ -nonaming ] { start | stop }");
    }

    protected class CatalinaShutdownHook
    extends Thread {
        protected CatalinaShutdownHook() {
        }

        public void run() {
            if (Catalina.this.server != null) {
                Catalina.this.stop();
            }
        }
    }
}

