/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.web.tomcat6.ws;

import java.io.File;
import org.apache.catalina.Context;
import org.apache.catalina.Engine;
import org.apache.catalina.Host;
import org.apache.catalina.Service;
import org.apache.catalina.connector.Connector;
import org.apache.catalina.startup.ContextConfig;
import org.ow2.jonas.web.tomcat6.JOnASStandardContext;
import org.ow2.jonas.web.tomcat6.Tomcat6Service;
import org.ow2.jonas.web.tomcat6.ws.WebServiceEndpointStandardWrapper;
import org.ow2.jonas.ws.jaxws.IWebServiceDeploymentManager;
import org.ow2.jonas.ws.jaxws.IWebServiceEndpoint;
import org.ow2.jonas.ws.jaxws.WSException;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;

public class WSDeployment
implements IWebServiceDeploymentManager {
    private static Log logger = LogFactory.getLog(WSDeployment.class);
    private Tomcat6Service tomcatService;
    private String workDirectory;

    public WSDeployment(Tomcat6Service tomcatService) {
        this.tomcatService = tomcatService;
    }

    public void setWorkDirectory(String workDirectory) {
        this.workDirectory = workDirectory;
    }

    public void registerWSEndpoint(IWebServiceEndpoint endpoint) throws WSException {
        switch (endpoint.getType()) {
            case POJO: {
                throw new IllegalStateException("Not implemented yet");
            }
            case EJB: {
                this.registerEJBEndpoint(endpoint);
            }
        }
    }

    private void registerEJBEndpoint(IWebServiceEndpoint endpoint) throws WSException {
        Host host = this.tomcatService.findHost(endpoint.getPortMetaData().getHostname());
        WebServiceEndpointStandardWrapper wrapper = null;
        wrapper = new WebServiceEndpointStandardWrapper(endpoint);
        wrapper.setParentClassLoader(this.getClass().getClassLoader());
        logger.debug((Object)"Added Wrapper/Servlet: {0}", new Object[]{wrapper});
        JOnASStandardContext context = new JOnASStandardContext(false, true, false);
        context.setPath(WSDeployment.getContextRoot(endpoint));
        context.addChild(wrapper);
        String pattern = endpoint.getPortMetaData().getUrlPattern();
        context.addServletMapping(pattern, wrapper.getServletName());
        context.setTomcatService(this.tomcatService);
        File docBase = new File(this.workDirectory, endpoint.getPortMetaData().getContextRoot());
        if (!docBase.exists()) {
            docBase.mkdirs();
        }
        context.setDocBase(docBase.getPath());
        ContextConfig config = this.tomcatService.createContextConfig();
        context.addLifecycleListener(config);
        host.addChild(context);
        WSDeployment.computeEndpointURL(endpoint, host, pattern);
        logger.debug((Object)"Added Context: {0}", new Object[]{context});
    }

    private static void computeEndpointURL(IWebServiceEndpoint endpoint, Host host, String pattern) {
        String hostname = host.getName();
        Engine engine = (Engine)host.getParent();
        Service service = engine.getService();
        Connector[] connectors = service.findConnectors();
        Connector httpConnector = null;
        Connector httpsConnector = null;
        for (Connector connector : connectors) {
            String scheme = connector.getScheme();
            if ("https".equals(scheme)) {
                httpsConnector = connector;
            }
            if (!"http".equals(scheme)) continue;
            httpConnector = connector;
        }
        StringBuffer sb = new StringBuffer();
        if (httpConnector != null) {
            sb.append("http://");
            sb.append(hostname);
            sb.append(":");
            sb.append(httpConnector.getPort());
            sb.append(WSDeployment.getContextRoot(endpoint));
            sb.append(pattern);
            endpoint.getPortMetaData().setEndpointURL(sb.toString());
        } else if (httpsConnector != null) {
            sb.append("https://");
            sb.append(hostname);
            sb.append(":");
            sb.append(httpsConnector.getPort());
            sb.append(WSDeployment.getContextRoot(endpoint));
            sb.append(pattern);
            endpoint.getPortMetaData().setEndpointURL(sb.toString());
        }
    }

    protected static String getContextRoot(IWebServiceEndpoint endpoint) {
        return "/" + endpoint.getPortMetaData().getContextRoot();
    }

    public void unregisterWSEndpoint(IWebServiceEndpoint endpoint) throws WSException {
        switch (endpoint.getType()) {
            case POJO: {
                throw new IllegalStateException("Not implemented yet");
            }
            case EJB: {
                this.unregisterEJBEndpoint(endpoint);
            }
        }
    }

    private void unregisterEJBEndpoint(IWebServiceEndpoint endpoint) {
        String contextName = WSDeployment.getContextRoot(endpoint);
        String hostname = endpoint.getPortMetaData().getHostname();
        Host host = this.tomcatService.findHost(hostname);
        Context context = (Context)host.findChild(contextName);
        String path = context.getDocBase();
        File docBase = new File(path);
        if (docBase.isDirectory()) {
            docBase.delete();
        }
        host.removeChild(context);
        logger.debug((Object)"Context {0} stopped", new Object[]{contextName});
    }
}

