/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.cmi.lb.strategy;

import java.util.Comparator;
import org.ow2.cmi.controller.common.ClusterViewManager;
import org.ow2.cmi.lb.LoadBalanceable;
import org.ow2.cmi.reference.ServerNotFoundException;
import org.ow2.cmi.reference.ServerRef;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class LoadFactorComparator<T extends LoadBalanceable>
implements Comparator<T> {
    private static final Log LOGGER = LogFactory.getLog(LoadFactorComparator.class);
    private final ClusterViewManager clusterViewManager;

    public LoadFactorComparator(ClusterViewManager clusterViewManager) {
        this.clusterViewManager = clusterViewManager;
    }

    @Override
    public int compare(T loadBalanceable1, T loadBalanceable2) {
        ServerRef serverRef1 = loadBalanceable1.getServerRef();
        ServerRef serverRef2 = loadBalanceable2.getServerRef();
        try {
            int factor1 = this.clusterViewManager.getLoadFactor(serverRef1);
            int factor2 = this.clusterViewManager.getLoadFactor(serverRef2);
            return Integer.valueOf(factor1).compareTo(factor2);
        }
        catch (ServerNotFoundException e) {
            LOGGER.error((Object)"Cannot compare the load factors of servers {0} and {1}.", new Object[]{serverRef1, serverRef2, e});
            return 0;
        }
    }
}

