/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ws.sandbox.security.conversation.sessions;

import java.net.URL;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ws.sandbox.security.conversation.ConversationException;
import org.apache.ws.sandbox.security.conversation.ConversationSession;
import org.apache.ws.security.util.Loader;

public class SessionMonitor
extends Thread {
    private Log log = LogFactory.getLog((String)(class$org$apache$ws$sandbox$security$conversation$sessions$SessionMonitor == null ? (class$org$apache$ws$sandbox$security$conversation$sessions$SessionMonitor = SessionMonitor.class$("org.apache.ws.sandbox.security.conversation.sessions.SessionMonitor")) : class$org$apache$ws$sandbox$security$conversation$sessions$SessionMonitor).getName());
    private long sessionLifetime;
    private long reapPeriodicity;
    private Hashtable sessionTable;
    private Vector expiredSessions = new Vector();
    private long lastReaped = System.currentTimeMillis();
    static /* synthetic */ Class class$org$apache$ws$sandbox$security$conversation$sessions$SessionMonitor;

    public SessionMonitor(Hashtable sessionTable) throws ConversationException {
        try {
            Properties prop = this.getProperties("SessionMonitor.properties");
            this.reapPeriodicity = Long.parseLong(prop.getProperty("org.apache.ws.security.converasation.session.reapPeriodicity"));
            this.sessionLifetime = Long.parseLong(prop.getProperty("org.apache.ws.security.converasation.session.sessionLifetime"));
            this.log.debug((Object)("Reap periodicity from prop file: " + this.reapPeriodicity));
            this.log.debug((Object)("Session lifetime from prop file: " + this.sessionLifetime));
        }
        catch (Exception e) {
            this.log.debug((Object)"SessionMonitor: Cannot load SessionMonitor.properties using defaults: \norg.apache.ws.security.converasation.session.reapInterval=60000org.apache.ws.security.converasation.session.sessionLifetime1800000");
            this.reapPeriodicity = 60000L;
            this.sessionLifetime = 1800000L;
        }
        this.sessionTable = sessionTable;
        this.log.debug((Object)"Session monitor created");
    }

    private Properties getProperties(String propFilename) {
        Properties properties = new Properties();
        try {
            URL url = Loader.getResource(propFilename);
            properties.load(url.openStream());
            this.log.debug((Object)"SessionMonitor.properties found");
        }
        catch (Exception e) {
            this.log.debug((Object)("Cannot find SessionMonitor property file: " + propFilename));
            throw new RuntimeException("SessionMonitor: Cannot load properties: " + propFilename);
        }
        return properties;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        while (true) {
            long now = System.currentTimeMillis();
            this.log.debug((Object)("Diff: " + (now - (this.lastReaped + this.reapPeriodicity))));
            if (now > this.lastReaped + this.reapPeriodicity) {
                this.log.debug((Object)"Special:Ruchith:Waiting to get session");
                Hashtable hashtable = this.sessionTable;
                synchronized (hashtable) {
                    this.log.debug((Object)"Checking sessions");
                    Enumeration keys = this.sessionTable.keys();
                    while (keys.hasMoreElements()) {
                        ConversationSession session;
                        String tempId = (String)keys.nextElement();
                        ConversationSession conversationSession = session = (ConversationSession)this.sessionTable.get(tempId);
                        synchronized (conversationSession) {
                            this.log.debug((Object)("Session: " + tempId));
                            if (this.isExpirable(session)) {
                                this.expireSession(tempId);
                            }
                        }
                    }
                }
                this.lastReaped = now;
            }
            try {
                SessionMonitor.sleep(this.reapPeriodicity / 2L);
                continue;
            }
            catch (InterruptedException e) {
                this.log.debug((Object)e.getMessage());
                continue;
            }
            break;
        }
    }

    private boolean isExpirable(ConversationSession session) {
        long lastTouched = session.getLastTouched();
        return lastTouched + this.sessionLifetime < System.currentTimeMillis();
    }

    private void expireSession(String identifier) {
        this.log.debug((Object)("Expirign session " + identifier));
        this.sessionTable.remove(identifier);
        this.expiredSessions.add(identifier);
    }

    public Vector getExpiredSessionIds() {
        return (Vector)this.expiredSessions.clone();
    }

    public Hashtable getLiveSessions() {
        return (Hashtable)this.sessionTable.clone();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

