/*
 * Decompiled with CFR 0.152.
 */
package wssec;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.Vector;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.xml.soap.SOAPMessage;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import org.apache.axis.AxisEngine;
import org.apache.axis.EngineConfiguration;
import org.apache.axis.Message;
import org.apache.axis.MessageContext;
import org.apache.axis.client.AxisClient;
import org.apache.axis.configuration.NullProvider;
import org.apache.axis.message.SOAPEnvelope;
import org.apache.axis.utils.XMLUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ws.security.WSEncryptionPart;
import org.apache.ws.security.WSPasswordCallback;
import org.apache.ws.security.WSSecurityEngine;
import org.apache.ws.security.components.crypto.Crypto;
import org.apache.ws.security.components.crypto.CryptoFactory;
import org.apache.ws.security.message.WSEncryptBody;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import wssec.SOAPUtil;

public class TestWSSecurity2
extends TestCase
implements CallbackHandler {
    private static Log log = LogFactory.getLog((Class)(class$wssec$TestWSSecurity2 == null ? (class$wssec$TestWSSecurity2 = TestWSSecurity2.class$("wssec.TestWSSecurity2")) : class$wssec$TestWSSecurity2));
    static final String soapMsg = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><soapenv:Envelope xmlns:soapenv=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\">   <soapenv:Body>      <ns1:testMethod xmlns:ns1=\"uri:LogTestService2\"></ns1:testMethod>   </soapenv:Body></soapenv:Envelope>";
    static final WSSecurityEngine secEngine = new WSSecurityEngine();
    static final Crypto crypto = CryptoFactory.getInstance("cryptoSKI.properties");
    MessageContext msgContext;
    Message message;
    static /* synthetic */ Class class$wssec$TestWSSecurity2;

    public TestWSSecurity2(String name) {
        super(name);
    }

    public static Test suite() {
        return new TestSuite(class$wssec$TestWSSecurity2 == null ? (class$wssec$TestWSSecurity2 = TestWSSecurity2.class$("wssec.TestWSSecurity2")) : class$wssec$TestWSSecurity2);
    }

    public static void main(String[] args) {
        TestRunner.run((Test)TestWSSecurity2.suite());
    }

    protected void setUp() throws Exception {
        AxisClient tmpEngine = new AxisClient((EngineConfiguration)new NullProvider());
        this.msgContext = new MessageContext((AxisEngine)tmpEngine);
        this.message = this.getSOAPMessage();
    }

    protected Message getSOAPMessage() throws Exception {
        ByteArrayInputStream in = new ByteArrayInputStream(soapMsg.getBytes());
        Message msg = new Message((Object)in);
        msg.setMessageContext(this.msgContext);
        return msg;
    }

    public void testEncryptionDecryptionRSA15() throws Exception {
        String encryptedString;
        SOAPEnvelope unsignedEnvelope = this.message.getSOAPEnvelope();
        Object envelope = null;
        WSEncryptBody builder = new WSEncryptBody();
        builder.setUserInfo("wss4jcert");
        builder.setKeyIdentifierType(3);
        Document doc = unsignedEnvelope.getAsDocument();
        log.info((Object)"Before Encryption Triple DES....");
        Document encryptedDoc = builder.build(doc, crypto);
        log.info((Object)"After Encryption Triple DES....");
        Message encryptedMsg = (Message)SOAPUtil.toSOAPMessage(encryptedDoc);
        if (log.isDebugEnabled()) {
            log.debug((Object)"Encrypted message, RSA-15 keytransport, 3DES:");
            XMLUtils.PrettyElementToWriter((Element)encryptedMsg.getSOAPEnvelope().getAsDOM(), (Writer)new PrintWriter(System.out));
        }
        TestWSSecurity2.assertTrue(((encryptedString = encryptedMsg.getSOAPPartAsString()).indexOf("LogTestService2") == -1 ? 1 : 0) != 0);
        encryptedDoc = encryptedMsg.getSOAPEnvelope().getAsDocument();
        this.verify(encryptedDoc);
        this.message = this.getSOAPMessage();
        builder.setKeyIdentifierType(2);
        builder.setSymmetricEncAlgorithm("http://www.w3.org/2001/04/xmlenc#aes128-cbc");
        Vector<WSEncryptionPart> parts = new Vector<WSEncryptionPart>();
        WSEncryptionPart encP = new WSEncryptionPart("testMethod", "uri:LogTestService2", "Element");
        parts.add(encP);
        builder.setParts(parts);
        unsignedEnvelope = this.message.getSOAPEnvelope();
        doc = unsignedEnvelope.getAsDocument();
        log.info((Object)"Before Encryption AES 128/RSA-15....");
        encryptedDoc = builder.build(doc, crypto);
        log.info((Object)"After Encryption AES 128/RSA-15....");
        encryptedMsg = (Message)SOAPUtil.toSOAPMessage(encryptedDoc);
        if (log.isDebugEnabled()) {
            log.debug((Object)"Encrypted message, RSA-15 keytransport, AES 128:");
            XMLUtils.PrettyElementToWriter((Element)encryptedMsg.getSOAPEnvelope().getAsDOM(), (Writer)new PrintWriter(System.out));
        }
        TestWSSecurity2.assertTrue(((encryptedString = encryptedMsg.getSOAPPartAsString()).indexOf("LogTestService2") == -1 ? 1 : 0) != 0);
        encryptedDoc = encryptedMsg.getSOAPEnvelope().getAsDocument();
        this.verify(encryptedDoc);
    }

    public void testEncryptionDecryptionOAEP() throws Exception {
        String encryptedString;
        SOAPEnvelope unsignedEnvelope = this.message.getSOAPEnvelope();
        Object envelope = null;
        WSEncryptBody builder = new WSEncryptBody();
        builder.setUserInfo("wss4jcert");
        builder.setKeyIdentifierType(3);
        builder.setKeyEnc("http://www.w3.org/2001/04/xmlenc#rsa-oaep-mgf1p");
        Document doc = unsignedEnvelope.getAsDocument();
        log.info((Object)"Before Encryption Triple DES/RSA-OAEP....");
        Document encryptedDoc = builder.build(doc, crypto);
        log.info((Object)"After Encryption Triple DES/RSA-OAEP....");
        Message encryptedMsg = (Message)SOAPUtil.toSOAPMessage(encryptedDoc);
        if (log.isDebugEnabled()) {
            log.debug((Object)"Encrypted message, RSA-OAEP keytransport, 3DES:");
            XMLUtils.PrettyElementToWriter((Element)encryptedMsg.getSOAPEnvelope().getAsDOM(), (Writer)new PrintWriter(System.out));
        }
        TestWSSecurity2.assertTrue(((encryptedString = encryptedMsg.getSOAPPartAsString()).indexOf("LogTestService2") == -1 ? 1 : 0) != 0);
        encryptedDoc = encryptedMsg.getSOAPEnvelope().getAsDocument();
        this.verify(encryptedDoc);
    }

    private void verify(Document doc) throws Exception {
        secEngine.processSecurityHeader(doc, null, this, crypto);
        SOAPUtil.updateSOAPMessage(doc, (SOAPMessage)this.message);
        String decryptedString = this.message.getSOAPPartAsString();
        TestWSSecurity2.assertTrue((decryptedString.indexOf("LogTestService2") > 0 ? 1 : 0) != 0);
    }

    public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
        for (int i = 0; i < callbacks.length; ++i) {
            if (!(callbacks[i] instanceof WSPasswordCallback)) {
                throw new UnsupportedCallbackException(callbacks[i], "Unrecognized Callback");
            }
            WSPasswordCallback pc = (WSPasswordCallback)callbacks[i];
            pc.setPassword("security");
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

