/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.lib.management.extensions.domain;

import java.util.ArrayList;
import java.util.Set;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.ow2.jonas.lib.management.extensions.base.BaseManagement;
import org.ow2.jonas.lib.management.extensions.base.BaseObjectName;
import org.ow2.jonas.lib.management.javaee.J2eeObjectName;
import org.ow2.jonas.lib.management.tools.ManagementRepr;
import org.ow2.jonas.lib.util.JonasObjectName;
import org.ow2.jonas.management.extensions.domain.api.IDomain;

public class DomainManagement
extends BaseManagement
implements IDomain {
    private static final String javaVMsAttribute = "javaVMs";
    private static final String nodeAttribute = "node";
    private static final String masterAttribute = "master";
    private static final String serverNamesAttribute = "serverNames";
    private static final String clustersAttribute = "clusters";
    private static final String clusterDaemonsAttribute = "clusterDaemons";
    private static final String portKey = "port";
    private static final String protocolAttribute = "protocol";
    private static final String httProtocol = "HTTP";
    private ObjectName domainOn = J2eeObjectName.J2EEDomain((String)this.getDomainName());
    private ObjectName serverOn = J2eeObjectName.J2EEServer((String)this.getDomainName(), (String)this.getServerName());

    public String getServerHost() {
        String[] jvms = (String[])ManagementRepr.getAttribute((ObjectName)this.serverOn, (String)javaVMsAttribute, (String)this.getServerName());
        ObjectName jvmOn = null;
        try {
            jvmOn = ObjectName.getInstance(jvms[0]);
        }
        catch (MalformedObjectNameException e) {
            e.printStackTrace();
            return null;
        }
        catch (NullPointerException e) {
            e.printStackTrace();
            return null;
        }
        return (String)ManagementRepr.getAttribute((ObjectName)jvmOn, (String)nodeAttribute, (String)this.getServerName());
    }

    public String getServerPort() {
        try {
            ObjectName connectorOns = BaseObjectName.catalinaConnectors(this.getDomainName());
            Set connectorOnSet = ManagementRepr.queryNames((ObjectName)connectorOns, (String)this.getServerName());
            if (!connectorOnSet.isEmpty()) {
                for (ObjectName connectorOn : connectorOnSet) {
                    if (connectorOnSet.size() == 1) {
                        return connectorOn.getKeyProperty(portKey);
                    }
                    String protocol = (String)ManagementRepr.getAttribute((ObjectName)connectorOn, (String)protocolAttribute, (String)this.getServerName());
                    if (!protocol.contains(httProtocol)) continue;
                    return connectorOn.getKeyProperty(portKey);
                }
            }
        }
        catch (MalformedObjectNameException e) {
            e.printStackTrace();
        }
        return "9600";
    }

    public boolean isMaster(String pServer) {
        return (Boolean)ManagementRepr.getAttribute((ObjectName)this.domainOn, (String)masterAttribute, (String)pServer);
    }

    public boolean isMaster() {
        return (Boolean)ManagementRepr.getAttribute((ObjectName)this.domainOn, (String)masterAttribute, (String)this.getServerName());
    }

    public String[] getServerNames() {
        return (String[])ManagementRepr.getAttribute((ObjectName)this.domainOn, (String)serverNamesAttribute, (String)this.getServerName());
    }

    public String[] getClustersNames() {
        String[] clusters = this.getClusters();
        return this.getKeyValues(clusters, "name");
    }

    public String[] getClusterDaemonNames() {
        String[] cdm = this.getclusterDaemons();
        return this.getKeyValues(cdm, "name");
    }

    public String[] getClusters() {
        String[] allClusters = (String[])ManagementRepr.getAttribute((ObjectName)this.domainOn, (String)clustersAttribute, (String)this.getServerName());
        String[] allClusterNames = this.getKeyValues(allClusters, "name");
        String[] clusters = new String[allClusters.length - 1];
        int j = 0;
        for (int i = 0; i < allClusters.length; ++i) {
            if (this.getDomainName().equals(allClusterNames[i])) continue;
            clusters[j++] = allClusters[i];
        }
        return clusters;
    }

    public String[] getclusterDaemons() {
        return (String[])ManagementRepr.getAttribute((ObjectName)this.domainOn, (String)clusterDaemonsAttribute, (String)this.getServerName());
    }

    public void addServer(String serverName, String connector, String userName, String password, String clusterDaemon) {
        if (clusterDaemon == null || clusterDaemon.length() < 1) {
            clusterDaemon = null;
        }
        if (userName == null || password == null || userName.length() < 1 || password.length() < 1) {
            userName = null;
            password = null;
        }
        String currentServerName = this.getServerName();
        String domainName = this.getDomainName();
        String clusterType = "LogicalCluster";
        ObjectName on = null;
        try {
            on = JonasObjectName.cluster((String)domainName, (String)domainName, (String)clusterType);
        }
        catch (MalformedObjectNameException e) {
            e.printStackTrace();
        }
        String[] signature = new String[]{"java.lang.String", "[Ljava.lang.String;", "java.lang.String", "java.lang.String", "java.lang.String"};
        Object[] params = new Object[5];
        if (serverName != null) {
            String[] urls;
            params[0] = serverName;
            params[1] = urls = new String[]{connector};
            params[2] = clusterDaemon;
            params[3] = userName;
            params[4] = password;
            ManagementRepr.invoke((ObjectName)on, (String)"addServer", (Object[])params, (String[])signature, (String)currentServerName);
        }
    }

    public void removeServers(String[] serversToRemove) {
        ObjectName clOn;
        String currentServerName = this.getServerName();
        String domainName = this.getDomainName();
        ArrayList<ObjectName> removeClOns = new ArrayList<ObjectName>();
        String[] clusters = this.getClusters();
        for (int i = 0; i < clusters.length; ++i) {
            String type = this.getKeyValue(clusters[i], "type");
            String name = this.getKeyValue(clusters[i], "name");
            if (!"LogicalCluster".equals(type) || domainName.equals(name)) continue;
            clOn = null;
            try {
                clOn = ObjectName.getInstance(clusters[i]);
            }
            catch (MalformedObjectNameException e) {
                e.printStackTrace();
                continue;
            }
            catch (NullPointerException e) {
                e.printStackTrace();
                continue;
            }
            removeClOns.add(clOn);
        }
        try {
            ObjectName on = JonasObjectName.cluster((String)domainName, (String)domainName, (String)"LogicalCluster");
            removeClOns.add(on);
        }
        catch (MalformedObjectNameException e) {
            e.printStackTrace();
        }
        for (int j = 0; j < serversToRemove.length; ++j) {
            String serverName = serversToRemove[j];
            for (int i = 0; i < removeClOns.size(); ++i) {
                clOn = (ObjectName)removeClOns.get(i);
                String[] signature = new String[]{"java.lang.String"};
                Object[] params = new String[]{serverName};
                ManagementRepr.invoke((ObjectName)clOn, (String)"removeServer", (Object[])params, (String[])signature, (String)currentServerName);
            }
        }
    }

    public void addCluster(String clusterName) {
        ObjectName domainOn = J2eeObjectName.J2EEDomain((String)this.getDomainName());
        String serverName = this.getServerName();
        String[] signature = new String[]{"java.lang.String"};
        Object[] params = new String[]{clusterName};
        signature[0] = "java.lang.String";
        ManagementRepr.invoke((ObjectName)domainOn, (String)"createCluster", (Object[])params, (String[])signature, (String)serverName);
    }

    public String getServerState(String serverName) {
        String operation = "getServerState";
        Object[] param = new Object[]{serverName};
        String[] signature = new String[]{"java.lang.String"};
        return (String)ManagementRepr.invoke((ObjectName)this.domainOn, (String)operation, (Object[])param, (String[])signature, (String)this.getServerName());
    }

    public String getServerClusterdaemon(String serverName) {
        String operation = "getServerClusterdaemon";
        Object[] param = new Object[]{serverName};
        String[] signature = new String[]{"java.lang.String"};
        return (String)ManagementRepr.invoke((ObjectName)this.domainOn, (String)operation, (Object[])param, (String[])signature, (String)this.getServerName());
    }

    public void startServer(String serverName) {
        String currentServerName = this.getServerName();
        String domainName = this.getDomainName();
        ObjectName on = null;
        try {
            on = JonasObjectName.serverProxy((String)domainName, (String)serverName);
        }
        catch (MalformedObjectNameException e) {
            e.printStackTrace();
        }
        ManagementRepr.invoke((ObjectName)on, (String)"startit", null, null, (String)currentServerName);
    }

    public void stopServer(String serverName) {
        String currentServerName = this.getServerName();
        String domainName = this.getDomainName();
        ObjectName on = null;
        try {
            on = JonasObjectName.serverProxy((String)domainName, (String)serverName);
        }
        catch (MalformedObjectNameException e) {
            e.printStackTrace();
        }
        ManagementRepr.invoke((ObjectName)on, (String)"stopit", null, null, (String)currentServerName);
    }

    public void haltServer(String serverName) {
        String currentServerName = this.getServerName();
        String domainName = this.getDomainName();
        ObjectName on = null;
        try {
            on = JonasObjectName.serverProxy((String)domainName, (String)serverName);
        }
        catch (MalformedObjectNameException e) {
            e.printStackTrace();
        }
        ManagementRepr.invoke((ObjectName)on, (String)"haltit", null, null, (String)currentServerName);
    }

    public String getClusterState(String clusterName) {
        String operation = "getClusterState";
        Object[] param = new Object[]{clusterName};
        String[] signature = new String[]{"java.lang.String"};
        return (String)ManagementRepr.invoke((ObjectName)this.domainOn, (String)operation, (Object[])param, (String[])signature, (String)this.getServerName());
    }

    public String getClusterType(String clusterName) {
        String operation = "getClusterType";
        Object[] param = new Object[]{clusterName};
        String[] signature = new String[]{"java.lang.String"};
        return (String)ManagementRepr.invoke((ObjectName)this.domainOn, (String)operation, (Object[])param, (String[])signature, (String)this.getServerName());
    }

    public String[] getServerNames(String clusterName) {
        String operation = "getServersInCluster";
        Object[] param = new Object[]{clusterName};
        String[] signature = new String[]{"java.lang.String"};
        return (String[])ManagementRepr.invoke((ObjectName)this.domainOn, (String)operation, (Object[])param, (String[])signature, (String)this.getServerName());
    }

    public String getClusterdaemonState(String clusterDaemonName) {
        String operation = "getClusterdaemonState";
        Object[] param = new Object[]{clusterDaemonName};
        String[] signature = new String[]{"java.lang.String"};
        return (String)ManagementRepr.invoke((ObjectName)this.domainOn, (String)operation, (Object[])param, (String[])signature, (String)this.getServerName());
    }

    public String[] getServersNotInCluster(String clusterName) {
        Object[] asParam = new Object[]{clusterName};
        String[] asSignature = new String[]{"java.lang.String"};
        String[] serverNames = (String[])ManagementRepr.invoke((ObjectName)this.domainOn, (String)"getServersNotInCluster", (Object[])asParam, (String[])asSignature, (String)this.getServerName());
        return serverNames;
    }
}

