/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.ws.cxf.easybeans.ext;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.wsdl.Definition;
import javax.wsdl.Port;
import javax.wsdl.Service;
import javax.wsdl.WSDLException;
import javax.wsdl.extensions.soap.SOAPAddress;
import javax.wsdl.extensions.soap12.SOAP12Address;
import javax.xml.namespace.QName;
import org.apache.cxf.Bus;
import org.apache.cxf.jaxws.support.JaxWsImplementorInfo;
import org.apache.cxf.jaxws.support.JaxWsServiceFactoryBean;
import org.apache.cxf.resource.ClassLoaderResolver;
import org.apache.cxf.resource.ResourceManager;
import org.apache.cxf.resource.ResourceResolver;
import org.apache.cxf.wsdl.WSDLManager;
import org.objectweb.util.monolog.api.BasicLevel;
import org.objectweb.util.monolog.api.Level;
import org.ow2.easybeans.api.EZBContainerCallbackInfo;
import org.ow2.easybeans.api.Factory;
import org.ow2.easybeans.api.bean.info.IBeanInfo;
import org.ow2.easybeans.api.bean.info.IWebServiceInfo;
import org.ow2.easybeans.container.EmptyLifeCycleCallBack;
import org.ow2.easybeans.container.session.stateless.StatelessSessionFactory;
import org.ow2.jonas.lib.util.Log;
import org.ow2.jonas.ws.cxf.BusCreator;
import org.ow2.jonas.ws.cxf.JOnASJaxWsImplementorInfo;
import org.ow2.jonas.ws.cxf.easybeans.EasyBeansEndpoint;
import org.ow2.jonas.ws.cxf.easybeans.EasyBeansJaxWsServerFactoryBean;
import org.ow2.jonas.ws.cxf.http.JOnASDestination;
import org.ow2.jonas.ws.cxf.jaxws.CXFWSEndpoint;
import org.ow2.jonas.ws.jaxws.IWebServiceDeploymentManager;
import org.ow2.jonas.ws.jaxws.IWebServiceEndpoint;
import org.ow2.jonas.ws.jaxws.PortMetaData;
import org.ow2.jonas.ws.jaxws.WSException;
import org.ow2.jonas.ws.jaxws.util.JAXWSClassUtils;
import org.ow2.jonas.ws.publish.PublicationInfo;
import org.ow2.jonas.ws.publish.WSDLPublisherException;
import org.ow2.jonas.ws.publish.WSDLPublisherManager;
import org.ow2.util.log.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LifeCycleCallback
extends EmptyLifeCycleCallBack {
    private static org.ow2.util.log.Log logger = LogFactory.getLog(LifeCycleCallback.class);
    private Bus bus = null;
    private IWebServiceDeploymentManager manager;
    private List<IWebServiceEndpoint> endpoints = new ArrayList<IWebServiceEndpoint>();
    private WSDLPublisherManager publisherManager;

    public void setManager(IWebServiceDeploymentManager manager) {
        this.manager = manager;
    }

    public void start(EZBContainerCallbackInfo info) {
        Map factories = info.getFactories();
        for (Factory f : factories.values()) {
            StatelessSessionFactory factory;
            Class klass;
            if (!(f instanceof StatelessSessionFactory) || !JAXWSClassUtils.isWebService((Class)(klass = (factory = (StatelessSessionFactory)f).getBeanClass()))) continue;
            if (this.bus == null) {
                BusCreator creator = new BusCreator();
                this.bus = creator.initBus();
            }
            IBeanInfo beanInfo = factory.getBeanInfo();
            IWebServiceInfo webServiceInfo = beanInfo.getWebServiceInfo();
            PortMetaData pmd = new PortMetaData();
            String contextRoot = LifeCycleCallback.extractContextRoot(info.getArchive().getName());
            pmd.setContextRoot(contextRoot);
            EasyBeansEndpoint easybeansEndpoint = this.createEasyBeansEndpoint(factory, klass, webServiceInfo);
            JaxWsImplementorInfo jaxWsInfo = easybeansEndpoint.getServiceFactory().getJaxWsImplementorInfo();
            String pattern = null;
            if (webServiceInfo != null && webServiceInfo.getEndpointAddress() != null) {
                pattern = webServiceInfo.getEndpointAddress();
                if (!pattern.startsWith("/")) {
                    pattern = "/" + pattern;
                }
            } else {
                String serviceName = jaxWsInfo.getServiceName().getLocalPart();
                pattern = !"".equals(serviceName) ? "/" + serviceName : "/" + klass.getSimpleName() + "Service";
            }
            pmd.setUrlPattern(pattern);
            logger.info((Object)"{0}", new Object[]{pmd});
            CXFWSEndpoint endpoint = new CXFWSEndpoint(easybeansEndpoint, IWebServiceEndpoint.EndpointType.EJB, pmd);
            try {
                this.manager.registerWSEndpoint((IWebServiceEndpoint)endpoint);
            }
            catch (WSException e) {
                logger.error((Object)"Unable to register endpoint {0}", new Object[]{endpoint, e});
                try {
                    this.manager.unregisterWSEndpoint((IWebServiceEndpoint)endpoint);
                }
                catch (WSException e1) {
                    logger.error((Object)"Unable to unregister endpoint {0} after a failed deployment", new Object[]{endpoint, e});
                }
                throw new RuntimeException("Endpoint not deployed completely", e);
            }
            endpoint.start();
            this.publishWSDL(endpoint, jaxWsInfo, webServiceInfo);
            this.endpoints.add(endpoint);
            logger.info((Object)"Endpoint {0} inited", new Object[]{klass.getName()});
        }
    }

    private void publishWSDL(CXFWSEndpoint endpoint, JaxWsImplementorInfo info, IWebServiceInfo webServiceInfo) {
        PublicationInfo publicationInfo = new PublicationInfo();
        publicationInfo.setOriginalWsdlFilename(info.getWsdlLocation());
        if (webServiceInfo != null && webServiceInfo.getWsdlPublicationDirectory() != null) {
            File directory = new File(webServiceInfo.getWsdlPublicationDirectory());
            publicationInfo.setPublicationDirectory(directory);
        }
        JOnASDestination destination = endpoint.getDestination();
        Bus bus = destination.getBus();
        WSDLManager wsdlManager = (WSDLManager)bus.getExtension(WSDLManager.class);
        try {
            Definition definition = wsdlManager.getDefinition(info.getWsdlLocation());
            this.updateDefinition(definition, info, endpoint.getPortMetaData());
            this.publisherManager.publish(definition, publicationInfo);
        }
        catch (WSDLPublisherException e) {
            logger.error((Object)"Unable to publish WSDL of endpoint {0}", new Object[]{endpoint, e});
        }
        catch (WSDLException e) {
            logger.error((Object)"Unable to load WSDL of endpoint {0}", new Object[]{endpoint, e});
        }
    }

    private void updateDefinition(Definition definition, JaxWsImplementorInfo info, PortMetaData portMetaData) {
        QName serviceName = info.getServiceName();
        QName portName = info.getEndpointName();
        Service service = definition.getService(serviceName);
        Port port = service.getPort(portName.getLocalPart());
        if (portMetaData.getEndpointURL() != null) {
            this.updateSoapAddressLocation(port, portMetaData.getEndpointURL());
        }
    }

    private void updateSoapAddressLocation(Port port, String url) {
        List extensions = port.getExtensibilityElements();
        for (Object extension : extensions) {
            if (extension instanceof SOAP12Address) {
                ((SOAP12Address)extension).setLocationURI(url);
                continue;
            }
            if (!(extension instanceof SOAPAddress)) continue;
            ((SOAPAddress)extension).setLocationURI(url);
        }
    }

    private static String extractContextRoot(String filename) {
        String context = filename.substring(filename.lastIndexOf(File.separator) + 1);
        context = context.substring(0, context.lastIndexOf(46));
        return context;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private EasyBeansEndpoint createEasyBeansEndpoint(StatelessSessionFactory factory, Class<?> klass, IWebServiceInfo info) {
        JaxWsImplementorInfo jaxWsImplementorInfo = info != null ? new JOnASJaxWsImplementorInfo(klass, info) : new JaxWsImplementorInfo(klass);
        JaxWsServiceFactoryBean jaxWsServiceFactoryBean = new JaxWsServiceFactoryBean(jaxWsImplementorInfo);
        jaxWsServiceFactoryBean.setBus(this.bus);
        ResourceManager manager = (ResourceManager)this.bus.getExtension(ResourceManager.class);
        manager.addResourceResolver((ResourceResolver)new ClassLoaderResolver(klass.getClassLoader()));
        ClassLoader old = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(Bus.class.getClassLoader());
            jaxWsServiceFactoryBean.create();
            Object var9_8 = null;
            Thread.currentThread().setContextClassLoader(old);
        }
        catch (Throwable throwable) {
            Object var9_9 = null;
            Thread.currentThread().setContextClassLoader(old);
            throw throwable;
        }
        EasyBeansJaxWsServerFactoryBean factoryBean = new EasyBeansJaxWsServerFactoryBean(jaxWsServiceFactoryBean, factory);
        EasyBeansEndpoint endpoint = new EasyBeansEndpoint(factory, this.bus, factoryBean);
        endpoint.setServiceFactory(jaxWsServiceFactoryBean);
        HashMap<String, QName> properties = new HashMap<String, QName>();
        if (jaxWsImplementorInfo.getServiceName() != null) {
            properties.put("javax.xml.ws.wsdl.service", jaxWsImplementorInfo.getServiceName());
        }
        if (jaxWsImplementorInfo.getEndpointName() != null) {
            properties.put("javax.xml.ws.wsdl.port", jaxWsImplementorInfo.getEndpointName());
        }
        endpoint.setProperties(properties);
        return endpoint;
    }

    public void stop(EZBContainerCallbackInfo info) {
        this.stop();
        logger.info((Object)("Bus stopped for " + info.getArchive()), new Object[0]);
    }

    public void stop() {
        ArrayList<WSException> exceptions = new ArrayList<WSException>();
        for (IWebServiceEndpoint endpoint : this.endpoints) {
            try {
                endpoint.stop();
                this.manager.unregisterWSEndpoint(endpoint);
            }
            catch (WSException e) {
                exceptions.add(e);
            }
        }
        this.endpoints.clear();
        if (this.bus != null) {
            Level old = Log.setComponentLogLevel((String)"org.apache.cxf", (Level)BasicLevel.LEVEL_ERROR);
            Level old2 = Log.setComponentLogLevel((String)"org.springframework", (Level)BasicLevel.LEVEL_ERROR);
            this.bus.shutdown(true);
            this.bus = null;
            Log.setComponentLogLevel((String)"org.apache.cxf", (Level)old);
            Log.setComponentLogLevel((String)"org.springframework", (Level)old2);
        }
        for (WSException exception : exceptions) {
            logger.warn((Object)"Unable to stop/unregister endpoint", new Object[]{exception});
        }
    }

    public void setWSDLPublisherManager(WSDLPublisherManager publisherManager) {
        this.publisherManager = publisherManager;
    }
}

