/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.ipojo.handlers.dependency;

import java.util.Iterator;
import java.util.List;
import org.apache.felix.ipojo.Handler;
import org.apache.felix.ipojo.architecture.HandlerDescription;
import org.apache.felix.ipojo.handlers.dependency.DependencyDescription;
import org.apache.felix.ipojo.metadata.Attribute;
import org.apache.felix.ipojo.metadata.Element;
import org.osgi.framework.ServiceReference;

public class DependencyHandlerDescription
extends HandlerDescription {
    private DependencyDescription[] m_dependencies = new DependencyDescription[0];

    public DependencyHandlerDescription(Handler handler) {
        super(handler);
    }

    public DependencyDescription[] getDependencies() {
        return this.m_dependencies;
    }

    public void addDependency(DependencyDescription dep) {
        for (int i = 0; i < this.m_dependencies.length; ++i) {
            if (this.m_dependencies[i] != dep) continue;
            return;
        }
        DependencyDescription[] newDep = new DependencyDescription[this.m_dependencies.length + 1];
        System.arraycopy(this.m_dependencies, 0, newDep, 0, this.m_dependencies.length);
        newDep[this.m_dependencies.length] = dep;
        this.m_dependencies = newDep;
    }

    public Element getHandlerInfo() {
        Element deps = super.getHandlerInfo();
        for (int i = 0; i < this.m_dependencies.length; ++i) {
            String state = "resolved";
            if (this.m_dependencies[i].getState() == 0) {
                state = "unresolved";
            }
            if (this.m_dependencies[i].getState() == -1) {
                state = "broken";
            }
            Element dep = new Element("Requires", "");
            dep.addAttribute(new Attribute("Specification", this.m_dependencies[i].getInterface()));
            if (this.m_dependencies[i].getFilter() != null) {
                dep.addAttribute(new Attribute("Filter", this.m_dependencies[i].getFilter()));
            }
            if (this.m_dependencies[i].isOptional()) {
                dep.addAttribute(new Attribute("Optional", "true"));
                if (this.m_dependencies[i].supportsNullable()) {
                    dep.addAttribute(new Attribute("Nullable", "true"));
                }
                if (this.m_dependencies[i].getDefaultImplementation() != null) {
                    dep.addAttribute(new Attribute("Default-Implementation", this.m_dependencies[i].getDefaultImplementation()));
                }
            } else {
                dep.addAttribute(new Attribute("Optional", "false"));
            }
            if (this.m_dependencies[i].isMultiple()) {
                dep.addAttribute(new Attribute("Aggregate", "true"));
            } else {
                dep.addAttribute(new Attribute("Aggregate", "false"));
            }
            String policy = "dynamic";
            if (this.m_dependencies[i].getPolicy() == 1) {
                policy = "static";
            } else if (this.m_dependencies[i].getPolicy() == 2) {
                policy = "dynamic-priority";
            }
            dep.addAttribute(new Attribute("Binding-Policy", policy));
            if (this.m_dependencies[i].getComparator() != null) {
                dep.addAttribute(new Attribute("Comparator", this.m_dependencies[i].getComparator()));
            }
            dep.addAttribute(new Attribute("State", state));
            List set = this.m_dependencies[i].getUsedServices();
            if (set != null) {
                Iterator iterator = set.iterator();
                while (iterator.hasNext()) {
                    Element use = new Element("Uses", "");
                    ServiceReference ref = (ServiceReference)iterator.next();
                    use.addAttribute(new Attribute("service.id", ref.getProperty("service.id").toString()));
                    String instance = (String)ref.getProperty("instance.name");
                    if (instance != null) {
                        use.addAttribute(new Attribute("instance.name", instance));
                    }
                    dep.addElement(use);
                }
            }
            deps.addElement(dep);
        }
        return deps;
    }
}

