/*
 * Decompiled with CFR 0.152.
 */
package aQute.bnd.build;

import aQute.bnd.build.Project;
import aQute.bnd.build.Workspace;
import aQute.lib.osgi.Processor;
import java.io.File;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Pattern;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Framework
extends Processor {
    String framework;
    final List<File> jars = new ArrayList<File>();
    final List<File> bundles = new ArrayList<File>();
    final List<String> systemPackages = new ArrayList<String>();
    private Bundle systemBundle;
    File configDir;
    boolean prepared;
    final Project project;

    public static Framework getInstance() throws Exception {
        Project project;
        String override = System.getProperty("aQute.bnd.project.override");
        if (override == null) {
            project = Workspace.getProject(new File(""));
            if (project == null || !project.getPropertiesFile().isFile()) {
                throw new IllegalArgumentException("Default directory is not a valid project, missing: " + project + " (" + new File("").getAbsolutePath() + ")");
            }
        } else {
            File file = Processor.getFile(new File(""), override);
            if (!file.isFile()) {
                throw new IllegalArgumentException("Override file does not exist (or is dir): " + override);
            }
            Project project2 = Project.getUnparented(file);
            Framework framework = new Framework(project2);
            return framework;
        }
        Framework framework = new Framework(project);
        if (framework.getErrors().size() > 0) {
            throw new IllegalArgumentException("Errors: " + framework.getErrors());
        }
        for (String w : framework.getWarnings()) {
            System.out.println("warning: " + w);
        }
        return framework;
    }

    void prepare() {
        if (!this.prepared) {
            this.prepared = true;
            Map<String, Map<String, String>> testpath = this.parseHeader(this.getProperty("-runpath"));
            for (Map.Entry<String, Map<String, String>> entry : testpath.entrySet()) {
                File f;
                String path = entry.getKey();
                Map<String, String> attrs = entry.getValue();
                if (attrs.containsKey("framework")) {
                    this.setFramework(attrs.get("framework"));
                }
                if (attrs.containsKey("exports")) {
                    String[] exports;
                    String[] stringArray = exports = attrs.get("exports").split("\\s*,\\s*");
                    int n = exports.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String export = stringArray[n2];
                        this.addSystemPackage(export);
                        ++n2;
                    }
                }
                if (!(f = new File(path)).exists()) {
                    this.error("No such file on test path " + f);
                    continue;
                }
                this.addJar(f);
            }
            Map<String, Map<String, String>> testbundles = this.parseHeader(this.getProperty("-runbundles"));
            for (Map.Entry entry : testbundles.entrySet()) {
                String path = (String)entry.getKey();
                this.addBundle(new File(path));
            }
            Map<String, Map<String, String>> map = this.parseHeader(this.getProperty("-runexports"));
            for (Map.Entry<String, Map<String, String>> entry : map.entrySet()) {
                StringBuffer sb = new StringBuffer();
                sb.append(entry.getKey());
                Framework.printClause(entry.getValue(), null, sb);
                this.addSystemPackage(sb.toString());
            }
        }
        if (this.project != null) {
            this.getInfo(this.project);
        }
    }

    public Framework(Project parent) {
        super(parent);
        this.systemPackages.add("org.osgi.framework");
        this.project = parent;
    }

    public Framework() throws Exception {
        this.systemPackages.add("org.osgi.framework");
        File cwd = new File("").getAbsoluteFile();
        this.project = new Project(new Workspace(cwd.getParentFile()), cwd);
        this.setParent(this.project);
    }

    public void activate() throws Exception {
        this.prepare();
        this.systemBundle = this.createFramework();
        this.systemBundle.start();
        BundleContext systemContext = this.getSystemBundleContext();
        ArrayList<Bundle> installed = new ArrayList<Bundle>();
        Iterator<File> i = this.bundles.iterator();
        while (i.hasNext()) {
            File path = i.next().getAbsoluteFile();
            Bundle bundle = systemContext.installBundle(path.toURL().toString());
            installed.add(bundle);
        }
        this.systemBundle.start();
        for (Bundle b : installed) {
            try {
                System.out.println("Starting " + b.getLocation());
                b.start();
            }
            catch (BundleException e) {
                throw new RuntimeException(String.valueOf(b.getLocation()) + " " + (Object)((Object)e));
            }
        }
    }

    public void deactivate() throws Exception {
        if (this.systemBundle != null) {
            this.getSystemBundle().stop();
            this.waitForStop(0L);
        }
    }

    /*
     * Unable to fully structure code
     */
    private Object call(Object target, String method, Object ... parms) throws Exception {
        types = null;
        if (parms != null) {
            types = new Class[parms.length];
            i = 0;
            while (i < parms.length) {
                if (parms[i] != null) {
                    types[i] = parms[i].getClass();
                }
                if (types[i] == Integer.class) {
                    types[i] = Integer.TYPE;
                } else if (types[i] == Long.class) {
                    types[i] = Long.TYPE;
                }
                ++i;
            }
        }
        try {
            m = target.getClass().getMethod(method, types);
            return m.invoke(target, parms);
        }
        catch (InvocationTargetException ite) {
            if (ite.getCause() instanceof Exception) {
                throw (Exception)ite.getCause();
            }
            throw new RuntimeException(ite.getCause());
        }
        catch (NoSuchMethodException e) {
            System.out.println("Method " + method);
            var9_9 = target.getClass().getDeclaredMethods();
            var8_10 = var9_9.length;
            var7_11 = 0;
            ** while (var7_11 < var8_10)
        }
lbl-1000:
        // 1 sources

        {
            m = var9_9[var7_11];
            System.out.println(m);
            ++var7_11;
            continue;
        }
lbl32:
        // 1 sources

        throw e;
    }

    public void addSystemPackage(String packageName) {
        this.systemPackages.add(packageName);
    }

    private Bundle createFramework() throws Exception {
        Properties p = new Properties(this.getFlattenedProperties());
        if (!this.systemPackages.isEmpty()) {
            p.setProperty("org.osgi.framework.system.packages", this.toPackages(this.systemPackages));
        }
        FilterLoader fl = new FilterLoader(this.getClass().getClassLoader(), this.systemPackages);
        URL[] urls = new URL[this.jars.size()];
        int i = 0;
        while (i < this.jars.size()) {
            urls[i] = this.jars.get(i).toURL();
            ++i;
        }
        URLClassLoader loader = new URLClassLoader(urls, (ClassLoader)fl);
        Class<?> clazz = loader.loadClass(this.framework);
        Constructor<?> ctor = clazz.getConstructor(new Class[0]);
        try {
            Bundle systemBundle = (Bundle)ctor.newInstance(new Object[0]);
            this.call(systemBundle, "init", p);
            return systemBundle;
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
            throw e;
        }
    }

    private String toPackages(List<String> packs) {
        String del = "";
        StringBuilder sb = new StringBuilder();
        for (String s : packs) {
            sb.append(del);
            sb.append(s);
            del = ", ";
        }
        return sb.toString();
    }

    public void addBundle(File resource) {
        this.bundles.add(resource);
    }

    public void addJar(File resource) {
        this.jars.add(resource);
    }

    public BundleContext getSystemBundleContext() {
        return this.systemBundle.getBundleContext();
    }

    public Bundle getSystemBundle() {
        return this.systemBundle;
    }

    public void setFramework(String framework) {
        this.framework = framework;
    }

    public String getFramework() {
        return this.framework;
    }

    public BundleContext getBundleContext() {
        return this.systemBundle.getBundleContext();
    }

    @Override
    public Object[] getMacroDomains() {
        if (this.project == null) {
            return new Object[0];
        }
        return new Object[]{this.project, this.project.getWorkspace()};
    }

    public void waitForStop(long time) throws Exception {
        this.call(this.getSystemBundle(), "waitForStop", time);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class FilterLoader
    extends ClassLoader {
        final Pattern allowed;

        FilterLoader(ClassLoader parent, Collection<String> allowedPackageNames) {
            if (allowedPackageNames.size() == 0) {
                this.allowed = null;
            } else {
                StringBuilder sb = new StringBuilder();
                sb.append("(java\\..+");
                for (String s : allowedPackageNames) {
                    int n = s.indexOf(59);
                    if (n > 0) {
                        s = s.substring(0, n).trim();
                    }
                    sb.append("|");
                    sb.append(s);
                }
                sb.append(")\\.[^.]+");
                this.allowed = Pattern.compile(sb.toString());
            }
        }

        @Override
        public Class<?> loadClass(String className, boolean resolve) throws ClassNotFoundException {
            if (this.allowed.matcher(className).matches()) {
                return super.loadClass(className, resolve);
            }
            throw new ClassNotFoundException(String.valueOf(className) + " (filtered)");
        }
    }
}

