/*
 * Decompiled with CFR 0.152.
 */
package aQute.bnd.build;

import aQute.bnd.build.CircularDependencyException;
import aQute.bnd.build.Container;
import aQute.bnd.build.ProjectBuilder;
import aQute.bnd.build.Workspace;
import aQute.bnd.service.RepositoryPlugin;
import aQute.bnd.test.ProjectLauncher;
import aQute.lib.osgi.Jar;
import aQute.lib.osgi.Processor;
import aQute.lib.osgi.Resource;
import aQute.lib.osgi.eclipse.EclipseClasspath;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Project
extends Processor {
    public static final int PATH_TEST = 1;
    public static final int PATH_BUILD = 2;
    public static final String BNDFILE = "bnd.bnd";
    public static final String BNDCNF = "cnf";
    final Workspace workspace;
    long time;
    int count;
    boolean preparedPaths;
    final Collection<Project> dependson = new LinkedHashSet<Project>();
    final Collection<Container> buildpath = new LinkedHashSet<Container>();
    final Collection<Container> runpath = new LinkedHashSet<Container>();
    final Collection<File> sourcepath = new LinkedHashSet<File>();
    final Collection<File> allsourcepath = new LinkedHashSet<File>();
    final Collection<Container> bootclasspath = new LinkedHashSet<Container>();
    final Collection<Container> runbundles = new LinkedHashSet<Container>();
    File output;
    File target;
    boolean inPrepare;

    public Project(Workspace workspace, File projectDir, File buildFile) throws Exception {
        super(workspace);
        this.setFileMustExist(false);
        this.setProperties(buildFile);
        assert (workspace != null);
        this.workspace = workspace;
        this.readBuildProperties();
    }

    public Project(Workspace workspace, File buildDir) throws Exception {
        this(workspace, buildDir, new File(buildDir, BNDFILE));
    }

    private void readBuildProperties() throws Exception {
        try {
            File f = this.getFile("build.properties");
            if (f.isFile()) {
                Properties p = this.loadProperties(f);
                Enumeration<?> e = p.propertyNames();
                while (e.hasMoreElements()) {
                    String key;
                    String newkey = key = (String)e.nextElement();
                    if (key.indexOf(36) >= 0) {
                        newkey = this.getReplacer().process(key);
                    }
                    this.setProperty(newkey, p.getProperty(key));
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static Project getUnparented(File propertiesFile) throws Exception {
        propertiesFile = propertiesFile.getAbsoluteFile();
        Workspace workspace = new Workspace(propertiesFile.getParentFile());
        Project project = new Project(workspace, propertiesFile.getParentFile());
        project.setProperties(propertiesFile);
        project.setFileMustExist(true);
        return project;
    }

    public synchronized boolean isValid() {
        return this.getBase().isDirectory() && this.getPropertiesFile().isFile();
    }

    public synchronized ProjectBuilder getBuilder(ProjectBuilder parent) throws Exception {
        ProjectBuilder builder = parent == null ? new ProjectBuilder(this) : new ProjectBuilder(parent);
        builder.setBase(this.getBase());
        for (Container container : this.getBuildpath()) {
            builder.addClasspath(container.getFile());
        }
        for (Container container : this.getBootclasspath()) {
            builder.addClasspath(container.getFile());
        }
        for (File file : this.getAllsourcepath()) {
            builder.addSourcepath(file);
        }
        return builder;
    }

    public synchronized int getChanged() {
        return this.count;
    }

    public synchronized void setChanged() {
        if (this.refresh()) {
            this.preparedPaths = false;
            ++this.count;
        }
    }

    public Workspace getWorkspace() {
        return this.workspace;
    }

    public String toString() {
        return this.getBase().getName();
    }

    public synchronized void prepare() throws Exception {
        if (this.inPrepare) {
            throw new CircularDependencyException(this.toString());
        }
        if (!this.preparedPaths) {
            this.preparedPaths = true;
            this.inPrepare = true;
            try {
                File src;
                this.dependson.clear();
                this.buildpath.clear();
                this.sourcepath.clear();
                this.allsourcepath.clear();
                this.bootclasspath.clear();
                this.runpath.clear();
                this.runbundles.clear();
                this.setProperty("basedir", this.getBase().getAbsolutePath());
                if (!this.getPropertiesFile().isFile() && new File(this.getBase(), ".classpath").isFile()) {
                    this.doEclipseClasspath();
                }
                if ((src = new File(this.getBase(), this.getProperty("src", "src"))).isDirectory()) {
                    this.sourcepath.add(src);
                    this.allsourcepath.add(src);
                } else {
                    this.sourcepath.add(this.getBase());
                }
                this.output = this.getFile(this.getProperty("bin", "bin")).getAbsoluteFile();
                if (this.output.isDirectory()) {
                    if (!this.buildpath.contains(this.output)) {
                        this.buildpath.add(new Container(this, this.output));
                    }
                } else {
                    if (!this.output.exists()) {
                        this.output.mkdirs();
                    }
                    if (!this.output.isDirectory()) {
                        this.error("Can not find output directory: " + this.output);
                    }
                }
                this.target = this.getFile(this.getProperty("target", "generated"));
                ArrayList<Project> dependencies = new ArrayList<Project>();
                String dp = this.getProperty("-dependson");
                Set<String> requiredProjectNames = this.parseHeader(dp).keySet();
                for (String p : requiredProjectNames) {
                    Project required = this.getWorkspace().getProject(p);
                    if (required == null) {
                        this.error("No such project " + required + " on " + "-dependson");
                        continue;
                    }
                    dependencies.add(required);
                }
                this.doPath(this.buildpath, dependencies, this.parseBuildpath(), this.bootclasspath);
                this.doPath(this.runpath, dependencies, this.parseTestpath(), this.bootclasspath);
                this.doPath(this.runbundles, dependencies, this.parseTestbundles(), null);
                HashSet<Project> done = new HashSet<Project>();
                done.add(this);
                this.allsourcepath.addAll(this.sourcepath);
                for (Project project : dependencies) {
                    project.traverse(this.dependson, done);
                }
                for (Project project : this.dependson) {
                    this.allsourcepath.addAll(project.getSourcepath());
                }
            }
            finally {
                this.inPrepare = false;
            }
        }
    }

    private void traverse(Collection<Project> dependencies, Set<Project> visited) throws Exception {
        if (visited.contains(this)) {
            return;
        }
        visited.add(this);
        for (Project project : this.getDependson()) {
            project.traverse(dependencies, visited);
        }
        dependencies.add(this);
    }

    private void doPath(Collection<Container> resultpath, Collection<Project> projects, Collection<Container> entries, Collection<Container> bootclasspath) {
        for (Container cpe : entries) {
            if (cpe.getError() != null) {
                this.error(cpe.getError());
                continue;
            }
            if (cpe.getType() == Container.TYPE.PROJECT) {
                projects.add(cpe.getProject());
            }
            if (bootclasspath != null && cpe.getBundleSymbolicName().startsWith("ee.") || cpe.getAttributes().containsKey("boot")) {
                bootclasspath.add(cpe);
                continue;
            }
            resultpath.add(cpe);
        }
    }

    private List<Container> parseBuildpath() throws Exception {
        return this.getBundles(-1, this.getProperty("-buildpath"));
    }

    private List<Container> parseTestpath() throws Exception {
        return this.getBundles(1, this.getProperty("-runpath"));
    }

    private List<Container> parseTestbundles() throws Exception {
        return this.getBundles(1, this.getProperty("-runbundles"));
    }

    public List<Container> getBundles(int strategy, String spec) throws Exception {
        ArrayList<Container> result = new ArrayList<Container>();
        Map<String, Map<String, String>> bundles = this.parseHeader(spec);
        try {
            for (Map.Entry<String, Map<String, String>> entry : bundles.entrySet()) {
                Container found;
                String bsn = entry.getKey();
                Map<String, String> attrs = entry.getValue();
                String versionRange = attrs.get("version");
                String output = attrs.get("output");
                if (versionRange != null && versionRange.equals("project")) {
                    Project project = this.getWorkspace().getProject(bsn);
                    File f = project.getOutput();
                    found = new Container(project, bsn, "project", Container.TYPE.PROJECT, f, null, attrs);
                } else if (versionRange != null && versionRange.equals("file")) {
                    File f = this.getFile(bsn);
                    String error = null;
                    if (!f.exists()) {
                        error = "File does not exist";
                    }
                    found = new Container(this, bsn, "file", Container.TYPE.EXTERNAL, f, error, attrs);
                } else {
                    if (output != null) {
                        this.warning("The output attribute on a bsn is only allowed when there is a project, and there is no " + bsn + " project in the workspace");
                    }
                    found = this.getBundle(bsn, versionRange, strategy, attrs);
                }
                if (found != null) {
                    if (result.contains(found)) {
                        this.warning("Multiple bundles with the same final URL: " + found);
                    }
                    result.add(found);
                    continue;
                }
                Container x = new Container(this, bsn, versionRange, Container.TYPE.ERROR, null, String.valueOf(bsn) + ";version=" + versionRange + " not found", attrs);
                result.add(x);
                this.warning("Can not find URL for bsn " + bsn);
            }
        }
        catch (Exception e) {
            this.error("While tring to get the bundles from " + spec, e);
        }
        return result;
    }

    public long getTime() {
        return this.time;
    }

    public Collection<Project> getDependson() throws Exception {
        this.prepare();
        return this.dependson;
    }

    public Collection<Container> getBuildpath() throws Exception {
        this.prepare();
        return this.buildpath;
    }

    public Collection<Container> getRunpath() throws Exception {
        this.prepare();
        return this.runpath;
    }

    public Collection<Container> getRunbundles() throws Exception {
        this.prepare();
        return this.runbundles;
    }

    public Collection<File> getSourcepath() throws Exception {
        this.prepare();
        return this.sourcepath;
    }

    public Collection<File> getAllsourcepath() throws Exception {
        this.prepare();
        return this.allsourcepath;
    }

    public Collection<Container> getBootclasspath() throws Exception {
        this.prepare();
        return this.bootclasspath;
    }

    public File getOutput() throws Exception {
        this.prepare();
        return this.output;
    }

    private void doEclipseClasspath() throws Exception {
        EclipseClasspath eclipse = new EclipseClasspath(this, this.getWorkspace().getBase(), this.getBase());
        eclipse.setRecurse(false);
        for (File dependent : eclipse.getDependents()) {
            Project required = this.workspace.getProject(dependent.getName());
            this.dependson.add(required);
        }
        for (File f : eclipse.getClasspath()) {
            this.buildpath.add(new Container(f));
        }
        for (File f : eclipse.getBootclasspath()) {
            this.bootclasspath.add(new Container(f));
        }
        this.sourcepath.addAll(eclipse.getSourcepath());
        this.allsourcepath.addAll(eclipse.getAllSources());
        this.output = eclipse.getOutput();
    }

    public String _p_dependson(String[] args) throws Exception {
        return this.list(args, this.toFiles(this.getDependson()));
    }

    private Collection<?> toFiles(Collection<Project> projects) {
        ArrayList<File> files = new ArrayList<File>();
        for (Project p : projects) {
            files.add(p.getBase());
        }
        return files;
    }

    public String _p_buildpath(String[] args) throws Exception {
        return this.list(args, this.getBuildpath());
    }

    public String _p_testpath(String[] args) throws Exception {
        return this.list(args, this.getRunpath());
    }

    public String _p_sourcepath(String[] args) throws Exception {
        return this.list(args, this.getSourcepath());
    }

    public String _p_allsourcepath(String[] args) throws Exception {
        return this.list(args, this.getAllsourcepath());
    }

    public String _p_bootclasspath(String[] args) throws Exception {
        return this.list(args, this.getBootclasspath());
    }

    public String _p_output(String[] args) throws Exception {
        if (args.length != 1) {
            throw new IllegalArgumentException("${output} should not have arguments");
        }
        return this.getOutput().getAbsolutePath();
    }

    private String list(String[] args, Collection<?> list) {
        if (args.length > 3) {
            throw new IllegalArgumentException("${" + args[0] + "[;<separator>]} can only take a separator as argument, has " + Arrays.toString(args));
        }
        String separator = ",";
        if (args.length == 2) {
            separator = args[1];
        }
        return Project.join(list, separator);
    }

    @Override
    protected Object[] getMacroDomains() {
        return new Object[]{this.workspace};
    }

    public File release(Jar jar) throws Exception {
        List<RepositoryPlugin> plugins = this.getPlugins(RepositoryPlugin.class);
        for (RepositoryPlugin repo : plugins) {
            if (!repo.canWrite()) continue;
            return repo.put(jar);
        }
        return null;
    }

    public void release(boolean test) throws Exception {
        File[] jars;
        File[] fileArray = jars = this.build(test);
        int n = jars.length;
        int n2 = 0;
        while (n2 < n) {
            File jar = fileArray[n2];
            Jar j = new Jar(jar);
            this.release(j);
            j.close();
            ++n2;
        }
    }

    public Container getBundle(String bsn, String range, int strategy, Map<String, String> attrs) throws Exception {
        List<RepositoryPlugin> plugins = this.getPlugins(RepositoryPlugin.class);
        if (range != null && range.equals("latest")) {
            strategy = 1;
        }
        for (RepositoryPlugin plugin : plugins) {
            File[] results = plugin.get(bsn, range);
            if (results == null || results.length <= 0) continue;
            File f = results[strategy == -1 ? 0 : results.length - 1];
            return new Container(null, bsn, range, Container.TYPE.REPO, f, null, attrs);
        }
        return new Container(this, bsn, range, Container.TYPE.ERROR, null, String.valueOf(bsn) + ";version=" + range + " Not found in " + plugins, null);
    }

    public void deploy(File file) throws Exception {
        List<RepositoryPlugin> plugins = this.getPlugins(RepositoryPlugin.class);
        for (RepositoryPlugin plugin : plugins) {
            if (!plugin.canWrite()) continue;
            Jar jar = new Jar(file);
            try {
                plugin.put(jar);
                return;
            }
            catch (Exception e) {
                this.error("Deploying " + file + " on " + plugin, e);
            }
            finally {
                jar.close();
            }
            return;
        }
        System.out.println("No repo found " + file);
        throw new IllegalArgumentException("No repository found for " + file);
    }

    public String _repo(String[] args) throws Exception {
        Container jar;
        if (args.length < 2) {
            throw new IllegalArgumentException("Too few arguments for repo, syntax=: ${repo ';'<bsn> [ ; <version> ]}");
        }
        String bsn = args[1];
        String version = null;
        int strategy = 1;
        if (args.length > 2) {
            version = args[2];
            if (args.length == 4) {
                if (args[3].equalsIgnoreCase("HIGHEST")) {
                    strategy = 1;
                } else if (args[3].equalsIgnoreCase("LOWEST")) {
                    strategy = -1;
                } else {
                    this.error("${repo;<bsn>;<version>;<'highest'|'lowest'>} macro requires a strategy of 'highest' or 'lowest', and is " + args[3]);
                }
            }
        }
        if ((jar = this.getBundle(bsn, version, strategy, null)).getError() == null) {
            return jar.getFile().getAbsolutePath();
        }
        this.error("The ${repo} macro could not find " + bsn + " in the repo, because " + jar.getError() + "\n" + "Repositories     : " + this.getPlugins(RepositoryPlugin.class) + "\n" + "Strategy         : " + strategy + "\n" + "Bsn              : " + bsn + ";version=" + version);
        return null;
    }

    public File getTarget() throws Exception {
        this.prepare();
        return this.target;
    }

    public File[] build(boolean underTest) throws Exception {
        ProjectBuilder builder = this.getBuilder(null);
        if (underTest) {
            builder.setProperty("-undertest", "true");
        }
        Jar[] jars = builder.builds();
        File[] files = new File[jars.length];
        File target = this.getTarget();
        target.mkdirs();
        int i = 0;
        while (i < jars.length) {
            Jar jar = jars[i];
            try {
                String bsn = jar.getName();
                files[i] = new File(target, String.valueOf(bsn) + ".jar");
                String msg = "";
                if (!files[i].exists() || files[i].lastModified() < jar.lastModified()) {
                    this.reportNewer(files[i].lastModified(), jar);
                    files[i].delete();
                    jar.write(files[i]);
                } else {
                    msg = "(not modified since " + new Date(files[i].lastModified()) + ")";
                }
                System.out.println(String.valueOf(jar.getName()) + " (" + files[i].getName() + ") " + jar.getResources().size() + " " + msg);
            }
            finally {
                jar.close();
            }
            ++i;
        }
        this.getInfo(builder);
        builder.close();
        return files;
    }

    private void reportNewer(long lastModified, Jar jar) {
        if (Project.isTrue(this.getProperty("-reportnewer"))) {
            StringBuilder sb = new StringBuilder();
            String del = "Newer than " + new Date(lastModified);
            for (Map.Entry<String, Resource> entry : jar.getResources().entrySet()) {
                if (entry.getValue().lastModified() <= lastModified) continue;
                sb.append(del);
                del = ", \n     ";
                sb.append(entry.getKey());
            }
            if (sb.length() > 0) {
                this.warning(sb.toString());
            }
        }
    }

    @Override
    public boolean refresh() {
        boolean changed = false;
        if (this.isCnf()) {
            changed = this.workspace.refresh();
        }
        return super.refresh() || changed;
    }

    public boolean isCnf() {
        return this.getBase().getName().equals(BNDCNF);
    }

    @Override
    public void propertiesChanged() {
        this.preparedPaths = false;
    }

    public String getName() {
        return this.getBase().getName();
    }

    public void action(String command) throws Exception {
        if (command.equals("build")) {
            this.build();
        } else if (command.equals("test")) {
            this.test();
        } else if (!command.equals("release") && command.equals("clean")) {
            this.clean();
        }
    }

    public void clean() throws Exception {
        File target = this.getTarget();
        if (target.isDirectory() && target.getParentFile() != null) {
            this.delete(target);
        }
    }

    public void build() throws Exception {
        this.build(false);
    }

    public boolean test() throws Exception {
        File[] jars = this.build(true);
        boolean ok = true;
        File[] fileArray = jars;
        int n = jars.length;
        int n2 = 0;
        while (n2 < n) {
            File jar = fileArray[n2];
            ok &= this.test(jar);
            ++n2;
        }
        return ok;
    }

    public boolean test(File f) throws Exception {
        ProjectLauncher pl = new ProjectLauncher(this);
        int errors = pl.run(f);
        this.getInfo(pl);
        if (errors == 0) {
            System.out.println("ok");
            return true;
        }
        this.error("Failed: " + this.normalize(f) + ", " + errors + " test" + (errors > 1 ? "s" : "") + " failures, see " + this.normalize(pl.getTestreport()));
        return false;
    }

    private void delete(File target) {
        if (target.getParentFile() == null) {
            throw new IllegalArgumentException("Can not delete root!");
        }
        if (!target.exists()) {
            return;
        }
        if (target.isDirectory()) {
            File[] sub;
            File[] fileArray = sub = target.listFiles();
            int n = sub.length;
            int n2 = 0;
            while (n2 < n) {
                File s = fileArray[n2];
                this.delete(s);
                ++n2;
            }
        }
        target.delete();
    }
}

