/*
 * Decompiled with CFR 0.152.
 */
package com.scalagent.joram.mom.dest.mail;

import com.scalagent.joram.mom.dest.mail.MailMessage;
import com.scalagent.joram.mom.dest.mail.SenderInfo;
import fr.dyade.aaa.util.Debug;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Date;
import java.util.Enumeration;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.mail.Address;
import javax.mail.BodyPart;
import javax.mail.Flags;
import javax.mail.Folder;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.Session;
import javax.mail.Store;
import javax.mail.Transport;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import org.objectweb.joram.shared.messages.ConversionHelper;
import org.objectweb.util.monolog.api.BasicLevel;
import org.objectweb.util.monolog.api.Logger;

public class JavaMailUtil {
    public static Logger logger = Debug.getLogger(JavaMailUtil.class.getName());
    private Store store = null;
    private Folder folder = null;

    public void sendJavaMail(SenderInfo si, MailMessage message) throws Exception {
        StringTokenizer st;
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)("--- " + this + " sendJavaMail(" + si + "," + message + ")"));
        }
        if (si.smtpServer == null || si.smtpServer.length() < 0) {
            logger.log(BasicLevel.ERROR, (Object)("--- " + this + " sendJavaMail : smtpServer is empty."));
            throw new Exception("sendJavaMail : smtpServer is empty.");
        }
        Properties props = System.getProperties();
        props.put("mail.smtp.host", si.smtpServer);
        Session session = Session.getDefaultInstance((Properties)props);
        MimeMessage msg = new MimeMessage(session);
        MimeMultipart mimeMultiPart = new MimeMultipart();
        MimeBodyPart mimeBodyPart = new MimeBodyPart();
        msg.setFrom((Address)new InternetAddress(si.from));
        if (si.to != null) {
            st = new StringTokenizer(si.to, ",");
            while (st.hasMoreTokens()) {
                msg.setRecipients(Message.RecipientType.TO, (Address[])InternetAddress.parse((String)st.nextToken(), (boolean)false));
            }
        } else {
            logger.log(BasicLevel.ERROR, (Object)("--- " + this + " sendJavaMail : to is null."));
            throw new Exception("sendJavaMail : to is null.");
        }
        if (si.cc != null) {
            st = new StringTokenizer(si.cc, ",");
            while (st.hasMoreTokens()) {
                msg.setRecipients(Message.RecipientType.CC, (Address[])InternetAddress.parse((String)st.nextToken(), (boolean)false));
            }
        }
        if (si.bcc != null) {
            st = new StringTokenizer(si.bcc, ",");
            while (st.hasMoreTokens()) {
                msg.setRecipients(Message.RecipientType.BCC, (Address[])InternetAddress.parse((String)st.nextToken(), (boolean)false));
            }
        }
        msg.setSubject(si.subject);
        if (ConversionHelper.toBoolean(message.getProperty("showProperties"))) {
            try {
                mimeMultiPart.addBodyPart((BodyPart)this.getMultipartProp(message));
            }
            catch (Exception exc) {
                logger.log(BasicLevel.WARN, (Object)("--- " + this + " sendJavaMail: setMultipartProp"), (Throwable)exc);
            }
        }
        if (message.getType() == 1) {
            mimeBodyPart.setText("JoramMessage :\n" + message.getText());
            mimeMultiPart.addBodyPart((BodyPart)mimeBodyPart);
        } else if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)"not yet implemented");
        }
        msg.setHeader("X-Mailer", "JORAM:JavaMailUtil");
        msg.setSentDate(new Date());
        msg.setContent((Multipart)mimeMultiPart);
        Transport.send((Message)msg);
    }

    private MimeBodyPart getMultipartProp(MailMessage msg) throws Exception {
        MimeBodyPart mbp = new MimeBodyPart();
        StringBuffer buf = new StringBuffer();
        buf.append("type=" + msg.getType() + "\n");
        buf.append("id=" + msg.getIdentifier() + "\n");
        buf.append("persistent=" + msg.getPersistent() + "\n");
        buf.append("priority=" + msg.getJMSPriority() + "\n");
        buf.append("expiration=" + msg.getJMSExpiration() + "\n");
        buf.append("timestamp=" + msg.getTimestamp() + "\n");
        buf.append("toId=" + msg.getDestinationId() + "\n");
        buf.append("destType=" + msg.getToType() + "\n");
        buf.append("correlationId=" + msg.getCorrelationId() + "\n");
        buf.append("replyToId=" + msg.getReplyToId() + "\n");
        buf.append("replyDestType=" + msg.replyToType() + "\n");
        buf.append("deliveryCount=" + msg.getDeliveryCount() + "\n");
        buf.append("denied=" + msg.getDenied() + "\n");
        if (msg.getProperty("JMS_JORAM_ERRORCOUNT") != null) {
            int errorCount = (Integer)msg.getProperty("JMS_JORAM_ERRORCOUNT");
            buf.append("errorCount=" + errorCount + "\n");
            for (int i = 1; i <= errorCount; ++i) {
                buf.append("errorCode" + i + "=" + msg.getProperty("JMS_JORAM_ERRORCODE_" + i) + "\n");
                buf.append("errorCause" + i + "=" + msg.getProperty("JMS_JORAM_ERRORCAUSE_" + i) + "\n");
            }
        }
        mbp.setText(buf.toString());
        return mbp;
    }

    public synchronized Message[] popMail(String popServer, String popUser, String popPassword, boolean expunge) {
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)("--- " + this + " popMail : " + "popServer=" + popServer + ", popUser=" + popUser + ", expunge=" + expunge));
        }
        Message[] msgs = null;
        try {
            Properties props = System.getProperties();
            Session session = Session.getDefaultInstance((Properties)props, null);
            this.store = session.getStore("pop3");
            this.store.connect(popServer, popUser, popPassword);
            this.folder = this.store.getDefaultFolder();
            if (this.folder == null) {
                throw new Exception("No default folder");
            }
            this.folder = this.folder.getFolder("INBOX");
            if (this.folder == null) {
                throw new Exception("No POP3 INBOX");
            }
            if (expunge) {
                this.folder.open(2);
                msgs = this.folder.getMessages();
            } else {
                this.folder.open(1);
                msgs = this.folder.getMessages();
            }
            return msgs;
        }
        catch (Exception exc) {
            logger.log(BasicLevel.ERROR, (Object)"JavaMailUtil.popMail", (Throwable)exc);
            return msgs;
        }
    }

    public synchronized void closeFolder(Vector msgs, boolean expunge) {
        try {
            if (expunge && msgs != null) {
                Enumeration elements = msgs.elements();
                while (elements.hasMoreElements()) {
                    Message msg = (Message)elements.nextElement();
                    msg.setFlag(Flags.Flag.DELETED, true);
                }
            }
            if (this.folder != null) {
                this.folder.close(expunge);
            }
            if (this.store != null) {
                this.store.close();
            }
        }
        catch (Exception exc) {
            logger.log(BasicLevel.ERROR, (Object)"JavaMailUtil.closeFolder", (Throwable)exc);
        }
    }

    protected MailMessage createMessage(Properties prop, String mailId, String destType, String toId, String replyDestType) throws Exception {
        MailMessage msg = new MailMessage();
        msg.setIdentifier(mailId);
        msg.setPersistent(ConversionHelper.toBoolean(prop.getProperty("persistent", "true")));
        msg.setPriority(ConversionHelper.toInt(prop.getProperty("priority", "4")));
        msg.setExpiration(ConversionHelper.toLong(prop.getProperty("expiration", "0")));
        if (prop.containsKey("timestamp")) {
            msg.setTimestamp(ConversionHelper.toLong(prop.getProperty("timestamp")));
        }
        msg.setDestination(prop.getProperty("toId", toId), prop.getProperty("destType", destType));
        if (prop.containsKey("correlationId")) {
            msg.setCorrelationId(prop.getProperty("correlationId"));
        }
        if (prop.containsKey("replyToId")) {
            msg.setReplyTo(prop.getProperty("replyToId"), prop.getProperty("replyDestType", replyDestType));
        }
        msg.setDeliveryCount(ConversionHelper.toInt(prop.getProperty("deliveryCount", "0")));
        msg.setDenied(ConversionHelper.toBoolean(prop.getProperty("denied", "false")));
        if (prop.containsKey("errorCount")) {
            int errorCount = ConversionHelper.toInt(prop.getProperty("errorCount"));
            msg.setProperty("JMS_JORAM_ERRORCOUNT", new Integer(errorCount));
            for (int i = 1; i <= errorCount; ++i) {
                msg.setProperty("JMS_JORAM_ERRORCODE_" + i, new Short(prop.getProperty("errorCode" + i)));
                msg.setProperty("JMS_JORAM_ERRORCAUSE_" + i, new Short(prop.getProperty("errorCause" + i)));
            }
        }
        msg.setText(prop.getProperty("mailMessage"));
        return msg;
    }

    public Properties getMOMProperties(Message message) throws Exception, MessagingException {
        StringBuffer sb;
        String currentLine;
        BufferedReader reader;
        InputStream is;
        String contentType;
        Properties prop = new Properties();
        String subject = message.getSubject();
        prop.setProperty("subject", subject);
        Message messagePart = message;
        Object content = messagePart.getContent();
        if (content instanceof Multipart) {
            messagePart = ((Multipart)content).getBodyPart(0);
        }
        if ((contentType = messagePart.getContentType()).startsWith("text/plain") || contentType.startsWith("text/html")) {
            is = messagePart.getInputStream();
            reader = new BufferedReader(new InputStreamReader(is));
            currentLine = reader.readLine();
            while (currentLine != null && !(currentLine = currentLine.trim()).equalsIgnoreCase("JoramMessage")) {
                if (currentLine.length() > 1) {
                    String[] buf = currentLine.split("=");
                    prop.setProperty(buf[0], buf[1]);
                    if (logger.isLoggable(BasicLevel.DEBUG)) {
                        logger.log(BasicLevel.DEBUG, (Object)(buf[0] + "=" + buf[1]));
                    }
                }
                currentLine = reader.readLine();
            }
            sb = new StringBuffer();
            currentLine = reader.readLine();
            while (currentLine != null) {
                sb.append(currentLine + "\n");
                currentLine = reader.readLine();
            }
            prop.setProperty("mailMessage", sb.toString());
        }
        if (content instanceof Multipart && ((contentType = (messagePart = ((Multipart)content).getBodyPart(1)).getContentType()).startsWith("text/plain") || contentType.startsWith("text/html"))) {
            is = messagePart.getInputStream();
            reader = new BufferedReader(new InputStreamReader(is));
            currentLine = reader.readLine();
            sb = new StringBuffer();
            while (currentLine != null) {
                if (currentLine.equalsIgnoreCase("JoramMessage")) continue;
                sb.append(currentLine + "\n");
                currentLine = reader.readLine();
            }
            prop.setProperty("mailMessage", sb.toString());
        }
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)("--- " + this + " getMOMProperties : prop=" + prop));
        }
        return prop;
    }
}

