/*
 * Decompiled with CFR 0.152.
 */
package fr.dyade.aaa.jndi2.ha;

import fr.dyade.aaa.agent.AgentServer;
import fr.dyade.aaa.agent.BagSerializer;
import fr.dyade.aaa.jndi2.ha.GetRequestIdNot;
import fr.dyade.aaa.jndi2.ha.HARequestContext;
import fr.dyade.aaa.jndi2.msg.JndiReply;
import fr.dyade.aaa.jndi2.server.LifeCycleListener;
import fr.dyade.aaa.jndi2.server.RequestManager;
import fr.dyade.aaa.jndi2.server.TcpRequestNot;
import fr.dyade.aaa.jndi2.server.Trace;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Hashtable;
import org.objectweb.util.monolog.api.BasicLevel;

public class HARequestManager
implements LifeCycleListener,
BagSerializer,
Serializable {
    private static final long serialVersionUID = 1L;
    public static final int IDEMPOTENT = -2;
    public static final int NOT_IDEMPOTENT = -1;
    public static final String HA_REQUEST_COUNTER = "haRequestCounter";
    private transient int requestCounter;
    private transient Hashtable requests;
    private RequestManager manager;

    public void setRequestManager(RequestManager manager) {
        this.manager = manager;
    }

    public void agentInitialize(boolean firstTime) throws Exception {
        Integer counter;
        if (Trace.logger.isLoggable(BasicLevel.DEBUG)) {
            Trace.logger.log(BasicLevel.DEBUG, (Object)("HARequestManager.agentInitialize(" + firstTime + ')'));
        }
        this.requestCounter = (counter = (Integer)AgentServer.getTransaction().load(HA_REQUEST_COUNTER)) == null ? 0 : counter;
        this.requests = new Hashtable();
        this.manager.agentInitialize(firstTime);
    }

    public void agentFinalize(boolean lastTime) {
        this.manager.agentFinalize(lastTime);
    }

    void doReact(GetRequestIdNot not) {
        if (Trace.logger.isLoggable(BasicLevel.DEBUG)) {
            Trace.logger.log(BasicLevel.DEBUG, (Object)("HARequestManager.doReact((GetRequestIdNot)" + not + ')'));
        }
        int id = this.requestCounter++;
        this.saveRequestCounter();
        not.Return(id);
    }

    void doReact(TcpRequestNot not) throws Exception {
        if (Trace.logger.isLoggable(BasicLevel.DEBUG)) {
            Trace.logger.log(BasicLevel.DEBUG, (Object)("HARequestManager.doReact((TcpRequestNot)" + not + ')'));
        }
        HARequestContext reqCtx = (HARequestContext)not.getRequestContext();
        if (Trace.logger.isLoggable(BasicLevel.DEBUG)) {
            Trace.logger.log(BasicLevel.DEBUG, (Object)(" -> request id = " + reqCtx.getId()));
        }
        if (reqCtx.getId() == -2) {
            JndiReply reply = this.manager.invoke(reqCtx);
            reqCtx.reply(reply);
        } else {
            Integer reqId = new Integer(reqCtx.getId());
            HARequestContext recoveredReqCtx = (HARequestContext)this.requests.get(reqId);
            if (recoveredReqCtx == null) {
                this.requests.put(new Integer(this.requestCounter), reqCtx);
                JndiReply reply = this.manager.invoke(reqCtx);
                reqCtx.reply(reply);
            } else {
                JndiReply reply = recoveredReqCtx.getReply();
                if (reply == null) {
                    recoveredReqCtx.recover(reqCtx);
                } else {
                    reqCtx.reply(reply);
                }
            }
        }
    }

    void removeContext(int id) {
        this.requests.remove(new Integer(id));
    }

    private void saveRequestCounter() {
        try {
            AgentServer.getTransaction().save(new Integer(this.requestCounter), HA_REQUEST_COUNTER);
        }
        catch (IOException exc) {
            throw new Error(exc.toString());
        }
    }

    public void writeBag(ObjectOutputStream out) throws IOException {
        out.writeInt(this.requestCounter);
        out.writeObject(this.requests);
        this.manager.writeBag(out);
    }

    public void readBag(ObjectInputStream in) throws IOException, ClassNotFoundException {
        this.requestCounter = in.readInt();
        this.requests = (Hashtable)in.readObject();
        this.manager.readBag(in);
    }
}

