/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.joram.client.connector;

import javax.jms.Destination;
import javax.jms.IllegalStateException;
import javax.jms.JMSException;
import javax.jms.MessageConsumer;
import javax.jms.Queue;
import javax.jms.QueueBrowser;
import javax.jms.Session;
import javax.jms.TemporaryQueue;
import javax.jms.Topic;
import javax.jms.TopicPublisher;
import javax.jms.TopicSession;
import javax.jms.TopicSubscriber;
import org.objectweb.joram.client.connector.AdapterTracing;
import org.objectweb.joram.client.connector.OutboundConnection;
import org.objectweb.joram.client.connector.OutboundPublisher;
import org.objectweb.joram.client.connector.OutboundSession;
import org.objectweb.joram.client.connector.OutboundSubscriber;
import org.objectweb.util.monolog.api.BasicLevel;

public class OutboundTopicSession
extends OutboundSession
implements TopicSession {
    OutboundTopicSession(Session sess, OutboundConnection cnx) {
        super(sess, cnx);
        if (AdapterTracing.dbgAdapter.isLoggable(BasicLevel.DEBUG)) {
            AdapterTracing.dbgAdapter.log(BasicLevel.DEBUG, (Object)("OutboundTopicSession(" + sess + ", " + cnx + ")"));
        }
    }

    OutboundTopicSession(Session sess, OutboundConnection cnx, boolean transacted) {
        super(sess, cnx, transacted);
        if (AdapterTracing.dbgAdapter.isLoggable(BasicLevel.DEBUG)) {
            AdapterTracing.dbgAdapter.log(BasicLevel.DEBUG, (Object)("OutboundTopicSession(" + sess + ", " + cnx + ")"));
        }
    }

    public TopicPublisher createPublisher(Topic topic) throws JMSException {
        if (AdapterTracing.dbgAdapter.isLoggable(BasicLevel.DEBUG)) {
            AdapterTracing.dbgAdapter.log(BasicLevel.DEBUG, (Object)(this + " createPublisher(" + topic + ")"));
        }
        this.checkValidity();
        return new OutboundPublisher(this.sess.createProducer((Destination)topic), this);
    }

    public TopicSubscriber createSubscriber(Topic topic, String selector, boolean noLocal) throws JMSException {
        if (AdapterTracing.dbgAdapter.isLoggable(BasicLevel.DEBUG)) {
            AdapterTracing.dbgAdapter.log(BasicLevel.DEBUG, (Object)(this + " createSubscriber(" + topic + ", " + selector + ", " + noLocal + ")"));
        }
        this.checkValidity();
        MessageConsumer cons = this.sess.createConsumer((Destination)topic, selector, noLocal);
        return new OutboundSubscriber(topic, noLocal, cons, this);
    }

    public TopicSubscriber createSubscriber(Topic topic, String selector) throws JMSException {
        if (AdapterTracing.dbgAdapter.isLoggable(BasicLevel.DEBUG)) {
            AdapterTracing.dbgAdapter.log(BasicLevel.DEBUG, (Object)(this + " createSubscriber(" + topic + ", " + selector + ")"));
        }
        this.checkValidity();
        MessageConsumer cons = this.sess.createConsumer((Destination)topic, selector);
        return new OutboundSubscriber(topic, false, cons, this);
    }

    public TopicSubscriber createSubscriber(Topic topic) throws JMSException {
        if (AdapterTracing.dbgAdapter.isLoggable(BasicLevel.DEBUG)) {
            AdapterTracing.dbgAdapter.log(BasicLevel.DEBUG, (Object)(this + " createSubscriber(" + topic + ")"));
        }
        this.checkValidity();
        return new OutboundSubscriber(topic, false, this.sess.createConsumer((Destination)topic), this);
    }

    public QueueBrowser createBrowser(Queue queue, String selector) throws JMSException {
        throw new IllegalStateException("Forbidden call on a TopicSession.");
    }

    public QueueBrowser createBrowser(Queue queue) throws JMSException {
        throw new IllegalStateException("Forbidden call on a TopicSession.");
    }

    public Queue createQueue(String queueName) throws JMSException {
        throw new IllegalStateException("Forbidden call on a TopicSession.");
    }

    public TemporaryQueue createTemporaryQueue() throws JMSException {
        throw new IllegalStateException("Forbidden call on a TopicSession.");
    }
}

