/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.joram.client.jms;

import fr.dyade.aaa.util.Daemon;
import fr.dyade.aaa.util.Debug;
import fr.dyade.aaa.util.Queue;
import java.util.Vector;
import javax.jms.ConnectionConsumer;
import javax.jms.IllegalStateException;
import javax.jms.JMSException;
import javax.jms.MessageListener;
import javax.jms.ServerSession;
import javax.jms.ServerSessionPool;
import org.objectweb.joram.client.jms.Connection;
import org.objectweb.joram.client.jms.Message;
import org.objectweb.joram.client.jms.MessageConsumerListener;
import org.objectweb.joram.client.jms.Session;
import org.objectweb.joram.client.jms.XASession;
import org.objectweb.joram.client.jms.connection.RequestMultiplexer;
import org.objectweb.joram.shared.client.ConsumerMessages;
import org.objectweb.util.monolog.api.BasicLevel;
import org.objectweb.util.monolog.api.Logger;

public class MultiSessionConsumer
extends MessageConsumerListener
implements ConnectionConsumer {
    private static final Logger logger = Debug.getLogger(MultiSessionConsumer.class.getName());
    private ServerSessionPool sessPool;
    private Connection cnx;
    private int maxMsgs;
    private Queue repliesIn;
    private int nbActivatedListeners;
    private MessageDispatcher msgDispatcher;

    MultiSessionConsumer(boolean queueMode, boolean durable, String selector, String targetName, ServerSessionPool sessionPool, int queueMessageReadMax, int topicActivationThreshold, int topicPassivationThreshold, int topicAckBufferMax, RequestMultiplexer reqMultiplexer, Connection connection, int maxMessages) {
        super(queueMode, durable, selector, targetName, null, queueMessageReadMax, topicActivationThreshold, topicPassivationThreshold, topicAckBufferMax, reqMultiplexer);
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)("MultiSessionConsumer.<init>(" + queueMode + ',' + durable + ',' + selector + ',' + targetName + ',' + sessionPool + ',' + queueMessageReadMax + ',' + topicActivationThreshold + ',' + topicPassivationThreshold + ',' + topicAckBufferMax + ',' + reqMultiplexer + ',' + maxMessages + ')'));
        }
        this.sessPool = sessionPool;
        this.cnx = connection;
        this.maxMsgs = maxMessages;
        this.msgDispatcher = new MessageDispatcher("MessageDispatcher[" + reqMultiplexer.getDemultiplexerDaemonName() + ']');
        this.repliesIn = new Queue();
        this.msgDispatcher.setDaemon(true);
        this.msgDispatcher.start();
    }

    public void pushMessages(ConsumerMessages cm) throws JMSException {
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)("MultiSessionConsumer.pushMessages(" + cm + ')'));
        }
        this.repliesIn.push(cm);
    }

    public ServerSessionPool getServerSessionPool() throws JMSException {
        return this.sessPool;
    }

    public void close() throws JMSException {
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)"MultiSessionConsumer.close()");
        }
        this.msgDispatcher.stop();
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)"MultiSessionConsumer -> dispatcher stopped");
        }
        super.close();
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)"MultiSessionConsumer -> close connection consumer");
        }
        this.cnx.closeConnectionConsumer(this);
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)"MultiSessionConsumer -> connection consumer closed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onMessage(Message msg, MessageListener listener, int ackMode) throws JMSException {
        MultiSessionConsumer multiSessionConsumer;
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)("MultiSessionConsumer.onMessage(" + msg + ')'));
        }
        try {
            multiSessionConsumer = this;
            synchronized (multiSessionConsumer) {
                if (this.getStatus() == 3) {
                    throw new IllegalStateException("Message listener closed");
                }
                if (this.nbActivatedListeners == 0) {
                    this.setStatus(2);
                }
                ++this.nbActivatedListeners;
            }
            this.activateListener(msg, listener, ackMode);
        }
        finally {
            multiSessionConsumer = this;
            synchronized (multiSessionConsumer) {
                --this.nbActivatedListeners;
                if (this.nbActivatedListeners == 0) {
                    this.setStatus(1);
                    this.notifyAll();
                }
            }
        }
    }

    class MessageDispatcher
    extends Daemon {
        MessageDispatcher(String name) {
            super(name);
        }

        protected void close() {
        }

        protected void shutdown() {
        }

        public void stop() {
            if (logger.isLoggable(BasicLevel.DEBUG)) {
                logger.log(BasicLevel.DEBUG, (Object)"MessageDispatcher.stop()");
            }
            if (this.isCurrentThread()) {
                this.finish();
            } else {
                super.stop();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                while (this.running) {
                    this.canStop = true;
                    ConsumerMessages cm = (ConsumerMessages)MultiSessionConsumer.this.repliesIn.get();
                    this.canStop = false;
                    Vector msgs = cm.getMessages();
                    int sessionMsgCounter = MultiSessionConsumer.this.maxMsgs + 1;
                    ServerSession serverSess = null;
                    Session sess = null;
                    for (int i = 0; i < msgs.size(); ++i) {
                        if (sessionMsgCounter > MultiSessionConsumer.this.maxMsgs) {
                            javax.jms.Session obj;
                            if (serverSess != null) {
                                serverSess.start();
                            }
                            if ((obj = (serverSess = MultiSessionConsumer.this.sessPool.getServerSession()).getSession()) instanceof Session) {
                                sess = (Session)obj;
                            } else if (obj instanceof XASession) {
                                sess = ((XASession)obj).sess;
                            } else {
                                throw new Error("Unexpected session type: " + obj);
                            }
                            sess.setMessageConsumerListener(MultiSessionConsumer.this);
                            sessionMsgCounter = 1;
                        }
                        sess.onMessage((org.objectweb.joram.shared.messages.Message)msgs.get(i));
                        ++sessionMsgCounter;
                    }
                    serverSess.start();
                    MultiSessionConsumer.this.repliesIn.pop();
                }
            }
            catch (InterruptedException exc) {
                if (logger.isLoggable(BasicLevel.DEBUG)) {
                    logger.log(BasicLevel.DEBUG, (Object)"", (Throwable)exc);
                }
            }
            catch (Exception exc) {
                if (logger.isLoggable(BasicLevel.DEBUG)) {
                    logger.log(BasicLevel.DEBUG, (Object)"", (Throwable)exc);
                }
                try {
                    MultiSessionConsumer.this.close();
                }
                catch (JMSException jMSException) {
                    // empty catch block
                }
            }
            finally {
                this.finish();
            }
        }
    }
}

