/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.joram.mom.dest.jmsbridge;

import fr.dyade.aaa.agent.AgentId;
import fr.dyade.aaa.agent.Channel;
import fr.dyade.aaa.agent.Debug;
import fr.dyade.aaa.util.Daemon;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;
import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import javax.jms.ExceptionListener;
import javax.jms.IllegalStateException;
import javax.jms.JMSException;
import javax.jms.JMSSecurityException;
import javax.jms.MessageConsumer;
import javax.jms.MessageFormatException;
import javax.jms.MessageListener;
import javax.jms.MessageProducer;
import javax.jms.Queue;
import javax.jms.Session;
import javax.jms.Topic;
import javax.jms.XAConnection;
import javax.jms.XAConnectionFactory;
import javax.jms.XASession;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NameNotFoundException;
import javax.naming.NamingException;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;
import org.objectweb.joram.client.jms.XidImpl;
import org.objectweb.joram.mom.dest.jmsbridge.JMSBridgeAckNot;
import org.objectweb.joram.mom.dest.jmsbridge.JMSBridgeDeliveryNot;
import org.objectweb.joram.shared.messages.Message;
import org.objectweb.util.monolog.api.BasicLevel;
import org.objectweb.util.monolog.api.Logger;

public class JMSBridgeModule
implements ExceptionListener,
MessageListener,
Serializable {
    private static final long serialVersionUID = 1L;
    public static Logger logger = Debug.getLogger(JMSBridgeModule.class.getName());
    protected AgentId agentId;
    protected String jndiFactory = null;
    protected String jndiUrl = null;
    protected String cnxFactName;
    protected String destName;
    protected ConnectionFactory cnxFact = null;
    protected XAConnectionFactory xaCnxFact = null;
    protected Destination dest = null;
    protected String userName = null;
    protected String password = null;
    protected String clientID = null;
    protected String selector;
    protected boolean usable = true;
    protected String notUsableMessage;
    protected transient Connection producerCnx;
    protected transient Connection consumerCnx;
    protected transient Session producerSession;
    protected transient Session consumerSession;
    protected transient MessageProducer producer;
    protected transient MessageConsumer consumer;
    protected transient boolean listener;
    protected transient Vector qout;
    protected transient ConsumerDaemon consumerDaemon;
    protected transient ReconnectionDaemon reconnectionDaemon;
    private boolean automaticRequest = false;
    private boolean isXA = false;
    private XAResource producerRes = null;
    private XAResource consumerRes = null;
    private Object lock = new String();

    public JMSBridgeModule(Properties prop) {
        if (logger.isLoggable(BasicLevel.FATAL)) {
            logger.log(BasicLevel.FATAL, (Object)("<init>(" + prop + ')'));
        }
        this.jndiFactory = prop.getProperty("jndiFactory");
        this.jndiUrl = prop.getProperty("jndiUrl");
        this.cnxFactName = prop.getProperty("connectionFactoryName");
        if (this.cnxFactName == null) {
            throw new IllegalArgumentException("Missing ConnectionFactory JNDI name.");
        }
        this.destName = prop.getProperty("destinationName");
        if (this.destName == null) {
            throw new IllegalArgumentException("Missing Destination JNDI name.");
        }
        String userName = prop.getProperty("userName");
        String password = prop.getProperty("password");
        if (userName != null && password != null) {
            this.userName = userName;
            this.password = password;
        }
        this.clientID = prop.getProperty("clientId");
        this.selector = prop.getProperty("selector");
        this.automaticRequest = Boolean.valueOf(prop.getProperty("automaticRequest", "false"));
    }

    public void init(AgentId agentId) {
        this.agentId = agentId;
    }

    public void connect() throws JMSException {
        if (!this.usable) {
            throw new IllegalStateException(this.notUsableMessage);
        }
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)"connect()");
        }
        this.listener = false;
        this.consumerDaemon = new ConsumerDaemon();
        this.reconnectionDaemon = new ReconnectionDaemon();
        this.consumerDaemon.start();
        if (!this.isXA && this.cnxFact == null || this.isXA && this.xaCnxFact == null || this.dest == null) {
            StartupDaemon startup = new StartupDaemon();
            startup.start();
        } else {
            try {
                if (this.isXA) {
                    this.doXAConnect();
                } else {
                    this.doConnect();
                }
            }
            catch (JMSException exc) {
                this.reconnectionDaemon.reconnect();
            }
        }
    }

    public void setMessageListener() throws IllegalStateException {
        if (!this.usable) {
            throw new IllegalStateException(this.notUsableMessage);
        }
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)"setMessageListener()");
        }
        this.listener = true;
        try {
            this.setConsumer();
            this.consumer.setMessageListener((MessageListener)this);
            this.consumerCnx.start();
        }
        catch (JMSException jMSException) {
            // empty catch block
        }
    }

    public void unsetMessageListener() {
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)"unsetMessageListener()");
        }
        try {
            this.consumerCnx.stop();
            this.consumer.setMessageListener(null);
            this.unsetConsumer();
        }
        catch (JMSException jMSException) {
            // empty catch block
        }
        this.listener = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Message receiveNoWait() throws IllegalStateException {
        if (!this.usable) {
            throw new IllegalStateException(this.notUsableMessage);
        }
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)"receiveNoWait()");
        }
        Message momMessage = null;
        Object object = this.lock;
        synchronized (object) {
            block33: {
                try {
                    this.setConsumer();
                    this.consumerCnx.start();
                    XidImpl xid = null;
                    try {
                        block32: {
                            if (this.isXA) {
                                xid = new XidImpl(new byte[0], 1, new String(this.agentId.toString() + System.currentTimeMillis()).getBytes());
                                if (logger.isLoggable(BasicLevel.DEBUG)) {
                                    logger.log(BasicLevel.DEBUG, (Object)("receiveNoWait: XA xid=" + xid));
                                }
                                try {
                                    this.consumerRes.start(xid, 0);
                                }
                                catch (XAException e) {
                                    if (!logger.isLoggable(BasicLevel.WARN)) break block32;
                                    logger.log(BasicLevel.WARN, (Object)("Exception:: XA can't start resource : " + this.consumerRes), (Throwable)e);
                                }
                            }
                        }
                        org.objectweb.joram.client.jms.Message clientMessage = org.objectweb.joram.client.jms.Message.convertJMSMessage(this.consumer.receiveNoWait());
                        if (logger.isLoggable(BasicLevel.DEBUG)) {
                            logger.log(BasicLevel.DEBUG, (Object)("receiveNoWait: clientMessage=" + clientMessage));
                        }
                        momMessage = clientMessage.getMomMsg();
                        if (this.isXA) {
                            try {
                                this.consumerRes.end(xid, 0x4000000);
                                if (logger.isLoggable(BasicLevel.DEBUG)) {
                                    logger.log(BasicLevel.DEBUG, (Object)("receiveNoWait: XA end " + this.consumerRes));
                                }
                            }
                            catch (XAException e) {
                                throw new JMSException("XA resource end(...) failed: " + this.consumerRes + " :: " + e.getMessage());
                            }
                            try {
                                int ret = this.consumerRes.prepare(xid);
                                if (ret == 0) {
                                    this.consumerRes.commit(xid, false);
                                }
                                if (logger.isLoggable(BasicLevel.DEBUG)) {
                                    logger.log(BasicLevel.DEBUG, (Object)("receiveNoWait: XA commit " + this.consumerRes));
                                }
                                break block33;
                            }
                            catch (XAException e) {
                                try {
                                    this.consumerRes.rollback(xid);
                                    if (logger.isLoggable(BasicLevel.DEBUG)) {
                                        logger.log(BasicLevel.DEBUG, (Object)("receiveNoWait: XA rollback" + this.consumerRes));
                                    }
                                }
                                catch (XAException e1) {
                                    // empty catch block
                                }
                                throw new JMSException("XA resource rollback(" + xid + ") failed: " + this.consumerRes + " :: " + e.getMessage());
                            }
                        }
                        this.consumerSession.commit();
                        if (logger.isLoggable(BasicLevel.DEBUG)) {
                            logger.log(BasicLevel.DEBUG, (Object)("receiveNoWait: commit " + this.consumerSession));
                        }
                    }
                    catch (MessageFormatException exc) {
                        if (this.isXA) {
                            try {
                                this.consumerRes.rollback(xid);
                                if (logger.isLoggable(BasicLevel.DEBUG)) {
                                    logger.log(BasicLevel.DEBUG, (Object)("receiveNoWait: XA rollback " + this.consumerRes));
                                }
                                break block33;
                            }
                            catch (XAException e1) {}
                            break block33;
                        }
                        this.consumerSession.rollback();
                        if (logger.isLoggable(BasicLevel.DEBUG)) {
                            logger.log(BasicLevel.DEBUG, (Object)("receiveNoWait: rollback " + this.consumerSession));
                        }
                    }
                }
                catch (JMSException commitExc) {
                    momMessage = null;
                }
            }
        }
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)("receiveNoWait: momMessage=" + momMessage));
        }
        return momMessage;
    }

    public void receive() throws IllegalStateException {
        if (!this.usable) {
            throw new IllegalStateException(this.notUsableMessage);
        }
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)"receive()");
        }
        this.consumerDaemon.receive();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void send(Message message) throws JMSException {
        if (!this.usable) {
            throw new IllegalStateException(this.notUsableMessage);
        }
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)("send(" + message + ')'));
        }
        Object object = this.lock;
        synchronized (object) {
            block24: {
                try {
                    XidImpl xid;
                    block23: {
                        xid = null;
                        if (this.isXA) {
                            xid = new XidImpl(new byte[0], 1, message.id.getBytes());
                            if (logger.isLoggable(BasicLevel.DEBUG)) {
                                logger.log(BasicLevel.DEBUG, (Object)("send: xid=" + xid));
                            }
                            try {
                                this.producerRes.start(xid, 0);
                            }
                            catch (XAException e) {
                                if (!logger.isLoggable(BasicLevel.WARN)) break block23;
                                logger.log(BasicLevel.WARN, (Object)("Exception:: XA can't start resource : " + this.producerRes), (Throwable)e);
                            }
                        }
                    }
                    this.producer.send((javax.jms.Message)org.objectweb.joram.client.jms.Message.wrapMomMessage(null, message));
                    if (logger.isLoggable(BasicLevel.DEBUG)) {
                        logger.log(BasicLevel.DEBUG, (Object)("send: " + this.producer + " send."));
                    }
                    this.acknowledge(message);
                    if (logger.isLoggable(BasicLevel.DEBUG)) {
                        logger.log(BasicLevel.DEBUG, (Object)"send: acknowledge.");
                    }
                    if (!this.isXA) break block24;
                    try {
                        this.producerRes.end(xid, 0x4000000);
                        if (logger.isLoggable(BasicLevel.DEBUG)) {
                            logger.log(BasicLevel.DEBUG, (Object)("send: XA end " + this.producerRes));
                        }
                    }
                    catch (XAException e) {
                        throw new JMSException("resource end(...) failed: " + this.producerRes + " :: " + e.getMessage());
                    }
                    try {
                        int ret = this.producerRes.prepare(xid);
                        if (ret == 0) {
                            this.producerRes.commit(xid, false);
                        }
                        if (logger.isLoggable(BasicLevel.DEBUG)) {
                            logger.log(BasicLevel.DEBUG, (Object)("send: XA commit " + this.producerRes));
                        }
                    }
                    catch (XAException e) {
                        try {
                            this.producerRes.rollback(xid);
                            if (logger.isLoggable(BasicLevel.DEBUG)) {
                                logger.log(BasicLevel.DEBUG, (Object)("send: XA rollback " + this.producerRes));
                            }
                        }
                        catch (XAException e1) {
                            // empty catch block
                        }
                        throw new JMSException("XA resource rollback(" + xid + ") failed: " + this.producerRes + " :: " + e.getMessage());
                    }
                }
                catch (JMSException exc) {
                    this.qout.add(message);
                    if (!logger.isLoggable(BasicLevel.DEBUG)) break block24;
                    logger.log(BasicLevel.DEBUG, (Object)("send: Exception qout=" + this.qout));
                }
            }
        }
    }

    public void close() {
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)"close()");
        }
        try {
            this.producerCnx.stop();
            this.consumerCnx.stop();
        }
        catch (JMSException exc) {
            // empty catch block
        }
        this.unsetMessageListener();
        try {
            this.consumerDaemon.interrupt();
        }
        catch (Exception exc) {
            // empty catch block
        }
        try {
            this.reconnectionDaemon.interrupt();
        }
        catch (Exception exc) {
            // empty catch block
        }
        try {
            this.producerCnx.close();
            this.consumerCnx.close();
        }
        catch (JMSException jMSException) {
            // empty catch block
        }
    }

    public void onException(JMSException exc) {
        if (logger.isLoggable(BasicLevel.WARN)) {
            logger.log(BasicLevel.WARN, (Object)("onException(" + (Object)((Object)exc) + ')'));
        }
        this.reconnectionDaemon.reconnect();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public void onMessage(javax.jms.Message jmsMessage) {
        if (JMSBridgeModule.logger.isLoggable(BasicLevel.DEBUG)) {
            JMSBridgeModule.logger.log(BasicLevel.DEBUG, (Object)("onMessage(" + jmsMessage + ')'));
        }
        try {
            xid = null;
            var3_4 = this.lock;
            synchronized (var3_4) {
                block32: {
                    try {
                        block31: {
                            if (this.isXA) {
                                xid = new XidImpl(new byte[0], 1, new String(this.agentId.toString() + System.currentTimeMillis()).getBytes());
                                if (JMSBridgeModule.logger.isLoggable(BasicLevel.DEBUG)) {
                                    JMSBridgeModule.logger.log(BasicLevel.DEBUG, (Object)("onMessage: xid=" + xid));
                                }
                                try {
                                    this.consumerRes.start(xid, 0);
                                }
                                catch (XAException e) {
                                    if (!JMSBridgeModule.logger.isLoggable(BasicLevel.WARN)) break block31;
                                    JMSBridgeModule.logger.log(BasicLevel.WARN, (Object)("Exception onMessage:: XA can't start resource : " + this.consumerRes), (Throwable)e);
                                }
                            }
                        }
                        clientMessage = org.objectweb.joram.client.jms.Message.convertJMSMessage(jmsMessage);
                        momMessage = clientMessage.getMomMsg();
                        if (this.isXA) {
                            try {
                                this.consumerRes.end(xid, 0x4000000);
                                if (JMSBridgeModule.logger.isLoggable(BasicLevel.DEBUG)) {
                                    JMSBridgeModule.logger.log(BasicLevel.DEBUG, (Object)("onMessage: XA end " + this.consumerRes));
                                }
                            }
                            catch (XAException e) {
                                if (JMSBridgeModule.logger.isLoggable(BasicLevel.DEBUG)) {
                                    JMSBridgeModule.logger.log(BasicLevel.DEBUG, (Object)("Exception onMessage:: XA resource end(...) failed: " + this.consumerRes), (Throwable)e);
                                }
                                throw new JMSException("onMessage: XA resource end(...) failed: " + this.consumerRes + " :: " + e.getMessage());
                            }
                            try {
                                ret = this.consumerRes.prepare(xid);
                                if (ret == 0) {
                                    this.consumerRes.commit(xid, false);
                                }
                                if (!JMSBridgeModule.logger.isLoggable(BasicLevel.DEBUG)) ** GOTO lbl53
                                JMSBridgeModule.logger.log(BasicLevel.DEBUG, (Object)("onMessage: XA commit " + this.consumerRes));
                            }
                            catch (XAException e) {
                                if (JMSBridgeModule.logger.isLoggable(BasicLevel.DEBUG)) {
                                    JMSBridgeModule.logger.log(BasicLevel.DEBUG, (Object)("Exception onMessage:: XA resource rollback(" + xid + ")"), (Throwable)e);
                                }
                                try {
                                    this.consumerRes.rollback(xid);
                                    if (JMSBridgeModule.logger.isLoggable(BasicLevel.DEBUG)) {
                                        JMSBridgeModule.logger.log(BasicLevel.DEBUG, (Object)("onMessage: XA rollback " + this.consumerRes));
                                    }
                                }
                                catch (XAException e1) {
                                    // empty catch block
                                }
                                throw new JMSException("onMessage: XA resource rollback(" + xid + ") failed: " + this.consumerRes + " :: " + e.getMessage());
                            }
                        } else {
                            if (JMSBridgeModule.logger.isLoggable(BasicLevel.DEBUG)) {
                                JMSBridgeModule.logger.log(BasicLevel.DEBUG, (Object)"onMessage: commit.");
                            }
                            this.consumerSession.commit();
                        }
lbl53:
                        // 3 sources

                        if (JMSBridgeModule.logger.isLoggable(BasicLevel.DEBUG)) {
                            JMSBridgeModule.logger.log(BasicLevel.DEBUG, (Object)"onMessage: send JMSBridgeDeliveryNot.");
                        }
                        Channel.sendTo(this.agentId, new JMSBridgeDeliveryNot(momMessage));
                    }
                    catch (MessageFormatException conversionExc) {
                        if (this.isXA) {
                            try {
                                this.consumerRes.rollback(xid);
                                if (JMSBridgeModule.logger.isLoggable(BasicLevel.DEBUG)) {
                                    JMSBridgeModule.logger.log(BasicLevel.DEBUG, (Object)("run: XA rollback " + this.consumerRes));
                                }
                            }
                            catch (XAException e1) {}
                        }
                        this.consumerSession.rollback();
                        if (!JMSBridgeModule.logger.isLoggable(BasicLevel.DEBUG)) break block32;
                        JMSBridgeModule.logger.log(BasicLevel.DEBUG, (Object)"Exception:: onMessage: rollback.");
                    }
                }
            }
        }
        catch (JMSException var2_3) {
            // empty catch block
        }
    }

    protected void doXAConnect() throws JMSException {
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)"doXAConnect()");
        }
        if (this.userName != null && this.password != null) {
            this.producerCnx = this.xaCnxFact.createXAConnection(this.userName, this.password);
            this.consumerCnx = this.xaCnxFact.createXAConnection(this.userName, this.password);
        } else {
            this.producerCnx = this.xaCnxFact.createXAConnection();
            this.consumerCnx = this.xaCnxFact.createXAConnection();
        }
        this.producerCnx.setExceptionListener((ExceptionListener)this);
        this.consumerCnx.setExceptionListener((ExceptionListener)this);
        if (this.clientID != null) {
            this.producerCnx.setClientID(this.clientID);
            this.consumerCnx.setClientID(this.clientID);
        }
        this.producerCnx.start();
        this.consumerCnx.start();
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)("doXAConnect: cnx=" + this.producerCnx + ", consumerCnx=" + this.consumerCnx));
        }
        this.producerSession = ((XAConnection)this.producerCnx).createXASession();
        this.producer = this.producerSession.createProducer(this.dest);
        this.consumerSession = ((XAConnection)this.consumerCnx).createXASession();
        this.producerRes = ((XASession)this.producerSession).getXAResource();
        this.consumerRes = ((XASession)this.consumerSession).getXAResource();
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)("doXAConnect: producerRes=" + this.producerRes + ", consumerRes=" + this.consumerRes));
        }
        new XARecoverDaemon(this.producerRes).start();
        new XARecoverDaemon(this.consumerRes).start();
    }

    protected void doConnect() throws JMSException {
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)"doConnect()");
        }
        if (this.userName != null && this.password != null) {
            this.producerCnx = this.cnxFact.createConnection(this.userName, this.password);
            this.consumerCnx = this.cnxFact.createConnection(this.userName, this.password);
        } else {
            this.producerCnx = this.cnxFact.createConnection();
            this.consumerCnx = this.cnxFact.createConnection();
        }
        this.producerCnx.setExceptionListener((ExceptionListener)this);
        this.consumerCnx.setExceptionListener((ExceptionListener)this);
        if (this.clientID != null) {
            this.producerCnx.setClientID(this.clientID);
            this.consumerCnx.setClientID(this.clientID);
        }
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)("doConnect: cnx=" + this.producerCnx + ", consumerCnx=" + this.consumerCnx));
        }
        this.producerSession = this.producerCnx.createSession(false, 1);
        this.producer = this.producerSession.createProducer(this.dest);
        this.consumerSession = this.consumerCnx.createSession(true, 0);
    }

    protected void setConsumer() throws JMSException {
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)"setConsumer()");
        }
        if (this.consumer != null) {
            return;
        }
        try {
            this.consumer = this.dest instanceof Queue ? this.consumerSession.createConsumer(this.dest, this.selector) : this.consumerSession.createDurableSubscriber((Topic)this.dest, this.agentId.toString(), this.selector, false);
            if (logger.isLoggable(BasicLevel.DEBUG)) {
                logger.log(BasicLevel.DEBUG, (Object)("setConsumer: consumer=" + this.consumer));
            }
        }
        catch (JMSException exc) {
            throw exc;
        }
        catch (Exception exc) {
            throw new JMSException("JMS resources do not allow to create consumer: " + exc);
        }
    }

    protected void unsetConsumer() {
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)"unsetConsumer()");
        }
        try {
            if (this.dest instanceof Topic) {
                this.consumerSession.unsubscribe(this.agentId.toString());
            }
            this.consumer.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.consumer = null;
    }

    protected void acknowledge(Message message) {
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)("acknowledge(" + message + ')'));
        }
        Channel.sendTo(this.agentId, new JMSBridgeAckNot(message.id));
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.qout = new Vector();
    }

    protected class XARecoverDaemon
    extends Daemon {
        private XAResource resource;

        protected XARecoverDaemon(XAResource resource) {
            super(JMSBridgeModule.this.agentId.toString() + ":XARecoverDaemon");
            this.resource = null;
            this.resource = resource;
            if (logger.isLoggable(BasicLevel.DEBUG)) {
                logger.log(BasicLevel.DEBUG, (Object)("XARecoverDaemon<init> " + JMSBridgeModule.this.agentId));
            }
        }

        protected void close() {
        }

        protected void shutdown() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            if (logger.isLoggable(BasicLevel.DEBUG)) {
                logger.log(BasicLevel.DEBUG, (Object)"run()");
            }
            Object object = JMSBridgeModule.this.lock;
            synchronized (object) {
                block13: {
                    XidImpl xid;
                    block12: {
                        xid = new XidImpl(new byte[0], 1, new String(JMSBridgeModule.this.agentId.toString() + System.currentTimeMillis()).getBytes());
                        if (logger.isLoggable(BasicLevel.DEBUG)) {
                            logger.log(BasicLevel.DEBUG, (Object)("run: xid = " + xid));
                        }
                        try {
                            this.resource.start(xid, 0);
                        }
                        catch (XAException exc) {
                            if (!logger.isLoggable(BasicLevel.WARN)) break block12;
                            logger.log(BasicLevel.WARN, (Object)("Exception:: XA can't start resource : " + this.resource), (Throwable)exc);
                        }
                    }
                    try {
                        Xid[] xids = this.resource.recover(0);
                        if (logger.isLoggable(BasicLevel.DEBUG)) {
                            logger.log(BasicLevel.DEBUG, (Object)("run: XA xid.length=" + xids.length));
                        }
                        for (int i = 0; i < xids.length; ++i) {
                            if (logger.isLoggable(BasicLevel.INFO)) {
                                logger.log(BasicLevel.INFO, (Object)("XARecoverDaemon : commit this " + xids[i].getGlobalTransactionId()));
                            }
                            this.resource.commit(xids[i], false);
                            if (!logger.isLoggable(BasicLevel.DEBUG)) continue;
                            logger.log(BasicLevel.DEBUG, (Object)("run: XA commit xid=" + xids[i]));
                        }
                        this.resource.end(xid, 0x4000000);
                    }
                    catch (XAException e) {
                        if (!logger.isLoggable(BasicLevel.DEBUG)) break block13;
                        logger.log(BasicLevel.DEBUG, (Object)"Exception:: run", (Throwable)e);
                    }
                }
            }
        }
    }

    protected class ConsumerDaemon
    extends Daemon {
        private int requests;
        private Object consumerLock;
        boolean receiveRequest;

        protected ConsumerDaemon() {
            super(JMSBridgeModule.this.agentId.toString() + ":ConsumerDaemon");
            this.requests = 0;
            this.consumerLock = new Object();
            this.receiveRequest = false;
            this.setDaemon(false);
            if (logger.isLoggable(BasicLevel.DEBUG)) {
                logger.log(BasicLevel.DEBUG, (Object)("ConsumerDaemon<init> " + JMSBridgeModule.this.agentId));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void receive() {
            if (logger.isLoggable(BasicLevel.DEBUG)) {
                logger.log(BasicLevel.DEBUG, (Object)("receive() automaticRequest = " + JMSBridgeModule.this.automaticRequest + ", receiveRequest = " + this.receiveRequest));
            }
            if (!JMSBridgeModule.this.automaticRequest) {
                Object object = this.consumerLock;
                synchronized (object) {
                    ++this.requests;
                    if (logger.isLoggable(BasicLevel.DEBUG)) {
                        logger.log(BasicLevel.DEBUG, (Object)"receive(): notify");
                    }
                    this.consumerLock.notify();
                    this.receiveRequest = true;
                }
            }
        }

        public void start() {
            if (logger.isLoggable(BasicLevel.DEBUG)) {
                logger.log(BasicLevel.DEBUG, (Object)("start() running =  " + this.running + ", automaticRequest = " + JMSBridgeModule.this.automaticRequest));
            }
            if (this.running) {
                return;
            }
            super.start();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void run() {
            if (logger.isLoggable(BasicLevel.DEBUG)) {
                logger.log(BasicLevel.DEBUG, (Object)"run()");
            }
            try {
                try {
                    JMSBridgeModule.this.setConsumer();
                    JMSBridgeModule.this.consumerCnx.start();
                    while (this.running) {
                        if (logger.isLoggable(BasicLevel.DEBUG)) {
                            logger.log(BasicLevel.DEBUG, (Object)("run: receiveRequest=" + this.receiveRequest + ", automaticRequest=" + JMSBridgeModule.this.automaticRequest));
                        }
                        Object object = this.consumerLock;
                        synchronized (object) {
                            if (JMSBridgeModule.this.automaticRequest || this.receiveRequest) {
                                this.process();
                            } else {
                                try {
                                    if (logger.isLoggable(BasicLevel.DEBUG)) {
                                        logger.log(BasicLevel.DEBUG, (Object)"run(): wait");
                                    }
                                    this.consumerLock.wait();
                                    if (logger.isLoggable(BasicLevel.DEBUG)) {
                                        logger.log(BasicLevel.DEBUG, (Object)"run(): after wait");
                                    }
                                    this.process();
                                }
                                catch (InterruptedException e2) {
                                    break;
                                }
                            }
                            this.receiveRequest = false;
                        }
                    }
                    Object var5_4 = null;
                }
                catch (JMSException jMSException) {
                    Object var5_5 = null;
                    this.finish();
                    return;
                }
            }
            catch (Throwable throwable) {
                Object var5_6 = null;
                this.finish();
                throw throwable;
            }
            this.finish();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void process() throws JMSException {
            Message momMessage;
            if (logger.isLoggable(BasicLevel.DEBUG)) {
                logger.log(BasicLevel.DEBUG, (Object)"process()");
            }
            this.canStop = true;
            XidImpl xid = null;
            Object object = JMSBridgeModule.this.lock;
            synchronized (object) {
                block33: {
                    try {
                        block32: {
                            if (JMSBridgeModule.this.isXA) {
                                xid = new XidImpl(new byte[0], 1, new String(JMSBridgeModule.this.agentId.toString() + System.currentTimeMillis()).getBytes());
                                if (logger.isLoggable(BasicLevel.DEBUG)) {
                                    logger.log(BasicLevel.DEBUG, (Object)("run: xid=" + xid));
                                }
                                try {
                                    JMSBridgeModule.this.consumerRes.start(xid, 0);
                                }
                                catch (XAException e) {
                                    if (!logger.isLoggable(BasicLevel.WARN)) break block32;
                                    logger.log(BasicLevel.WARN, (Object)("Exception:: XA can't start resource : " + JMSBridgeModule.this.consumerRes + ", xid = " + xid), (Throwable)e);
                                }
                            }
                        }
                        org.objectweb.joram.client.jms.Message clientMessage = org.objectweb.joram.client.jms.Message.convertJMSMessage(JMSBridgeModule.this.consumer.receive());
                        if (logger.isLoggable(BasicLevel.DEBUG)) {
                            logger.log(BasicLevel.DEBUG, (Object)("run: clientMessage=" + clientMessage));
                        }
                        momMessage = clientMessage.getMomMsg();
                        if (JMSBridgeModule.this.isXA) {
                            try {
                                JMSBridgeModule.this.consumerRes.end(xid, 0x4000000);
                                if (logger.isLoggable(BasicLevel.DEBUG)) {
                                    logger.log(BasicLevel.DEBUG, (Object)("run: XA end " + JMSBridgeModule.this.consumerRes));
                                }
                            }
                            catch (XAException e) {
                                if (logger.isLoggable(BasicLevel.DEBUG)) {
                                    logger.log(BasicLevel.DEBUG, (Object)("Exception:: XA resource end(...) failed: " + JMSBridgeModule.this.consumerRes + ", xid = " + xid), (Throwable)e);
                                }
                                throw new JMSException("XA resource end(...) failed: " + JMSBridgeModule.this.consumerRes + " :: " + e.getMessage());
                            }
                            try {
                                int ret = JMSBridgeModule.this.consumerRes.prepare(xid);
                                if (ret == 0) {
                                    JMSBridgeModule.this.consumerRes.commit(xid, false);
                                }
                                if (logger.isLoggable(BasicLevel.DEBUG)) {
                                    logger.log(BasicLevel.DEBUG, (Object)("run: XA commit " + JMSBridgeModule.this.consumerRes));
                                }
                                break block33;
                            }
                            catch (XAException e) {
                                if (logger.isLoggable(BasicLevel.DEBUG)) {
                                    logger.log(BasicLevel.DEBUG, (Object)("Exception:: XA resource rollback(" + xid + ")"), (Throwable)e);
                                }
                                try {
                                    JMSBridgeModule.this.consumerRes.rollback(xid);
                                    if (logger.isLoggable(BasicLevel.DEBUG)) {
                                        logger.log(BasicLevel.DEBUG, (Object)("run: XA rollback " + JMSBridgeModule.this.consumerRes));
                                    }
                                }
                                catch (XAException e1) {
                                    // empty catch block
                                }
                                throw new JMSException("XA resource rollback(" + xid + ") failed: " + JMSBridgeModule.this.consumerRes + " :: " + e.getMessage());
                            }
                        }
                        JMSBridgeModule.this.consumerSession.commit();
                    }
                    catch (MessageFormatException messageExc) {
                        if (JMSBridgeModule.this.isXA) {
                            try {
                                JMSBridgeModule.this.consumerRes.rollback(xid);
                                if (logger.isLoggable(BasicLevel.DEBUG)) {
                                    logger.log(BasicLevel.DEBUG, (Object)("run: XA rollback " + JMSBridgeModule.this.consumerRes));
                                }
                            }
                            catch (XAException e1) {}
                        } else {
                            JMSBridgeModule.this.consumerSession.rollback();
                            if (logger.isLoggable(BasicLevel.DEBUG)) {
                                logger.log(BasicLevel.DEBUG, (Object)("run: rollback " + JMSBridgeModule.this.consumerSession));
                            }
                        }
                        return;
                    }
                }
            }
            this.canStop = false;
            JMSBridgeDeliveryNot notif = new JMSBridgeDeliveryNot(momMessage);
            Channel.sendTo(JMSBridgeModule.this.agentId, notif);
            if (logger.isLoggable(BasicLevel.DEBUG)) {
                logger.log(BasicLevel.DEBUG, (Object)("run: sendTo momMessage=" + momMessage));
            }
            if (!JMSBridgeModule.this.automaticRequest) {
                --this.requests;
            }
        }

        public void shutdown() {
        }

        public void close() {
        }
    }

    protected class ReconnectionDaemon
    extends Daemon {
        private long interval1;
        private long interval2;
        private long interval3;

        protected ReconnectionDaemon() {
            super(JMSBridgeModule.this.agentId.toString() + ":ReconnectionDaemon");
            this.interval1 = 1000L;
            this.interval2 = 5000L;
            this.interval3 = 60000L;
            this.setDaemon(false);
            if (logger.isLoggable(BasicLevel.DEBUG)) {
                logger.log(BasicLevel.DEBUG, (Object)("ReconnectionDaemon<init> " + JMSBridgeModule.this.agentId));
            }
        }

        protected void reconnect() {
            if (logger.isLoggable(BasicLevel.DEBUG)) {
                logger.log(BasicLevel.DEBUG, (Object)("reconnect() running=" + this.running));
            }
            if (this.running) {
                return;
            }
            JMSBridgeModule.this.consumer = null;
            this.start();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            if (logger.isLoggable(BasicLevel.DEBUG)) {
                logger.log(BasicLevel.DEBUG, (Object)"run()");
            }
            int attempts = 0;
            try {
                while (this.running) {
                    this.canStop = true;
                    long interval = ++attempts <= 30 ? this.interval1 : (attempts <= 55 ? this.interval2 : this.interval3);
                    try {
                        Thread.sleep(interval);
                        if (JMSBridgeModule.this.isXA) {
                            JMSBridgeModule.this.doXAConnect();
                        } else {
                            JMSBridgeModule.this.doConnect();
                        }
                        if (JMSBridgeModule.this.listener) {
                            JMSBridgeModule.this.setMessageListener();
                        }
                        JMSBridgeModule.this.consumerDaemon.start();
                        while (!JMSBridgeModule.this.qout.isEmpty()) {
                            JMSBridgeModule.this.send((Message)JMSBridgeModule.this.qout.remove(0));
                        }
                    }
                    catch (Exception exc) {
                        continue;
                    }
                    this.canStop = false;
                    break;
                }
                Object var6_4 = null;
            }
            catch (Throwable throwable) {
                Object var6_5 = null;
                this.finish();
                throw throwable;
            }
            this.finish();
        }

        public void shutdown() {
        }

        public void close() {
        }
    }

    protected class StartupDaemon
    extends Daemon {
        protected StartupDaemon() {
            super(JMSBridgeModule.this.agentId.toString() + ":StartupDaemon");
            this.setDaemon(false);
            if (logger.isLoggable(BasicLevel.DEBUG)) {
                logger.log(BasicLevel.DEBUG, (Object)("StartupDaemon<init> " + JMSBridgeModule.this.agentId));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Loose catch block
         */
        public void run() {
            block43: {
                Context jndiCtx;
                block41: {
                    if (logger.isLoggable(BasicLevel.DEBUG)) {
                        logger.log(BasicLevel.DEBUG, (Object)"run()");
                    }
                    jndiCtx = null;
                    this.canStop = true;
                    if (!JMSBridgeModule.this.isXA && JMSBridgeModule.this.cnxFact == null || JMSBridgeModule.this.isXA && JMSBridgeModule.this.xaCnxFact == null || JMSBridgeModule.this.dest == null) {
                        if (JMSBridgeModule.this.jndiFactory == null || JMSBridgeModule.this.jndiUrl == null) {
                            jndiCtx = new InitialContext();
                        } else {
                            Hashtable<String, String> env = new Hashtable<String, String>();
                            env.put("java.naming.factory.initial", JMSBridgeModule.this.jndiFactory);
                            env.put("java.naming.provider.url", JMSBridgeModule.this.jndiUrl);
                            jndiCtx = new InitialContext(env);
                        }
                        Object factory = jndiCtx.lookup(JMSBridgeModule.this.cnxFactName);
                        if (factory instanceof XAConnectionFactory) {
                            JMSBridgeModule.this.isXA = true;
                            JMSBridgeModule.this.xaCnxFact = (XAConnectionFactory)factory;
                        } else {
                            JMSBridgeModule.this.cnxFact = (ConnectionFactory)factory;
                        }
                        JMSBridgeModule.this.dest = (Destination)jndiCtx.lookup(JMSBridgeModule.this.destName);
                        if (logger.isLoggable(BasicLevel.DEBUG)) {
                            logger.log(BasicLevel.DEBUG, (Object)("run: factory=" + factory + ", destination=" + JMSBridgeModule.this.dest));
                        }
                        if (JMSBridgeModule.this.dest instanceof Topic) {
                            JMSBridgeModule.this.automaticRequest = false;
                        }
                    }
                    try {
                        if (JMSBridgeModule.this.isXA) {
                            JMSBridgeModule.this.doXAConnect();
                        } else {
                            JMSBridgeModule.this.doConnect();
                        }
                        JMSBridgeModule.this.consumerDaemon.start();
                    }
                    catch (AbstractMethodError exc) {
                        JMSBridgeModule.this.usable = false;
                        JMSBridgeModule.this.notUsableMessage = "Retrieved administered objects types not compatible with the 'unified' communication  mode: " + exc;
                        if (logger.isLoggable(BasicLevel.DEBUG)) {
                            logger.log(BasicLevel.DEBUG, (Object)("Exception:: notUsableMessage=" + JMSBridgeModule.this.notUsableMessage), (Throwable)exc);
                        }
                    }
                    catch (ClassCastException exc) {
                        JMSBridgeModule.this.usable = false;
                        JMSBridgeModule.this.notUsableMessage = "Retrieved administered objects types not compatible with the chosen communication mode: " + exc;
                        if (logger.isLoggable(BasicLevel.DEBUG)) {
                            logger.log(BasicLevel.DEBUG, (Object)("Exception:: notUsableMessage=" + JMSBridgeModule.this.notUsableMessage), (Throwable)exc);
                        }
                    }
                    catch (JMSSecurityException exc) {
                        JMSBridgeModule.this.usable = false;
                        JMSBridgeModule.this.notUsableMessage = "Provided user identification does not allow to connect to the foreign JMS server: " + (Object)((Object)exc);
                        if (logger.isLoggable(BasicLevel.DEBUG)) {
                            logger.log(BasicLevel.DEBUG, (Object)("Exception:: notUsableMessage=" + JMSBridgeModule.this.notUsableMessage), (Throwable)exc);
                        }
                    }
                    catch (JMSException exc) {
                        if (logger.isLoggable(BasicLevel.DEBUG)) {
                            logger.log(BasicLevel.DEBUG, (Object)"Exception:: ", (Throwable)exc);
                        }
                        JMSBridgeModule.this.reconnectionDaemon.reconnect();
                    }
                    catch (Throwable exc) {
                        JMSBridgeModule.this.usable = false;
                        JMSBridgeModule.this.notUsableMessage = "" + exc;
                        if (!logger.isLoggable(BasicLevel.DEBUG)) break block41;
                        logger.log(BasicLevel.DEBUG, (Object)("Exception:: notUsableMessage=" + JMSBridgeModule.this.notUsableMessage), exc);
                    }
                }
                Object var4_12 = null;
                try {
                    jndiCtx.close();
                }
                catch (Exception exc2) {
                    // empty catch block
                }
                this.finish();
                {
                    break block43;
                    catch (NameNotFoundException exc) {
                        JMSBridgeModule.this.usable = false;
                        if (!JMSBridgeModule.this.isXA && JMSBridgeModule.this.cnxFact == null || JMSBridgeModule.this.isXA && JMSBridgeModule.this.xaCnxFact == null) {
                            JMSBridgeModule.this.notUsableMessage = "Could not retrieve ConnectionFactory [" + JMSBridgeModule.this.cnxFactName + "] from JNDI: " + exc;
                        } else if (JMSBridgeModule.this.dest == null) {
                            JMSBridgeModule.this.notUsableMessage = "Could not retrieve Destination [" + JMSBridgeModule.this.destName + "] from JNDI: " + exc;
                        }
                        if (logger.isLoggable(BasicLevel.DEBUG)) {
                            logger.log(BasicLevel.DEBUG, (Object)("Exception:: notUsableMessage=" + JMSBridgeModule.this.notUsableMessage), (Throwable)exc);
                        }
                        Object var4_13 = null;
                        try {
                            jndiCtx.close();
                        }
                        catch (Exception exc2) {
                            // empty catch block
                        }
                        this.finish();
                        break block43;
                    }
                    catch (NamingException exc) {
                        JMSBridgeModule.this.usable = false;
                        JMSBridgeModule.this.notUsableMessage = "Could not access JNDI: " + exc;
                        if (logger.isLoggable(BasicLevel.DEBUG)) {
                            logger.log(BasicLevel.DEBUG, (Object)("Exception:: notUsableMessage=" + JMSBridgeModule.this.notUsableMessage), (Throwable)exc);
                        }
                        Object var4_14 = null;
                        try {
                            jndiCtx.close();
                        }
                        catch (Exception exc2) {
                            // empty catch block
                        }
                        this.finish();
                        break block43;
                    }
                    catch (ClassCastException exc) {
                        JMSBridgeModule.this.usable = false;
                        JMSBridgeModule.this.notUsableMessage = "Error while retrieving administered objects through JNDI possibly because of missing foreign JMS client libraries in classpath: " + exc;
                        if (logger.isLoggable(BasicLevel.DEBUG)) {
                            logger.log(BasicLevel.DEBUG, (Object)("Exception:: notUsableMessage=" + JMSBridgeModule.this.notUsableMessage), (Throwable)exc);
                        }
                        Object var4_15 = null;
                        try {
                            jndiCtx.close();
                        }
                        catch (Exception exc2) {
                            // empty catch block
                        }
                        this.finish();
                        break block43;
                    }
                    catch (Exception exc) {
                        JMSBridgeModule.this.usable = false;
                        JMSBridgeModule.this.notUsableMessage = "Error while retrieving administered objects through JNDI: " + exc;
                        if (logger.isLoggable(BasicLevel.DEBUG)) {
                            logger.log(BasicLevel.DEBUG, (Object)("Exception:: notUsableMessage=" + JMSBridgeModule.this.notUsableMessage), (Throwable)exc);
                        }
                        Object var4_16 = null;
                        try {
                            jndiCtx.close();
                        }
                        catch (Exception exc2) {
                            // empty catch block
                        }
                        this.finish();
                    }
                }
                catch (Throwable throwable) {
                    Object var4_17 = null;
                    try {
                        jndiCtx.close();
                    }
                    catch (Exception exc2) {
                        // empty catch block
                    }
                    this.finish();
                    throw throwable;
                }
            }
        }

        public void shutdown() {
        }

        public void close() {
        }
    }
}

