/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.poa;

import org.apache.avalon.framework.configuration.Configurable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.logger.Logger;
import org.jacorb.poa.POAManager;
import org.jacorb.poa.POAManagerMonitor;
import org.jacorb.poa.gui.POAManagerMonitorController;
import org.jacorb.poa.gui.POAManagerMonitorView;
import org.jacorb.poa.gui.pm.POAManagerFrame;
import org.omg.PortableServer.POAManagerPackage.AdapterInactive;

public class POAManagerMonitorImpl
implements POAManagerMonitor,
POAManagerMonitorController,
Configurable {
    private POAManager model = null;
    private POAManagerMonitorView view = null;
    private org.jacorb.config.Configuration configuration = null;
    private Logger logger;

    public void configure(Configuration configuration) throws ConfigurationException {
        this.configuration = (org.jacorb.config.Configuration)configuration;
        this.logger = this.configuration.getNamedLogger("jacorb.poa.manager_monitor");
    }

    public void actionClosePOAMonitor(String string) {
        if (this.model != null) {
            try {
                this.printMessage("invoke \"closeMonitor()\" on POAMonitor " + string);
                this.model.getRegisteredPOA(this.reducePOAName(string)).getMonitor().closeMonitor();
                this.printMessage("closeMonitor() on POAMonitor " + string + " is returned successfully");
            }
            catch (Throwable throwable) {
                this.printMessage("exception ocurred: " + throwable);
            }
        }
    }

    public void actionCloseView() {
        this.closeMonitor();
    }

    public void actionDestroyPOA(String string) {
        if (this.model != null) {
            try {
                this.printMessage("invoke \"destroy()\" on POA " + string);
                this.model.getRegisteredPOA(this.reducePOAName(string)).destroy(true, true);
                this.printMessage("destroy() on POA " + string + " is returned successfully");
            }
            catch (Throwable throwable) {
                this.printMessage("exception ocurred: " + throwable);
            }
        }
    }

    public void actionOpenPOAMonitor(String string) {
        if (this.model != null) {
            try {
                this.printMessage("invoke \"openMonitor()\" on POAMonitor " + string);
                this.model.getRegisteredPOA(this.reducePOAName(string)).getMonitor().openMonitor();
                this.printMessage("openMonitor() on POAMonitor " + string + " is returned successfully");
            }
            catch (Throwable throwable) {
                this.printMessage("exception ocurred: " + throwable);
            }
        }
    }

    public void actionSetToActive() {
        if (this.model != null) {
            try {
                this.printMessage("invoke \"activate()\" on POAManager");
                this.model.activate();
                this.printMessage("activate() on POAManager is returned successfully");
            }
            catch (AdapterInactive adapterInactive) {
                this.printMessage("exception ocurred: " + adapterInactive);
                this.resetState();
            }
        }
    }

    public void actionSetToDiscarding(boolean bl) {
        if (this.model != null) {
            try {
                this.printMessage("invoke \"discard_requests(" + bl + ")\" on POAManager");
                this.model.discard_requests(bl);
                this.printMessage("discard_requests(" + bl + ") on POAManager is returned successfully");
            }
            catch (AdapterInactive adapterInactive) {
                this.printMessage("exception ocurred: " + adapterInactive);
                this.resetState();
            }
        }
    }

    public void actionSetToHolding(boolean bl) {
        if (this.model != null) {
            try {
                this.printMessage("invoke \"hold_requests(" + bl + ")\" on POAManager");
                this.model.hold_requests(bl);
                this.printMessage("hold_requests(" + bl + ") on POAManager is returned successfully");
            }
            catch (AdapterInactive adapterInactive) {
                this.printMessage("exception ocurred: " + adapterInactive);
                this.resetState();
            }
        }
    }

    public void actionSetToInactive(boolean bl, boolean bl2) {
        if (this.model != null) {
            try {
                this.printMessage("invoke \"deactivate(" + bl2 + ", " + bl + ")\" on POAManager");
                this.model.deactivate(bl2, bl);
                this.printMessage("deactivate(" + bl2 + ", " + bl + ") on POAManager is returned successfully");
            }
            catch (AdapterInactive adapterInactive) {
                this.printMessage("exception ocurred: " + adapterInactive);
                this.resetState();
            }
        }
    }

    public synchronized void addPOA(String string) {
        if (this.view != null) {
            block3: {
                try {
                    this.view._addPOA(this.expandPOAName(string));
                }
                catch (Throwable throwable) {
                    if (!this.logger.isErrorEnabled()) break block3;
                    this.logger.error("Exception in addPOA()" + throwable.getMessage());
                }
            }
            this.printMessage("register POA " + string);
        }
    }

    public synchronized void closeMonitor() {
        block3: {
            if (this.view != null) {
                try {
                    POAManagerMonitor pOAManagerMonitor = (POAManagerMonitor)Class.forName("org.jacorb.poa.POAManagerMonitorImpl").newInstance();
                    pOAManagerMonitor.init(this.model);
                    pOAManagerMonitor.configure(this.configuration);
                    this.model.setMonitor(pOAManagerMonitor);
                    POAManagerMonitorView pOAManagerMonitorView = this.view;
                    this.view = null;
                    pOAManagerMonitorView._destroy();
                }
                catch (Throwable throwable) {
                    if (!this.logger.isErrorEnabled()) break block3;
                    this.logger.error("Exception in closeMonitor" + throwable.getMessage());
                }
            }
        }
    }

    private String expandPOAName(String string) {
        return string.equals("") ? "RootPOA" : "RootPOA/" + string;
    }

    public void init(POAManager pOAManager) {
        this.model = pOAManager;
    }

    public synchronized void openMonitor() {
        block2: {
            try {
                this.view = new POAManagerFrame(this);
                this.view._setVisible(true);
            }
            catch (Throwable throwable) {
                if (!this.logger.isErrorEnabled()) break block2;
                this.logger.error("Exception in openMonitor" + throwable.getMessage());
            }
        }
    }

    public synchronized void printMessage(String string) {
        block3: {
            if (this.view != null) {
                try {
                    this.view._printMessage(string);
                }
                catch (Throwable throwable) {
                    if (!this.logger.isErrorEnabled()) break block3;
                    this.logger.error("Exception int printMessage(): " + throwable.getMessage());
                }
            }
        }
    }

    private String reducePOAName(String string) {
        return string.equals("RootPOA") ? "" : string.substring("RootPOA".length() + 1);
    }

    public synchronized void removePOA(String string) {
        if (this.view != null) {
            block3: {
                try {
                    this.view._removePOA(this.expandPOAName(string));
                }
                catch (Throwable throwable) {
                    if (!this.logger.isErrorEnabled()) break block3;
                    this.logger.error("Exception in printMessage(): " + throwable.getMessage());
                }
            }
            this.printMessage("unregister POA " + string);
        }
    }

    protected synchronized void resetState() {
        block3: {
            if (this.view != null) {
                try {
                    this.view._resetState();
                }
                catch (Throwable throwable) {
                    if (!this.logger.isErrorEnabled()) break block3;
                    this.logger.error("Exception in resetState(): " + throwable.getMessage());
                }
            }
        }
    }

    public synchronized void setToActive() {
        if (this.view != null) {
            block3: {
                try {
                    this.view._setToActive();
                }
                catch (Throwable throwable) {
                    if (!this.logger.isErrorEnabled()) break block3;
                    this.logger.error("Exception in setToActive(): " + throwable.getMessage());
                }
            }
            this.printMessage("POAManager is set to \"active\"");
        }
    }

    public synchronized void setToDiscarding(boolean bl) {
        if (this.view != null) {
            block3: {
                try {
                    this.view._setToDiscarding(bl);
                }
                catch (Throwable throwable) {
                    if (!this.logger.isErrorEnabled()) break block3;
                    this.logger.error("Exception in setToActive(): " + throwable.getMessage());
                }
            }
            this.printMessage("POAManager is set to \"discarding\"");
        }
    }

    public synchronized void setToHolding(boolean bl) {
        if (this.view != null) {
            block3: {
                try {
                    this.view._setToHolding(bl);
                }
                catch (Throwable throwable) {
                    if (!this.logger.isErrorEnabled()) break block3;
                    this.logger.error("Exception in setToHolding(): " + throwable.getMessage());
                }
            }
            this.printMessage("POAManager is set to \"holding\"");
        }
    }

    public synchronized void setToInactive(boolean bl, boolean bl2) {
        if (this.view != null) {
            block3: {
                try {
                    this.view._setToInactive(bl, bl2);
                }
                catch (Throwable throwable) {
                    if (!this.logger.isErrorEnabled()) break block3;
                    this.logger.error("Exception in setToInactive(): " + throwable.getMessage());
                }
            }
            this.printMessage("POAManager is set to \"inactive\"");
        }
    }
}

