/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.ws.policy.builder.jaxb;

import java.util.Collection;
import java.util.Collections;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.namespace.QName;
import org.apache.cxf.common.classloader.ClassLoaderUtils;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.common.util.PackageUtils;
import org.apache.cxf.jaxb.JAXBUtils;
import org.apache.cxf.ws.policy.AssertionBuilder;
import org.apache.cxf.ws.policy.PolicyAssertion;
import org.apache.cxf.ws.policy.builder.jaxb.JaxbAssertion;
import org.apache.neethi.Constants;
import org.apache.neethi.PolicyComponent;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JaxbAssertionBuilder<T>
implements AssertionBuilder {
    private static final Logger LOG = LogUtils.getL7dLogger(JaxbAssertionBuilder.class);
    private Unmarshaller unmarshaller;
    private Collection<QName> supportedTypes;
    private Class<T> type;

    public JaxbAssertionBuilder(QName qn) throws JAXBException, ClassNotFoundException {
        this(JAXBUtils.namespaceURIToPackage(qn.getNamespaceURI()) + "." + JAXBUtils.nameToIdentifier(qn.getLocalPart(), JAXBUtils.IdentifierType.CLASS), qn);
    }

    public JaxbAssertionBuilder(String className, QName qn) throws JAXBException, ClassNotFoundException {
        this(ClassLoaderUtils.loadClass(className, JaxbAssertionBuilder.class), qn);
    }

    public JaxbAssertionBuilder(Class<T> type, QName qn) throws JAXBException {
        this.type = type;
        this.supportedTypes = Collections.singletonList(qn);
    }

    protected Unmarshaller getUnmarshaller() {
        if (this.unmarshaller == null) {
            try {
                this.createUnmarhsaller();
            }
            catch (JAXBException e) {
                throw new RuntimeException(e);
            }
        }
        return this.unmarshaller;
    }

    protected synchronized void createUnmarhsaller() throws JAXBException {
        if (this.unmarshaller != null) {
            return;
        }
        JAXBContext context = JAXBContext.newInstance((String)PackageUtils.getPackageName(this.type), (ClassLoader)this.type.getClassLoader());
        this.unmarshaller = context.createUnmarshaller();
    }

    @Override
    public PolicyAssertion build(Element element) {
        QName name = new QName(element.getNamespaceURI(), element.getLocalName());
        JaxbAssertion<T> assertion = this.buildAssertion();
        assertion.setName(name);
        assertion.setOptional(this.getOptionality(element));
        assertion.setData(this.getData(element));
        return assertion;
    }

    @Override
    public Collection<QName> getKnownElements() {
        return this.supportedTypes;
    }

    @Override
    public PolicyAssertion buildCompatible(PolicyAssertion a, PolicyAssertion b) {
        if (a.equal((PolicyComponent)b)) {
            JaxbAssertion ja = (JaxbAssertion)a;
            JaxbAssertion compatible = this.buildAssertion();
            compatible.setName(a.getName());
            compatible.setOptional(a.isOptional() && b.isOptional());
            compatible.setData(ja.getData());
            return compatible;
        }
        return null;
    }

    protected JaxbAssertion<T> buildAssertion() {
        return new JaxbAssertion();
    }

    protected boolean getOptionality(Element element) {
        boolean optional = false;
        String value = element.getAttributeNS(Constants.Q_ELEM_OPTIONAL_ATTR.getNamespaceURI(), Constants.Q_ELEM_OPTIONAL_ATTR.getLocalPart());
        if (Boolean.valueOf(value).booleanValue()) {
            optional = true;
        }
        return optional;
    }

    protected T getData(Element element) {
        Object obj = null;
        try {
            obj = this.getUnmarshaller().unmarshal((Node)element);
        }
        catch (JAXBException ex) {
            LogUtils.log(LOG, Level.SEVERE, "UNMARSHAL_ELEMENT_EXC", ex);
        }
        if (obj instanceof JAXBElement) {
            JAXBElement el = (JAXBElement)obj;
            obj = el.getValue();
        }
        if (null != obj && LOG.isLoggable(Level.FINE)) {
            LOG.fine("Unmarshaled element into object of type: " + obj.getClass().getName() + "    value: " + obj);
        }
        return (T)obj;
    }
}

