/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.deployablemonitor;

import java.io.File;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.apache.felix.ipojo.ComponentInstance;
import org.apache.felix.ipojo.InstanceManager;
import org.apache.felix.ipojo.Pojo;
import org.ow2.jonas.deployablemonitor.DeployableMonitor;
import org.ow2.jonas.depmonitor.MonitoringService;
import org.ow2.jonas.jmx.JmxService;
import org.ow2.jonas.lib.bootstrap.JProp;
import org.ow2.jonas.lib.service.AbsServiceImpl;
import org.ow2.jonas.lib.util.JonasObjectName;
import org.ow2.jonas.management.J2EEServerService;
import org.ow2.jonas.service.ServiceException;
import org.ow2.util.ee.deploy.api.deployer.IDeployerManager;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;

public class DeployableMonitorService
extends AbsServiceImpl
implements MonitoringService,
Pojo {
    private InstanceManager __IM;
    public static final String DEVELOPMENT_MODE_PROPERTY = "development";
    public static final String DIRECTORIES_LIST_PROPERTY = "directories";
    protected static final String JONAS_BASE = JProp.getJonasBase();
    public static final String DEFAULT_DIRECTORY = JONAS_BASE + File.separator + "deploy";
    private boolean __Flogger;
    private Log logger;
    private boolean __FdevelopmentMode;
    private boolean developmentMode;
    private boolean __FjmxService;
    private JmxService jmxService;
    private boolean __Fdirectories;
    private List<File> directories;
    private boolean __FdeployableMonitor;
    private DeployableMonitor deployableMonitor;
    private boolean __FreadyToRunning;
    private boolean readyToRunning;
    private boolean __Fj2eeServer;
    private J2EEServerService j2eeServer;
    private boolean __MdoStart;
    private boolean __MstartMonitoring;
    private boolean __MdoStop;
    private boolean __MsetDirectories$java_lang_String;
    private boolean __MgetDirectoryNames;
    private boolean __MsetExclusions$java_lang_String;
    private boolean __MsetDeployerManager$org_ow2_util_ee_deploy_api_deployer_IDeployerManager;
    private boolean __MsetJmxService$org_ow2_jonas_jmx_JmxService;
    private boolean __MsetJ2EEServer$org_ow2_jonas_management_J2EEServerService;
    private boolean __MfirstCheckEnded;
    private boolean __MisReadyToRunning;
    private boolean __MsetReadyToRunning$boolean;
    private boolean __MisDevelopmentMode;
    private boolean __MsetDevelopmentMode$java_lang_String;
    private boolean __MgetDeployableMonitor;

    Log __getlogger() {
        if (!this.__Flogger) {
            return this.logger;
        }
        return (Log)this.__IM.onGet((Object)this, "logger");
    }

    void __setlogger(Log log) {
        if (!this.__Flogger) {
            this.logger = log;
            return;
        }
        this.__IM.onSet((Object)this, "logger", (Object)log);
    }

    boolean __getdevelopmentMode() {
        if (!this.__FdevelopmentMode) {
            return this.developmentMode;
        }
        Object object = this.__IM.onGet((Object)this, "developmentMode");
        Boolean bl = (Boolean)object;
        return bl;
    }

    void __setdevelopmentMode(boolean bl) {
        if (!this.__FdevelopmentMode) {
            this.developmentMode = bl;
            return;
        }
        Boolean bl2 = new Boolean(bl);
        this.__IM.onSet((Object)this, "developmentMode", (Object)bl2);
    }

    JmxService __getjmxService() {
        if (!this.__FjmxService) {
            return this.jmxService;
        }
        return (JmxService)this.__IM.onGet((Object)this, "jmxService");
    }

    void __setjmxService(JmxService jmxService) {
        if (!this.__FjmxService) {
            this.jmxService = jmxService;
            return;
        }
        this.__IM.onSet((Object)this, "jmxService", (Object)jmxService);
    }

    List __getdirectories() {
        if (!this.__Fdirectories) {
            return this.directories;
        }
        return (List)this.__IM.onGet((Object)this, DIRECTORIES_LIST_PROPERTY);
    }

    void __setdirectories(List list) {
        if (!this.__Fdirectories) {
            this.directories = list;
            return;
        }
        this.__IM.onSet((Object)this, DIRECTORIES_LIST_PROPERTY, (Object)list);
    }

    DeployableMonitor __getdeployableMonitor() {
        if (!this.__FdeployableMonitor) {
            return this.deployableMonitor;
        }
        return (DeployableMonitor)this.__IM.onGet((Object)this, "deployableMonitor");
    }

    void __setdeployableMonitor(DeployableMonitor deployableMonitor) {
        if (!this.__FdeployableMonitor) {
            this.deployableMonitor = deployableMonitor;
            return;
        }
        this.__IM.onSet((Object)this, "deployableMonitor", (Object)deployableMonitor);
    }

    boolean __getreadyToRunning() {
        if (!this.__FreadyToRunning) {
            return this.readyToRunning;
        }
        Object object = this.__IM.onGet((Object)this, "readyToRunning");
        Boolean bl = (Boolean)object;
        return bl;
    }

    void __setreadyToRunning(boolean bl) {
        if (!this.__FreadyToRunning) {
            this.readyToRunning = bl;
            return;
        }
        Boolean bl2 = new Boolean(bl);
        this.__IM.onSet((Object)this, "readyToRunning", (Object)bl2);
    }

    J2EEServerService __getj2eeServer() {
        if (!this.__Fj2eeServer) {
            return this.j2eeServer;
        }
        return (J2EEServerService)this.__IM.onGet((Object)this, "j2eeServer");
    }

    void __setj2eeServer(J2EEServerService j2EEServerService) {
        if (!this.__Fj2eeServer) {
            this.j2eeServer = j2EEServerService;
            return;
        }
        this.__IM.onSet((Object)this, "j2eeServer", (Object)j2EEServerService);
    }

    public DeployableMonitorService() {
        this(null);
    }

    private DeployableMonitorService(InstanceManager _manager) {
        this._setInstanceManager(_manager);
        this.__setlogger(LogFactory.getLog(DeployableMonitor.class));
        this.__setdevelopmentMode(true);
        this.__setjmxService(null);
        this.__setdirectories(null);
        this.__setdeployableMonitor(null);
        this.__setreadyToRunning(false);
        this.__setj2eeServer(null);
        this.__setdirectories(new LinkedList());
        this.__setdeployableMonitor(new DeployableMonitor(this));
    }

    protected void doStart() throws ServiceException {
        if (!this.__MdoStart) {
            this.__doStart();
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "doStart", new Object[0]);
            this.__doStart();
            this.__IM.onExit((Object)this, "doStart", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "doStart", throwable);
            throw throwable;
        }
    }

    private void __doStart() throws ServiceException {
        this.__getlogger().info((Object)"Use the deploy directories ''{0}'', development mode is ''{1}''", new Object[]{this.__getdirectories(), this.__getdevelopmentMode()});
        File defaultDirectory = new File(DEFAULT_DIRECTORY);
        if (!defaultDirectory.exists()) {
            this.__getlogger().info((Object)"Creating default deploy directory ''{0}''", new Object[]{defaultDirectory});
            defaultDirectory.mkdirs();
        }
        this.__getdirectories().add(defaultDirectory);
        if (this.__getjmxService() != null) {
            this.__getjmxService().loadDescriptors(((Object)((Object)this)).getClass().getPackage().getName(), ((Object)((Object)this)).getClass().getClassLoader());
            try {
                this.__getjmxService().registerModelMBean((Object)this, JonasObjectName.deployableMonitorService((String)this.getDomainName()));
            }
            catch (Exception e) {
                this.__getlogger().warn((Object)"Cannot register MBean for Deployable Monitor service", new Object[]{e});
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
    }

    public void startMonitoring() {
        if (!this.__MstartMonitoring) {
            this.__startMonitoring();
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "startMonitoring", new Object[0]);
            this.__startMonitoring();
            this.__IM.onExit((Object)this, "startMonitoring", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "startMonitoring", throwable);
            throw throwable;
        }
    }

    private void __startMonitoring() {
        if (!this.getDeployableMonitor().isAlive()) {
            this.__getlogger().debug((Object)"Start DeployableMonitor", new Object[0]);
            this.__getdeployableMonitor().start();
        }
    }

    protected void doStop() throws ServiceException {
        if (!this.__MdoStop) {
            this.__doStop();
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "doStop", new Object[0]);
            this.__doStop();
            this.__IM.onExit((Object)this, "doStop", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "doStop", throwable);
            throw throwable;
        }
    }

    private void __doStop() throws ServiceException {
        if (this.__getjmxService() != null) {
            try {
                this.__getjmxService().unregisterModelMBean(JonasObjectName.deployableMonitorService((String)this.getDomainName()));
            }
            catch (Exception e) {
                this.__getlogger().warn((Object)"Cannot unregister MBean for Deployable Monitor service", new Object[]{e});
            }
        }
        this.__getdeployableMonitor().stopOrder();
        this.__setdeployableMonitor(null);
        this.__getlogger().info((Object)"DeployableMonitor stopped successfully", new Object[0]);
    }

    public void setDirectories(String string) {
        if (!this.__MsetDirectories$java_lang_String) {
            this.__setDirectories(string);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "setDirectories$java_lang_String", new Object[]{string});
            this.__setDirectories(string);
            this.__IM.onExit((Object)this, "setDirectories$java_lang_String", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "setDirectories$java_lang_String", throwable);
            throw throwable;
        }
    }

    private void __setDirectories(String dirs) {
        List additionalDirectories = DeployableMonitorService.convertToList((String)dirs);
        for (String dir : additionalDirectories) {
            File tmpFile = new File(dir);
            if (!tmpFile.isAbsolute()) {
                tmpFile = new File(JONAS_BASE + File.separator + dir);
            }
            if (!tmpFile.exists()) {
                this.__getlogger().warn((Object)"The given directory ''{0}'' is neither present on the filesystem or in JONAS_BASE ''{1}''", new Object[]{tmpFile, JONAS_BASE});
                continue;
            }
            this.__getdirectories().add(tmpFile);
        }
        this.getDeployableMonitor().setDirectories(this.__getdirectories());
    }

    public String[] getDirectoryNames() {
        String[] stringArray;
        if (!this.__MgetDirectoryNames) {
            return this.__getDirectoryNames();
        }
        try {
            this.__IM.onEntry((Object)this, "getDirectoryNames", new Object[0]);
            stringArray = this.__getDirectoryNames();
            this.__IM.onExit((Object)this, "getDirectoryNames", (Object)stringArray);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "getDirectoryNames", throwable);
            throw throwable;
        }
        return stringArray;
    }

    private String[] __getDirectoryNames() {
        ArrayList<String> result = new ArrayList<String>();
        for (File directory : this.__getdirectories()) {
            result.add(directory.getName());
        }
        String[] dirNames = new String[result.size()];
        int i = 0;
        for (String dir : result) {
            dirNames[i++] = dir;
        }
        return dirNames;
    }

    public void setExclusions(String string) {
        if (!this.__MsetExclusions$java_lang_String) {
            this.__setExclusions(string);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "setExclusions$java_lang_String", new Object[]{string});
            this.__setExclusions(string);
            this.__IM.onExit((Object)this, "setExclusions$java_lang_String", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "setExclusions$java_lang_String", throwable);
            throw throwable;
        }
    }

    private void __setExclusions(String exclusionList) {
        List exclusions = DeployableMonitorService.convertToList((String)exclusionList);
        this.getDeployableMonitor().setExclusionPatterns(exclusions);
    }

    public void setDeployerManager(IDeployerManager iDeployerManager) {
        if (!this.__MsetDeployerManager$org_ow2_util_ee_deploy_api_deployer_IDeployerManager) {
            this.__setDeployerManager(iDeployerManager);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "setDeployerManager$org_ow2_util_ee_deploy_api_deployer_IDeployerManager", new Object[]{iDeployerManager});
            this.__setDeployerManager(iDeployerManager);
            this.__IM.onExit((Object)this, "setDeployerManager$org_ow2_util_ee_deploy_api_deployer_IDeployerManager", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "setDeployerManager$org_ow2_util_ee_deploy_api_deployer_IDeployerManager", throwable);
            throw throwable;
        }
    }

    private void __setDeployerManager(IDeployerManager deployerManager) {
        this.getDeployableMonitor().setDeployerManager(deployerManager);
    }

    public void setJmxService(JmxService jmxService) {
        if (!this.__MsetJmxService$org_ow2_jonas_jmx_JmxService) {
            this.__setJmxService(jmxService);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "setJmxService$org_ow2_jonas_jmx_JmxService", new Object[]{jmxService});
            this.__setJmxService(jmxService);
            this.__IM.onExit((Object)this, "setJmxService$org_ow2_jonas_jmx_JmxService", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "setJmxService$org_ow2_jonas_jmx_JmxService", throwable);
            throw throwable;
        }
    }

    private void __setJmxService(JmxService jmxService) {
        this.__setjmxService(jmxService);
    }

    public void setJ2EEServer(J2EEServerService j2EEServerService) {
        if (!this.__MsetJ2EEServer$org_ow2_jonas_management_J2EEServerService) {
            this.__setJ2EEServer(j2EEServerService);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "setJ2EEServer$org_ow2_jonas_management_J2EEServerService", new Object[]{j2EEServerService});
            this.__setJ2EEServer(j2EEServerService);
            this.__IM.onExit((Object)this, "setJ2EEServer$org_ow2_jonas_management_J2EEServerService", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "setJ2EEServer$org_ow2_jonas_management_J2EEServerService", throwable);
            throw throwable;
        }
    }

    private void __setJ2EEServer(J2EEServerService j2eeServer) {
        this.__setj2eeServer(j2eeServer);
    }

    public void firstCheckEnded() {
        if (!this.__MfirstCheckEnded) {
            this.__firstCheckEnded();
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "firstCheckEnded", new Object[0]);
            this.__firstCheckEnded();
            this.__IM.onExit((Object)this, "firstCheckEnded", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "firstCheckEnded", throwable);
            throw throwable;
        }
    }

    private void __firstCheckEnded() {
        this.__getj2eeServer().setRunning();
    }

    public boolean isReadyToRunning() {
        boolean bl;
        if (!this.__MisReadyToRunning) {
            return this.__isReadyToRunning();
        }
        try {
            this.__IM.onEntry((Object)this, "isReadyToRunning", new Object[0]);
            bl = this.__isReadyToRunning();
            this.__IM.onExit((Object)this, "isReadyToRunning", (Object)new Boolean(bl));
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "isReadyToRunning", throwable);
            throw throwable;
        }
        return bl;
    }

    private boolean __isReadyToRunning() {
        return this.__getreadyToRunning();
    }

    public void setReadyToRunning(boolean bl) {
        if (!this.__MsetReadyToRunning$boolean) {
            this.__setReadyToRunning(bl);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "setReadyToRunning$boolean", new Object[]{new Boolean(bl)});
            this.__setReadyToRunning(bl);
            this.__IM.onExit((Object)this, "setReadyToRunning$boolean", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "setReadyToRunning$boolean", throwable);
            throw throwable;
        }
    }

    private void __setReadyToRunning(boolean readyToRunning) {
        this.__setreadyToRunning(readyToRunning);
    }

    public boolean isDevelopmentMode() {
        boolean bl;
        if (!this.__MisDevelopmentMode) {
            return this.__isDevelopmentMode();
        }
        try {
            this.__IM.onEntry((Object)this, "isDevelopmentMode", new Object[0]);
            bl = this.__isDevelopmentMode();
            this.__IM.onExit((Object)this, "isDevelopmentMode", (Object)new Boolean(bl));
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "isDevelopmentMode", throwable);
            throw throwable;
        }
        return bl;
    }

    private boolean __isDevelopmentMode() {
        return this.__getdevelopmentMode();
    }

    public void setDevelopmentMode(String string) {
        if (!this.__MsetDevelopmentMode$java_lang_String) {
            this.__setDevelopmentMode(string);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "setDevelopmentMode$java_lang_String", new Object[]{string});
            this.__setDevelopmentMode(string);
            this.__IM.onExit((Object)this, "setDevelopmentMode$java_lang_String", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "setDevelopmentMode$java_lang_String", throwable);
            throw throwable;
        }
    }

    private void __setDevelopmentMode(String mode) {
        if (mode.equals("inherit")) {
            this.__setdevelopmentMode(this.getServerProperties().isDevelopment());
        } else {
            this.__setdevelopmentMode(Boolean.parseBoolean(mode));
        }
        this.getDeployableMonitor().setDevelopmentMode(this.__getdevelopmentMode());
    }

    private DeployableMonitor getDeployableMonitor() {
        DeployableMonitor deployableMonitor;
        if (!this.__MgetDeployableMonitor) {
            return this.__getDeployableMonitor();
        }
        try {
            this.__IM.onEntry((Object)this, "getDeployableMonitor", new Object[0]);
            deployableMonitor = this.__getDeployableMonitor();
            this.__IM.onExit((Object)this, "getDeployableMonitor", (Object)deployableMonitor);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "getDeployableMonitor", throwable);
            throw throwable;
        }
        return deployableMonitor;
    }

    private DeployableMonitor __getDeployableMonitor() {
        if (this.__getdeployableMonitor() == null) {
            this.__setdeployableMonitor(new DeployableMonitor(this));
        }
        return this.__getdeployableMonitor();
    }

    private void _setInstanceManager(InstanceManager instanceManager) {
        if (instanceManager == null) {
            return;
        }
        this.__IM = instanceManager;
        Set set = this.__IM.getRegistredFields();
        if (set != null) {
            if (set.contains(DIRECTORIES_LIST_PROPERTY)) {
                this.__Fdirectories = true;
            }
            if (set.contains("j2eeServer")) {
                this.__Fj2eeServer = true;
            }
            if (set.contains("readyToRunning")) {
                this.__FreadyToRunning = true;
            }
            if (set.contains("developmentMode")) {
                this.__FdevelopmentMode = true;
            }
            if (set.contains("deployableMonitor")) {
                this.__FdeployableMonitor = true;
            }
            if (set.contains("logger")) {
                this.__Flogger = true;
            }
            if (set.contains("jmxService")) {
                this.__FjmxService = true;
            }
        }
        if ((set = this.__IM.getRegistredMethods()) != null) {
            if (set.contains("doStart")) {
                this.__MdoStart = true;
            }
            if (set.contains("startMonitoring")) {
                this.__MstartMonitoring = true;
            }
            if (set.contains("doStop")) {
                this.__MdoStop = true;
            }
            if (set.contains("setDirectories$java_lang_String")) {
                this.__MsetDirectories$java_lang_String = true;
            }
            if (set.contains("getDirectoryNames")) {
                this.__MgetDirectoryNames = true;
            }
            if (set.contains("setExclusions$java_lang_String")) {
                this.__MsetExclusions$java_lang_String = true;
            }
            if (set.contains("setDeployerManager$org_ow2_util_ee_deploy_api_deployer_IDeployerManager")) {
                this.__MsetDeployerManager$org_ow2_util_ee_deploy_api_deployer_IDeployerManager = true;
            }
            if (set.contains("setJmxService$org_ow2_jonas_jmx_JmxService")) {
                this.__MsetJmxService$org_ow2_jonas_jmx_JmxService = true;
            }
            if (set.contains("setJ2EEServer$org_ow2_jonas_management_J2EEServerService")) {
                this.__MsetJ2EEServer$org_ow2_jonas_management_J2EEServerService = true;
            }
            if (set.contains("firstCheckEnded")) {
                this.__MfirstCheckEnded = true;
            }
            if (set.contains("isReadyToRunning")) {
                this.__MisReadyToRunning = true;
            }
            if (set.contains("setReadyToRunning$boolean")) {
                this.__MsetReadyToRunning$boolean = true;
            }
            if (set.contains("isDevelopmentMode")) {
                this.__MisDevelopmentMode = true;
            }
            if (set.contains("setDevelopmentMode$java_lang_String")) {
                this.__MsetDevelopmentMode$java_lang_String = true;
            }
            if (set.contains("getDeployableMonitor")) {
                this.__MgetDeployableMonitor = true;
            }
        }
    }

    public ComponentInstance getComponentInstance() {
        return this.__IM;
    }
}

