/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.fastinfoset.stax.events;

import com.sun.xml.fastinfoset.CommonResourceBundle;
import com.sun.xml.fastinfoset.stax.events.AttributeBase;
import com.sun.xml.fastinfoset.stax.events.CharactersEvent;
import com.sun.xml.fastinfoset.stax.events.CommentEvent;
import com.sun.xml.fastinfoset.stax.events.DTDEvent;
import com.sun.xml.fastinfoset.stax.events.EndDocumentEvent;
import com.sun.xml.fastinfoset.stax.events.EndElementEvent;
import com.sun.xml.fastinfoset.stax.events.EntityDeclarationImpl;
import com.sun.xml.fastinfoset.stax.events.EntityReferenceEvent;
import com.sun.xml.fastinfoset.stax.events.EventBase;
import com.sun.xml.fastinfoset.stax.events.NamespaceBase;
import com.sun.xml.fastinfoset.stax.events.ProcessingInstructionEvent;
import com.sun.xml.fastinfoset.stax.events.StartDocumentEvent;
import com.sun.xml.fastinfoset.stax.events.StartElementEvent;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.events.XMLEvent;
import javax.xml.stream.util.XMLEventAllocator;
import javax.xml.stream.util.XMLEventConsumer;

public class StAXEventAllocator
implements XMLEventAllocator {
    StartElementEvent startElement = new StartElementEvent();
    EndElementEvent endElement = new EndElementEvent();
    CharactersEvent characters = new CharactersEvent();
    CharactersEvent cData = new CharactersEvent("", true);
    CharactersEvent space = new CharactersEvent();
    CommentEvent comment = new CommentEvent();
    EntityReferenceEvent entity = new EntityReferenceEvent();
    ProcessingInstructionEvent pi = new ProcessingInstructionEvent();
    StartDocumentEvent startDoc = new StartDocumentEvent();
    EndDocumentEvent endDoc = new EndDocumentEvent();
    DTDEvent dtd = new DTDEvent();

    public XMLEventAllocator newInstance() {
        return new StAXEventAllocator();
    }

    public XMLEvent allocate(XMLStreamReader streamReader) throws XMLStreamException {
        if (streamReader == null) {
            throw new XMLStreamException(CommonResourceBundle.getInstance().getString("message.nullReader"));
        }
        return this.getXMLEvent(streamReader);
    }

    public void allocate(XMLStreamReader streamReader, XMLEventConsumer consumer) throws XMLStreamException {
        consumer.add(this.getXMLEvent(streamReader));
    }

    XMLEvent getXMLEvent(XMLStreamReader reader) {
        EventBase event = null;
        int eventType = reader.getEventType();
        switch (eventType) {
            case 1: {
                this.startElement.reset();
                this.startElement.setName(new QName(reader.getNamespaceURI(), reader.getLocalName(), reader.getPrefix()));
                this.addAttributes(this.startElement, reader);
                this.addNamespaces(this.startElement, reader);
                event = this.startElement;
                break;
            }
            case 2: {
                this.endElement.reset();
                this.endElement.setName(new QName(reader.getNamespaceURI(), reader.getLocalName(), reader.getPrefix()));
                this.addNamespaces(this.endElement, reader);
                event = this.endElement;
                break;
            }
            case 3: {
                this.pi.setTarget(reader.getPITarget());
                this.pi.setData(reader.getPIData());
                event = this.pi;
                break;
            }
            case 4: {
                this.characters.setData(reader.getText());
                event = this.characters;
                break;
            }
            case 5: {
                this.comment.setText(reader.getText());
                event = this.comment;
                break;
            }
            case 7: {
                this.startDoc.reset();
                String encoding = reader.getEncoding();
                String version2 = reader.getVersion();
                if (encoding != null) {
                    this.startDoc.setEncoding(encoding);
                }
                if (version2 != null) {
                    this.startDoc.setVersion(version2);
                }
                this.startDoc.setStandalone(reader.isStandalone());
                if (reader.getCharacterEncodingScheme() != null) {
                    this.startDoc.setDeclaredEncoding(true);
                } else {
                    this.startDoc.setDeclaredEncoding(false);
                }
                event = this.startDoc;
                break;
            }
            case 8: {
                event = this.endDoc;
                break;
            }
            case 9: {
                this.entity.setName(reader.getLocalName());
                this.entity.setDeclaration(new EntityDeclarationImpl(reader.getLocalName(), reader.getText()));
                event = this.entity;
                break;
            }
            case 10: {
                event = null;
                break;
            }
            case 11: {
                this.dtd.setDTD(reader.getText());
                event = this.dtd;
                break;
            }
            case 12: {
                this.cData.setData(reader.getText());
                event = this.cData;
                break;
            }
            case 6: {
                this.space.setData(reader.getText());
                this.space.setSpace(true);
                event = this.space;
            }
        }
        event.setLocation(reader.getLocation());
        return event;
    }

    protected void addAttributes(StartElementEvent event, XMLStreamReader reader) {
        AttributeBase attr = null;
        for (int i = 0; i < reader.getAttributeCount(); ++i) {
            attr = new AttributeBase(reader.getAttributeName(i), reader.getAttributeValue(i));
            attr.setAttributeType(reader.getAttributeType(i));
            attr.setSpecified(reader.isAttributeSpecified(i));
            event.addAttribute(attr);
        }
    }

    protected void addNamespaces(StartElementEvent event, XMLStreamReader reader) {
        NamespaceBase namespace = null;
        for (int i = 0; i < reader.getNamespaceCount(); ++i) {
            namespace = new NamespaceBase(reader.getNamespacePrefix(i), reader.getNamespaceURI(i));
            event.addNamespace(namespace);
        }
    }

    protected void addNamespaces(EndElementEvent event, XMLStreamReader reader) {
        NamespaceBase namespace = null;
        for (int i = 0; i < reader.getNamespaceCount(); ++i) {
            namespace = new NamespaceBase(reader.getNamespacePrefix(i), reader.getNamespaceURI(i));
            event.addNamespace(namespace);
        }
    }
}

