/*
 * Decompiled with CFR 0.152.
 */
package fr.dyade.aaa.jndi2.haclient;

import fr.dyade.aaa.jndi2.client.NamingConnection;
import fr.dyade.aaa.jndi2.client.Trace;
import fr.dyade.aaa.jndi2.msg.BindRequest;
import fr.dyade.aaa.jndi2.msg.IOControl;
import fr.dyade.aaa.jndi2.msg.JndiReadRequest;
import fr.dyade.aaa.jndi2.msg.JndiReply;
import fr.dyade.aaa.jndi2.msg.JndiRequest;
import java.io.IOException;
import java.net.Socket;
import java.util.Hashtable;
import java.util.Vector;
import javax.naming.NamingException;
import org.objectweb.util.monolog.api.BasicLevel;

public class HANamingConnection
implements NamingConnection {
    public static final int IDEMPOTENT = -2;
    public static final int NOT_IDEMPOTENT = -1;
    private Vector addresses = new Vector();
    private IOControl ioCtrl;
    private int id = -1;

    public static boolean isIdempotent(JndiRequest request) {
        if (request instanceof JndiReadRequest) {
            return true;
        }
        if (request instanceof BindRequest) {
            BindRequest br = (BindRequest)request;
            return br.isRebind();
        }
        return false;
    }

    public void addServerAddress(String host, int port) {
        this.addresses.addElement(new ServerAddress(host, port));
    }

    public synchronized JndiReply invoke(JndiRequest request) throws NamingException {
        if (Trace.logger.isLoggable(BasicLevel.DEBUG)) {
            Trace.logger.log(BasicLevel.DEBUG, (Object)("HANamingConnection.invoke(" + request + ')'));
        }
        this.open();
        try {
            if (this.id < 0) {
                if (HANamingConnection.isIdempotent(request)) {
                    if (Trace.logger.isLoggable(BasicLevel.DEBUG)) {
                        Trace.logger.log(BasicLevel.DEBUG, (Object)" -> write idempotent");
                    }
                    this.ioCtrl.writeInt(-2);
                } else {
                    if (Trace.logger.isLoggable(BasicLevel.DEBUG)) {
                        Trace.logger.log(BasicLevel.DEBUG, (Object)" -> write not idempotent");
                    }
                    this.ioCtrl.writeInt(-1);
                    this.id = this.ioCtrl.readInt();
                    if (Trace.logger.isLoggable(BasicLevel.DEBUG)) {
                        Trace.logger.log(BasicLevel.DEBUG, (Object)(" -> receive new request id = " + this.id));
                    }
                }
            } else {
                this.ioCtrl.writeInt(this.id);
            }
            if (Trace.logger.isLoggable(BasicLevel.DEBUG)) {
                Trace.logger.log(BasicLevel.DEBUG, (Object)" -> send request");
            }
            this.ioCtrl.writeObject(request);
            JndiReply jndiReply = (JndiReply)this.ioCtrl.readObject();
            return jndiReply;
        }
        catch (IOException ioe) {
            if (Trace.logger.isLoggable(BasicLevel.ERROR)) {
                Trace.logger.log(BasicLevel.ERROR, (Object)"NamingConnection.receive()", (Throwable)ioe);
            }
            NamingException ne = new NamingException(ioe.getMessage());
            ne.setRootCause(ioe);
            throw ne;
        }
        catch (ClassNotFoundException cnfe) {
            if (Trace.logger.isLoggable(BasicLevel.ERROR)) {
                Trace.logger.log(BasicLevel.ERROR, (Object)"NamingConnection.receive()", (Throwable)cnfe);
            }
            NamingException ne = new NamingException(cnfe.getMessage());
            ne.setRootCause(cnfe);
            throw ne;
        }
        finally {
            this.close();
        }
    }

    private void open() throws NamingException {
        if (Trace.logger.isLoggable(BasicLevel.DEBUG)) {
            Trace.logger.log(BasicLevel.DEBUG, (Object)"HANamingConnection.open()");
        }
        for (int i = 0; i < this.addresses.size(); ++i) {
            ServerAddress sa = (ServerAddress)this.addresses.elementAt(0);
            if (Trace.logger.isLoggable(BasicLevel.DEBUG)) {
                Trace.logger.log(BasicLevel.DEBUG, (Object)(" -> try connection " + sa));
            }
            try {
                Socket socket = new Socket(sa.hostName, sa.port);
                this.ioCtrl = new IOControl(socket);
                return;
            }
            catch (IOException exc) {
                if (Trace.logger.isLoggable(BasicLevel.WARN)) {
                    Trace.logger.log(BasicLevel.WARN, (Object)"NamingConnection.open()", (Throwable)exc);
                }
                this.addresses.removeElementAt(0);
                this.addresses.addElement(sa);
                continue;
            }
        }
        NamingException exc2 = new NamingException("Connection failed with all replicas: " + this.addresses);
        throw exc2;
    }

    private void close() throws NamingException {
        if (Trace.logger.isLoggable(BasicLevel.DEBUG)) {
            Trace.logger.log(BasicLevel.DEBUG, (Object)"HANamingConnection.close()");
        }
        this.ioCtrl.close();
    }

    public NamingConnection cloneConnection() {
        HANamingConnection clone = new HANamingConnection();
        clone.addresses = (Vector)this.addresses.clone();
        return clone;
    }

    public String toString() {
        return '(' + super.toString() + ",addresses=" + this.addresses + ')';
    }

    public Hashtable getEnvironment() {
        Hashtable env = new Hashtable();
        return env;
    }

    static class ServerAddress {
        String hostName;
        int port;

        public ServerAddress(String hostName, int port) {
            this.hostName = hostName;
            this.port = port;
        }

        public String toString() {
            return '(' + super.toString() + ",hostName=" + this.hostName + ",port=" + this.port + ')';
        }
    }
}

