/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxrs.impl;

import javax.ws.rs.core.Cookie;
import javax.ws.rs.ext.RuntimeDelegate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CookieHeaderProvider
implements RuntimeDelegate.HeaderDelegate<Cookie> {
    private static final String VERSION = "$Version";
    private static final String PATH = "$Path";
    private static final String DOMAIN = "$Domain";

    public Cookie fromString(String c) {
        String[] tokens;
        int version2 = -1;
        String name = null;
        String value = null;
        String path = null;
        String domain = null;
        for (String token : tokens = c.split(";")) {
            if (token.startsWith(VERSION)) {
                version2 = Integer.parseInt(token.substring(VERSION.length() + 1));
                continue;
            }
            if (token.startsWith(PATH)) {
                path = token.substring(PATH.length() + 1);
                continue;
            }
            if (token.startsWith(DOMAIN)) {
                domain = token.substring(DOMAIN.length() + 1);
                continue;
            }
            int i = token.indexOf(61);
            if (i == -1) continue;
            name = token.substring(0, i);
            value = i == token.length() + 1 ? "" : token.substring(i + 1);
        }
        if (name == null || value == null) {
            throw new IllegalArgumentException("Cookie is malformed : " + c);
        }
        return new Cookie(name, value, path, domain, version2);
    }

    public String toString(Cookie c) {
        StringBuilder sb = new StringBuilder();
        if (c.getVersion() != -1) {
            sb.append(VERSION).append('=').append(c.getVersion()).append(';');
        }
        sb.append(c.getName()).append('=').append(c.getValue());
        if (c.getPath() != null) {
            sb.append(';').append(PATH).append('=').append(c.getPath());
        }
        if (c.getDomain() != null) {
            sb.append(';').append(DOMAIN).append('=').append(c.getDomain());
        }
        return sb.toString();
    }
}

