/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxws.context;

import java.security.Principal;
import java.util.logging.Logger;
import javax.xml.ws.EndpointReference;
import javax.xml.ws.WebServiceContext;
import javax.xml.ws.WebServiceException;
import javax.xml.ws.handler.MessageContext;
import javax.xml.ws.wsaddressing.W3CEndpointReference;
import javax.xml.ws.wsaddressing.W3CEndpointReferenceBuilder;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.endpoint.Endpoint;
import org.apache.cxf.jaxws.context.WrappedMessageContext;
import org.apache.cxf.message.Message;
import org.apache.cxf.security.SecurityContext;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WebServiceContextImpl
implements WebServiceContext {
    private static final Logger LOG = LogUtils.getL7dLogger(WebServiceContextImpl.class);
    private static ThreadLocal<MessageContext> context = new ThreadLocal();

    public WebServiceContextImpl() {
    }

    public WebServiceContextImpl(MessageContext ctx) {
        WebServiceContextImpl.setMessageContext(ctx);
    }

    @Override
    public final MessageContext getMessageContext() {
        return context.get();
    }

    @Override
    public final Principal getUserPrincipal() {
        SecurityContext ctx = (SecurityContext)this.getMessageContext().get(SecurityContext.class.getName());
        if (ctx == null) {
            return null;
        }
        return ctx.getUserPrincipal();
    }

    @Override
    public final boolean isUserInRole(String role) {
        SecurityContext ctx = (SecurityContext)this.getMessageContext().get(SecurityContext.class.getName());
        if (ctx == null) {
            return false;
        }
        return ctx.isUserInRole(role);
    }

    @Override
    public EndpointReference getEndpointReference(Element ... referenceParameters) {
        WrappedMessageContext ctx = (WrappedMessageContext)this.getMessageContext();
        Message msg = ctx.getWrappedMessage();
        Endpoint ep = msg.getExchange().get(Endpoint.class);
        W3CEndpointReferenceBuilder builder = new W3CEndpointReferenceBuilder();
        builder.address(ep.getEndpointInfo().getAddress());
        builder.serviceName(ep.getService().getName());
        builder.endpointName(ep.getEndpointInfo().getName());
        if (referenceParameters != null) {
            for (Element referenceParameter : referenceParameters) {
                builder.referenceParameter(referenceParameter);
            }
        }
        return builder.build();
    }

    @Override
    public <T extends EndpointReference> T getEndpointReference(Class<T> clazz, Element ... referenceParameters) {
        if (W3CEndpointReference.class.isAssignableFrom(clazz)) {
            return (T)((EndpointReference)clazz.cast(this.getEndpointReference(referenceParameters)));
        }
        throw new WebServiceException(new org.apache.cxf.common.i18n.Message("ENDPOINTREFERENCE_TYPE_NOT_SUPPORTED", LOG, clazz.getName()).toString());
    }

    public static void setMessageContext(MessageContext ctx) {
        context.set(ctx);
    }

    public static void clear() {
        context.set(null);
    }
}

