/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxws.spi;

import java.io.IOException;
import java.net.URL;
import java.util.List;
import java.util.logging.Logger;
import javax.wsdl.Definition;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.transform.Source;
import javax.xml.ws.Endpoint;
import javax.xml.ws.EndpointReference;
import javax.xml.ws.WebServiceException;
import javax.xml.ws.WebServiceFeature;
import javax.xml.ws.spi.Provider;
import javax.xml.ws.spi.ServiceDelegate;
import javax.xml.ws.wsaddressing.W3CEndpointReference;
import org.apache.cxf.Bus;
import org.apache.cxf.BusFactory;
import org.apache.cxf.common.i18n.Message;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.io.CachedOutputStream;
import org.apache.cxf.jaxws.EndpointImpl;
import org.apache.cxf.jaxws.EndpointUtils;
import org.apache.cxf.jaxws.ServiceImpl;
import org.apache.cxf.staxutils.StaxUtils;
import org.apache.cxf.wsdl.WSDLConstants;
import org.apache.cxf.wsdl.WSDLManager;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProviderImpl
extends Provider {
    public static final String JAXWS_PROVIDER = ProviderImpl.class.getName();
    private static final Logger LOG = LogUtils.getL7dLogger(ProviderImpl.class);
    private static JAXBContext jaxbContext;

    @Override
    public ServiceDelegate createServiceDelegate(URL url, QName qname, Class cls) {
        Bus bus = BusFactory.getThreadDefaultBus();
        return new ServiceImpl(bus, url, qname, cls);
    }

    @Override
    public Endpoint createEndpoint(String bindingId, Object implementor) {
        EndpointImpl ep = null;
        if (EndpointUtils.isValidImplementor(implementor)) {
            Bus bus = BusFactory.getThreadDefaultBus();
            ep = new EndpointImpl(bus, implementor, bindingId);
            return ep;
        }
        throw new WebServiceException(new Message("INVALID_IMPLEMENTOR_EXC", LOG, new Object[0]).toString());
    }

    @Override
    public Endpoint createAndPublishEndpoint(String url, Object implementor) {
        Endpoint ep = this.createEndpoint(null, implementor);
        ep.publish(url);
        return ep;
    }

    @Override
    public W3CEndpointReference createW3CEndpointReference(String address, QName serviceName, QName portName, List<Element> metadata, String wsdlDocumentLocation, List<Element> referenceParameters) {
        QName portType = null;
        if (serviceName != null && portName != null && wsdlDocumentLocation != null) {
            Bus bus = BusFactory.getThreadDefaultBus();
            WSDLManager wsdlManager = bus.getExtension(WSDLManager.class);
            try {
                Definition def = wsdlManager.getDefinition(wsdlDocumentLocation);
                portType = def.getService(serviceName).getPort(portName.getLocalPart()).getBinding().getPortType().getQName();
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        CachedOutputStream cos = new CachedOutputStream();
        XMLStreamWriter writer = StaxUtils.createXMLStreamWriter(cos);
        try {
            if (serviceName == null && portName == null && address == null) {
                throw new IllegalStateException("Address in an EPR cannot be null,  when serviceName or portName is null");
            }
            writer.setPrefix("wsa", "http://www.w3.org/2005/08/addressing");
            writer.writeStartElement("wsa", "EndpointReference", "http://www.w3.org/2005/08/addressing");
            writer.writeNamespace("wsa", "http://www.w3.org/2005/08/addressing");
            writer.writeStartElement("wsa", "Address", "http://www.w3.org/2005/08/addressing");
            address = address == null ? "" : address;
            writer.writeCharacters(address);
            writer.writeEndElement();
            if (referenceParameters != null) {
                writer.writeStartElement("wsa", "ReferenceParameters", "http://www.w3.org/2005/08/addressing");
                for (Element ele : referenceParameters) {
                    StaxUtils.writeElement(ele, writer, true);
                }
                writer.writeEndElement();
            }
            writer.writeStartElement("wsa", "Metadata", "http://www.w3.org/2005/08/addressing");
            writer.writeNamespace("wsaw", "http://www.w3.org/2006/05/addressing/wsdl");
            if (portType != null) {
                writer.writeStartElement("wsaw", "InterfaceName", "http://www.w3.org/2006/05/addressing/wsdl");
                String portTypePrefix = portType.getPrefix();
                if (portTypePrefix == null || portTypePrefix.equals("")) {
                    portTypePrefix = "ns1";
                }
                writer.writeNamespace(portTypePrefix, portType.getNamespaceURI());
                writer.writeCharacters(portTypePrefix + ":" + portType.getLocalPart());
                writer.writeEndElement();
            }
            String serviceNamePrefix = null;
            if (serviceName != null) {
                serviceNamePrefix = serviceName.getPrefix() == null || serviceName.getPrefix().length() == 0 ? "ns2" : serviceName.getPrefix();
                writer.writeStartElement("wsaw", "ServiceName", "http://www.w3.org/2006/05/addressing/wsdl");
                if (portName != null) {
                    writer.writeAttribute("EndpointName", portName.getLocalPart());
                }
                writer.writeNamespace(serviceNamePrefix, serviceName.getNamespaceURI());
                writer.writeCharacters(serviceNamePrefix + ":" + serviceName.getLocalPart());
                writer.writeEndElement();
            }
            if (wsdlDocumentLocation != null) {
                writer.writeStartElement("wsdl", WSDLConstants.QNAME_DEFINITIONS.getLocalPart(), "http://schemas.xmlsoap.org/wsdl/");
                writer.writeNamespace("wsdl", "http://schemas.xmlsoap.org/wsdl/");
                writer.writeStartElement("wsdl", WSDLConstants.QNAME_IMPORT.getLocalPart(), WSDLConstants.QNAME_IMPORT.getNamespaceURI());
                if (serviceName != null) {
                    writer.writeAttribute("namespace", serviceName.getNamespaceURI());
                }
                writer.writeAttribute("location", wsdlDocumentLocation);
                writer.writeEndElement();
                writer.writeEndElement();
            }
            if (metadata != null) {
                for (Element e : metadata) {
                    StaxUtils.writeElement(e, writer, true);
                }
            }
            writer.writeEndElement();
            writer.writeEndElement();
            writer.flush();
        }
        catch (XMLStreamException e) {
            throw new WebServiceException(new Message("ERROR_UNMARSHAL_ENDPOINTREFERENCE", LOG, new Object[0]).toString(), e);
        }
        try {
            Unmarshaller unmarshaller = this.getJAXBContext().createUnmarshaller();
            return (W3CEndpointReference)unmarshaller.unmarshal(cos.getInputStream());
        }
        catch (JAXBException e) {
            throw new WebServiceException(new Message("ERROR_UNMARSHAL_ENDPOINTREFERENCE", LOG, new Object[0]).toString(), e);
        }
        catch (IOException e) {
            throw new WebServiceException(new Message("ERROR_UNMARSHAL_ENDPOINTREFERENCE", LOG, new Object[0]).toString(), e);
        }
    }

    @Override
    public <T> T getPort(EndpointReference endpointReference, Class<T> serviceEndpointInterface, WebServiceFeature ... features) {
        ServiceDelegate sd = this.createServiceDelegate(null, null, serviceEndpointInterface);
        return sd.getPort(endpointReference, serviceEndpointInterface, features);
    }

    @Override
    public EndpointReference readEndpointReference(Source eprInfoset) {
        try {
            Unmarshaller unmarshaller = this.getJAXBContext().createUnmarshaller();
            return (EndpointReference)unmarshaller.unmarshal(StaxUtils.createXMLStreamReader(eprInfoset));
        }
        catch (JAXBException e) {
            throw new WebServiceException(new Message("ERROR_UNMARSHAL_ENDPOINTREFERENCE", LOG, new Object[0]).toString(), e);
        }
    }

    private JAXBContext getJAXBContext() {
        if (jaxbContext == null) {
            try {
                jaxbContext = JAXBContext.newInstance(W3CEndpointReference.class);
            }
            catch (JAXBException e) {
                throw new WebServiceException(new Message("JAXBCONTEXT_CREATION_FAILED", LOG, new Object[0]).toString(), e);
            }
        }
        return jaxbContext;
    }
}

