/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.tools.corba.processors.wsdl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.wsdl.Binding;
import javax.wsdl.Definition;
import javax.wsdl.Part;
import javax.xml.namespace.QName;
import org.apache.cxf.binding.corba.wsdl.CaseType;
import org.apache.cxf.binding.corba.wsdl.CorbaConstants;
import org.apache.cxf.binding.corba.wsdl.CorbaTypeImpl;
import org.apache.cxf.binding.corba.wsdl.Enum;
import org.apache.cxf.binding.corba.wsdl.Enumerator;
import org.apache.cxf.binding.corba.wsdl.MemberType;
import org.apache.cxf.binding.corba.wsdl.Struct;
import org.apache.cxf.binding.corba.wsdl.TypeMappingType;
import org.apache.cxf.binding.corba.wsdl.Union;
import org.apache.cxf.binding.corba.wsdl.Unionbranch;
import org.apache.cxf.binding.corba.wsdl.W3CConstants;
import org.apache.cxf.common.i18n.Message;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.common.util.StringUtils;
import org.apache.cxf.common.xmlschema.SchemaCollection;
import org.apache.cxf.tools.corba.common.CorbaPrimitiveMap;
import org.apache.cxf.tools.corba.common.ReferenceConstants;
import org.apache.cxf.tools.corba.common.WSDLUtils;
import org.apache.cxf.tools.corba.processors.wsdl.WSDLTypes;
import org.apache.ws.commons.schema.XmlSchema;
import org.apache.ws.commons.schema.XmlSchemaAll;
import org.apache.ws.commons.schema.XmlSchemaAnnotation;
import org.apache.ws.commons.schema.XmlSchemaAttribute;
import org.apache.ws.commons.schema.XmlSchemaChoice;
import org.apache.ws.commons.schema.XmlSchemaComplexContent;
import org.apache.ws.commons.schema.XmlSchemaComplexContentExtension;
import org.apache.ws.commons.schema.XmlSchemaComplexContentRestriction;
import org.apache.ws.commons.schema.XmlSchemaComplexType;
import org.apache.ws.commons.schema.XmlSchemaElement;
import org.apache.ws.commons.schema.XmlSchemaEnumerationFacet;
import org.apache.ws.commons.schema.XmlSchemaExternal;
import org.apache.ws.commons.schema.XmlSchemaFacet;
import org.apache.ws.commons.schema.XmlSchemaGroupBase;
import org.apache.ws.commons.schema.XmlSchemaImport;
import org.apache.ws.commons.schema.XmlSchemaLengthFacet;
import org.apache.ws.commons.schema.XmlSchemaMaxLengthFacet;
import org.apache.ws.commons.schema.XmlSchemaParticle;
import org.apache.ws.commons.schema.XmlSchemaSequence;
import org.apache.ws.commons.schema.XmlSchemaSimpleContent;
import org.apache.ws.commons.schema.XmlSchemaSimpleContentExtension;
import org.apache.ws.commons.schema.XmlSchemaSimpleContentRestriction;
import org.apache.ws.commons.schema.XmlSchemaSimpleType;
import org.apache.ws.commons.schema.XmlSchemaSimpleTypeList;
import org.apache.ws.commons.schema.XmlSchemaSimpleTypeRestriction;
import org.apache.ws.commons.schema.XmlSchemaType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WSDLToCorbaHelper {
    public static final String REPO_STRING = "IDL:";
    public static final String IDL_VERSION = ":1.0";
    protected static final Logger LOG = LogUtils.getL7dLogger(WSDLToCorbaHelper.class);
    protected static final String[] DISCRIMINATORTYPES = new String[]{"long", "short", "boolean", "char"};
    protected static final Set<String> SUPPORTEDDISTYPES = new TreeSet<String>(Arrays.asList(DISCRIMINATORTYPES));
    protected static final CorbaPrimitiveMap CORBAPRIMITIVEMAP = new CorbaPrimitiveMap();
    String idlNamespace;
    SchemaCollection xmlSchemaList;
    TypeMappingType typeMappingType;
    Definition def;
    Map<QName, CorbaTypeImpl> recursionMap = new HashMap<QName, CorbaTypeImpl>();

    public void setTypeMap(TypeMappingType map) {
        this.typeMappingType = map;
    }

    public void setIdlNamespace(String ns) {
        this.idlNamespace = ns;
    }

    public String getIdlNamespace() {
        return this.idlNamespace;
    }

    public void setXMLSchemaList(SchemaCollection list) {
        this.xmlSchemaList = list;
    }

    public SchemaCollection getXMLSchemaList() {
        return this.xmlSchemaList;
    }

    public void setWsdlDefinition(Definition defn) {
        this.def = defn;
    }

    public CorbaTypeImpl convertSchemaToCorbaType(XmlSchemaType stype, QName defaultName, XmlSchemaType parent, XmlSchemaAnnotation annotation, boolean anonymous) throws Exception {
        CorbaTypeImpl corbaTypeImpl = null;
        if (!this.isAddressingNamespace(stype.getQName())) {
            if (stype.getBaseSchemaType() != null) {
                corbaTypeImpl = this.processPrimitiveType(stype.getQName());
            } else if (stype instanceof XmlSchemaComplexType) {
                corbaTypeImpl = this.processComplexType((XmlSchemaComplexType)stype, defaultName, annotation, anonymous);
            } else if (stype instanceof XmlSchemaSimpleType) {
                corbaTypeImpl = this.processSimpleType((XmlSchemaSimpleType)stype, defaultName, anonymous);
            } else if (this.xmlSchemaList.getElementByQName(stype.getQName()) != null) {
                XmlSchemaElement el = this.xmlSchemaList.getElementByQName(stype.getQName());
                corbaTypeImpl = this.processElementType(el, defaultName, stype.getQName().getNamespaceURI());
            } else {
                throw new Exception("Couldn't convert schema " + stype.getQName() + " to corba type");
            }
        }
        return corbaTypeImpl;
    }

    protected List processContainerAsMembers(XmlSchemaParticle particle, QName defaultName, QName schemaTypeName) throws Exception {
        XmlSchemaGroupBase scontainer;
        ArrayList<MemberType> members = new ArrayList<MemberType>();
        Iterator iterL = null;
        if (particle instanceof XmlSchemaSequence) {
            scontainer = (XmlSchemaSequence)particle;
            iterL = ((XmlSchemaSequence)scontainer).getItems().getIterator();
        } else if (particle instanceof XmlSchemaChoice) {
            scontainer = (XmlSchemaChoice)particle;
            iterL = ((XmlSchemaChoice)scontainer).getItems().getIterator();
        } else if (particle instanceof XmlSchemaAll) {
            XmlSchemaAll acontainer = (XmlSchemaAll)particle;
            iterL = acontainer.getItems().getIterator();
        } else {
            LOG.warning("Unknown particle type " + particle.getClass().getName());
            iterL = Collections.emptyList().iterator();
        }
        while (iterL.hasNext()) {
            MemberType member;
            MemberType member2;
            XmlSchemaParticle container = (XmlSchemaParticle)iterL.next();
            if (container instanceof XmlSchemaSequence) {
                XmlSchemaSequence sequence = (XmlSchemaSequence)container;
                CorbaTypeImpl memberType = this.processSequenceType(sequence, defaultName, schemaTypeName);
                QName typeName = memberType.getQName();
                if (memberType instanceof Struct && !this.isDuplicate(memberType)) {
                    this.typeMappingType.getStructOrExceptionOrUnion().add(memberType);
                }
                member2 = new MemberType();
                member2.setName(memberType.getName() + "_f");
                member2.setIdltype(typeName);
                member2.setAnonschematype(true);
                if (memberType.isSetQualified() && memberType.isQualified()) {
                    member2.setQualified(true);
                }
                members.add(member2);
                continue;
            }
            if (container instanceof XmlSchemaChoice) {
                XmlSchemaChoice choice = (XmlSchemaChoice)container;
                member = this.processChoiceMember(choice, defaultName, schemaTypeName);
                member.setAnonschematype(true);
                members.add(member);
                continue;
            }
            if (container instanceof XmlSchemaAll) {
                XmlSchemaAll all = (XmlSchemaAll)container;
                member = this.processAllMember(all, defaultName, schemaTypeName);
                member.setAnonschematype(true);
                members.add(member);
                continue;
            }
            if (!(container instanceof XmlSchemaElement)) continue;
            XmlSchemaElement element = (XmlSchemaElement)container;
            CorbaTypeImpl corbatype = this.processLocalElement(element, schemaTypeName.getNamespaceURI());
            QName elName = element.getQName();
            if (elName == null) {
                elName = element.getRefName();
            }
            if (corbatype != null) {
                String memberName = elName.getLocalPart();
                member2 = new MemberType();
                member2.setName(memberName);
                member2.setIdltype(corbatype.getQName());
                if (corbatype.isSetQualified() && corbatype.isQualified()) {
                    member2.setQualified(true);
                }
                members.add(member2);
                continue;
            }
            LOG.log(Level.WARNING, "Unsupported Element Found in CORBA Binding Generation:" + elName);
        }
        return members;
    }

    private MemberType processChoiceMember(XmlSchemaChoice choice, QName defaultName, QName schemaTypeName) throws Exception {
        CorbaTypeImpl corbatype = this.processChoice(choice, defaultName, schemaTypeName);
        MemberType member = new MemberType();
        member.setName(corbatype.getQName().getLocalPart());
        member.setIdltype(corbatype.getQName());
        if (corbatype.isSetQualified() && corbatype.isQualified()) {
            member.setQualified(true);
        }
        return member;
    }

    private MemberType processAllMember(XmlSchemaAll all, QName defaultName, QName schemaTypeName) throws Exception {
        CorbaTypeImpl corbatype = this.processAllType(all, defaultName, schemaTypeName);
        MemberType member = new MemberType();
        member.setName(corbatype.getQName().getLocalPart());
        member.setIdltype(corbatype.getQName());
        if (corbatype.isSetQualified() && corbatype.isQualified()) {
            member.setQualified(true);
        }
        return member;
    }

    private CorbaTypeImpl processChoice(XmlSchemaChoice choice, QName defaultName, QName schemaTypeName) throws Exception {
        QName name;
        CorbaTypeImpl arrayType;
        QName choicename = null;
        choicename = schemaTypeName == null ? this.createQNameCorbaNamespace(defaultName.getLocalPart()) : this.createQNameCorbaNamespace(schemaTypeName.getLocalPart());
        choicename = this.checkPrefix(choicename);
        Union corbatype = this.createUnion(choicename, choice, defaultName, schemaTypeName);
        String repoId = REPO_STRING + corbatype.getQName().getLocalPart().replace('.', '/') + IDL_VERSION;
        corbatype.setRepositoryID(repoId);
        if (!(choice.getMaxOccurs() == 1L && choice.getMinOccurs() == 1L || (arrayType = this.createArray(name = this.createQNameTargetNamespace(corbatype.getQName().getLocalPart() + "Array"), corbatype.getQName(), corbatype.getQName(), choice.getMaxOccurs(), choice.getMinOccurs(), false)) == null || this.isDuplicate(arrayType))) {
            this.typeMappingType.getStructOrExceptionOrUnion().add(arrayType);
        }
        return corbatype;
    }

    private CorbaTypeImpl processLocalElement(XmlSchemaElement element, String uri) throws Exception {
        QName name;
        CorbaTypeImpl membertype = new CorbaTypeImpl();
        CorbaTypeImpl memtype = new CorbaTypeImpl();
        XmlSchemaType schemaType = element.getSchemaType();
        QName schemaName = element.getQName();
        if (schemaName == null) {
            schemaName = element.getRefName();
            schemaType = this.findSchemaType(schemaName);
        }
        if (schemaName.getNamespaceURI().equals("")) {
            schemaName = new QName(uri, schemaName.getLocalPart());
        }
        QName elemName = schemaName;
        boolean elementQualified = this.getElementQualification(element, uri);
        if (!elementQualified) {
            elemName = new QName("", elemName.getLocalPart());
        }
        QName memName = null;
        if (element.isNillable()) {
            CorbaTypeImpl elemtype = this.convertSchemaToCorbaType(schemaType, elemName, schemaType, null, true);
            QName name2 = this.createQNameTargetNamespace(elemtype.getQName().getLocalPart() + "_nil");
            QName elName = this.checkPrefix(elemName);
            if (elName == null) {
                elName = this.createQNameTargetNamespace(elemName.getLocalPart());
            }
            memtype = this.createNillableUnion(elName, name2, elemtype.getQName(), elementQualified);
            memName = this.createQNameCorbaNamespace(memtype.getQName().getLocalPart());
            if (memtype != null && !this.isDuplicate(memtype)) {
                this.typeMappingType.getStructOrExceptionOrUnion().add(memtype);
            }
            membertype.setQName(memName);
            membertype.setName(memtype.getName());
            membertype.setType(memtype.getType());
        } else if (schemaType != null) {
            XmlSchemaType st = schemaType;
            boolean anonymous = WSDLTypes.isAnonymous(st.getName());
            membertype = this.convertSchemaToCorbaType(st, elemName, st, null, anonymous);
        } else if (element.getSchemaTypeName() != null) {
            name = this.checkPrefix(element.getSchemaTypeName());
            membertype = this.getLocalType(name);
        }
        if (membertype == null) {
            return null;
        }
        if (element.getMaxOccurs() != 1L || element.getMinOccurs() != 1L) {
            name = this.createQNameCorbaNamespace(this.getModulePrefix(membertype) + elemName.getLocalPart() + "Array");
            CorbaTypeImpl arraytype = null;
            arraytype = memName != null ? this.createArray(name, schemaName, memName, elemName, element.getMaxOccurs(), element.getMinOccurs(), false) : this.createArray(name, schemaName, membertype.getQName(), elemName, element.getMaxOccurs(), element.getMinOccurs(), false);
            membertype.setName(arraytype.getName());
            membertype.setQName(arraytype.getQName());
            membertype.setType(arraytype.getType());
            if (arraytype != null && !this.isDuplicate(arraytype)) {
                this.typeMappingType.getStructOrExceptionOrUnion().add(arraytype);
            }
        }
        membertype.setQualified(elementQualified);
        return membertype;
    }

    public XmlSchemaType getSchemaType(QName name) throws Exception {
        XmlSchemaType type = null;
        for (XmlSchema xmlSchema : this.xmlSchemaList.getXmlSchemas()) {
            QName tname;
            String nspace = name.getNamespaceURI();
            if (nspace == null) {
                nspace = xmlSchema.getTargetNamespace();
            }
            if ((type = this.findSchemaType(tname = this.createQName(nspace, name.getLocalPart(), ""))) != null) break;
        }
        return type;
    }

    private String getModulePrefix(CorbaTypeImpl type) {
        String name = type.getQName().getLocalPart();
        int dotPos = name.lastIndexOf(".");
        return dotPos == -1 ? "" : name.substring(0, dotPos + 1);
    }

    protected CorbaTypeImpl processSequenceType(XmlSchemaSequence seq, QName defaultName, QName schemaTypeName) throws Exception {
        QName name;
        CorbaTypeImpl atype;
        Struct type = null;
        QName seqName = null;
        seqName = schemaTypeName == null ? this.createQNameCorbaNamespace(defaultName.getLocalPart() + "SequenceStruct") : this.createQNameCorbaNamespace(schemaTypeName.getLocalPart() + "SequenceStruct");
        schemaTypeName = this.checkPrefix(schemaTypeName);
        Struct struct = new Struct();
        struct.setName(seqName.getLocalPart());
        struct.setQName(seqName);
        struct.setRepositoryID(REPO_STRING + seqName.getLocalPart().replace('.', '/') + IDL_VERSION);
        struct.setType(schemaTypeName);
        List members = this.processContainerAsMembers(seq, defaultName, schemaTypeName);
        for (MemberType memberType : members) {
            struct.getMember().add(memberType);
        }
        type = struct;
        if (!("1".equals(seq.getMaxOccurs()) && "1".equals(seq.getMinOccurs()) || (atype = this.createArray(name = this.createQNameTargetNamespace(type.getQName().getLocalPart() + "Array"), type.getQName(), type.getQName(), seq.getMaxOccurs(), seq.getMinOccurs(), false)) == null || this.isDuplicate(atype))) {
            this.typeMappingType.getStructOrExceptionOrUnion().add(atype);
        }
        if (type instanceof Struct && struct.getMember().size() == 0) {
            String msgStr = "Cannot create CORBA Struct" + struct.getName() + "from container with no members";
            Message msg = new Message(msgStr, LOG, new Object[0]);
            throw new Exception(msg.toString());
        }
        return type;
    }

    protected CorbaTypeImpl processAllType(XmlSchemaAll seq, QName defaultName, QName schematypeName) throws Exception {
        QName allName = null;
        Struct type = null;
        allName = schematypeName == null ? this.createQNameCorbaNamespace(defaultName.getLocalPart() + "AllStruct") : this.createQNameCorbaNamespace(schematypeName.getLocalPart() + "AllStruct");
        type = new Struct();
        type.setName(allName.getLocalPart());
        type.setQName(allName);
        type.setType(schematypeName);
        List members = this.processContainerAsMembers(seq, defaultName, schematypeName);
        for (MemberType memberType : members) {
            type.getMember().add(memberType);
        }
        String repoId = REPO_STRING + type.getQName().getLocalPart().replace('.', '/') + IDL_VERSION;
        type.setRepositoryID(repoId);
        return type;
    }

    private CorbaTypeImpl processPrimitiveType(QName typeName) {
        QName qName = this.createQNameXmlSchemaNamespace(typeName.getLocalPart());
        CorbaTypeImpl corbatype = (CorbaTypeImpl)CORBAPRIMITIVEMAP.get(qName);
        if (corbatype == null) {
            CorbaTypeImpl type = null;
            if (typeName.equals(W3CConstants.NT_SCHEMA_DECIMAL)) {
                QName name = new QName(this.idlNamespace, "fixed_1");
                type = WSDLTypes.getFixedCorbaType(name, typeName, 31, 6);
                corbatype = WSDLTypes.getFixedCorbaType(name, typeName, 31, 6);
            } else if (typeName.equals(W3CConstants.NT_SCHEMA_BASE64) || typeName.equals(W3CConstants.NT_SCHEMA_HBIN)) {
                QName name = new QName(this.idlNamespace, typeName.getLocalPart() + "Seq");
                type = WSDLTypes.getOctetCorbaType(name, typeName, 0);
                corbatype = WSDLTypes.getOctetCorbaType(name, typeName, 0);
            }
            if (type != null && !this.isDuplicate(type)) {
                this.typeMappingType.getStructOrExceptionOrUnion().add(type);
            }
        }
        return corbatype;
    }

    protected List<MemberType> processAttributesAsMembers(Iterator attrs, String uri) throws Exception {
        QName memName = null;
        ArrayList<MemberType> members = new ArrayList<MemberType>();
        while (attrs.hasNext()) {
            Object attrObj = attrs.next();
            if (!(attrObj instanceof XmlSchemaAttribute)) {
                LOG.warning(attrObj.getClass() + " not supported in CORBA binding.  Skipping.");
                continue;
            }
            XmlSchemaAttribute attribute = (XmlSchemaAttribute)attrObj;
            QName attrName = attribute.getQName();
            if (attrName.getNamespaceURI().equals("")) {
                attrName = new QName(uri, attrName.getLocalPart());
            }
            CorbaTypeImpl membertype = null;
            boolean attrQualified = this.getAttributeQualification(attribute, uri);
            if (attribute.getUse().getValue().equals("none") || attribute.getUse().getValue().equals("optional")) {
                CorbaTypeImpl attType = null;
                if (attribute.getSchemaType() != null) {
                    attType = this.convertSchemaToCorbaType(attribute.getSchemaType(), this.checkPrefix(attrName), attribute.getSchemaType(), null, true);
                    if (attType != null) {
                        QName typeName = attType.getQName();
                        if (!this.isDuplicate(attType)) {
                            this.typeMappingType.getStructOrExceptionOrUnion().add(attType);
                        }
                        QName name = this.createQNameTargetNamespace(typeName.getLocalPart() + "_nil");
                        membertype = this.createNillableUnion(name, this.checkPrefix(attrName), this.createQNameCorbaNamespace(typeName.getLocalPart()), attrQualified);
                    }
                } else {
                    attType = this.processPrimitiveType(attribute.getSchemaTypeName());
                    if (attType != null) {
                        QName name = this.createQNameTargetNamespace(attType.getQName().getLocalPart() + "_nil");
                        membertype = this.createNillableUnion(name, this.checkPrefix(attrName), attType.getQName(), attrQualified);
                    }
                }
                if (membertype != null) {
                    memName = this.createQNameCorbaNamespace(membertype.getQName().getLocalPart());
                    if (!this.isDuplicate(membertype)) {
                        this.typeMappingType.getStructOrExceptionOrUnion().add(membertype);
                    }
                }
            } else {
                membertype = attribute.getSchemaType() != null ? this.convertSchemaToCorbaType(attribute.getSchemaType(), attrName, attribute.getSchemaType(), null, false) : this.processPrimitiveType(attribute.getSchemaTypeName());
            }
            if (membertype != null) {
                String memberName = attrName.getLocalPart();
                MemberType member = new MemberType();
                member.setName(memberName);
                if (memName != null) {
                    member.setIdltype(memName);
                } else {
                    member.setIdltype(membertype.getQName());
                }
                if (attrQualified) {
                    member.setQualified(true);
                }
                members.add(member);
                continue;
            }
            String msg = "Unsupported Attribute Found in CORBA Binding Generation:" + attrName;
            LOG.log(Level.WARNING, msg.toString());
        }
        return members;
    }

    private CorbaTypeImpl processElementType(XmlSchemaElement stype, QName defaultName, String uri) throws Exception {
        String name = null;
        QName schemaTypeName = null;
        XmlSchemaType schemaType = stype.getSchemaType();
        if (stype.getQName() == null) {
            if (stype.getRefName() == null) {
                schemaTypeName = defaultName;
            } else {
                name = stype.getRefName().getLocalPart();
                schemaType = this.findSchemaType(stype.getRefName());
            }
        } else {
            name = stype.getQName().getLocalPart();
        }
        if (schemaTypeName == null) {
            schemaTypeName = this.createQNameTargetNamespace(name);
        }
        CorbaTypeImpl result = this.convertSchemaToCorbaType(schemaType, schemaTypeName, schemaType, null, false);
        result.setQualified(this.getElementQualification(stype, uri));
        return result;
    }

    private CorbaTypeImpl processSimpleType(XmlSchemaSimpleType stype, QName defaultName, boolean anonymous) throws Exception {
        QName name;
        CorbaTypeImpl corbaTypeImpl = null;
        QName schematypeName = null;
        if (stype.getQName() == null) {
            schematypeName = defaultName;
            name = this.createQNameTargetNamespace(defaultName.getLocalPart() + "Type");
        } else {
            schematypeName = this.checkPrefix(stype.getQName());
            if (schematypeName == null) {
                schematypeName = stype.getQName();
            }
            name = this.createQNameCorbaNamespace(schematypeName.getLocalPart());
        }
        if (stype.getContent() instanceof XmlSchemaSimpleTypeRestriction) {
            corbaTypeImpl = this.processSimpleRestrictionType(stype, name, schematypeName, anonymous);
        } else if (stype.getContent() instanceof XmlSchemaSimpleTypeList) {
            XmlSchemaSimpleTypeList ltype = (XmlSchemaSimpleTypeList)stype.getContent();
            CorbaTypeImpl itemType = null;
            if (ltype.getItemType() != null) {
                itemType = this.convertSchemaToCorbaType(ltype.getItemType(), name, stype, null, false);
                if (itemType != null) {
                    return WSDLTypes.mapToSequence(name, this.checkPrefix(schematypeName), itemType.getQName(), null, 0, false);
                }
                return itemType;
            }
            QName ltypeName = this.createQNameXmlSchemaNamespace(ltype.getItemTypeName().getLocalPart());
            itemType = this.processPrimitiveType(ltypeName);
            if (itemType != null) {
                return WSDLTypes.mapToSequence(name, this.checkPrefix(schematypeName), itemType.getQName(), null, 0, false);
            }
            XmlSchemaType base = this.getSchemaType(ltype.getItemTypeName());
            itemType = this.convertSchemaToCorbaType(base, base.getQName(), base, null, false);
            if (itemType != null) {
                return WSDLTypes.mapToSequence(name, this.checkPrefix(schematypeName), itemType.getQName(), null, 0, false);
            }
        } else if (stype.getContent() == null) {
            QName stypeName = this.createQNameXmlSchemaNamespace(stype.getName());
            corbaTypeImpl = this.getLocalType(stypeName);
        } else {
            System.out.println("SimpleType Union Not Supported in CORBA Binding");
        }
        return corbaTypeImpl;
    }

    private CorbaTypeImpl processSimpleRestrictionType(XmlSchemaSimpleType stype, QName name, QName schematypeName, boolean anonymous) throws Exception {
        CorbaTypeImpl corbaTypeImpl = null;
        XmlSchemaSimpleTypeRestriction restrictionType = (XmlSchemaSimpleTypeRestriction)stype.getContent();
        QName baseName = this.checkPrefix(restrictionType.getBaseTypeName());
        String maxLength = null;
        String length = null;
        Iterator i = restrictionType.getFacets().getIterator();
        while (i.hasNext()) {
            XmlSchemaFacet val = (XmlSchemaFacet)i.next();
            if (val instanceof XmlSchemaMaxLengthFacet) {
                maxLength = val.getValue().toString();
            }
            if (!(val instanceof XmlSchemaLengthFacet)) continue;
            length = val.getValue().toString();
        }
        if (this.isEnumeration(restrictionType)) {
            corbaTypeImpl = this.createCorbaEnum(restrictionType, name, schematypeName);
        } else {
            if (restrictionType.getBaseType() != null) {
                corbaTypeImpl = this.convertSchemaToCorbaType(restrictionType.getBaseType(), schematypeName, stype, null, false);
            } else {
                corbaTypeImpl = this.processPrimitiveType(baseName);
                if (corbaTypeImpl == null) {
                    XmlSchemaType schematype = this.findSchemaType(baseName);
                    corbaTypeImpl = this.convertSchemaToCorbaType(schematype, schematypeName, schematype, null, false);
                }
            }
            if (corbaTypeImpl != null) {
                if (corbaTypeImpl.getType().equals(W3CConstants.NT_SCHEMA_STRING) || baseName.equals(W3CConstants.NT_SCHEMA_STRING)) {
                    corbaTypeImpl = WSDLTypes.processStringType(corbaTypeImpl, name, maxLength, length);
                } else if (corbaTypeImpl.getType().equals(W3CConstants.NT_SCHEMA_DECIMAL) || baseName.equals(W3CConstants.NT_SCHEMA_DECIMAL)) {
                    corbaTypeImpl = WSDLTypes.processDecimalType(restrictionType, name, corbaTypeImpl, anonymous);
                } else if (corbaTypeImpl.getType().equals(W3CConstants.NT_SCHEMA_BASE64) || baseName.equals(W3CConstants.NT_SCHEMA_BASE64) || corbaTypeImpl.getType().equals(W3CConstants.NT_SCHEMA_HBIN) || corbaTypeImpl.getType().equals(W3CConstants.NT_SCHEMA_HBIN)) {
                    corbaTypeImpl = WSDLTypes.processBase64Type(corbaTypeImpl, name, maxLength, length);
                }
            }
        }
        return corbaTypeImpl;
    }

    private CorbaTypeImpl getLocalType(QName qname) {
        return this.processPrimitiveType(qname);
    }

    private Enum createCorbaEnum(XmlSchemaSimpleTypeRestriction restrictionType, QName name, QName schematypeName) {
        Enum corbaEnum = new Enum();
        corbaEnum.setType(schematypeName);
        corbaEnum.setName(name.getLocalPart());
        corbaEnum.setQName(name);
        corbaEnum.setRepositoryID(REPO_STRING + name.getLocalPart().replace('.', '/') + IDL_VERSION);
        Iterator enums = restrictionType.getFacets().getIterator();
        while (enums.hasNext()) {
            XmlSchemaEnumerationFacet val = (XmlSchemaEnumerationFacet)enums.next();
            Enumerator enumerator = new Enumerator();
            enumerator.setValue(val.getValue().toString());
            corbaEnum.getEnumerator().add(enumerator);
        }
        return corbaEnum;
    }

    private boolean isEnumeration(XmlSchemaSimpleTypeRestriction restriction) {
        if (restriction == null || restriction.getFacets().getCount() == 0 || restriction.getBaseTypeName() == null) {
            return false;
        }
        Iterator it = restriction.getFacets().getIterator();
        while (it.hasNext()) {
            XmlSchemaFacet facet = (XmlSchemaFacet)it.next();
            if (!(facet instanceof XmlSchemaEnumerationFacet)) continue;
            return true;
        }
        return false;
    }

    protected XmlSchemaType lookUpType(Part part) {
        XmlSchemaType schemaType = null;
        for (XmlSchema xmlSchema : this.xmlSchemaList.getXmlSchemas()) {
            if (part.getElementName() != null) {
                XmlSchemaElement schemaElement = xmlSchema.getElementByName(part.getElementName());
                if (schemaElement != null) {
                    schemaType = schemaElement.getSchemaType();
                }
            } else if (part.getTypeName() != null) {
                schemaType = xmlSchema.getTypeByName(part.getTypeName());
            }
            if (schemaType == null) continue;
            return schemaType;
        }
        return schemaType;
    }

    private XmlSchemaType findSchemaType(QName typeName) {
        for (XmlSchema xmlSchema : this.xmlSchemaList.getXmlSchemas()) {
            XmlSchemaType schemaType = this.findTypeInSchema(xmlSchema, typeName);
            if (schemaType == null) continue;
            return schemaType;
        }
        return null;
    }

    private XmlSchemaType findTypeInSchema(XmlSchema xmlSchema, QName typeName) {
        XmlSchemaType schemaType = null;
        if (xmlSchema.getElementByName(typeName) != null) {
            XmlSchemaElement schemaElement = xmlSchema.getElementByName(typeName);
            schemaType = schemaElement.getSchemaType();
        } else if (xmlSchema.getTypeByName(typeName) != null) {
            schemaType = xmlSchema.getTypeByName(typeName);
        }
        if (schemaType != null) {
            return schemaType;
        }
        if (xmlSchema.getIncludes() != null) {
            Iterator schemas = xmlSchema.getIncludes().getIterator();
            while (schemas.hasNext()) {
                XmlSchemaExternal extSchema;
                Object obj = schemas.next();
                if (!(obj instanceof XmlSchemaExternal) || (extSchema = (XmlSchemaExternal)obj) instanceof XmlSchemaImport || (schemaType = this.findTypeInSchema(extSchema.getSchema(), typeName)) == null) continue;
                return schemaType;
            }
        }
        return null;
    }

    protected boolean isSchemaTypeException(XmlSchemaType stype) {
        boolean exception = false;
        XmlSchemaComplexType complex = null;
        if (stype instanceof XmlSchemaComplexType && !this.isLiteralArray(complex = (XmlSchemaComplexType)stype) && !WSDLTypes.isOMGUnion(complex) && !WSDLTypes.isUnion(complex)) {
            exception = true;
        }
        return exception;
    }

    public boolean isLiteralArray(XmlSchemaComplexType type) {
        XmlSchemaSequence stype;
        boolean array = false;
        if (type.getAttributes().getCount() == 0 && type.getParticle() instanceof XmlSchemaSequence && (stype = (XmlSchemaSequence)type.getParticle()).getItems().getCount() == 1 && stype.getItems().getIterator().next() instanceof XmlSchemaElement) {
            XmlSchemaElement el = (XmlSchemaElement)stype.getItems().getIterator().next();
            if (el.getMaxOccurs() != 1L) {
                array = true;
            }
            if (el.getMaxOccurs() == 1L && el.getMinOccurs() == 1L && type.getName() != null && WSDLTypes.isAnonymous(type.getName())) {
                array = true;
            }
        }
        return array;
    }

    protected CorbaTypeImpl createArray(QName name, QName schematypeName, QName arrayType, Long maxOccurs, Long minOccurs, boolean anonymous) {
        return this.createArray(name, schematypeName, arrayType, null, maxOccurs, minOccurs, anonymous);
    }

    protected CorbaTypeImpl createArray(QName name, QName schematypeName, QName arrayType, QName elName, Long maxOccurs, Long minOccurs, boolean anonymous) {
        int max = maxOccurs.intValue();
        if (max == -1) {
            return WSDLTypes.mapToSequence(name, schematypeName, arrayType, elName, 0, anonymous);
        }
        int min = minOccurs.intValue();
        if (min == max) {
            if (max == 1) {
                if (!anonymous) {
                    String msg = "Couldn't Map to Array:" + name + ":minOccurs=" + minOccurs + ":maxOccurs=" + maxOccurs;
                    LOG.log(Level.WARNING, msg.toString());
                    return null;
                }
                return WSDLTypes.mapToArray(name, this.checkPrefix(schematypeName), arrayType, elName, max, anonymous);
            }
            return WSDLTypes.mapToArray(name, this.checkPrefix(schematypeName), arrayType, elName, max, anonymous);
        }
        return WSDLTypes.mapToSequence(name, this.checkPrefix(schematypeName), arrayType, elName, max, anonymous);
    }

    private CorbaTypeImpl processComplexType(XmlSchemaComplexType complex, QName defaultName, XmlSchemaAnnotation annotation, boolean anonymous) throws Exception {
        CorbaTypeImpl corbatype = null;
        corbatype = this.isLiteralArray(complex) ? this.processLiteralArray(complex, defaultName, anonymous) : (WSDLTypes.isOMGUnion(complex) ? this.processOMGUnion(complex, defaultName) : (WSDLTypes.isUnion(complex) ? this.processRegularUnion(complex, defaultName) : (complex.getQName() != null && this.isIDLObjectType(complex.getQName()) ? WSDLTypes.processObject(this.def, complex, annotation, this.checkPrefix(complex.getQName()), defaultName, this.idlNamespace) : this.processStruct(complex, defaultName))));
        return corbatype;
    }

    private CorbaTypeImpl processStruct(XmlSchemaComplexType complex, QName defaultName) throws Exception {
        QName name;
        Struct corbaStruct = null;
        QName schematypeName = this.checkPrefix(complex.getQName());
        if (schematypeName == null) {
            schematypeName = this.createQNameTargetNamespace(defaultName.getLocalPart());
            schematypeName = defaultName.getNamespaceURI().equals("") ? this.checkPrefix(schematypeName) : this.checkPrefix(defaultName);
            name = this.checkPrefix(this.createQNameCorbaNamespace(defaultName.getLocalPart()));
        } else {
            name = this.checkPrefix(this.createQNameCorbaNamespace(schematypeName.getLocalPart()));
        }
        corbaStruct = (Struct)this.recursionMap.get(name);
        if (corbaStruct != null) {
            return corbaStruct;
        }
        corbaStruct = new Struct();
        corbaStruct.setName(name.getLocalPart());
        corbaStruct.setQName(name);
        String repoId = REPO_STRING + name.getLocalPart().replace('.', '/') + IDL_VERSION;
        corbaStruct.setRepositoryID(repoId);
        corbaStruct.setType(schematypeName);
        this.recursionMap.put(name, corbaStruct);
        if (complex.getContentModel() instanceof XmlSchemaSimpleContent) {
            corbaStruct = this.processSimpleContentStruct((XmlSchemaSimpleContent)complex.getContentModel(), defaultName, corbaStruct, schematypeName);
        } else if (complex.getContentModel() instanceof XmlSchemaComplexContent) {
            corbaStruct = this.processComplexContentStruct((XmlSchemaComplexContent)complex.getContentModel(), defaultName, corbaStruct, schematypeName);
        }
        if (complex.getAttributes().getIterator() != null) {
            Iterator iterator = complex.getAttributes().getIterator();
            String uri = schematypeName != null ? schematypeName.getNamespaceURI() : defaultName.getNamespaceURI();
            List<MemberType> attlist2 = this.processAttributesAsMembers(iterator, uri);
            for (int i = 0; i < attlist2.size(); ++i) {
                MemberType member = attlist2.get(i);
                corbaStruct.getMember().add(member);
            }
        }
        if (complex.getParticle() != null) {
            List members = this.processContainerAsMembers(complex.getParticle(), defaultName, schematypeName);
            for (MemberType memberType : members) {
                corbaStruct.getMember().add(memberType);
            }
        }
        this.recursionMap.remove(name);
        return corbaStruct;
    }

    protected Struct processSimpleContentStruct(XmlSchemaSimpleContent simpleContent, QName defaultName, Struct corbaStruct, QName schematypeName) throws Exception {
        QName baseTypeName;
        MemberType basemember;
        XmlSchemaType base = null;
        List<MemberType> attrMembers = null;
        CorbaTypeImpl basetype = null;
        String uri = schematypeName != null ? schematypeName.getNamespaceURI() : defaultName.getNamespaceURI();
        if (simpleContent.getContent() instanceof XmlSchemaSimpleContentExtension) {
            XmlSchemaSimpleContentExtension ext = (XmlSchemaSimpleContentExtension)simpleContent.getContent();
            if (ext.getBaseTypeName() != null) {
                basetype = this.processPrimitiveType(ext.getBaseTypeName());
            }
            if (basetype == null) {
                base = this.getSchemaType(ext.getBaseTypeName());
                basetype = this.convertSchemaToCorbaType(base, base.getQName(), base, null, false);
            }
            if (basetype == null) {
                return null;
            }
            basemember = new MemberType();
            basemember.setName("_simpleTypeValue");
            baseTypeName = this.checkPrefix(basetype.getQName());
            basemember.setIdltype(baseTypeName);
            corbaStruct.getMember().add(basemember);
            if (!this.isDuplicate(basetype)) {
                this.typeMappingType.getStructOrExceptionOrUnion().add(basetype);
            }
            attrMembers = this.processAttributesAsMembers(ext.getAttributes().getIterator(), uri);
        } else if (simpleContent.getContent() instanceof XmlSchemaSimpleContentRestriction) {
            XmlSchemaSimpleContentRestriction restrict = (XmlSchemaSimpleContentRestriction)simpleContent.getContent();
            base = restrict.getBaseType();
            if (restrict.getBaseTypeName() != null) {
                basetype = this.processPrimitiveType(restrict.getBaseTypeName());
            }
            if (basetype == null) {
                base = this.getSchemaType(restrict.getBaseTypeName());
                basetype = this.convertSchemaToCorbaType(base, base.getQName(), base, null, false);
            }
            basemember = new MemberType();
            basemember.setName("_simpleTypeValue");
            baseTypeName = this.checkPrefix(basetype.getQName());
            basemember.setIdltype(baseTypeName);
            corbaStruct.getMember().add(basemember);
            if (!this.isDuplicate(basetype)) {
                this.typeMappingType.getStructOrExceptionOrUnion().add(basetype);
            }
            attrMembers = this.processAttributesAsMembers(restrict.getAttributes().getIterator(), uri);
        }
        for (int i = 0; i < attrMembers.size(); ++i) {
            MemberType member = (MemberType)attrMembers.get(i);
            corbaStruct.getMember().add(member);
        }
        return corbaStruct;
    }

    protected Struct processComplexContentStruct(XmlSchemaComplexContent complex, QName defaultName, Struct corbaStruct, QName schematypeName) throws Exception {
        if (complex.getContent() instanceof XmlSchemaComplexContentExtension) {
            XmlSchemaComplexContentExtension extype = (XmlSchemaComplexContentExtension)complex.getContent();
            QName extName = extype.getBaseTypeName();
            Iterator attrs = extype.getAttributes().getIterator();
            corbaStruct = this.processComplexContentStructParticle(extype.getParticle(), defaultName, corbaStruct, schematypeName, extName, attrs);
        } else if (complex.getContent() instanceof XmlSchemaComplexContentRestriction) {
            XmlSchemaComplexContentRestriction extype = (XmlSchemaComplexContentRestriction)complex.getContent();
            QName extName = extype.getBaseTypeName();
            Iterator attrs = extype.getAttributes().getIterator();
            corbaStruct = this.processComplexContentStructParticle(extype.getParticle(), defaultName, corbaStruct, schematypeName, extName, attrs);
        }
        return corbaStruct;
    }

    private Struct processComplexContentStructParticle(XmlSchemaParticle extype, QName defaultName, Struct corbaStruct, QName schematypeName, QName extName, Iterator attrs) throws Exception {
        String uri = schematypeName != null ? schematypeName.getNamespaceURI() : defaultName.getNamespaceURI();
        MemberType memberType = new MemberType();
        memberType.setName(extName.getLocalPart() + "_f");
        if (extName.getLocalPart().equals("anyType")) {
            memberType.setIdltype(this.processPrimitiveType(extName).getQName());
        } else {
            memberType.setIdltype(this.createQNameCorbaNamespace(extName.getLocalPart()));
        }
        corbaStruct.getMember().add(memberType);
        List<MemberType> attlist1 = this.processAttributesAsMembers(attrs, uri);
        for (int i = 0; i < attlist1.size(); ++i) {
            MemberType member = attlist1.get(i);
            corbaStruct.getMember().add(member);
        }
        if (extype instanceof XmlSchemaChoice) {
            XmlSchemaChoice choice = (XmlSchemaChoice)extype;
            MemberType choicemem = this.processComplexContentStructChoice(choice, schematypeName, defaultName);
            choicemem.setAnonschematype(true);
            corbaStruct.getMember().add(choicemem);
        } else if (extype instanceof XmlSchemaSequence) {
            XmlSchemaSequence seq = (XmlSchemaSequence)extype;
            corbaStruct = this.processComplexContentStructSequence(corbaStruct, seq, defaultName, schematypeName);
        } else if (extype instanceof XmlSchemaAll) {
            XmlSchemaAll all = (XmlSchemaAll)extype;
            corbaStruct = this.processComplexContentStructSchemaAll(corbaStruct, all, defaultName, schematypeName);
        }
        return corbaStruct;
    }

    private Struct processComplexContentStructSequence(Struct corbaStruct, XmlSchemaSequence seq, QName defaultName, QName schematypeName) throws Exception {
        CorbaTypeImpl seqtype = this.processSequenceType(seq, defaultName, schematypeName);
        if (seqtype != null) {
            MemberType seqmem = new MemberType();
            seqmem.setName(seqtype.getQName().getLocalPart() + "_f");
            QName type = this.createQNameCorbaNamespace(seqtype.getQName().getLocalPart());
            seqmem.setIdltype(type);
            seqmem.setAnonschematype(true);
            if (seqtype.isSetQualified() && seqtype.isQualified()) {
                seqmem.setQualified(true);
            }
            corbaStruct.getMember().add(seqmem);
            if (!this.isDuplicate(seqtype)) {
                this.typeMappingType.getStructOrExceptionOrUnion().add(seqtype);
            }
        } else {
            LOG.log(Level.WARNING, "Couldnt map Sequence inside extension");
        }
        return corbaStruct;
    }

    private Struct processComplexContentStructSchemaAll(Struct corbaStruct, XmlSchemaAll all, QName defaultName, QName schematypeName) throws Exception {
        CorbaTypeImpl alltype = this.processAllType(all, defaultName, schematypeName);
        if (alltype != null) {
            MemberType allmem = new MemberType();
            allmem.setName(alltype.getQName().getLocalPart() + "_f");
            allmem.setIdltype(alltype.getQName());
            allmem.setAnonschematype(true);
            if (alltype.isSetQualified() && alltype.isQualified()) {
                allmem.setQualified(true);
            }
            corbaStruct.getMember().add(allmem);
            if (!this.isDuplicate(alltype)) {
                this.typeMappingType.getStructOrExceptionOrUnion().add(alltype);
            }
        } else {
            LOG.log(Level.WARNING, "Couldnt map All inside extension");
        }
        return corbaStruct;
    }

    protected MemberType processComplexContentStructChoice(XmlSchemaChoice choice, QName schematypeName, QName defaultName) throws Exception {
        QName choicename = this.createQNameTargetNamespace(schematypeName.getLocalPart() + "ChoiceType");
        Union choiceunion = this.createUnion(choicename, choice, defaultName, schematypeName);
        String repoId = REPO_STRING + choiceunion.getQName().getLocalPart().replace('.', '/') + IDL_VERSION;
        choiceunion.setRepositoryID(repoId);
        MemberType choicemem = new MemberType();
        choicemem.setName(choiceunion.getQName().getLocalPart() + "_f");
        choicemem.setIdltype(this.createQNameCorbaNamespace(choiceunion.getQName().getLocalPart()));
        if (choiceunion != null && !this.isDuplicate(choiceunion)) {
            this.typeMappingType.getStructOrExceptionOrUnion().add(choiceunion);
        }
        return choicemem;
    }

    protected CorbaTypeImpl createNillableUnion(QName name, QName schemaType, QName membertype, boolean isQualified) {
        Union nilUnion = new Union();
        nilUnion.setName(name.getLocalPart());
        nilUnion.setType(schemaType);
        nilUnion.setQName(name);
        nilUnion.setDiscriminator(CorbaConstants.NT_CORBA_BOOLEAN);
        String id = REPO_STRING + nilUnion.getQName().getLocalPart().replace('.', '/') + IDL_VERSION;
        nilUnion.setRepositoryID(id);
        Unionbranch branch = new Unionbranch();
        branch.setName("value");
        branch.setIdltype(membertype);
        branch.setDefault(false);
        if (isQualified) {
            branch.setQualified(true);
        }
        CaseType caseType = new CaseType();
        caseType.setLabel("TRUE");
        branch.getCase().add(caseType);
        nilUnion.getUnionbranch().add(branch);
        nilUnion.setNillable(true);
        return nilUnion;
    }

    private CorbaTypeImpl processLiteralArray(XmlSchemaComplexType complex, QName defaultName, boolean anonymous) throws Exception {
        QName name;
        QName typeName = null;
        QName schematypeName = this.checkPrefix(complex.getQName());
        if (schematypeName == null) {
            schematypeName = defaultName;
            name = this.createQNameCorbaNamespace(defaultName.getLocalPart() + "Type");
            schematypeName = this.checkPrefix(schematypeName);
            name = this.checkPrefix(name);
        } else {
            name = this.createQNameCorbaNamespace(schematypeName.getLocalPart());
            name = this.checkPrefix(name);
        }
        CorbaTypeImpl arrayType = null;
        XmlSchemaElement arrayEl = null;
        QName elName = null;
        if (complex.getParticle() instanceof XmlSchemaSequence) {
            XmlSchemaSequence seq = (XmlSchemaSequence)complex.getParticle();
            Iterator iterator = seq.getItems().getIterator();
            Iterator iter = seq.getItems().getIterator();
            while (iterator.hasNext()) {
                if (!(iter.next() instanceof XmlSchemaElement)) continue;
                arrayEl = (XmlSchemaElement)iterator.next();
                elName = arrayEl.getQName();
                XmlSchemaType atype = arrayEl.getSchemaType();
                if (elName == null) {
                    elName = arrayEl.getRefName();
                    atype = this.findSchemaType(elName);
                }
                String uri = defaultName.getNamespaceURI();
                if (complex.getQName() != null) {
                    uri = complex.getQName().getNamespaceURI();
                }
                if (elName.getNamespaceURI().equals("")) {
                    elName = new QName(uri, elName.getLocalPart());
                }
                arrayType = this.convertSchemaToCorbaType(atype, elName, atype, null, true);
                boolean isQualified = this.getElementQualification(arrayEl, uri);
                if (isQualified) {
                    arrayType.setQualified(isQualified);
                } else {
                    elName = new QName("", elName.getLocalPart());
                }
                typeName = arrayType.getQName();
            }
        }
        if (arrayEl.isNillable()) {
            QName nilunionname = this.createQNameTargetNamespace(arrayType.getQName().getLocalPart() + "_nil");
            boolean isQualified = arrayType.isSetQualified() && arrayType.isQualified();
            arrayType = this.createNillableUnion(nilunionname, elName, arrayType.getQName(), isQualified);
            typeName = this.createQNameCorbaNamespace(arrayType.getQName().getLocalPart());
            if (arrayType != null && !this.isDuplicate(arrayType)) {
                this.typeMappingType.getStructOrExceptionOrUnion().add(arrayType);
            }
        }
        Long maxOccurs = null;
        Long minOccurs = null;
        if (arrayEl != null) {
            maxOccurs = arrayEl.getMaxOccurs();
            minOccurs = arrayEl.getMinOccurs();
        }
        return this.createArray(name, schematypeName, this.checkPrefix(typeName), elName, maxOccurs, minOccurs, anonymous);
    }

    private CorbaTypeImpl processOMGUnion(XmlSchemaComplexType complex, QName defaultName) throws Exception {
        QName name;
        Union corbaUnion = null;
        QName schematypeName = this.checkPrefix(complex.getQName());
        if (schematypeName == null) {
            schematypeName = defaultName;
            name = this.createQNameCorbaNamespace(defaultName.getLocalPart() + "Type");
        } else {
            name = this.createQNameCorbaNamespace(schematypeName.getLocalPart());
        }
        corbaUnion = new Union();
        corbaUnion.setName(name.getLocalPart());
        corbaUnion.setQName(name);
        String id = REPO_STRING + name.getLocalPart().replace('.', '/') + IDL_VERSION;
        corbaUnion.setRepositoryID(id);
        corbaUnion.setType(schematypeName);
        XmlSchemaSequence stype = (XmlSchemaSequence)complex.getParticle();
        Iterator it = stype.getItems().getIterator();
        XmlSchemaParticle st1 = (XmlSchemaParticle)it.next();
        XmlSchemaParticle st2 = (XmlSchemaParticle)it.next();
        XmlSchemaElement discEl = null;
        XmlSchemaChoice choice = null;
        if (st1 instanceof XmlSchemaElement) {
            discEl = (XmlSchemaElement)st1;
            choice = (XmlSchemaChoice)st2;
        } else {
            discEl = (XmlSchemaElement)st2;
            choice = (XmlSchemaChoice)st1;
        }
        CorbaTypeImpl disctype = this.convertSchemaToCorbaType(discEl.getSchemaType(), discEl.getQName(), discEl.getSchemaType(), null, false);
        corbaUnion.setDiscriminator(disctype.getQName());
        List fields = this.processContainerAsMembers(choice, defaultName, schematypeName);
        ArrayList<String> caselist = new ArrayList<String>();
        if (disctype instanceof Enum) {
            Enum corbaenum = (Enum)disctype;
            for (Enumerator enumerator : corbaenum.getEnumerator()) {
                caselist.add(enumerator.getValue());
            }
        } else if (SUPPORTEDDISTYPES.contains(disctype.getQName().getLocalPart())) {
            if (disctype.getQName().getLocalPart().equals("long") || disctype.getQName().getLocalPart().equals("short")) {
                for (int i = 0; i < fields.size(); ++i) {
                    caselist.add(Integer.toString(i));
                }
            } else if (disctype.getQName().getLocalPart().equals("char")) {
                for (int i = 0; i < fields.size(); ++i) {
                    caselist.add(Integer.toString(i));
                }
            } else if (disctype.getQName().getLocalPart().equals("char")) {
                for (int i = 0; i < fields.size(); ++i) {
                    caselist.add(Integer.toString(i));
                }
            } else if (disctype.getQName().getLocalPart().equals("boolean")) {
                if (fields.size() == 2) {
                    caselist.add("TRUE");
                    caselist.add("FALSE");
                } else if (fields.size() == 1) {
                    caselist.add("TRUE");
                } else {
                    String msg = "Discriminator Type doesnt match number of Choices in Union:" + name;
                    LOG.log(Level.WARNING, msg.toString());
                }
            }
        }
        WSDLTypes.processUnionBranches(corbaUnion, fields, caselist);
        return corbaUnion;
    }

    private CorbaTypeImpl processRegularUnion(XmlSchemaComplexType complex, QName defaultName) throws Exception {
        QName name = null;
        QName schematypeName = complex.getQName();
        if (schematypeName == null) {
            schematypeName = defaultName;
            name = this.createQNameCorbaNamespace(defaultName.getLocalPart() + "Type");
        } else {
            name = this.createQNameCorbaNamespace(schematypeName.getLocalPart());
        }
        return this.createUnion(name, (XmlSchemaChoice)complex.getParticle(), defaultName, schematypeName);
    }

    protected Union createUnion(QName name, XmlSchemaChoice choice, QName defaultName, QName schematypeName) throws Exception {
        Union corbaUnion = null;
        if (this.recursionMap.get(name) instanceof Union && (corbaUnion = (Union)this.recursionMap.get(name)) != null) {
            return corbaUnion;
        }
        corbaUnion = new Union();
        corbaUnion.setName(name.getLocalPart());
        corbaUnion.setQName(name);
        corbaUnion.setType(schematypeName);
        String id = REPO_STRING + name.getLocalPart().replace('.', '/') + IDL_VERSION;
        corbaUnion.setRepositoryID(id);
        corbaUnion.setDiscriminator(CorbaConstants.NT_CORBA_LONG);
        this.recursionMap.put(name, corbaUnion);
        List fields = this.processContainerAsMembers(choice, defaultName, schematypeName);
        ArrayList<String> caselist = new ArrayList<String>();
        for (int i = 0; i < fields.size(); ++i) {
            caselist.add(Integer.toString(i));
        }
        corbaUnion = WSDLTypes.processUnionBranches(corbaUnion, fields, caselist);
        this.recursionMap.remove(name);
        if (!this.isDuplicate(corbaUnion)) {
            this.typeMappingType.getStructOrExceptionOrUnion().add(corbaUnion);
        }
        return corbaUnion;
    }

    protected boolean isDuplicate(CorbaTypeImpl corbaTypeImpl) {
        String corbaName = corbaTypeImpl.getName();
        QName corbaType = corbaTypeImpl.getType();
        QName primName = this.createQNameXmlSchemaNamespace(corbaName);
        if ((CorbaTypeImpl)CORBAPRIMITIVEMAP.get(primName) != null) {
            return true;
        }
        if (!this.typeMappingType.getStructOrExceptionOrUnion().isEmpty()) {
            for (CorbaTypeImpl type : this.typeMappingType.getStructOrExceptionOrUnion()) {
                if (corbaName == null || type.getType() == null || corbaType == null || !corbaName.equals(type.getName()) || !corbaType.getLocalPart().equals(type.getType().getLocalPart()) || !corbaTypeImpl.getClass().getName().equals(type.getClass().getName())) continue;
                return true;
            }
        }
        return false;
    }

    protected CorbaTypeImpl isDuplicateException(CorbaTypeImpl corbaTypeImpl) {
        CorbaTypeImpl duplicate = null;
        String corbaName = corbaTypeImpl.getName();
        String corbaType = corbaTypeImpl.getType().getLocalPart();
        if (!this.typeMappingType.getStructOrExceptionOrUnion().isEmpty()) {
            for (CorbaTypeImpl type : this.typeMappingType.getStructOrExceptionOrUnion()) {
                if (!corbaName.equals(type.getName()) || !corbaType.equals(type.getType().getLocalPart()) || !(type instanceof Struct)) continue;
                return type;
            }
        }
        return duplicate;
    }

    protected QName checkPrefix(QName schematypeName) {
        QName name = schematypeName;
        if (name != null && (name.getPrefix() == null || name.getPrefix().equals(""))) {
            if (StringUtils.isEmpty(name.getNamespaceURI())) {
                return name;
            }
            String prefix = this.def.getPrefix(name.getNamespaceURI());
            if (prefix == null) {
                prefix = this.xmlSchemaList.getSchemaByTargetNamespace(name.getNamespaceURI()).getNamespaceContext().getPrefix(name.getNamespaceURI());
            }
            if (prefix != null) {
                return new QName(name.getNamespaceURI(), name.getLocalPart(), prefix);
            }
            return null;
        }
        return name;
    }

    public QName createQNameTargetNamespace(String name) {
        return new QName(this.def.getTargetNamespace(), name, this.def.getPrefix(this.def.getTargetNamespace()));
    }

    public QName createQNameCorbaNamespace(String name) {
        return new QName(this.getIdlNamespace(), name, this.def.getPrefix(this.getIdlNamespace()));
    }

    public QName createQName(String name, String namespaceName, String prefix) {
        return new QName(name, namespaceName, prefix);
    }

    public QName createQNameXmlSchemaNamespace(String name) {
        return new QName("http://www.w3.org/2001/XMLSchema", name, "xsd");
    }

    private boolean isIDLObjectType(QName typeName) {
        return typeName.equals(ReferenceConstants.REFERENCE_TYPE) || typeName.equals(ReferenceConstants.WSADDRESSING_TYPE);
    }

    private boolean isAddressingNamespace(QName typeName) {
        return typeName != null && !this.isIDLObjectType(typeName) && (typeName.getNamespaceURI().equals("http://schemas.iona.com/references") || typeName.getNamespaceURI().equals("http://www.w3.org/2005/08/addressing"));
    }

    protected static boolean queryBinding(Definition definition, QName bqname) {
        Map bindings = definition.getBindings();
        for (Binding binding : bindings.values()) {
            if (!binding.getQName().getLocalPart().equals(bqname.getLocalPart())) continue;
            return true;
        }
        return false;
    }

    private boolean getElementQualification(XmlSchemaElement element, String uri) {
        QName schemaName = element.getQName();
        if (schemaName == null) {
            schemaName = element.getRefName();
        }
        if (schemaName.getNamespaceURI().equals("")) {
            schemaName = new QName(uri, schemaName.getLocalPart());
        }
        boolean qualified = false;
        qualified = element.getForm().getValue().equals("qualified") ? true : WSDLUtils.isElementFormQualified(this.xmlSchemaList, schemaName);
        return qualified;
    }

    private boolean getAttributeQualification(XmlSchemaAttribute attr, String uri) {
        QName schemaName = attr.getQName();
        if (schemaName.getNamespaceURI().equals("")) {
            schemaName = new QName(uri, schemaName.getLocalPart());
        }
        boolean qualified = false;
        qualified = attr.getForm().getValue().equals("qualified") ? true : WSDLUtils.isElementFormQualified(this.xmlSchemaList, schemaName);
        return qualified;
    }
}

