/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.ws.security.policy.model;

import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.apache.cxf.ws.security.policy.SPConstants;
import org.apache.cxf.ws.security.policy.model.Token;
import org.apache.neethi.PolicyComponent;

public class HttpsToken
extends Token {
    private boolean requireClientCertificate;
    private boolean httpBasicAuthentication;
    private boolean httpDigestAuthentication;

    public HttpsToken(SPConstants version2) {
        super(version2);
    }

    public boolean isRequireClientCertificate() {
        return this.requireClientCertificate;
    }

    public void setRequireClientCertificate(boolean requireClientCertificate) {
        this.requireClientCertificate = requireClientCertificate;
    }

    public boolean isHttpBasicAuthentication() {
        return this.httpBasicAuthentication;
    }

    public void setHttpBasicAuthentication(boolean httpBasicAuthentication) {
        this.httpBasicAuthentication = httpBasicAuthentication;
    }

    public boolean isHttpDigestAuthentication() {
        return this.httpDigestAuthentication;
    }

    public void setHttpDigestAuthentication(boolean httpDigestAuthentication) {
        this.httpDigestAuthentication = httpDigestAuthentication;
    }

    public QName getName() {
        return this.constants.getHttpsToken();
    }

    public PolicyComponent normalize() {
        throw new UnsupportedOperationException();
    }

    public void serialize(XMLStreamWriter writer) throws XMLStreamException {
        String localname = this.getName().getLocalPart();
        String namespaceURI = this.getName().getNamespaceURI();
        String prefix = writer.getPrefix(namespaceURI);
        if (prefix == null) {
            prefix = this.getName().getPrefix();
            writer.setPrefix(prefix, namespaceURI);
        }
        writer.writeStartElement(prefix, localname, namespaceURI);
        if (this.constants.getVersion() == SPConstants.Version.SP_V12) {
            if (this.isRequireClientCertificate() || this.isHttpBasicAuthentication() || this.isHttpDigestAuthentication()) {
                writer.writeStartElement(SPConstants.POLICY.getPrefix(), SPConstants.POLICY.getLocalPart(), SPConstants.POLICY.getNamespaceURI());
                if (this.isHttpBasicAuthentication()) {
                    writer.writeStartElement(prefix, SPConstants.HTTP_BASIC_AUTHENTICATION.getLocalPart(), namespaceURI);
                    writer.writeEndElement();
                } else if (this.isHttpDigestAuthentication()) {
                    writer.writeStartElement(prefix, SPConstants.HTTP_DIGEST_AUTHENTICATION.getLocalPart(), namespaceURI);
                    writer.writeEndElement();
                } else if (this.isRequireClientCertificate()) {
                    writer.writeStartElement(prefix, SPConstants.REQUIRE_CLIENT_CERTIFICATE.getLocalPart(), namespaceURI);
                    writer.writeEndElement();
                }
                writer.writeEndElement();
            }
        } else {
            writer.writeAttribute(SPConstants.REQUIRE_CLIENT_CERTIFICATE.getLocalPart(), Boolean.toString(this.isRequireClientCertificate()));
        }
        writer.writeEndElement();
    }
}

