/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.ws.security.policy.model;

import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.apache.cxf.staxutils.StaxUtils;
import org.apache.cxf.ws.security.policy.SPConstants;
import org.apache.cxf.ws.security.policy.model.SecurityContextToken;
import org.apache.neethi.Policy;
import org.w3c.dom.Element;

public class SecureConversationToken
extends SecurityContextToken {
    private Policy bootstrapPolicy;
    private Element issuerEpr;

    public SecureConversationToken(SPConstants version2) {
        super(version2);
    }

    public Policy getBootstrapPolicy() {
        return this.bootstrapPolicy;
    }

    public void setBootstrapPolicy(Policy bootstrapPolicy) {
        this.bootstrapPolicy = bootstrapPolicy;
    }

    public QName getName() {
        return this.constants.getSecureConversationToken();
    }

    public void serialize(XMLStreamWriter writer) throws XMLStreamException {
        String inclusion;
        String prefix;
        String localname = this.getName().getLocalPart();
        String namespaceURI = this.getName().getNamespaceURI();
        String writerPrefix = writer.getPrefix(namespaceURI);
        if (writerPrefix == null) {
            prefix = this.getName().getPrefix();
            writer.setPrefix(prefix, namespaceURI);
        } else {
            prefix = writerPrefix;
        }
        writer.writeStartElement(prefix, localname, namespaceURI);
        if (writerPrefix == null) {
            writer.writeNamespace(prefix, namespaceURI);
        }
        if ((inclusion = this.constants.getAttributeValueFromInclusion(this.getInclusion())) != null) {
            writer.writeAttribute(prefix, namespaceURI, "IncludeToken", inclusion);
        }
        if (this.issuerEpr != null) {
            writer.writeStartElement(prefix, "Issuer", namespaceURI);
            StaxUtils.copy(this.issuerEpr, writer);
            writer.writeEndElement();
        }
        if (this.isDerivedKeys() || this.isRequireExternalUriRef() || this.isSc10SecurityContextToken() || this.bootstrapPolicy != null) {
            String wspPrefix;
            String wspNamespaceURI = SPConstants.POLICY.getNamespaceURI();
            String wspWriterPrefix = writer.getPrefix(wspNamespaceURI);
            if (wspWriterPrefix == null) {
                wspPrefix = SPConstants.POLICY.getPrefix();
                writer.setPrefix(wspPrefix, wspNamespaceURI);
            } else {
                wspPrefix = wspWriterPrefix;
            }
            writer.writeStartElement(wspPrefix, SPConstants.POLICY.getLocalPart(), wspNamespaceURI);
            if (wspWriterPrefix == null) {
                writer.writeNamespace(wspPrefix, wspNamespaceURI);
            }
            if (this.isDerivedKeys()) {
                writer.writeEmptyElement(prefix, "RequireDerivedKeys", namespaceURI);
            }
            if (this.isRequireExternalUriRef()) {
                writer.writeEmptyElement(prefix, "RequireExternalUriReference", namespaceURI);
            }
            if (this.isSc10SecurityContextToken()) {
                writer.writeEmptyElement(prefix, "SC10SecurityContextToken", namespaceURI);
            }
            if (this.bootstrapPolicy != null) {
                writer.writeStartElement(prefix, "BootstrapPolicy", namespaceURI);
                this.bootstrapPolicy.serialize(writer);
                writer.writeEndElement();
            }
            writer.writeEndElement();
        }
        writer.writeEndElement();
    }

    public Element getIssuerEpr() {
        return this.issuerEpr;
    }

    public void setIssuerEpr(Element issuerEpr) {
        this.issuerEpr = issuerEpr;
    }
}

