/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.ws.security.policy.model;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.apache.cxf.ws.security.policy.SPConstants;
import org.apache.cxf.ws.security.policy.model.AbstractSecurityAssertion;
import org.apache.neethi.PolicyComponent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SignedEncryptedElements
extends AbstractSecurityAssertion {
    private List<String> xPathExpressions = new ArrayList<String>();
    private Map<String, String> declaredNamespaces = new HashMap<String, String>();
    private String xPathVersion;
    private boolean signedElemets;

    public SignedEncryptedElements(boolean signedElements, SPConstants version2) {
        super(version2);
        this.signedElemets = signedElements;
    }

    public List<String> getXPathExpressions() {
        return this.xPathExpressions;
    }

    public void addXPathExpression(String expr) {
        this.xPathExpressions.add(expr);
    }

    public String getXPathVersion() {
        return this.xPathVersion;
    }

    public void setXPathVersion(String pathVersion) {
        this.xPathVersion = pathVersion;
    }

    public boolean isSignedElemets() {
        return this.signedElemets;
    }

    public Map<String, String> getDeclaredNamespaces() {
        return this.declaredNamespaces;
    }

    public void addDeclaredNamespaces(String uri, String prefix) {
        this.declaredNamespaces.put(prefix, uri);
    }

    @Override
    public void serialize(XMLStreamWriter writer) throws XMLStreamException {
        String localName = this.getName().getLocalPart();
        String namespaceURI = this.getName().getNamespaceURI();
        String prefix = writer.getPrefix(namespaceURI);
        if (prefix == null) {
            prefix = this.getName().getPrefix();
            writer.setPrefix(prefix, namespaceURI);
        }
        writer.writeStartElement(prefix, localName, namespaceURI);
        writer.writeNamespace(prefix, namespaceURI);
        if (this.xPathVersion != null) {
            writer.writeAttribute(prefix, namespaceURI, "XPathVersion", this.xPathVersion);
        }
        for (String xpathExpression : this.xPathExpressions) {
            writer.writeStartElement(prefix, "XPath", namespaceURI);
            writer.writeCharacters(xpathExpression);
            writer.writeEndElement();
        }
        writer.writeEndElement();
    }

    @Override
    public QName getName() {
        if (this.signedElemets) {
            return this.constants.getSignedElements();
        }
        return this.constants.getEncryptedElements();
    }

    @Override
    public PolicyComponent normalize() {
        return this;
    }
}

