/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.util;

import java.io.IOException;
import java.io.StringReader;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.Token;
import org.apache.lucene.analysis.TokenStream;
import org.apache.solr.util.TokenOrderingFilter;

class MultiValueTokenStream
extends TokenStream {
    private String fieldName;
    private String[] values;
    private Analyzer analyzer;
    private int curIndex;
    private int curOffset;
    private TokenStream currentStream;
    private boolean orderTokenOffsets;

    public MultiValueTokenStream(String fieldName, String[] values, Analyzer analyzer, boolean orderTokenOffsets) {
        this.fieldName = fieldName;
        this.values = values;
        this.analyzer = analyzer;
        this.curIndex = -1;
        this.curOffset = 0;
        this.currentStream = null;
        this.orderTokenOffsets = orderTokenOffsets;
    }

    public Token next() throws IOException {
        Token nextToken;
        int extra = 0;
        if (this.currentStream == null) {
            ++this.curIndex;
            if (this.curIndex < this.values.length) {
                this.currentStream = this.analyzer.tokenStream(this.fieldName, new StringReader(this.values[this.curIndex]));
                if (this.orderTokenOffsets) {
                    this.currentStream = new TokenOrderingFilter(this.currentStream, 10);
                }
                if (this.curIndex > 0) {
                    extra = this.analyzer.getPositionIncrementGap(this.fieldName);
                }
            } else {
                return null;
            }
        }
        if ((nextToken = this.currentStream.next()) == null) {
            this.curOffset += this.values[this.curIndex].length();
            this.currentStream = null;
            return this.next();
        }
        Token offsetToken = new Token(nextToken.termText(), nextToken.startOffset() + this.curOffset, nextToken.endOffset() + this.curOffset);
        offsetToken.setPositionIncrement(nextToken.getPositionIncrement() + extra * 10);
        return offsetToken;
    }

    public String asSingleValue() {
        StringBuilder sb = new StringBuilder();
        for (String str : this.values) {
            sb.append(str);
        }
        return sb.toString();
    }
}

